/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.PickShape;
import org.jogamp.java3d.Transform3D;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Point4d;

public final class PickSegment
extends PickShape {
    Point3d start;
    Point3d end;

    public PickSegment() {
        this.start = new Point3d();
        this.end = new Point3d();
    }

    public PickSegment(Point3d start, Point3d end) {
        this.start = new Point3d(start);
        this.end = new Point3d(end);
    }

    public void set(Point3d start, Point3d end) {
        this.start.x = start.x;
        this.start.y = start.y;
        this.start.z = start.z;
        this.end.x = end.x;
        this.end.y = end.y;
        this.end.z = end.z;
    }

    public void get(Point3d start, Point3d end) {
        start.x = this.start.x;
        start.y = this.start.y;
        start.z = this.start.z;
        end.x = this.end.x;
        end.y = this.end.y;
        end.z = this.end.z;
    }

    @Override
    final boolean intersect(Bounds bounds, Point4d pickPos) {
        return bounds.intersect(this.start, this.end, pickPos);
    }

    @Override
    PickShape transform(Transform3D t3d) {
        PickSegment newPS = new PickSegment(this.start, this.end);
        t3d.transform(newPS.start);
        t3d.transform(newPS.end);
        return newPS;
    }

    @Override
    Point3d getStartPoint() {
        return this.start;
    }

    @Override
    int getPickType() {
        return 2;
    }
}

