/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.BackgroundSound;
import org.jogamp.java3d.BoundingLeaf;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.CapabilityNotSetException;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.Leaf;
import org.jogamp.java3d.MediaContainer;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.NodeReferenceTable;
import org.jogamp.java3d.PointSoundRetained;
import org.jogamp.java3d.SceneGraphObject;
import org.jogamp.java3d.SoundRetained;
import org.jogamp.java3d.View;

public abstract class Sound
extends Leaf {
    public static final int ALLOW_SOUND_DATA_READ = 12;
    public static final int ALLOW_SOUND_DATA_WRITE = 13;
    public static final int ALLOW_INITIAL_GAIN_READ = 14;
    public static final int ALLOW_INITIAL_GAIN_WRITE = 15;
    public static final int ALLOW_LOOP_READ = 16;
    public static final int ALLOW_LOOP_WRITE = 17;
    public static final int ALLOW_RELEASE_READ = 18;
    public static final int ALLOW_RELEASE_WRITE = 19;
    public static final int ALLOW_CONT_PLAY_READ = 20;
    public static final int ALLOW_CONT_PLAY_WRITE = 21;
    public static final int ALLOW_ENABLE_READ = 22;
    public static final int ALLOW_ENABLE_WRITE = 23;
    public static final int ALLOW_SCHEDULING_BOUNDS_READ = 24;
    public static final int ALLOW_SCHEDULING_BOUNDS_WRITE = 25;
    public static final int ALLOW_PRIORITY_READ = 26;
    public static final int ALLOW_PRIORITY_WRITE = 27;
    public static final int ALLOW_DURATION_READ = 28;
    public static final int ALLOW_IS_READY_READ = 29;
    public static final int ALLOW_IS_PLAYING_READ = 30;
    public static final int ALLOW_CHANNELS_USED_READ = 31;
    public static final int ALLOW_MUTE_READ = 40;
    public static final int ALLOW_MUTE_WRITE = 41;
    public static final int ALLOW_PAUSE_READ = 42;
    public static final int ALLOW_PAUSE_WRITE = 43;
    public static final int ALLOW_RATE_SCALE_FACTOR_READ = 44;
    public static final int ALLOW_RATE_SCALE_FACTOR_WRITE = 45;
    public static final float NO_FILTER = -1.0f;
    public static final int DURATION_UNKNOWN = -1;
    public static final int INFINITE_LOOPS = -1;
    private static final int[] readCapabilities = new int[]{31, 20, 28, 22, 14, 30, 29, 16, 40, 42, 26, 44, 18, 24, 12};

    public Sound() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public Sound(MediaContainer soundData, float initialGain) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((SoundRetained)this.retained).setSoundData(soundData);
        ((SoundRetained)this.retained).setInitialGain(initialGain);
    }

    public Sound(MediaContainer soundData, float initialGain, int loopCount, boolean release, boolean continuous, boolean enable, Bounds region, float priority) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((SoundRetained)this.retained).setSoundData(soundData);
        ((SoundRetained)this.retained).setInitialGain(initialGain);
        ((SoundRetained)this.retained).setLoop(loopCount);
        ((SoundRetained)this.retained).setReleaseEnable(release);
        ((SoundRetained)this.retained).setContinuousEnable(continuous);
        ((SoundRetained)this.retained).setEnable(enable);
        ((SoundRetained)this.retained).setSchedulingBounds(region);
        ((SoundRetained)this.retained).setPriority(priority);
    }

    public Sound(MediaContainer soundData, float initialGain, int loopCount, boolean release, boolean continuous, boolean enable, Bounds region, float priority, float rateFactor) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((SoundRetained)this.retained).setSoundData(soundData);
        ((SoundRetained)this.retained).setInitialGain(initialGain);
        ((SoundRetained)this.retained).setLoop(loopCount);
        ((SoundRetained)this.retained).setReleaseEnable(release);
        ((SoundRetained)this.retained).setContinuousEnable(continuous);
        ((SoundRetained)this.retained).setEnable(enable);
        ((SoundRetained)this.retained).setSchedulingBounds(region);
        ((SoundRetained)this.retained).setPriority(priority);
        ((SoundRetained)this.retained).setRateScaleFactor(rateFactor);
    }

    public void setSoundData(MediaContainer soundData) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound0"));
        }
        if (this instanceof BackgroundSound) {
            ((SoundRetained)this.retained).setSoundData(soundData);
        } else {
            ((PointSoundRetained)this.retained).setSoundData(soundData);
        }
    }

    public MediaContainer getSoundData() {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound1"));
        }
        return ((SoundRetained)this.retained).getSoundData();
    }

    public void setInitialGain(float amplitude) {
        if (this.isLiveOrCompiled() && !this.getCapability(15)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound2"));
        }
        ((SoundRetained)this.retained).setInitialGain(amplitude);
    }

    public float getInitialGain() {
        if (this.isLiveOrCompiled() && !this.getCapability(14)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound3"));
        }
        return ((SoundRetained)this.retained).getInitialGain();
    }

    public void setLoop(int loopCount) {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound4"));
        }
        ((SoundRetained)this.retained).setLoop(loopCount);
    }

    public int getLoop() {
        if (this.isLiveOrCompiled() && !this.getCapability(16)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound5"));
        }
        return ((SoundRetained)this.retained).getLoop();
    }

    public void setReleaseEnable(boolean state) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound6"));
        }
        ((SoundRetained)this.retained).setReleaseEnable(state);
    }

    public boolean getReleaseEnable() {
        if (this.isLiveOrCompiled() && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound7"));
        }
        return ((SoundRetained)this.retained).getReleaseEnable();
    }

    public void setContinuousEnable(boolean state) {
        if (this.isLiveOrCompiled() && !this.getCapability(21)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound8"));
        }
        ((SoundRetained)this.retained).setContinuousEnable(state);
    }

    public boolean getContinuousEnable() {
        if (this.isLiveOrCompiled() && !this.getCapability(20)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound9"));
        }
        return ((SoundRetained)this.retained).getContinuousEnable();
    }

    public void setEnable(boolean state) {
        if (this.isLiveOrCompiled() && !this.getCapability(23)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound10"));
        }
        if (this instanceof BackgroundSound) {
            ((SoundRetained)this.retained).setEnable(state);
        } else {
            ((PointSoundRetained)this.retained).setEnable(state);
        }
    }

    public boolean getEnable() {
        if (this.isLiveOrCompiled() && !this.getCapability(22)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound21"));
        }
        return ((SoundRetained)this.retained).getEnable();
    }

    public void setSchedulingBounds(Bounds region) {
        if (this.isLiveOrCompiled() && !this.getCapability(25)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound11"));
        }
        ((SoundRetained)this.retained).setSchedulingBounds(region);
    }

    public Bounds getSchedulingBounds() {
        if (this.isLiveOrCompiled() && !this.getCapability(24)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound12"));
        }
        return ((SoundRetained)this.retained).getSchedulingBounds();
    }

    public void setSchedulingBoundingLeaf(BoundingLeaf region) {
        if (this.isLiveOrCompiled() && !this.getCapability(25)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound11"));
        }
        ((SoundRetained)this.retained).setSchedulingBoundingLeaf(region);
    }

    public BoundingLeaf getSchedulingBoundingLeaf() {
        if (this.isLiveOrCompiled() && !this.getCapability(24)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound12"));
        }
        return ((SoundRetained)this.retained).getSchedulingBoundingLeaf();
    }

    public void setPriority(float priority) {
        if (this.isLiveOrCompiled() && !this.getCapability(27)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound15"));
        }
        ((SoundRetained)this.retained).setPriority(priority);
    }

    public float getPriority() {
        if (this.isLiveOrCompiled() && !this.getCapability(26)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound16"));
        }
        return ((SoundRetained)this.retained).getPriority();
    }

    public long getDuration() {
        if (this.isLiveOrCompiled() && !this.getCapability(28)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound17"));
        }
        return ((SoundRetained)this.retained).getDuration();
    }

    public boolean isReady() {
        if (this.isLiveOrCompiled() && !this.getCapability(29)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound22"));
        }
        return ((SoundRetained)this.retained).isReady();
    }

    public boolean isReady(View view) {
        if (this.isLiveOrCompiled() && !this.getCapability(29)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound22"));
        }
        return ((SoundRetained)this.retained).isReady(view);
    }

    public boolean isPlaying() {
        if (this.isLiveOrCompiled() && !this.getCapability(30)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound18"));
        }
        return ((SoundRetained)this.retained).isPlaying();
    }

    public boolean isPlaying(View view) {
        if (this.isLiveOrCompiled() && !this.getCapability(30)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound18"));
        }
        return ((SoundRetained)this.retained).isPlaying(view);
    }

    public boolean isPlayingSilently() {
        if (this.isLiveOrCompiled() && !this.getCapability(30)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound18"));
        }
        return ((SoundRetained)this.retained).isPlayingSilently();
    }

    public boolean isPlayingSilently(View view) {
        if (this.isLiveOrCompiled() && !this.getCapability(30)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound18"));
        }
        return ((SoundRetained)this.retained).isPlayingSilently(view);
    }

    public int getNumberOfChannelsUsed() {
        if (this.isLiveOrCompiled() && !this.getCapability(31)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound20"));
        }
        return ((SoundRetained)this.retained).getNumberOfChannelsUsed();
    }

    public int getNumberOfChannelsUsed(View view) {
        if (this.isLiveOrCompiled() && !this.getCapability(31)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound20"));
        }
        return ((SoundRetained)this.retained).getNumberOfChannelsUsed(view);
    }

    public void setMute(boolean state) {
        if (this.isLiveOrCompiled() && !this.getCapability(41)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound23"));
        }
        ((SoundRetained)this.retained).setMute(state);
    }

    public boolean getMute() {
        if (this.isLiveOrCompiled() && !this.getCapability(40)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound24"));
        }
        return ((SoundRetained)this.retained).getMute();
    }

    public void setPause(boolean state) {
        if (this.isLiveOrCompiled() && !this.getCapability(43)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound25"));
        }
        ((SoundRetained)this.retained).setPause(state);
    }

    public boolean getPause() {
        if (this.isLiveOrCompiled() && !this.getCapability(42)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound26"));
        }
        return ((SoundRetained)this.retained).getPause();
    }

    public void setRateScaleFactor(float scaleFactor) {
        if (this.isLiveOrCompiled() && !this.getCapability(45)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound27"));
        }
        ((SoundRetained)this.retained).setRateScaleFactor(scaleFactor);
    }

    public float getRateScaleFactor() {
        if (this.isLiveOrCompiled() && !this.getCapability(44)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Sound28"));
        }
        return ((SoundRetained)this.retained).getRateScaleFactor();
    }

    @Override
    void duplicateAttributes(Node originalNode, boolean forceDuplicate) {
        super.duplicateAttributes(originalNode, forceDuplicate);
        SoundRetained orgRetained = (SoundRetained)originalNode.retained;
        SoundRetained thisRetained = (SoundRetained)this.retained;
        thisRetained.setSoundData((MediaContainer)this.getNodeComponent(orgRetained.getSoundData(), forceDuplicate, originalNode.nodeHashtable));
        thisRetained.setInitialGain(orgRetained.getInitialGain());
        thisRetained.setLoop(orgRetained.getLoop());
        thisRetained.setReleaseEnable(orgRetained.getReleaseEnable());
        thisRetained.setContinuousEnable(orgRetained.getContinuousEnable());
        thisRetained.setSchedulingBounds(orgRetained.getSchedulingBounds());
        thisRetained.setPriority(orgRetained.getPriority());
        thisRetained.setEnable(orgRetained.getEnable());
        thisRetained.setSchedulingBoundingLeaf(orgRetained.getSchedulingBoundingLeaf());
    }

    @Override
    public void updateNodeReferences(NodeReferenceTable referenceTable) {
        MediaContainer sd;
        super.updateNodeReferences(referenceTable);
        SoundRetained rt = (SoundRetained)this.retained;
        BoundingLeaf bl = rt.getSchedulingBoundingLeaf();
        if (bl != null) {
            SceneGraphObject o = referenceTable.getNewObjectReference(bl);
            rt.setSchedulingBoundingLeaf((BoundingLeaf)o);
        }
        if ((sd = rt.getSoundData()) != null) {
            rt.setSoundData(sd);
        }
    }
}

