/*
 * Decompiled with CFR 0.152.
 */
package jlk;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;

public class GenerateArrays {
    static final int ENTRIES = 32;
    static final int VALUES = 64;
    static String def_chars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz[]!@#$%^&|{}";

    GenerateArrays(String class_name, String application_name) {
        int def_chars_count = def_chars.length();
        int[] ha = new int[32];
        int sum = 0;
        RandomGenerator rg = new RandomGenerator();
        String eol = System.getProperty("line.separator");
        PrintStream old_stdout = System.out;
        try {
            int j;
            PrintStream out_file = new PrintStream(new BufferedOutputStream(new FileOutputStream(new File("src/jlk/Matrix" + class_name + ".java"))));
            System.setOut(out_file);
            System.out.println("package jlk;" + eol);
            System.out.println("class Matrix" + class_name + " implements LicenseMatrix" + eol + "{" + eol);
            System.out.println("   private static final String APPLICATION_NAME = \"" + application_name + "\";\n");
            System.out.println("   public String getApplicationName() {");
            System.out.println("     return APPLICATION_NAME;");
            System.out.println("   }\n");
            System.out.println("   private static final String[] PERM_ARRAY = {");
            int i = 0;
            while (i < 32) {
                String line = "";
                j = 0;
                while (j < 64) {
                    char c;
                    int n;
                    while ((n = (int)(rg.get() * (double)def_chars_count)) < 0 || n >= def_chars_count || line.indexOf(c = def_chars.charAt(n)) >= 0) {
                    }
                    line = String.valueOf(String.valueOf(line)) + String.valueOf(c);
                    sum += c;
                    ++j;
                }
                System.out.print(String.valueOf(String.valueOf(new StringBuffer("      \"").append(line).append("\""))));
                if (i < 31) {
                    System.out.println(",");
                } else {
                    System.out.println();
                    System.out.println("   };");
                }
                ++i;
            }
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("   private static final int PERM_ARRAY_CHECKSUM = ").append(sum).append(";"))));
            while ((i = (int)(rg.get() * 64.0)) < 0 || i >= 64) {
            }
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("   private static final int ROLL_PERM_ARRAY = ").append(i).append(";"))));
            i = 0;
            while (i < 32) {
                ha[i] = -1;
                ++i;
            }
            i = 0;
            while (i < 32) {
                int n;
                while (true) {
                    if ((n = (int)(rg.get() * 32.0)) < 0 || n >= 32) {
                        continue;
                    }
                    j = 0;
                    while (j < 32 && ha[j] != n) {
                        ++j;
                    }
                    if (j == 32) break;
                }
                ha[i] = n;
                ++i;
            }
            System.out.println();
            System.out.print("   private static final int[] HEX_ARRAY = {");
            i = 0;
            while (i < 32) {
                if (i % 8 == 0) {
                    System.out.println();
                    System.out.print("     ");
                }
                System.out.print(" ".concat(String.valueOf(String.valueOf(ha[i]))));
                if (i < 31) {
                    System.out.print(",");
                }
                ++i;
            }
            System.out.println();
            System.out.println("   };");
            System.out.println();
            System.out.println("   public String[] getPermArray()" + eol + "   {" + eol + "      return this.PERM_ARRAY;" + eol + "   }" + eol + eol + "   public int getPermArrayChecksum()" + eol + "   {" + eol + "      return this.PERM_ARRAY_CHECKSUM;" + eol + "   }" + eol + eol + "   public int getRollPermArray()" + eol + "   {" + eol + "      return this.ROLL_PERM_ARRAY;" + eol + "   }" + eol + eol + "   public int[] getHexArray()" + eol + "   {" + eol + "      return this.HEX_ARRAY;" + eol + "   }" + eol + "}");
            System.setOut(old_stdout);
            out_file.close();
            System.out.println("License arrays for application " + class_name + " successfully created");
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        System.out.print("Enter application name (= class name): ");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        try {
            String name = br.readLine();
            System.out.print("Enter application description (= application name): ");
            br = new BufferedReader(new InputStreamReader(System.in));
            String description = br.readLine();
            new GenerateArrays(name, description);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public class RandomGenerator {
        private int random_status_i = 0;
        private double[] random_status_u = new double[97];
        private double random_status_c = 0.0;

        public void init(int na1, int na2, int na3, int nb1) {
            this.random_status_i = 96;
            int j = 0;
            while (j < 97) {
                double s = 0.0;
                double t = 0.5;
                int i = 0;
                while (i < 24) {
                    int mat = na1 * na2 % 179 * na3 % 179;
                    na1 = na2;
                    na2 = na3;
                    na3 = mat;
                    if ((nb1 = (53 * nb1 + 1) % 169) * mat % 64 >= 32) {
                        s += t;
                    }
                    t /= 2.0;
                    ++i;
                }
                this.random_status_u[j] = s;
                ++j;
            }
            this.random_status_c = 0.021602869033813477;
        }

        double get() {
            double r = this.random_status_u[this.random_status_i] - this.random_status_u[(this.random_status_i + 33) % 97];
            if (r < 0.0) {
                r += 1.0;
            }
            this.random_status_u[this.random_status_i--] = r;
            if (this.random_status_i < 0) {
                this.random_status_i = 96;
            }
            this.random_status_c -= 0.45623308420181274;
            if (this.random_status_c < 0.0) {
                this.random_status_c += 0.9999998211860657;
            }
            if ((r -= this.random_status_c) < 0.0) {
                r += 1.0;
            }
            return r;
        }

        public RandomGenerator() {
            long msec_now = System.currentTimeMillis();
            long sec_now = msec_now / 1000L;
            this.init((int)(sec_now / 17L), (int)(sec_now % 1017L), (int)(msec_now / 23L), (int)(msec_now % 2023L));
        }

        public RandomGenerator(int na1, int na2, int na3, int nb1) {
            this.init(na1, na2, na3, nb1);
        }
    }
}

