/*
 * Decompiled with CFR 0.152.
 */
package jlk;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JPanel;

public class JButtonGroupPanel
extends JPanel
implements ActionListener {
    protected Vector buttons = new Vector();
    protected Vector listeners;
    protected ButtonGroup group = new ButtonGroup();

    public JButtonGroupPanel() {
        this.listeners = new Vector();
        super.setLayout(new GridLayout());
    }

    public JButtonGroupPanel(ButtonGroup grp) {
        this.listeners = new Vector();
        Enumeration<AbstractButton> e = grp.getElements();
        while (e.hasMoreElements()) {
            this.add(e.nextElement());
        }
    }

    public Enumeration getElements() {
        return this.group.getElements();
    }

    public void addActionListener(ActionListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
        }
    }

    public void removeActionListener(ActionListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.removeElement(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent event) {
        Vector vector;
        Vector vector2 = this.listeners;
        synchronized (vector2) {
            vector = (Vector)this.listeners.clone();
        }
        ActionEvent evt = new ActionEvent(this, 1001, ((AbstractButton)event.getSource()).getText());
        Enumeration e = vector.elements();
        while (e.hasMoreElements()) {
            ((ActionListener)e.nextElement()).actionPerformed(evt);
        }
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        if (comp instanceof AbstractButton) {
            AbstractButton btn = (AbstractButton)comp;
            if (!this.buttons.contains(btn)) {
                this.buttons.addElement(btn);
                this.group.add(btn);
                btn.addActionListener(this);
                super.addImpl(comp, constraints, index);
            }
        } else {
            super.addImpl(comp, constraints, index);
        }
    }

    public void remove(AbstractButton btn) {
        if (this.buttons.contains(btn)) {
            this.buttons.removeElement(btn);
            this.group.remove(btn);
        }
    }

    public void setSelection(AbstractButton btn, boolean f) {
        btn.getModel().setSelected(f);
    }

    public void setSelection(String text, boolean f) {
        Enumeration e = this.buttons.elements();
        while (e.hasMoreElements()) {
            AbstractButton btn = (AbstractButton)e.nextElement();
            if (!btn.getText().equals(text)) continue;
            this.setSelection(btn, f);
        }
    }

    public AbstractButton getSelection() {
        ButtonModel model = this.group.getSelection();
        Enumeration e = this.buttons.elements();
        while (e.hasMoreElements()) {
            AbstractButton btn = (AbstractButton)e.nextElement();
            if (btn.getModel() != model) continue;
            return btn;
        }
        return null;
    }

    public boolean isSelected(AbstractButton btn) {
        return btn == this.getSelection();
    }

    public boolean isSelected(String text) {
        return text.equals(this.getSelection().getText());
    }
}

