/*
 * Decompiled with CFR 0.152.
 */
package de.isas.mztab2.io.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import de.isas.mztab2.io.serialization.Serializers;
import de.isas.mztab2.model.Metadata;
import de.isas.mztab2.model.SmallMoleculeEvidence;
import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.pride.jmztab2.model.IMZTabColumn;
import uk.ac.ebi.pride.jmztab2.model.SmallMoleculeEvidenceColumn;

public class SmallMoleculeEvidenceSerializer
extends StdSerializer<SmallMoleculeEvidence> {
    private static final Logger log = LoggerFactory.getLogger(SmallMoleculeEvidenceSerializer.class);

    public SmallMoleculeEvidenceSerializer() {
        this(null);
    }

    public SmallMoleculeEvidenceSerializer(Class<SmallMoleculeEvidence> t) {
        super(t);
    }

    public void serializeWithType(SmallMoleculeEvidence value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        typeSer.writeTypePrefixForObject((Object)value, gen);
        this.serialize(value, gen, serializers);
        typeSer.writeTypeSuffixForObject((Object)value, gen);
    }

    public void serialize(SmallMoleculeEvidence smallMoleculeEvidence, JsonGenerator jg, SerializerProvider sp) throws IOException {
        if (smallMoleculeEvidence != null) {
            jg.writeStartObject();
            Serializers.writeString(SmallMoleculeEvidence.HeaderPrefixEnum.SEH.getValue(), jg, SmallMoleculeEvidence.PrefixEnum.SME.getValue());
            Serializers.writeNumber((IMZTabColumn)SmallMoleculeEvidenceColumn.Stable.columnFor(SmallMoleculeEvidenceColumn.Stable.SME_ID), jg, smallMoleculeEvidence.getSmeId());
            Serializers.writeString(SmallMoleculeEvidenceColumn.Stable.columnFor(SmallMoleculeEvidenceColumn.Stable.EVIDENCE_INPUT_ID), jg, smallMoleculeEvidence.getEvidenceInputId());
            Serializers.writeString(SmallMoleculeEvidenceColumn.Stable.columnFor(SmallMoleculeEvidenceColumn.Stable.DATABASE_IDENTIFIER), jg, smallMoleculeEvidence.getDatabaseIdentifier());
            Serializers.writeString(SmallMoleculeEvidenceColumn.Stable.columnFor(SmallMoleculeEvidenceColumn.Stable.CHEMICAL_FORMULA), jg, smallMoleculeEvidence.getChemicalFormula());
            Serializers.writeString(SmallMoleculeEvidenceColumn.Stable.columnFor(SmallMoleculeEvidenceColumn.Stable.SMILES), jg, smallMoleculeEvidence.getSmiles());
            Serializers.writeString(SmallMoleculeEvidenceColumn.Stable.columnFor(SmallMoleculeEvidenceColumn.Stable.INCHI), jg, smallMoleculeEvidence.getInchi());
            Serializers.writeString(SmallMoleculeEvidenceColumn.Stable.columnFor(SmallMoleculeEvidenceColumn.Stable.CHEMICAL_NAME), jg, smallMoleculeEvidence.getChemicalName());
            Serializers.writeString(SmallMoleculeEvidenceColumn.Stable.columnFor(SmallMoleculeEvidenceColumn.Stable.URI), jg, smallMoleculeEvidence.getUri());
            Serializers.writeObject(SmallMoleculeEvidenceColumn.Stable.columnFor(SmallMoleculeEvidenceColumn.Stable.DERIVATIZED_FORM), jg, sp, (Object)smallMoleculeEvidence.getDerivatizedForm());
            Serializers.writeString(SmallMoleculeEvidenceColumn.Stable.columnFor(SmallMoleculeEvidenceColumn.Stable.ADDUCT_ION), jg, smallMoleculeEvidence.getAdductIon());
            Serializers.writeNumber((IMZTabColumn)SmallMoleculeEvidenceColumn.Stable.columnFor(SmallMoleculeEvidenceColumn.Stable.EXP_MASS_TO_CHARGE), jg, smallMoleculeEvidence.getExpMassToCharge());
            Serializers.writeNumber((IMZTabColumn)SmallMoleculeEvidenceColumn.Stable.columnFor(SmallMoleculeEvidenceColumn.Stable.CHARGE), jg, smallMoleculeEvidence.getCharge());
            Serializers.writeNumber((IMZTabColumn)SmallMoleculeEvidenceColumn.Stable.columnFor(SmallMoleculeEvidenceColumn.Stable.THEORETICAL_MASS_TO_CHARGE), jg, smallMoleculeEvidence.getTheoreticalMassToCharge());
            Serializers.writeAsStringArray(SmallMoleculeEvidenceColumn.Stable.columnFor(SmallMoleculeEvidenceColumn.Stable.SPECTRA_REF), jg, Optional.ofNullable(smallMoleculeEvidence.getSpectraRef()).orElse(Collections.emptyList()).stream().map(spectraRef -> Metadata.Properties.msRun.getPropertyName() + "[" + spectraRef.getMsRun().getId() + "]:" + spectraRef.getReference()).collect(Collectors.toList()));
            Serializers.writeObject(SmallMoleculeEvidenceColumn.Stable.columnFor(SmallMoleculeEvidenceColumn.Stable.IDENTIFICATION_METHOD), jg, sp, (Object)smallMoleculeEvidence.getIdentificationMethod());
            Serializers.writeObject(SmallMoleculeEvidenceColumn.Stable.columnFor(SmallMoleculeEvidenceColumn.Stable.MS_LEVEL), jg, sp, (Object)smallMoleculeEvidence.getMsLevel());
            Serializers.writeIndexedDoubles(SmallMoleculeEvidence.Properties.idConfidenceMeasure.getPropertyName(), jg, Optional.ofNullable(smallMoleculeEvidence.getIdConfidenceMeasure()).orElse(Collections.emptyList()));
            Serializers.writeNumber((IMZTabColumn)SmallMoleculeEvidenceColumn.Stable.columnFor(SmallMoleculeEvidenceColumn.Stable.RANK), jg, smallMoleculeEvidence.getRank());
            Serializers.writeOptColumnMappings(smallMoleculeEvidence.getOpt(), jg, sp);
            jg.writeEndObject();
        } else {
            log.debug(SmallMoleculeEvidence.class.getSimpleName() + " is null!");
        }
    }
}

