/*
 * Decompiled with CFR 0.152.
 */
package de.isas.mztab2.io.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import de.isas.mztab2.io.serialization.Serializers;
import de.isas.mztab2.model.IndexedElement;
import de.isas.mztab2.model.Software;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.pride.jmztab2.model.Section;

public class SoftwareSerializer
extends StdSerializer<Software> {
    private static final Logger log = LoggerFactory.getLogger(SoftwareSerializer.class);

    public SoftwareSerializer() {
        this(null);
    }

    public SoftwareSerializer(Class<Software> t) {
        super(t);
    }

    public void serializeWithType(Software value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        typeSer.writeTypePrefixForObject((Object)value, gen);
        this.serialize(value, gen, serializers);
        typeSer.writeTypeSuffixForObject((Object)value, gen);
    }

    public void serialize(Software software, JsonGenerator jg, SerializerProvider sp) throws IOException {
        if (software != null) {
            Serializers.checkIndexedElement((IndexedElement)software);
            Serializers.addIndexedLine(jg, sp, Section.Metadata.getPrefix(), (Object)software, software.getParameter());
            Serializers.addSubElementStrings(jg, Section.Metadata.getPrefix(), software, Software.Properties.setting.getPropertyName(), software.getSetting(), false);
        } else {
            log.debug(Software.class.getSimpleName() + " is null!");
        }
    }
}

