/*
 * Decompiled with CFR 0.152.
 */
package de.isas.mztab2.io.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import de.isas.mztab2.io.serialization.Serializers;
import de.isas.mztab2.model.IndexedElement;
import de.isas.mztab2.model.Metadata;
import de.isas.mztab2.model.StudyVariable;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.pride.jmztab2.model.Section;

public class StudyVariableSerializer
extends StdSerializer<StudyVariable> {
    private static final Logger log = LoggerFactory.getLogger(StudyVariableSerializer.class);

    public StudyVariableSerializer() {
        this(null);
    }

    public StudyVariableSerializer(Class<StudyVariable> t) {
        super(t);
    }

    public void serializeWithType(StudyVariable value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        typeSer.writeTypePrefixForObject((Object)value, gen);
        this.serialize(value, gen, serializers);
        typeSer.writeTypeSuffixForObject((Object)value, gen);
    }

    public void serialize(StudyVariable studyVariable, JsonGenerator jg, SerializerProvider sp) throws IOException {
        if (studyVariable != null) {
            Serializers.checkIndexedElement((IndexedElement)studyVariable);
            Serializers.addLineWithProperty(jg, Section.Metadata.getPrefix(), null, studyVariable, studyVariable.getName());
            Serializers.addLineWithProperty(jg, Section.Metadata.getPrefix(), StudyVariable.Properties.description.getPropertyName(), studyVariable, studyVariable.getDescription());
            Serializers.addSubElementParameters(jg, Section.Metadata.getPrefix(), studyVariable, StudyVariable.Properties.factors.getPropertyName(), studyVariable.getFactors(), true);
            Serializers.addLineWithProperty(jg, Section.Metadata.getPrefix(), StudyVariable.Properties.averageFunction.getPropertyName(), studyVariable, studyVariable.getAverageFunction());
            Serializers.addLineWithProperty(jg, Section.Metadata.getPrefix(), StudyVariable.Properties.variationFunction.getPropertyName(), studyVariable, studyVariable.getVariationFunction());
            Serializers.addSubElementStrings(jg, Section.Metadata.getPrefix(), studyVariable, StudyVariable.Properties.assayRefs.getPropertyName(), Optional.ofNullable(studyVariable.getAssayRefs()).orElse(Collections.emptyList()).stream().sorted(Comparator.comparing(IndexedElement::getId, Comparator.nullsFirst(Comparator.naturalOrder()))).map(assayRef -> Metadata.Properties.assay.getPropertyName() + "[" + assayRef.getId() + "]").collect(Collectors.toList()), true);
        } else {
            log.debug(StudyVariable.class.getSimpleName() + " is null!");
        }
    }
}

