/*
 * Decompiled with CFR 0.152.
 */
package de.isas.mztab2.io.validators;

import de.isas.mztab2.io.validators.RefiningValidator;
import de.isas.mztab2.model.Database;
import de.isas.mztab2.model.Metadata;
import java.util.LinkedList;
import java.util.List;
import uk.ac.ebi.pride.jmztab2.utils.errors.LogicalErrorType;
import uk.ac.ebi.pride.jmztab2.utils.errors.MZTabError;
import uk.ac.ebi.pride.jmztab2.utils.parser.MZTabParserContext;

public class DatabaseValidator
implements RefiningValidator<Metadata> {
    @Override
    public List<MZTabError> validateRefine(Metadata metadata, MZTabParserContext parserContext) {
        LinkedList<MZTabError> errorList = new LinkedList<MZTabError>();
        if (metadata.getDatabase() == null || metadata.getDatabase().isEmpty()) {
            errorList.add(new MZTabError(LogicalErrorType.NotDefineInMetadata, -1, new String[]{Metadata.Properties.database + ""}));
        } else {
            for (Database db : metadata.getDatabase()) {
                if (db.getParam().getName().equals("no database")) {
                    if (db.getPrefix() != null && !db.getPrefix().equals("null")) {
                        errorList.add(new MZTabError(LogicalErrorType.NoDatabaseMustHaveNullPrefix, -1, new String[]{db.getId() + "", db.getPrefix()}));
                    }
                    if (db.getUri() != null && !db.getUri().equals("null")) {
                        errorList.add(new MZTabError(LogicalErrorType.NotDefineInMetadata, -1, new String[]{Metadata.Properties.database + "[" + db.getId() + "]-" + Database.Properties.uri}));
                    }
                } else if (db.getUri() == null) {
                    errorList.add(new MZTabError(LogicalErrorType.NotDefineInMetadata, -1, new String[]{Metadata.Properties.database + "[" + db.getId() + "]-" + Database.Properties.uri}));
                }
                if (db.getVersion() != null) continue;
                errorList.add(new MZTabError(LogicalErrorType.NotDefineInMetadata, -1, new String[]{Metadata.Properties.database + "[" + db.getId() + "]-" + Database.Properties.version}));
            }
        }
        return errorList;
    }
}

