/*
 * Decompiled with CFR 0.152.
 */
package de.isas.mztab2.io.validators;

import de.isas.mztab2.io.validators.FieldValidator;
import de.isas.mztab2.model.MsRun;
import de.isas.mztab2.model.Parameter;
import de.isas.mztab2.model.SpectraRef;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.ebi.pride.jmztab2.model.IMZTabColumn;
import uk.ac.ebi.pride.jmztab2.utils.errors.FormatErrorType;
import uk.ac.ebi.pride.jmztab2.utils.errors.LogicalErrorType;
import uk.ac.ebi.pride.jmztab2.utils.errors.MZTabError;
import uk.ac.ebi.pride.jmztab2.utils.parser.MZTabParserContext;

public class SpectraRefValidator
implements FieldValidator<List<SpectraRef>> {
    @Override
    public List<MZTabError> validateLine(int lineNumber, MZTabParserContext parserContext, IMZTabColumn column, String field, List<SpectraRef> refList) {
        LinkedList<MZTabError> errorList = new LinkedList<MZTabError>();
        if (refList.isEmpty()) {
            errorList.add(new MZTabError(FormatErrorType.SpectraRef, lineNumber, new String[]{column.getHeader(), field}));
        } else {
            for (SpectraRef ref : refList) {
                Optional<MZTabError> error;
                MsRun run = ref.getMsRun();
                if (!Optional.ofNullable(run.getLocation()).isPresent()) {
                    errorList.add(new MZTabError(LogicalErrorType.SpectraRef, lineNumber, new String[]{column.getHeader(), field, "ms_run[" + run.getId() + "]-location"}));
                    continue;
                }
                String referenceString = ref.getReference();
                Parameter idFormatParam = run.getIdFormat();
                if (idFormatParam == null || idFormatParam.getCvAccession() == null || idFormatParam.getCvAccession().isEmpty()) continue;
                String validationPattern = "";
                switch (idFormatParam.getCvAccession()) {
                    case "MS:1000768": {
                        validationPattern = "controllerType=[\\d]+ controllerNumber=[1-9]\\d* scan=[1-9]\\d*";
                        break;
                    }
                    case "MS:1000769": {
                        validationPattern = "function=[1-9]\\d* process=[\\d]+ scan=[\\d]+";
                        break;
                    }
                    case "MS:1000770": {
                        validationPattern = "sample=[\\d]+ period=[\\d]+ cycle=[\\d]+ experiment=[\\d]+";
                        break;
                    }
                    case "MS:1000774": {
                        validationPattern = "index=[\\d]+";
                        break;
                    }
                    case "MS:1000773": 
                    case "MS:1000775": {
                        validationPattern = "file=[\\w]+";
                        break;
                    }
                    case "MS:1000777": {
                        validationPattern = "spectrum=[\\d]+";
                        break;
                    }
                    case "MS:1001530": {
                        validationPattern = "[\\w]+";
                        break;
                    }
                    case "MS:1000771": 
                    case "MS:1000772": 
                    case "MS:1000776": {
                        validationPattern = "scan=[\\d]+";
                        break;
                    }
                    default: {
                        errorList.add(new MZTabError(LogicalErrorType.SpectraIdFormatNotSupported, lineNumber, new String[]{referenceString, column.getHeader()}));
                    }
                }
                if (validationPattern.isEmpty() || !(error = this.validatePattern(Pattern.compile(validationPattern), referenceString, lineNumber, column, field, run)).isPresent()) continue;
                errorList.add(error.get());
            }
        }
        return errorList;
    }

    protected Optional<MZTabError> validatePattern(Pattern pattern, String reference, int lineNumber, IMZTabColumn column, String field, MsRun run) {
        Matcher matcher = pattern.matcher(reference);
        if (matcher.find()) {
            return Optional.empty();
        }
        return Optional.of(new MZTabError(LogicalErrorType.SpectraIdFormatNotValid, lineNumber, new String[]{reference, column.getHeader(), pattern.toString()}));
    }
}

