/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.jmztab2.model;

public enum MetadataElement {
    MZTAB("mzTab"),
    TITLE("title"),
    DESCRIPTION("description"),
    SAMPLE_PROCESSING("sample_processing"),
    INSTRUMENT("instrument"),
    SOFTWARE("software"),
    PUBLICATION("publication"),
    CONTACT("contact"),
    URI("uri"),
    EXTERNAL_STUDY_URI("external_study_uri"),
    DERIVATIZATION_AGENT("derivatization_agent"),
    QUANTIFICATION_METHOD("quantification_method"),
    SMALL_MOLECULE("small_molecule"),
    SMALL_MOLECULE_FEATURE("small_molecule_feature"),
    MS_RUN("ms_run"),
    CUSTOM("custom"),
    SAMPLE("sample"),
    ASSAY("assay"),
    STUDY_VARIABLE("study_variable"),
    CV("cv"),
    COLUNIT("colunit"),
    COLUNIT_SMALL_MOLECULE("colunit-small_molecule"),
    COLUNIT_SMALL_MOLECULE_FEATURE("colunit-small_molecule_feature"),
    COLUNIT_SMALL_MOLECULE_EVIDENCE("colunit-small_molecule_evidence"),
    ID_CONFIDENCE_MEASURE("id_confidence_measure"),
    DATABASE("database"),
    SMALLMOLECULE_QUANTIFICATION_UNIT("small_molecule-quantification_unit"),
    SMALLMOLECULE_FEATURE_QUANTIFICATION_UNIT("small_molecule_feature-quantification_unit"),
    SMALLMOLECULE_IDENTIFICATION_RELIABILITY("small_molecule-identification_reliability");

    private final String name;

    private MetadataElement(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public static MetadataElement findElement(String name) {
        MetadataElement element;
        if (name == null) {
            return null;
        }
        try {
            element = MetadataElement.valueOf(name.trim().toUpperCase());
        }
        catch (IllegalArgumentException e) {
            element = null;
        }
        return element;
    }
}

