/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.jmztab2.model;

import de.isas.mztab2.model.IndexedElement;
import de.isas.mztab2.model.OptColumnMapping;
import de.isas.mztab2.model.Parameter;
import uk.ac.ebi.pride.jmztab2.model.IOptColumnMappingBuilder;
import uk.ac.ebi.pride.jmztab2.model.OptionColumn;
import uk.ac.ebi.pride.jmztab2.model.ParameterOptionColumn;

public class OptColumnMappingBuilder
implements IOptColumnMappingBuilder {
    private OptColumnMappingBuilder() {
    }

    public static GlobalOptColumnMappingBuilder forGlobal() {
        return new GlobalOptColumnMappingBuilder();
    }

    public static IndexedElementOptColumnMappingBuilder forIndexedElement(IndexedElement indexedElement) {
        return new IndexedElementOptColumnMappingBuilder(indexedElement);
    }

    public static class IndexedElementOptColumnMappingBuilder
    extends NameParamOptColumnMappingBuilder {
        private final IndexedElement indexedElement;

        @Override
        public IndexedElementOptColumnMappingBuilder withName(String name) {
            super.withName(name);
            return this;
        }

        @Override
        public IndexedElementOptColumnMappingBuilder withParameter(Parameter parameter) {
            super.withParameter(parameter);
            return this;
        }

        public IndexedElementOptColumnMappingBuilder(IndexedElement indexedElement) {
            this.indexedElement = indexedElement;
        }

        @Override
        public OptColumnMapping build(String value) {
            if (this.indexedElement == null) {
                throw new IllegalArgumentException("Indexed element must not be null!");
            }
            if (this.param != null) {
                return new OptColumnMapping().param(this.param).value(value).identifier(ParameterOptionColumn.getHeader(this.indexedElement, this.param));
            }
            if (this.name == null) {
                throw new IllegalArgumentException("Name must be defined if parameter is not set!");
            }
            return new OptColumnMapping().value(value).identifier(OptionColumn.getHeader(this.indexedElement, this.name));
        }
    }

    public static class GlobalOptColumnMappingBuilder
    extends NameParamOptColumnMappingBuilder {
        @Override
        public GlobalOptColumnMappingBuilder withName(String name) {
            super.withName(name);
            return this;
        }

        @Override
        public GlobalOptColumnMappingBuilder withParameter(Parameter parameter) {
            super.withParameter(parameter);
            return this;
        }

        @Override
        public OptColumnMapping build(String value) {
            if (this.param != null) {
                return new OptColumnMapping().param(this.param).value(value).identifier(ParameterOptionColumn.getHeader(null, this.param));
            }
            if (this.name == null) {
                throw new IllegalArgumentException("Name must be defined if parameter is not set!");
            }
            return new OptColumnMapping().value(value).identifier(OptionColumn.getHeader(null, this.name));
        }
    }

    private static class NameParamOptColumnMappingBuilder
    implements IOptColumnMappingBuilder {
        protected Parameter param;
        protected String name;

        private NameParamOptColumnMappingBuilder() {
        }

        IOptColumnMappingBuilder withName(String name) {
            if (this.param != null) {
                throw new IllegalStateException("Can not set name for opt column, parameter already has been set!");
            }
            this.name = name;
            return this;
        }

        IOptColumnMappingBuilder withParameter(Parameter parameter) {
            if (this.name != null) {
                throw new IllegalStateException("Can not set parameter for opt column, name has been set already!");
            }
            if (parameter.getCvAccession() == null || parameter.getCvAccession().isEmpty()) {
                throw new IllegalArgumentException("Parameter must have cvAccession defined!");
            }
            if (parameter.getCvLabel() == null || parameter.getCvLabel().isEmpty()) {
                throw new IllegalArgumentException("Parameter must have cvLabel defined!");
            }
            if (parameter.getName() == null || parameter.getName().isEmpty()) {
                throw new IllegalArgumentException("Parameter must have name defined!");
            }
            this.param = parameter;
            return this;
        }
    }
}

