/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.jmztab2.model;

import uk.ac.ebi.pride.jmztab2.model.MZTabStringUtils;

public enum Section {
    Comment("COM", "comment", 0),
    Metadata("MTD", "metadata", 1),
    Protein_Header("PRH", "protein_header", 2),
    Protein("PRT", "protein", 3),
    Peptide_Header("PEH", "peptide_header", 4),
    Peptide("PEP", "peptide", 5),
    PSM_Header("PSH", "psm_header", 6),
    PSM("PSM", "psm", 7),
    Small_Molecule_Header("SMH", "small_molecule_header", 8),
    Small_Molecule("SML", "small_molecule", 9),
    Small_Molecule_Feature_Header("SFH", "small_molecule_feature_header", 10),
    Small_Molecule_Feature("SMF", "small_molecule_feature", 11),
    Small_Molecule_Evidence_Header("SEH", "small_molecule_evidence_header", 12),
    Small_Molecule_Evidence("SME", "small_molecule_evidence", 13);

    private final String prefix;
    private final String name;
    private final int level;

    private Section(String prefix, String name, int level) {
        this.prefix = prefix;
        this.name = name;
        this.level = level;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getName() {
        return this.name;
    }

    public int getLevel() {
        return this.level;
    }

    public static Section findSection(int level) {
        Section section;
        switch (level) {
            case 0: {
                section = Comment;
                break;
            }
            case 1: {
                section = Metadata;
                break;
            }
            case 2: {
                section = Protein_Header;
                break;
            }
            case 3: {
                section = Protein;
                break;
            }
            case 4: {
                section = Peptide_Header;
                break;
            }
            case 5: {
                section = Peptide;
                break;
            }
            case 6: {
                section = PSM_Header;
                break;
            }
            case 7: {
                section = PSM;
                break;
            }
            case 8: {
                section = Small_Molecule_Header;
                break;
            }
            case 9: {
                section = Small_Molecule;
                break;
            }
            case 10: {
                section = Small_Molecule_Feature_Header;
                break;
            }
            case 11: {
                section = Small_Molecule_Feature;
                break;
            }
            case 12: {
                section = Small_Molecule_Evidence_Header;
                break;
            }
            case 13: {
                section = Small_Molecule_Evidence;
                break;
            }
            default: {
                section = null;
            }
        }
        return section;
    }

    public boolean isComment() {
        return this == Comment;
    }

    public boolean isMetadata() {
        return this == Metadata;
    }

    public boolean isHeader() {
        return this == Protein_Header || this == Peptide_Header || this == PSM_Header || this == Small_Molecule_Header || this == Small_Molecule_Feature_Header || this == Small_Molecule_Evidence_Header;
    }

    public boolean isData() {
        return this == Protein || this == Peptide || this == PSM || this == Small_Molecule || this == Small_Molecule_Feature || this == Small_Molecule_Evidence;
    }

    public static Section toHeaderSection(Section section) {
        Section header;
        switch (section) {
            case Peptide: 
            case Peptide_Header: {
                header = Peptide_Header;
                break;
            }
            case Protein: 
            case Protein_Header: {
                header = Protein_Header;
                break;
            }
            case PSM: 
            case PSM_Header: {
                header = PSM_Header;
                break;
            }
            case Small_Molecule: 
            case Small_Molecule_Header: {
                header = Small_Molecule_Header;
                break;
            }
            case Small_Molecule_Feature: 
            case Small_Molecule_Feature_Header: {
                header = Small_Molecule_Feature_Header;
                break;
            }
            case Small_Molecule_Evidence: 
            case Small_Molecule_Evidence_Header: {
                header = Small_Molecule_Evidence_Header;
                break;
            }
            default: {
                header = null;
            }
        }
        return header;
    }

    public static Section toDataSection(Section section) {
        Section data;
        switch (section) {
            case Peptide: 
            case Peptide_Header: {
                data = Peptide;
                break;
            }
            case Protein: 
            case Protein_Header: {
                data = Protein;
                break;
            }
            case PSM: 
            case PSM_Header: {
                data = PSM;
                break;
            }
            case Small_Molecule: 
            case Small_Molecule_Header: {
                data = Small_Molecule;
                break;
            }
            case Small_Molecule_Feature: 
            case Small_Molecule_Feature_Header: {
                data = Small_Molecule_Feature;
                break;
            }
            case Small_Molecule_Evidence: 
            case Small_Molecule_Evidence_Header: {
                data = Small_Molecule_Evidence;
                break;
            }
            default: {
                data = null;
            }
        }
        return data;
    }

    public static Section findSection(String key) {
        if (MZTabStringUtils.isEmpty((String)key)) {
            return null;
        }
        if ((key = key.trim()).equalsIgnoreCase(Comment.getName()) || key.equalsIgnoreCase(Comment.getPrefix())) {
            return Comment;
        }
        if (key.equalsIgnoreCase(Metadata.getName()) || key.equalsIgnoreCase(Metadata.getPrefix())) {
            return Metadata;
        }
        if (key.equalsIgnoreCase(Peptide_Header.getName()) || key.equalsIgnoreCase(Peptide_Header.getPrefix())) {
            return Peptide_Header;
        }
        if (key.equalsIgnoreCase(Peptide.getName()) || key.equalsIgnoreCase(Peptide.getPrefix())) {
            return Peptide;
        }
        if (key.equalsIgnoreCase(Protein_Header.getName()) || key.equalsIgnoreCase(Protein_Header.getPrefix())) {
            return Protein_Header;
        }
        if (key.equalsIgnoreCase(Protein.getName()) || key.equalsIgnoreCase(Protein.getPrefix())) {
            return Protein;
        }
        if (key.equalsIgnoreCase(PSM_Header.getName()) || key.equalsIgnoreCase(PSM_Header.getPrefix())) {
            return PSM_Header;
        }
        if (key.equalsIgnoreCase(PSM.getName()) || key.equalsIgnoreCase(PSM.getPrefix())) {
            return PSM;
        }
        if (key.equalsIgnoreCase(Small_Molecule_Header.getName()) || key.equalsIgnoreCase(Small_Molecule_Header.getPrefix())) {
            return Small_Molecule_Header;
        }
        if (key.equalsIgnoreCase(Small_Molecule.getName()) || key.equalsIgnoreCase(Small_Molecule.getPrefix())) {
            return Small_Molecule;
        }
        if (key.equalsIgnoreCase(Small_Molecule_Feature_Header.getName()) || key.equalsIgnoreCase(Small_Molecule_Feature_Header.getPrefix())) {
            return Small_Molecule_Feature_Header;
        }
        if (key.equalsIgnoreCase(Small_Molecule_Feature.getName()) || key.equalsIgnoreCase(Small_Molecule_Feature.getPrefix())) {
            return Small_Molecule_Feature;
        }
        if (key.equalsIgnoreCase(Small_Molecule_Evidence_Header.getName()) || key.equalsIgnoreCase(Small_Molecule_Evidence_Header.getPrefix())) {
            return Small_Molecule_Evidence_Header;
        }
        if (key.equalsIgnoreCase(Small_Molecule_Evidence.getName()) || key.equalsIgnoreCase(Small_Molecule_Evidence.getPrefix())) {
            return Small_Molecule_Evidence;
        }
        return null;
    }
}

