/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.jmztab2.utils.parser;

import de.isas.mztab2.model.Assay;
import de.isas.mztab2.model.CV;
import de.isas.mztab2.model.ColumnParameterMapping;
import de.isas.mztab2.model.Contact;
import de.isas.mztab2.model.Database;
import de.isas.mztab2.model.Instrument;
import de.isas.mztab2.model.Metadata;
import de.isas.mztab2.model.MsRun;
import de.isas.mztab2.model.Parameter;
import de.isas.mztab2.model.Publication;
import de.isas.mztab2.model.PublicationItem;
import de.isas.mztab2.model.Sample;
import de.isas.mztab2.model.SampleProcessing;
import de.isas.mztab2.model.Software;
import de.isas.mztab2.model.StudyVariable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import uk.ac.ebi.pride.jmztab2.model.MZTabStringUtils;

public class MZTabParserContext {
    private SortedMap<Integer, SampleProcessing> sampleProcessingMap = new TreeMap<Integer, SampleProcessing>();
    private SortedMap<Integer, Instrument> instrumentMap = new TreeMap<Integer, Instrument>();
    private SortedMap<Integer, Software> softwareMap = new TreeMap<Integer, Software>();
    private SortedMap<Integer, Publication> publicationMap = new TreeMap<Integer, Publication>();
    private SortedMap<Integer, Contact> contactMap = new TreeMap<Integer, Contact>();
    private Parameter quantificationMethod;
    private SortedMap<Integer, Assay> assayMap = new TreeMap<Integer, Assay>();
    private Parameter smallMoleculeQuantificationUnit;
    private SortedMap<Integer, MsRun> msRunMap = new TreeMap<Integer, MsRun>();
    private SortedMap<Integer, Parameter> customItemMap = new TreeMap<Integer, Parameter>();
    private SortedMap<Integer, Parameter> derivatizationItemMap = new TreeMap<Integer, Parameter>();
    private SortedMap<Integer, Parameter> idConfidenceMeasureMap = new TreeMap<Integer, Parameter>();
    private SortedMap<Integer, Sample> sampleMap = new TreeMap<Integer, Sample>();
    private SortedMap<Integer, StudyVariable> studyVariableMap = new TreeMap<Integer, StudyVariable>();
    private SortedMap<Integer, CV> cvMap = new TreeMap<Integer, CV>();
    private SortedMap<Integer, Database> databaseMap = new TreeMap<Integer, Database>();
    private List<ColumnParameterMapping> smallMoleculeColUnitList = new ArrayList<ColumnParameterMapping>();
    private List<ColumnParameterMapping> smallMoleculeFeatureColUnitList = new ArrayList<ColumnParameterMapping>();
    private List<ColumnParameterMapping> smallMoleculeEvidenceColUnitList = new ArrayList<ColumnParameterMapping>();
    private Map<String, String> colUnitMap = new HashMap<String, String>();

    public Sample addSample(Metadata metadata, Sample sample) {
        if (sample == null) {
            throw new IllegalArgumentException("Sample should not be null");
        }
        this.sampleMap.put(sample.getId(), sample);
        metadata.addSampleItem(sample);
        return sample;
    }

    public Sample addSampleSpecies(Metadata metadata, Integer id, Parameter species) {
        if (id <= 0) {
            throw new IllegalArgumentException("Sample id should be greater than 0!");
        }
        Sample sample = (Sample)this.sampleMap.get(id);
        if (species == null) {
            return sample;
        }
        if (sample == null) {
            sample = new Sample();
            sample.id(id);
            sample.addSpeciesItem(species);
            this.sampleMap.put(id, sample);
            metadata.addSampleItem(sample);
        } else {
            sample.addSpeciesItem(species);
        }
        return sample;
    }

    public Sample addSampleTissue(Metadata metadata, Integer id, Parameter tissue) {
        if (id <= 0) {
            throw new IllegalArgumentException("Sample id should be greater than 0!");
        }
        Sample sample = (Sample)this.sampleMap.get(id);
        if (tissue == null) {
            return sample;
        }
        if (sample == null) {
            sample = new Sample();
            sample.id(id);
            sample.addTissueItem(tissue);
            this.sampleMap.put(id, sample);
            metadata.addSampleItem(sample);
        } else {
            sample.addTissueItem(tissue);
        }
        return sample;
    }

    public Sample addSampleCellType(Metadata metadata, Integer id, Parameter cellType) {
        if (id <= 0) {
            throw new IllegalArgumentException("Sample id should be greater than 0!");
        }
        Sample sample = (Sample)this.sampleMap.get(id);
        if (cellType == null) {
            return sample;
        }
        if (sample == null) {
            sample = new Sample();
            sample.id(id);
            sample.addCellTypeItem(cellType);
            this.sampleMap.put(id, sample);
            metadata.addSampleItem(sample);
        } else {
            sample.addCellTypeItem(cellType);
        }
        return sample;
    }

    public Sample addSampleDisease(Metadata metadata, Integer id, Parameter disease) {
        if (id <= 0) {
            throw new IllegalArgumentException("Sample id should be greater than 0!");
        }
        Sample sample = (Sample)this.sampleMap.get(id);
        if (disease == null) {
            return sample;
        }
        if (sample == null) {
            sample = new Sample();
            sample.id(id);
            sample.addDiseaseItem(disease);
            this.sampleMap.put(id, sample);
            metadata.addSampleItem(sample);
        } else {
            sample.addDiseaseItem(disease);
        }
        return sample;
    }

    public Sample addSampleDescription(Metadata metadata, Integer id, String description) {
        if (id <= 0) {
            throw new IllegalArgumentException("Sample id should be greater than 0!");
        }
        Sample sample = (Sample)this.sampleMap.get(id);
        if (MZTabStringUtils.isEmpty((String)description)) {
            return sample;
        }
        if (sample == null) {
            sample = new Sample();
            sample.id(id);
            sample.setDescription(description);
            this.sampleMap.put(id, sample);
            metadata.addSampleItem(sample);
        } else {
            sample.setDescription(description);
        }
        return sample;
    }

    public Sample addSampleCustom(Metadata metadata, Integer id, Parameter custom) {
        if (id <= 0) {
            throw new IllegalArgumentException("Sample id should be greater than 0!");
        }
        Sample sample = (Sample)this.sampleMap.get(id);
        if (custom == null) {
            return sample;
        }
        if (sample == null) {
            sample = new Sample();
            sample.id(id);
            sample.addCustomItem(custom);
            this.sampleMap.put(id, sample);
            metadata.addSampleItem(sample);
        } else {
            sample.addCustomItem(custom);
        }
        return sample;
    }

    public SampleProcessing addSampleProcessing(Metadata metadata, Integer id, List<Parameter> sampleProcessing) {
        if (id <= 0) {
            throw new IllegalArgumentException("Sample id should be greater than 0!");
        }
        if (sampleProcessing == null) {
            return null;
        }
        SampleProcessing sp = new SampleProcessing();
        sp.id(id);
        sp.sampleProcessing(sampleProcessing);
        metadata.addSampleProcessingItem(sp);
        this.sampleProcessingMap.put(id, sp);
        return sp;
    }

    public SampleProcessing addSampleProcessingParameter(Metadata metadata, Integer id, Parameter param) {
        if (id <= 0) {
            throw new IllegalArgumentException("Sample processing id should be greater than 0!");
        }
        SampleProcessing sampleProcessing = (SampleProcessing)this.sampleProcessingMap.get(id);
        if (param == null) {
            return sampleProcessing;
        }
        if (sampleProcessing == null) {
            sampleProcessing = new SampleProcessing();
            sampleProcessing.id(id);
            sampleProcessing.addSampleProcessingItem(param);
            this.sampleProcessingMap.put(id, sampleProcessing);
            metadata.addSampleProcessingItem(sampleProcessing);
        } else {
            sampleProcessing.addSampleProcessingItem(param);
        }
        return sampleProcessing;
    }

    public Instrument addInstrument(Metadata metadata, Instrument instrument) {
        if (instrument == null) {
            throw new IllegalArgumentException("Instrument should not be null");
        }
        this.instrumentMap.put(instrument.getId(), instrument);
        metadata.addInstrumentItem(instrument);
        return instrument;
    }

    public Instrument addInstrumentName(Metadata metadata, Integer id, Parameter name) {
        if (id <= 0) {
            throw new IllegalArgumentException("Instrument id should be greater than 0!");
        }
        Instrument instrument = (Instrument)this.instrumentMap.get(id);
        if (name == null) {
            return instrument;
        }
        if (instrument == null) {
            instrument = new Instrument();
            instrument.id(id);
            instrument.name(name);
            this.instrumentMap.put(id, instrument);
            metadata.addInstrumentItem(instrument);
        } else {
            instrument.name(name);
        }
        return instrument;
    }

    public Instrument addInstrumentSource(Metadata metadata, Integer id, Parameter source) {
        if (id <= 0) {
            throw new IllegalArgumentException("Instrument id should be greater than 0!");
        }
        Instrument instrument = (Instrument)this.instrumentMap.get(id);
        if (source == null) {
            return instrument;
        }
        if (instrument == null) {
            instrument = new Instrument();
            instrument.id(id);
            instrument.setSource(source);
            this.instrumentMap.put(id, instrument);
            metadata.addInstrumentItem(instrument);
        } else {
            instrument.setSource(source);
        }
        return instrument;
    }

    public Instrument addInstrumentAnalyzer(Metadata metadata, Integer id, Parameter analyzer) {
        if (id <= 0) {
            throw new IllegalArgumentException("Instrument id should be greater than 0!");
        }
        Instrument instrument = (Instrument)this.instrumentMap.get(id);
        if (analyzer == null) {
            return instrument;
        }
        if (instrument == null) {
            instrument = new Instrument();
            instrument.id(id);
            instrument.addAnalyzerItem(analyzer);
            this.instrumentMap.put(id, instrument);
            metadata.addInstrumentItem(instrument);
        } else {
            instrument.addAnalyzerItem(analyzer);
        }
        return instrument;
    }

    public Instrument addInstrumentDetector(Metadata metadata, Integer id, Parameter detector) {
        if (id <= 0) {
            throw new IllegalArgumentException("Instrument id should be greater than 0!");
        }
        Instrument instrument = (Instrument)this.instrumentMap.get(id);
        if (detector == null) {
            return instrument;
        }
        if (instrument == null) {
            instrument = new Instrument();
            instrument.id(id);
            instrument.setDetector(detector);
            this.instrumentMap.put(id, instrument);
            metadata.addInstrumentItem(instrument);
        } else {
            instrument.setDetector(detector);
        }
        return instrument;
    }

    public Software addSoftware(Metadata metadata, Software software) {
        if (software == null) {
            throw new IllegalArgumentException("Software should not be null");
        }
        this.softwareMap.put(software.getId(), software);
        metadata.addSoftwareItem(software);
        return software;
    }

    public Software addSoftwareParameter(Metadata metadata, Integer id, Parameter param) {
        if (id <= 0) {
            throw new IllegalArgumentException("Software id should be greater than 0!");
        }
        Software software = (Software)this.softwareMap.get(id);
        if (param == null) {
            return software;
        }
        if (software == null) {
            software = new Software();
            software.id(id);
            software.setParameter(param);
            this.softwareMap.put(id, software);
            metadata.addSoftwareItem(software);
        } else {
            software.setParameter(param);
        }
        return software;
    }

    public Software addSoftwareSetting(Metadata metadata, Integer id, String setting) {
        if (id <= 0) {
            throw new IllegalArgumentException("Software id should be greater than 0!");
        }
        Software software = (Software)this.softwareMap.get(id);
        if (MZTabStringUtils.isEmpty((String)setting)) {
            return software;
        }
        if (software == null) {
            software = new Software();
            software.id(id);
            software.addSettingItem(setting);
            this.softwareMap.put(id, software);
            metadata.addSoftwareItem(software);
        } else {
            software.addSettingItem(setting);
        }
        return software;
    }

    public Publication addPublication(Metadata metadata, Publication publication) {
        if (publication == null) {
            throw new IllegalArgumentException("Publication should not be null");
        }
        this.publicationMap.put(publication.getId(), publication);
        metadata.addPublicationItem(publication);
        return publication;
    }

    public Publication addPublicationItem(Metadata metadata, Integer id, PublicationItem.TypeEnum type, String accession) {
        if (id <= 0) {
            throw new IllegalArgumentException("Publication id should be greater than 0!");
        }
        if (type == null) {
            throw new NullPointerException("Publication type should not be null");
        }
        if (MZTabStringUtils.isEmpty((String)accession)) {
            throw new IllegalArgumentException("Publication accession should not be empty.");
        }
        Publication publication = (Publication)this.publicationMap.get(id);
        if (publication == null) {
            publication = new Publication();
            publication.id(id);
            publication.addPublicationItemsItem(new PublicationItem().type(type).accession(accession));
            this.publicationMap.put(id, publication);
            metadata.addPublicationItem(publication);
        } else {
            publication.addPublicationItemsItem(new PublicationItem().type(type).accession(accession));
        }
        return publication;
    }

    public Publication addPublicationItems(Metadata metadata, Integer id, Collection<PublicationItem> items) {
        if (id <= 0) {
            throw new IllegalArgumentException("Publication id should be greater than 0!");
        }
        if (items == null) {
            throw new NullPointerException("Publication items should not be null");
        }
        Publication publication = (Publication)this.publicationMap.get(id);
        if (publication == null) {
            publication = new Publication();
            publication.id(id);
            publication.setPublicationItems(new ArrayList<PublicationItem>(items));
            this.publicationMap.put(id, publication);
            metadata.addPublicationItem(publication);
        } else {
            publication.setPublicationItems(new ArrayList<PublicationItem>(items));
        }
        return publication;
    }

    public Contact addContact(Metadata metadata, Contact contact) {
        if (contact == null) {
            throw new IllegalArgumentException("Contact should not be null");
        }
        this.contactMap.put(contact.getId(), contact);
        metadata.addContactItem(contact);
        return contact;
    }

    public Contact addContactName(Metadata metadata, Integer id, String name) {
        if (id <= 0) {
            throw new IllegalArgumentException("Contact id should be greater than 0!");
        }
        if (MZTabStringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("Contact name should not be empty.");
        }
        Contact contact = (Contact)this.contactMap.get(id);
        if (contact == null) {
            contact = new Contact();
            contact.id(id);
            contact.setName(name);
            this.contactMap.put(id, contact);
            metadata.addContactItem(contact);
        } else {
            contact.setName(name);
        }
        return contact;
    }

    public Contact addContactAffiliation(Metadata metadata, Integer id, String affiliation) {
        if (id <= 0) {
            throw new IllegalArgumentException("Contact id should be greater than 0!");
        }
        if (MZTabStringUtils.isEmpty((String)affiliation)) {
            throw new IllegalArgumentException("Contact affiliation should not be empty.");
        }
        Contact contact = (Contact)this.contactMap.get(id);
        if (contact == null) {
            contact = new Contact();
            contact.id(id);
            contact.setAffiliation(affiliation);
            this.contactMap.put(id, contact);
            metadata.addContactItem(contact);
        } else {
            contact.setAffiliation(affiliation);
        }
        return contact;
    }

    public Contact addContactEmail(Metadata metadata, Integer id, String email) {
        if (id <= 0) {
            throw new IllegalArgumentException("Contact id should be greater than 0!");
        }
        if (MZTabStringUtils.isEmpty((String)email)) {
            throw new IllegalArgumentException("Contact email should not be empty.");
        }
        Contact contact = (Contact)this.contactMap.get(id);
        if (contact == null) {
            contact = new Contact();
            contact.id(id);
            contact.setEmail(email);
            this.contactMap.put(id, contact);
            metadata.addContactItem(contact);
        } else {
            contact.setEmail(email);
        }
        return contact;
    }

    public MsRun addMsRun(Metadata metadata, MsRun msRun) {
        if (msRun == null) {
            throw new IllegalArgumentException("MsRun should not be null");
        }
        this.msRunMap.put(msRun.getId(), msRun);
        metadata.addMsRunItem(msRun);
        return msRun;
    }

    public MsRun addMsRunFormat(Metadata metadata, Integer id, Parameter format) {
        if (id <= 0) {
            throw new IllegalArgumentException("ms_run id should be greater than 0!");
        }
        MsRun msRun = (MsRun)this.msRunMap.get(id);
        if (format == null) {
            return msRun;
        }
        if (msRun == null) {
            msRun = new MsRun();
            msRun.id(id);
            msRun.setFormat(format);
            this.msRunMap.put(id, msRun);
            metadata.addMsRunItem(msRun);
        } else {
            msRun.setFormat(format);
        }
        return msRun;
    }

    public MsRun addMsRunLocation(Metadata metadata, Integer id, URI location) {
        if (id <= 0) {
            throw new IllegalArgumentException("ms_run id should be greater than 0!");
        }
        MsRun msRun = (MsRun)this.msRunMap.get(id);
        if (msRun == null) {
            msRun = new MsRun();
            msRun.id(id);
            msRun.setLocation(location == null ? null : location.toASCIIString());
            this.msRunMap.put(id, msRun);
            metadata.addMsRunItem(msRun);
        } else {
            msRun.setLocation(location.toString());
        }
        return msRun;
    }

    public MsRun addMsRunInstrumentRef(Metadata metadata, Integer id, Instrument instrument) {
        if (id <= 0) {
            throw new IllegalArgumentException("ms_run id should be greater than 0!");
        }
        if (instrument == null) {
            throw new IllegalArgumentException("instrument must not be null!");
        }
        MsRun msRun = (MsRun)this.msRunMap.get(id);
        if (msRun == null) {
            msRun = new MsRun();
            msRun.id(id);
            msRun.setInstrumentRef(instrument);
            this.msRunMap.put(id, msRun);
            metadata.addMsRunItem(msRun);
        } else {
            msRun.setInstrumentRef(instrument);
        }
        return msRun;
    }

    public MsRun addMsRunIdFormat(Metadata metadata, Integer id, Parameter idFormat) {
        if (id <= 0) {
            throw new IllegalArgumentException("ms_run id should be greater than 0!");
        }
        MsRun msRun = (MsRun)this.msRunMap.get(id);
        if (idFormat == null) {
            return msRun;
        }
        if (msRun == null) {
            msRun = new MsRun();
            msRun.id(id);
            msRun.setIdFormat(idFormat);
            this.msRunMap.put(id, msRun);
            metadata.addMsRunItem(msRun);
        } else {
            msRun.setIdFormat(idFormat);
        }
        return msRun;
    }

    public MsRun addMsRunFragmentationMethod(Metadata metadata, Integer id, Parameter fragmentationMethod) {
        if (id <= 0) {
            throw new IllegalArgumentException("ms_run id should be greater than 0!");
        }
        MsRun msRun = (MsRun)this.msRunMap.get(id);
        if (fragmentationMethod == null) {
            return msRun;
        }
        if (msRun == null) {
            msRun = new MsRun();
            msRun.id(id);
            msRun.addFragmentationMethodItem(fragmentationMethod);
            this.msRunMap.put(id, msRun);
            metadata.addMsRunItem(msRun);
        } else {
            msRun.addFragmentationMethodItem(fragmentationMethod);
        }
        return msRun;
    }

    public MsRun addMsRunHash(Metadata metadata, Integer id, String hash) {
        if (id <= 0) {
            throw new IllegalArgumentException("ms_run id should be greater than 0!");
        }
        if (MZTabStringUtils.isEmpty((String)hash)) {
            throw new IllegalArgumentException("ms_run hash should not be empty.");
        }
        MsRun msRun = (MsRun)this.msRunMap.get(id);
        if (msRun == null) {
            msRun = new MsRun();
            msRun.id(id);
            msRun.setHash(hash);
            this.msRunMap.put(id, msRun);
            metadata.addMsRunItem(msRun);
        } else {
            msRun.setHash(hash);
        }
        return msRun;
    }

    public MsRun addMsRunHashMethod(Metadata metadata, Integer id, Parameter hashMethod) {
        if (id <= 0) {
            throw new IllegalArgumentException("ms_run id should be greater than 0!");
        }
        MsRun msRun = (MsRun)this.msRunMap.get(id);
        if (hashMethod == null) {
            return msRun;
        }
        if (msRun == null) {
            msRun = new MsRun();
            msRun.id(id);
            msRun.setHashMethod(hashMethod);
            this.msRunMap.put(id, msRun);
            metadata.addMsRunItem(msRun);
        } else {
            msRun.setHashMethod(hashMethod);
        }
        return msRun;
    }

    public MsRun addMsRunScanPolarity(Metadata metadata, Integer id, Parameter scanPolarity) {
        if (id <= 0) {
            throw new IllegalArgumentException("ms_run id should be greater than 0!");
        }
        MsRun msRun = (MsRun)this.msRunMap.get(id);
        if (scanPolarity == null) {
            return msRun;
        }
        if (msRun == null) {
            msRun = new MsRun();
            msRun.id(id);
            msRun.addScanPolarityItem(scanPolarity);
            this.msRunMap.put(id, msRun);
            metadata.addMsRunItem(msRun);
        } else {
            msRun.addScanPolarityItem(scanPolarity);
        }
        return msRun;
    }

    public Assay addAssay(Metadata metadata, Assay assay) {
        if (assay == null) {
            throw new IllegalArgumentException("Assay should not be null");
        }
        this.assayMap.put(assay.getId(), assay);
        metadata.addAssayItem(assay);
        return assay;
    }

    public Assay addAssayCustom(Metadata metadata, Integer id, Parameter param) {
        if (id <= 0) {
            throw new IllegalArgumentException("assay id should be greater than 0!");
        }
        Assay assay = (Assay)this.assayMap.get(id);
        if (assay == null) {
            assay = new Assay();
            assay.id(id);
            assay.addCustomItem(param);
            this.assayMap.put(id, assay);
            metadata.addAssayItem(assay);
        } else {
            assay.addCustomItem(param);
        }
        return assay;
    }

    public Assay addAssayExternalUri(Metadata metadata, Integer id, URI location) {
        if (id <= 0) {
            throw new IllegalArgumentException("assay id should be greater than 0!");
        }
        Assay assay = (Assay)this.assayMap.get(id);
        if (assay == null) {
            assay = new Assay();
            assay.id(id);
            assay.setExternalUri(location == null ? null : location.toASCIIString());
            this.assayMap.put(id, assay);
            metadata.addAssayItem(assay);
        } else {
            assay.setExternalUri(location.toString());
        }
        return assay;
    }

    public Assay addAssaySample(Metadata metadata, Integer id, Sample sample) {
        if (id <= 0) {
            throw new IllegalArgumentException("assay id should be greater than 0!");
        }
        if (sample == null) {
            throw new NullPointerException("assay sample_ref should not be null.");
        }
        if (!this.sampleMap.containsValue(sample)) {
            throw new IllegalArgumentException("Sample not defined in metadata.");
        }
        Assay assay = (Assay)this.assayMap.get(id);
        if (assay == null) {
            assay = new Assay();
            assay.id(id);
            assay.setSampleRef(sample);
            this.assayMap.put(id, assay);
            metadata.addAssayItem(assay);
        } else {
            assay.setSampleRef(sample);
        }
        return assay;
    }

    public Assay addAssayMsRun(Metadata metadata, Integer id, MsRun msRun) {
        if (id <= 0) {
            throw new IllegalArgumentException("assay id should be greater than 0!");
        }
        if (msRun == null) {
            throw new NullPointerException("assay ms_run_ref should not be null.");
        }
        if (!this.msRunMap.containsValue(msRun)) {
            throw new IllegalArgumentException("ms_run should be defined in metadata first.");
        }
        Assay assay = (Assay)this.assayMap.get(id);
        if (assay == null) {
            assay = new Assay();
            assay.id(id);
            assay.addMsRunRefItem(msRun);
            this.assayMap.put(id, assay);
            metadata.addAssayItem(assay);
        } else {
            assay.addMsRunRefItem(msRun);
        }
        return assay;
    }

    public StudyVariable addStudyVariable(Metadata metadata, StudyVariable studyVariable) {
        if (studyVariable == null) {
            throw new IllegalArgumentException("StudyVariable should not be null");
        }
        this.studyVariableMap.put(studyVariable.getId(), studyVariable);
        metadata.addStudyVariableItem(studyVariable);
        return studyVariable;
    }

    public StudyVariable addStudyVariableAssay(Metadata metadata, Integer id, Assay assay) {
        if (id <= 0) {
            throw new IllegalArgumentException("study variable id should be greater than 0!");
        }
        if (assay == null) {
            throw new NullPointerException("study_variable[n]-assay_ref should not be null.");
        }
        if (!this.assayMap.containsValue(assay)) {
            throw new IllegalArgumentException("assay should be defined in metadata first");
        }
        StudyVariable studyVariable = (StudyVariable)this.studyVariableMap.get(id);
        if (studyVariable == null) {
            studyVariable = new StudyVariable();
            studyVariable.id(id);
            studyVariable.addAssayRefsItem(assay);
            this.studyVariableMap.put(id, studyVariable);
            metadata.addStudyVariableItem(studyVariable);
        } else {
            studyVariable.addAssayRefsItem(assay);
        }
        return studyVariable;
    }

    public StudyVariable addStudyVariableDescription(Metadata metadata, Integer id, String description) {
        if (id <= 0) {
            throw new IllegalArgumentException("study variable id should be greater than 0!");
        }
        StudyVariable studyVariable = (StudyVariable)this.studyVariableMap.get(id);
        if (MZTabStringUtils.isEmpty((String)description)) {
            return studyVariable;
        }
        if (studyVariable == null) {
            studyVariable = new StudyVariable();
            studyVariable.id(id);
            metadata.addStudyVariableItem(studyVariable);
        }
        studyVariable.setDescription(description);
        this.studyVariableMap.put(id, studyVariable);
        return studyVariable;
    }

    public StudyVariable addStudyVariableFactors(Metadata metadata, Integer id, Parameter checkParameter) {
        if (id <= 0) {
            throw new IllegalArgumentException("study variable id should be greater than 0!");
        }
        StudyVariable studyVariable = (StudyVariable)this.studyVariableMap.get(id);
        if (checkParameter == null) {
            return studyVariable;
        }
        if (studyVariable == null) {
            studyVariable = new StudyVariable();
            studyVariable.id(id);
            metadata.addStudyVariableItem(studyVariable);
        }
        studyVariable.addFactorsItem(checkParameter);
        this.studyVariableMap.put(id, studyVariable);
        return studyVariable;
    }

    public StudyVariable addStudyVariableVariationFunction(Metadata metadata, Integer id, Parameter checkParameter) {
        if (id <= 0) {
            throw new IllegalArgumentException("study variable id should be greater than 0!");
        }
        StudyVariable studyVariable = (StudyVariable)this.studyVariableMap.get(id);
        if (checkParameter == null) {
            return studyVariable;
        }
        if (studyVariable == null) {
            studyVariable = new StudyVariable();
            studyVariable.id(id);
            studyVariable.setVariationFunction(checkParameter);
            this.studyVariableMap.put(id, studyVariable);
            metadata.addStudyVariableItem(studyVariable);
        } else {
            studyVariable.setVariationFunction(checkParameter);
        }
        return studyVariable;
    }

    public StudyVariable addStudyVariableAverageFunction(Metadata metadata, Integer id, Parameter checkParameter) {
        if (id <= 0) {
            throw new IllegalArgumentException("study variable id should be greater than 0!");
        }
        StudyVariable studyVariable = (StudyVariable)this.studyVariableMap.get(id);
        if (checkParameter == null) {
            return studyVariable;
        }
        if (studyVariable == null) {
            studyVariable = new StudyVariable();
            studyVariable.id(id);
            studyVariable.setAverageFunction(checkParameter);
            this.studyVariableMap.put(id, studyVariable);
            metadata.addStudyVariableItem(studyVariable);
        } else {
            studyVariable.setAverageFunction(checkParameter);
        }
        return studyVariable;
    }

    public CV addCV(Metadata metadata, CV cv) {
        if (cv == null) {
            throw new NullPointerException("Controlled vocabularies/ontologies can not set null!");
        }
        this.cvMap.put(cv.getId(), cv);
        metadata.addCvItem(cv);
        return cv;
    }

    public CV addCVLabel(Metadata metadata, Integer id, String label) {
        if (id <= 0) {
            throw new IllegalArgumentException("controlled vocabularies id should be greater than 0!");
        }
        CV cv = (CV)this.cvMap.get(id);
        if (cv == null) {
            cv = new CV();
            cv.id(id);
            metadata.addCvItem(cv);
        }
        cv.setLabel(label);
        return this.cvMap.put(id, cv);
    }

    public CV addCVFullName(Metadata metadata, Integer id, String fullName) {
        if (id <= 0) {
            throw new IllegalArgumentException("controlled vocabularies id should be greater than 0!");
        }
        CV cv = (CV)this.cvMap.get(id);
        if (cv == null) {
            cv = new CV();
            cv.id(id);
            metadata.addCvItem(cv);
        }
        cv.setFullName(fullName);
        return this.cvMap.put(id, cv);
    }

    public CV addCVVersion(Metadata metadata, Integer id, String version) {
        if (id <= 0) {
            throw new IllegalArgumentException("controlled vocabularies id should be greater than 0!");
        }
        CV cv = (CV)this.cvMap.get(id);
        if (cv == null) {
            cv = new CV();
            cv.id(id);
            metadata.addCvItem(cv);
        }
        cv.setVersion(version);
        return this.cvMap.put(id, cv);
    }

    public CV addCVURI(Metadata metadata, Integer id, String uri) {
        if (id <= 0) {
            throw new IllegalArgumentException("controlled vocabularies id should be greater than 0!");
        }
        CV cv = (CV)this.cvMap.get(id);
        if (cv == null) {
            cv = new CV();
            cv.id(id);
            metadata.addCvItem(cv);
        }
        cv.setUri(uri);
        return this.cvMap.put(id, cv);
    }

    public void addSmallMoleculeColUnit(Metadata metadata, String columnName, Parameter param) {
        ColumnParameterMapping cpm = new ColumnParameterMapping();
        cpm.columnName(columnName).param(param);
        this.smallMoleculeColUnitList.add(cpm);
        metadata.addColunitSmallMoleculeItem(cpm);
    }

    public void addSmallMoleculeFeatureColUnit(Metadata metadata, String columnName, Parameter param) {
        ColumnParameterMapping cpm = new ColumnParameterMapping();
        cpm.columnName(columnName).param(param);
        this.smallMoleculeFeatureColUnitList.add(cpm);
        metadata.addColunitSmallMoleculeFeatureItem(cpm);
    }

    public void addSmallMoleculeEvidenceColUnit(Metadata metadata, String columnName, Parameter param) {
        ColumnParameterMapping cpm = new ColumnParameterMapping();
        cpm.columnName(columnName).param(param);
        this.smallMoleculeEvidenceColUnitList.add(cpm);
        metadata.addColunitSmallMoleculeEvidenceItem(cpm);
    }

    public Map<String, String> getColUnitMap() {
        return this.colUnitMap;
    }

    void addIdConfidenceMeasure(Metadata metadata, Integer id, Parameter parameter) {
        if (parameter.getId() == null) {
            parameter.setId(id);
        }
        this.idConfidenceMeasureMap.put(id, parameter);
        metadata.addIdConfidenceMeasureItem(parameter);
    }

    Parameter addCustomItem(Metadata metadata, Integer id, Parameter custom) {
        if (custom == null) {
            return null;
        }
        if (custom.getId() == null) {
            custom.setId(id);
        }
        this.customItemMap.put(id, custom);
        metadata.addCustomItem(custom);
        return custom;
    }

    Parameter addDerivatizationAgentItem(Metadata metadata, Integer id, Parameter derivatizationAgent) {
        if (derivatizationAgent == null) {
            return null;
        }
        if (derivatizationAgent.getId() == null) {
            derivatizationAgent.setId(id);
        }
        this.derivatizationItemMap.put(id, derivatizationAgent);
        metadata.addDerivatizationAgentItem(derivatizationAgent);
        return derivatizationAgent;
    }

    public Database addDatabase(Metadata metadata, Database database) {
        if (database == null) {
            throw new IllegalArgumentException("Database should not be null");
        }
        this.databaseMap.put(database.getId(), database);
        metadata.addDatabaseItem(database);
        return database;
    }

    public Database addDatabasePrefix(Metadata metadata, Integer id, String valueLabel) {
        if (id <= 0) {
            throw new IllegalArgumentException("database id should be greater than 0!");
        }
        Database database = (Database)this.databaseMap.get(id);
        if (database == null) {
            database = new Database();
            database.id(id);
            database.setPrefix(valueLabel);
            this.databaseMap.put(id, database);
            metadata.addDatabaseItem(database);
        } else {
            database.setPrefix(valueLabel);
        }
        return database;
    }

    public Database addDatabaseVersion(Metadata metadata, Integer id, String version) {
        if (id <= 0) {
            throw new IllegalArgumentException("database id should be greater than 0!");
        }
        Database database = (Database)this.databaseMap.get(id);
        if (database == null) {
            database = new Database();
            database.id(id);
            database.setVersion(version);
            this.databaseMap.put(id, database);
            metadata.addDatabaseItem(database);
        } else {
            database.setVersion(version);
        }
        return database;
    }

    public Database addDatabaseUri(Metadata metadata, Integer id, URI checkURI) {
        if (id <= 0) {
            throw new IllegalArgumentException("database id should be greater than 0!");
        }
        Database database = (Database)this.databaseMap.get(id);
        if (database == null) {
            database = new Database();
            database.id(id);
            database.setUri(checkURI == null ? null : checkURI.toString());
            this.databaseMap.put(id, database);
            metadata.addDatabaseItem(database);
        } else {
            database.setUri(checkURI == null ? null : checkURI.toString());
        }
        return database;
    }

    public SortedMap<Integer, SampleProcessing> getSampleProcessingMap() {
        return this.sampleProcessingMap;
    }

    public SortedMap<Integer, Instrument> getInstrumentMap() {
        return this.instrumentMap;
    }

    public SortedMap<Integer, Software> getSoftwareMap() {
        return this.softwareMap;
    }

    public SortedMap<Integer, Publication> getPublicationMap() {
        return this.publicationMap;
    }

    public SortedMap<Integer, Contact> getContactMap() {
        return this.contactMap;
    }

    public Parameter getQuantificationMethod() {
        return this.quantificationMethod;
    }

    public SortedMap<Integer, Assay> getAssayMap() {
        return this.assayMap;
    }

    public Parameter getSmallMoleculeQuantificationUnit() {
        return this.smallMoleculeQuantificationUnit;
    }

    public SortedMap<Integer, MsRun> getMsRunMap() {
        return this.msRunMap;
    }

    public SortedMap<Integer, Parameter> getCustomItemMap() {
        return this.customItemMap;
    }

    public SortedMap<Integer, Parameter> getDerivatizationItemMap() {
        return this.derivatizationItemMap;
    }

    public SortedMap<Integer, Parameter> getIdConfidenceMeasureMap() {
        return this.idConfidenceMeasureMap;
    }

    public SortedMap<Integer, Sample> getSampleMap() {
        return this.sampleMap;
    }

    public SortedMap<Integer, StudyVariable> getStudyVariableMap() {
        return this.studyVariableMap;
    }

    public SortedMap<Integer, CV> getCvMap() {
        return this.cvMap;
    }

    public SortedMap<Integer, Database> getDatabaseMap() {
        return this.databaseMap;
    }

    public List<ColumnParameterMapping> getSmallMoleculeColUnitList() {
        return this.smallMoleculeColUnitList;
    }

    public List<ColumnParameterMapping> getSmallMoleculeFeatureColUnitList() {
        return this.smallMoleculeFeatureColUnitList;
    }

    public List<ColumnParameterMapping> getSmallMoleculeEvidenceColUnitList() {
        return this.smallMoleculeEvidenceColUnitList;
    }

    public void setSampleProcessingMap(SortedMap<Integer, SampleProcessing> sampleProcessingMap) {
        this.sampleProcessingMap = sampleProcessingMap;
    }

    public void setInstrumentMap(SortedMap<Integer, Instrument> instrumentMap) {
        this.instrumentMap = instrumentMap;
    }

    public void setSoftwareMap(SortedMap<Integer, Software> softwareMap) {
        this.softwareMap = softwareMap;
    }

    public void setPublicationMap(SortedMap<Integer, Publication> publicationMap) {
        this.publicationMap = publicationMap;
    }

    public void setContactMap(SortedMap<Integer, Contact> contactMap) {
        this.contactMap = contactMap;
    }

    public void setQuantificationMethod(Parameter quantificationMethod) {
        this.quantificationMethod = quantificationMethod;
    }

    public void setAssayMap(SortedMap<Integer, Assay> assayMap) {
        this.assayMap = assayMap;
    }

    public void setSmallMoleculeQuantificationUnit(Parameter smallMoleculeQuantificationUnit) {
        this.smallMoleculeQuantificationUnit = smallMoleculeQuantificationUnit;
    }

    public void setMsRunMap(SortedMap<Integer, MsRun> msRunMap) {
        this.msRunMap = msRunMap;
    }

    public void setCustomItemMap(SortedMap<Integer, Parameter> customItemMap) {
        this.customItemMap = customItemMap;
    }

    public void setDerivatizationItemMap(SortedMap<Integer, Parameter> derivatizationItemMap) {
        this.derivatizationItemMap = derivatizationItemMap;
    }

    public void setIdConfidenceMeasureMap(SortedMap<Integer, Parameter> idConfidenceMeasureMap) {
        this.idConfidenceMeasureMap = idConfidenceMeasureMap;
    }

    public void setSampleMap(SortedMap<Integer, Sample> sampleMap) {
        this.sampleMap = sampleMap;
    }

    public void setStudyVariableMap(SortedMap<Integer, StudyVariable> studyVariableMap) {
        this.studyVariableMap = studyVariableMap;
    }

    public void setCvMap(SortedMap<Integer, CV> cvMap) {
        this.cvMap = cvMap;
    }

    public void setDatabaseMap(SortedMap<Integer, Database> databaseMap) {
        this.databaseMap = databaseMap;
    }

    public void setSmallMoleculeColUnitList(List<ColumnParameterMapping> smallMoleculeColUnitList) {
        this.smallMoleculeColUnitList = smallMoleculeColUnitList;
    }

    public void setSmallMoleculeFeatureColUnitList(List<ColumnParameterMapping> smallMoleculeFeatureColUnitList) {
        this.smallMoleculeFeatureColUnitList = smallMoleculeFeatureColUnitList;
    }

    public void setSmallMoleculeEvidenceColUnitList(List<ColumnParameterMapping> smallMoleculeEvidenceColUnitList) {
        this.smallMoleculeEvidenceColUnitList = smallMoleculeEvidenceColUnitList;
    }

    public void setColUnitMap(Map<String, String> colUnitMap) {
        this.colUnitMap = colUnitMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MZTabParserContext)) {
            return false;
        }
        MZTabParserContext other = (MZTabParserContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SortedMap<Integer, SampleProcessing> this$sampleProcessingMap = this.getSampleProcessingMap();
        SortedMap<Integer, SampleProcessing> other$sampleProcessingMap = other.getSampleProcessingMap();
        if (this$sampleProcessingMap == null ? other$sampleProcessingMap != null : !this$sampleProcessingMap.equals(other$sampleProcessingMap)) {
            return false;
        }
        SortedMap<Integer, Instrument> this$instrumentMap = this.getInstrumentMap();
        SortedMap<Integer, Instrument> other$instrumentMap = other.getInstrumentMap();
        if (this$instrumentMap == null ? other$instrumentMap != null : !this$instrumentMap.equals(other$instrumentMap)) {
            return false;
        }
        SortedMap<Integer, Software> this$softwareMap = this.getSoftwareMap();
        SortedMap<Integer, Software> other$softwareMap = other.getSoftwareMap();
        if (this$softwareMap == null ? other$softwareMap != null : !this$softwareMap.equals(other$softwareMap)) {
            return false;
        }
        SortedMap<Integer, Publication> this$publicationMap = this.getPublicationMap();
        SortedMap<Integer, Publication> other$publicationMap = other.getPublicationMap();
        if (this$publicationMap == null ? other$publicationMap != null : !this$publicationMap.equals(other$publicationMap)) {
            return false;
        }
        SortedMap<Integer, Contact> this$contactMap = this.getContactMap();
        SortedMap<Integer, Contact> other$contactMap = other.getContactMap();
        if (this$contactMap == null ? other$contactMap != null : !this$contactMap.equals(other$contactMap)) {
            return false;
        }
        Parameter this$quantificationMethod = this.getQuantificationMethod();
        Parameter other$quantificationMethod = other.getQuantificationMethod();
        if (this$quantificationMethod == null ? other$quantificationMethod != null : !this$quantificationMethod.equals(other$quantificationMethod)) {
            return false;
        }
        SortedMap<Integer, Assay> this$assayMap = this.getAssayMap();
        SortedMap<Integer, Assay> other$assayMap = other.getAssayMap();
        if (this$assayMap == null ? other$assayMap != null : !this$assayMap.equals(other$assayMap)) {
            return false;
        }
        Parameter this$smallMoleculeQuantificationUnit = this.getSmallMoleculeQuantificationUnit();
        Parameter other$smallMoleculeQuantificationUnit = other.getSmallMoleculeQuantificationUnit();
        if (this$smallMoleculeQuantificationUnit == null ? other$smallMoleculeQuantificationUnit != null : !this$smallMoleculeQuantificationUnit.equals(other$smallMoleculeQuantificationUnit)) {
            return false;
        }
        SortedMap<Integer, MsRun> this$msRunMap = this.getMsRunMap();
        SortedMap<Integer, MsRun> other$msRunMap = other.getMsRunMap();
        if (this$msRunMap == null ? other$msRunMap != null : !this$msRunMap.equals(other$msRunMap)) {
            return false;
        }
        SortedMap<Integer, Parameter> this$customItemMap = this.getCustomItemMap();
        SortedMap<Integer, Parameter> other$customItemMap = other.getCustomItemMap();
        if (this$customItemMap == null ? other$customItemMap != null : !this$customItemMap.equals(other$customItemMap)) {
            return false;
        }
        SortedMap<Integer, Parameter> this$derivatizationItemMap = this.getDerivatizationItemMap();
        SortedMap<Integer, Parameter> other$derivatizationItemMap = other.getDerivatizationItemMap();
        if (this$derivatizationItemMap == null ? other$derivatizationItemMap != null : !this$derivatizationItemMap.equals(other$derivatizationItemMap)) {
            return false;
        }
        SortedMap<Integer, Parameter> this$idConfidenceMeasureMap = this.getIdConfidenceMeasureMap();
        SortedMap<Integer, Parameter> other$idConfidenceMeasureMap = other.getIdConfidenceMeasureMap();
        if (this$idConfidenceMeasureMap == null ? other$idConfidenceMeasureMap != null : !this$idConfidenceMeasureMap.equals(other$idConfidenceMeasureMap)) {
            return false;
        }
        SortedMap<Integer, Sample> this$sampleMap = this.getSampleMap();
        SortedMap<Integer, Sample> other$sampleMap = other.getSampleMap();
        if (this$sampleMap == null ? other$sampleMap != null : !this$sampleMap.equals(other$sampleMap)) {
            return false;
        }
        SortedMap<Integer, StudyVariable> this$studyVariableMap = this.getStudyVariableMap();
        SortedMap<Integer, StudyVariable> other$studyVariableMap = other.getStudyVariableMap();
        if (this$studyVariableMap == null ? other$studyVariableMap != null : !this$studyVariableMap.equals(other$studyVariableMap)) {
            return false;
        }
        SortedMap<Integer, CV> this$cvMap = this.getCvMap();
        SortedMap<Integer, CV> other$cvMap = other.getCvMap();
        if (this$cvMap == null ? other$cvMap != null : !this$cvMap.equals(other$cvMap)) {
            return false;
        }
        SortedMap<Integer, Database> this$databaseMap = this.getDatabaseMap();
        SortedMap<Integer, Database> other$databaseMap = other.getDatabaseMap();
        if (this$databaseMap == null ? other$databaseMap != null : !this$databaseMap.equals(other$databaseMap)) {
            return false;
        }
        List<ColumnParameterMapping> this$smallMoleculeColUnitList = this.getSmallMoleculeColUnitList();
        List<ColumnParameterMapping> other$smallMoleculeColUnitList = other.getSmallMoleculeColUnitList();
        if (this$smallMoleculeColUnitList == null ? other$smallMoleculeColUnitList != null : !((Object)this$smallMoleculeColUnitList).equals(other$smallMoleculeColUnitList)) {
            return false;
        }
        List<ColumnParameterMapping> this$smallMoleculeFeatureColUnitList = this.getSmallMoleculeFeatureColUnitList();
        List<ColumnParameterMapping> other$smallMoleculeFeatureColUnitList = other.getSmallMoleculeFeatureColUnitList();
        if (this$smallMoleculeFeatureColUnitList == null ? other$smallMoleculeFeatureColUnitList != null : !((Object)this$smallMoleculeFeatureColUnitList).equals(other$smallMoleculeFeatureColUnitList)) {
            return false;
        }
        List<ColumnParameterMapping> this$smallMoleculeEvidenceColUnitList = this.getSmallMoleculeEvidenceColUnitList();
        List<ColumnParameterMapping> other$smallMoleculeEvidenceColUnitList = other.getSmallMoleculeEvidenceColUnitList();
        if (this$smallMoleculeEvidenceColUnitList == null ? other$smallMoleculeEvidenceColUnitList != null : !((Object)this$smallMoleculeEvidenceColUnitList).equals(other$smallMoleculeEvidenceColUnitList)) {
            return false;
        }
        Map<String, String> this$colUnitMap = this.getColUnitMap();
        Map<String, String> other$colUnitMap = other.getColUnitMap();
        return !(this$colUnitMap == null ? other$colUnitMap != null : !((Object)this$colUnitMap).equals(other$colUnitMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MZTabParserContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SortedMap<Integer, SampleProcessing> $sampleProcessingMap = this.getSampleProcessingMap();
        result = result * 59 + ($sampleProcessingMap == null ? 43 : $sampleProcessingMap.hashCode());
        SortedMap<Integer, Instrument> $instrumentMap = this.getInstrumentMap();
        result = result * 59 + ($instrumentMap == null ? 43 : $instrumentMap.hashCode());
        SortedMap<Integer, Software> $softwareMap = this.getSoftwareMap();
        result = result * 59 + ($softwareMap == null ? 43 : $softwareMap.hashCode());
        SortedMap<Integer, Publication> $publicationMap = this.getPublicationMap();
        result = result * 59 + ($publicationMap == null ? 43 : $publicationMap.hashCode());
        SortedMap<Integer, Contact> $contactMap = this.getContactMap();
        result = result * 59 + ($contactMap == null ? 43 : $contactMap.hashCode());
        Parameter $quantificationMethod = this.getQuantificationMethod();
        result = result * 59 + ($quantificationMethod == null ? 43 : $quantificationMethod.hashCode());
        SortedMap<Integer, Assay> $assayMap = this.getAssayMap();
        result = result * 59 + ($assayMap == null ? 43 : $assayMap.hashCode());
        Parameter $smallMoleculeQuantificationUnit = this.getSmallMoleculeQuantificationUnit();
        result = result * 59 + ($smallMoleculeQuantificationUnit == null ? 43 : $smallMoleculeQuantificationUnit.hashCode());
        SortedMap<Integer, MsRun> $msRunMap = this.getMsRunMap();
        result = result * 59 + ($msRunMap == null ? 43 : $msRunMap.hashCode());
        SortedMap<Integer, Parameter> $customItemMap = this.getCustomItemMap();
        result = result * 59 + ($customItemMap == null ? 43 : $customItemMap.hashCode());
        SortedMap<Integer, Parameter> $derivatizationItemMap = this.getDerivatizationItemMap();
        result = result * 59 + ($derivatizationItemMap == null ? 43 : $derivatizationItemMap.hashCode());
        SortedMap<Integer, Parameter> $idConfidenceMeasureMap = this.getIdConfidenceMeasureMap();
        result = result * 59 + ($idConfidenceMeasureMap == null ? 43 : $idConfidenceMeasureMap.hashCode());
        SortedMap<Integer, Sample> $sampleMap = this.getSampleMap();
        result = result * 59 + ($sampleMap == null ? 43 : $sampleMap.hashCode());
        SortedMap<Integer, StudyVariable> $studyVariableMap = this.getStudyVariableMap();
        result = result * 59 + ($studyVariableMap == null ? 43 : $studyVariableMap.hashCode());
        SortedMap<Integer, CV> $cvMap = this.getCvMap();
        result = result * 59 + ($cvMap == null ? 43 : $cvMap.hashCode());
        SortedMap<Integer, Database> $databaseMap = this.getDatabaseMap();
        result = result * 59 + ($databaseMap == null ? 43 : $databaseMap.hashCode());
        List<ColumnParameterMapping> $smallMoleculeColUnitList = this.getSmallMoleculeColUnitList();
        result = result * 59 + ($smallMoleculeColUnitList == null ? 43 : ((Object)$smallMoleculeColUnitList).hashCode());
        List<ColumnParameterMapping> $smallMoleculeFeatureColUnitList = this.getSmallMoleculeFeatureColUnitList();
        result = result * 59 + ($smallMoleculeFeatureColUnitList == null ? 43 : ((Object)$smallMoleculeFeatureColUnitList).hashCode());
        List<ColumnParameterMapping> $smallMoleculeEvidenceColUnitList = this.getSmallMoleculeEvidenceColUnitList();
        result = result * 59 + ($smallMoleculeEvidenceColUnitList == null ? 43 : ((Object)$smallMoleculeEvidenceColUnitList).hashCode());
        Map<String, String> $colUnitMap = this.getColUnitMap();
        result = result * 59 + ($colUnitMap == null ? 43 : ((Object)$colUnitMap).hashCode());
        return result;
    }

    public String toString() {
        return "MZTabParserContext(sampleProcessingMap=" + this.getSampleProcessingMap() + ", instrumentMap=" + this.getInstrumentMap() + ", softwareMap=" + this.getSoftwareMap() + ", publicationMap=" + this.getPublicationMap() + ", contactMap=" + this.getContactMap() + ", quantificationMethod=" + this.getQuantificationMethod() + ", assayMap=" + this.getAssayMap() + ", smallMoleculeQuantificationUnit=" + this.getSmallMoleculeQuantificationUnit() + ", msRunMap=" + this.getMsRunMap() + ", customItemMap=" + this.getCustomItemMap() + ", derivatizationItemMap=" + this.getDerivatizationItemMap() + ", idConfidenceMeasureMap=" + this.getIdConfidenceMeasureMap() + ", sampleMap=" + this.getSampleMap() + ", studyVariableMap=" + this.getStudyVariableMap() + ", cvMap=" + this.getCvMap() + ", databaseMap=" + this.getDatabaseMap() + ", smallMoleculeColUnitList=" + this.getSmallMoleculeColUnitList() + ", smallMoleculeFeatureColUnitList=" + this.getSmallMoleculeFeatureColUnitList() + ", smallMoleculeEvidenceColUnitList=" + this.getSmallMoleculeEvidenceColUnitList() + ", colUnitMap=" + this.getColUnitMap() + ")";
    }
}

