/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.jmztab2.utils.parser;

import de.isas.mztab2.model.Assay;
import de.isas.mztab2.model.Metadata;
import de.isas.mztab2.model.Parameter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.pride.jmztab2.model.IMZTabColumn;
import uk.ac.ebi.pride.jmztab2.model.ISmallMoleculeFeatureColumn;
import uk.ac.ebi.pride.jmztab2.model.MZTabColumnFactory;
import uk.ac.ebi.pride.jmztab2.model.Section;
import uk.ac.ebi.pride.jmztab2.model.SmallMoleculeFeatureColumn;
import uk.ac.ebi.pride.jmztab2.utils.errors.FormatErrorType;
import uk.ac.ebi.pride.jmztab2.utils.errors.LogicalErrorType;
import uk.ac.ebi.pride.jmztab2.utils.errors.MZTabError;
import uk.ac.ebi.pride.jmztab2.utils.errors.MZTabException;
import uk.ac.ebi.pride.jmztab2.utils.parser.MZTabHeaderLineParser;
import uk.ac.ebi.pride.jmztab2.utils.parser.MZTabParserContext;

public class SFHLineParser
extends MZTabHeaderLineParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(SFHLineParser.class);
    private Map<Integer, String> physPositionToOrder;

    public SFHLineParser(MZTabParserContext context, Metadata metadata) {
        super(context, MZTabColumnFactory.getInstance(Section.Small_Molecule_Feature_Header), metadata);
    }

    @Override
    protected int parseColumns() throws MZTabException {
        SortedMap<String, IMZTabColumn> columnMapping = this.factory.getColumnMapping();
        SortedMap<String, IMZTabColumn> optionalMapping = this.factory.getOptionalColumnMapping();
        SortedMap<String, IMZTabColumn> stableMapping = this.factory.getStableColumnMapping();
        this.physPositionToOrder = this.generateHeaderPhysPositionToOrderMap(this.items);
        Integer physicalPosition = 1;
        while (physicalPosition < this.items.length) {
            ISmallMoleculeFeatureColumn column = null;
            String header = this.items[physicalPosition];
            if (header.contains("abundance_")) {
                this.checkAbundanceColumns(physicalPosition, this.physPositionToOrder.get(physicalPosition));
            } else if (header.startsWith("opt_")) {
                this.checkOptColumnName(header);
            } else {
                try {
                    column = SmallMoleculeFeatureColumn.Stable.columnFor(header);
                }
                catch (IllegalArgumentException ex) {
                    throw new MZTabException(new MZTabError(LogicalErrorType.ColumnNotValid, this.lineNumber, new String[]{header, this.section.getName()}));
                }
            }
            if (column != null) {
                if (!column.getOrder().equals(this.physPositionToOrder.get(physicalPosition))) {
                    column.setOrder(this.physPositionToOrder.get(physicalPosition));
                    LOGGER.debug(column.toString());
                }
                if (column.isOptional()) {
                    optionalMapping.put(column.getLogicPosition(), column);
                } else {
                    stableMapping.put(column.getLogicPosition(), column);
                }
                columnMapping.put(column.getLogicPosition(), column);
            }
            Integer n = physicalPosition;
            Integer n2 = physicalPosition = Integer.valueOf(physicalPosition + 1);
        }
        return physicalPosition;
    }

    private Map<Integer, String> generateHeaderPhysPositionToOrderMap(String[] items) {
        LinkedHashMap<Integer, String> physicalPositionToOrder = new LinkedHashMap<Integer, String>();
        int order = 0;
        Integer physicalPosition = 1;
        while (physicalPosition < items.length) {
            if (physicalPositionToOrder.containsKey(physicalPosition)) {
                throw new IllegalArgumentException("Physical position " + physicalPosition + " for item " + items[physicalPosition - 1] + " is already assigned!");
            }
            physicalPositionToOrder.put(physicalPosition, this.fromIndexToOrder(++order));
            Integer n = physicalPosition;
            Integer n2 = physicalPosition = Integer.valueOf(physicalPosition + 1);
        }
        return physicalPositionToOrder;
    }

    @Override
    protected void refine() throws MZTabException {
        ArrayList<String> mandatoryColumnHeaders = new ArrayList<String>();
        for (ISmallMoleculeFeatureColumn column : SmallMoleculeFeatureColumn.Stable.columns()) {
            mandatoryColumnHeaders.add(column.getName());
        }
        Parameter smallMoleculeFeatureQuantificationUnit = Optional.ofNullable(this.metadata.getSmallMoleculeFeatureQuantificationUnit()).orElseThrow(() -> new MZTabException(new MZTabError(LogicalErrorType.NoSmallMoleculeFeatureQuantificationUnit, this.lineNumber, new String[0])));
        for (String columnHeader : mandatoryColumnHeaders) {
            if (this.factory.findColumnByHeader(columnHeader) != null) continue;
            throw new MZTabException(new MZTabError(FormatErrorType.StableColumn, this.lineNumber, new String[]{columnHeader}));
        }
        for (Assay assay : this.metadata.getAssay()) {
            String assayLabel = "_" + Metadata.Properties.assay + "[" + assay.getId() + "]";
            this.refineOptionalColumn(Section.Small_Molecule_Feature_Header, "abundance" + assayLabel);
        }
    }
}

