/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.jmztab2.utils.parser;

import de.isas.mztab2.model.Assay;
import de.isas.mztab2.model.Metadata;
import de.isas.mztab2.model.Parameter;
import de.isas.mztab2.model.StudyVariable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.pride.jmztab2.model.IMZTabColumn;
import uk.ac.ebi.pride.jmztab2.model.ISmallMoleculeColumn;
import uk.ac.ebi.pride.jmztab2.model.MZTabColumnFactory;
import uk.ac.ebi.pride.jmztab2.model.Section;
import uk.ac.ebi.pride.jmztab2.model.SmallMoleculeColumn;
import uk.ac.ebi.pride.jmztab2.utils.errors.FormatErrorType;
import uk.ac.ebi.pride.jmztab2.utils.errors.LogicalErrorType;
import uk.ac.ebi.pride.jmztab2.utils.errors.MZTabError;
import uk.ac.ebi.pride.jmztab2.utils.errors.MZTabException;
import uk.ac.ebi.pride.jmztab2.utils.parser.MZTabHeaderLineParser;
import uk.ac.ebi.pride.jmztab2.utils.parser.MZTabParserContext;

public class SMHLineParser
extends MZTabHeaderLineParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(SMHLineParser.class);
    private Map<Integer, String> physPositionToOrder;

    public SMHLineParser(MZTabParserContext context, Metadata metadata) {
        super(context, MZTabColumnFactory.getInstance(Section.Small_Molecule_Header), metadata);
    }

    @Override
    protected int parseColumns() throws MZTabException {
        SortedMap<String, IMZTabColumn> columnMapping = this.factory.getColumnMapping();
        SortedMap<String, IMZTabColumn> optionalMapping = this.factory.getOptionalColumnMapping();
        SortedMap<String, IMZTabColumn> stableMapping = this.factory.getStableColumnMapping();
        this.physPositionToOrder = this.generateHeaderPhysPositionToOrderMap(this.items);
        Integer physicalPosition = 1;
        while (physicalPosition < this.items.length) {
            ISmallMoleculeColumn column = null;
            String header = this.items[physicalPosition];
            if (header.startsWith("abundance_")) {
                this.checkAbundanceColumns(physicalPosition, this.physPositionToOrder.get(physicalPosition));
            } else if (header.startsWith("opt_")) {
                this.checkOptColumnName(header);
            } else {
                try {
                    column = SmallMoleculeColumn.Stable.columnFor(header);
                }
                catch (IllegalArgumentException iae) {
                    throw new MZTabException(new MZTabError(LogicalErrorType.ColumnNotValid, this.lineNumber, new String[]{header, this.section.getName()}));
                }
            }
            if (column != null) {
                if (!column.getOrder().equals(this.physPositionToOrder.get(physicalPosition))) {
                    column.setOrder(this.physPositionToOrder.get(physicalPosition));
                    LOGGER.debug(column.toString());
                }
                if (column.isOptional()) {
                    optionalMapping.put(column.getLogicPosition(), column);
                } else {
                    stableMapping.put(column.getLogicPosition(), column);
                }
                columnMapping.put(column.getLogicPosition(), column);
            }
            Integer n = physicalPosition;
            Integer n2 = physicalPosition = Integer.valueOf(physicalPosition + 1);
        }
        return physicalPosition;
    }

    private Map<Integer, String> generateHeaderPhysPositionToOrderMap(String[] items) {
        LinkedHashMap<Integer, String> physicalPositionToOrder = new LinkedHashMap<Integer, String>();
        int order = 0;
        Integer physicalPosition = 1;
        while (physicalPosition < items.length) {
            if (physicalPositionToOrder.containsKey(physicalPosition)) {
                throw new IllegalArgumentException("Physical position " + physicalPosition + " for item " + items[physicalPosition - 1] + " is already assigned!");
            }
            physicalPositionToOrder.put(physicalPosition, this.fromIndexToOrder(++order));
            Integer n = physicalPosition;
            Integer n2 = physicalPosition = Integer.valueOf(physicalPosition + 1);
        }
        return physicalPositionToOrder;
    }

    @Override
    protected void refine() throws MZTabException {
        for (SmallMoleculeColumn.Stable columnHeader : SmallMoleculeColumn.Stable.values()) {
            ISmallMoleculeColumn smc = SmallMoleculeColumn.Stable.columnFor(columnHeader);
            if (this.factory.findColumnByHeader(smc.getHeader()) != null) continue;
            throw new MZTabException(new MZTabError(FormatErrorType.StableColumn, this.lineNumber, new String[]{smc.getHeader()}));
        }
        Parameter smallMoleculeQuantificationUnit = Optional.ofNullable(this.metadata.getSmallMoleculeQuantificationUnit()).orElseThrow(() -> new MZTabException(new MZTabError(LogicalErrorType.NoSmallMoleculeQuantificationUnit, this.lineNumber, new String[0])));
        if (this.metadata.getSmallMoleculeIdentificationReliability() == null) {
            throw new MZTabException(new MZTabError(LogicalErrorType.NoSmallMoleculeIdentificationReliability, this.lineNumber, new String[0]));
        }
        for (StudyVariable studyVariable : this.metadata.getStudyVariable()) {
            String svLabel = "_" + Metadata.Properties.studyVariable + "[" + studyVariable.getId() + "]";
            this.refineOptionalColumn(Section.Small_Molecule_Header, "abundance" + svLabel);
            this.refineOptionalColumn(Section.Small_Molecule_Header, "abundance_variation" + svLabel);
        }
        for (Assay assay : this.metadata.getAssay()) {
            String assayLabel = "_" + Metadata.Properties.assay + "[" + assay.getId() + "]";
            this.refineOptionalColumn(Section.Small_Molecule_Header, "abundance" + assayLabel);
        }
    }
}

