/*
 * Decompiled with CFR 0.152.
 */
package de.isas.lipidomics.mztab2.validation;

import de.isas.lipidomics.mztab2.validation.Validator;
import de.isas.mztab2.model.MzTab;
import de.isas.mztab2.model.ValidationMessage;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class MzTabValidator
implements Validator<MzTab> {
    private final List<Validator<MzTab>> validators;

    public MzTabValidator(Validator<MzTab> ... validator) {
        this.validators = Arrays.asList(validator);
    }

    @Override
    public List<ValidationMessage> validate(MzTab mzTab) {
        return this.validators.stream().map(validator -> validator.validate(mzTab)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static List<ValidationMessage> validate(MzTab mzTab, ValidationMessage.MessageTypeEnum validationLevel, Validator<MzTab> ... validators) {
        MzTabValidator validator = new MzTabValidator(validators);
        return validator.validate(mzTab).stream().filter(validationMessage -> {
            switch (validationLevel) {
                case INFO: {
                    return validationMessage.getMessageType() == ValidationMessage.MessageTypeEnum.INFO || validationMessage.getMessageType() == ValidationMessage.MessageTypeEnum.WARN || validationMessage.getMessageType() == ValidationMessage.MessageTypeEnum.ERROR;
                }
                case WARN: {
                    return validationMessage.getMessageType() == ValidationMessage.MessageTypeEnum.WARN || validationMessage.getMessageType() == ValidationMessage.MessageTypeEnum.ERROR;
                }
                case ERROR: {
                    return validationMessage.getMessageType() == ValidationMessage.MessageTypeEnum.ERROR;
                }
            }
            throw new IllegalArgumentException("Unknown message type for validationLevel '" + (Object)((Object)validationLevel) + "' and message: '" + validationMessage.getMessage() + "'!");
        }).collect(Collectors.toList());
    }
}

