/*
 * Decompiled with CFR 0.152.
 */
package de.isas.mztab2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import de.isas.mztab2.model.Parameter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@ApiModel(description="Defines the used unit for a column in the mzTab-M file. The format of the value has to be \\{column name}=\\{Parameter defining the unit}. This field MUST NOT be used to define a unit for quantification columns. The unit used for small molecule quantification values MUST be set in small_molecule-quantification_unit.")
@XmlRootElement(name="ColumnParameterMapping")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JacksonXmlRootElement(localName="ColumnParameterMapping")
public class ColumnParameterMapping {
    @JsonProperty(value="column_name")
    @JacksonXmlProperty(localName="column_name")
    @XmlElement(name="column_name")
    private String columnName = null;
    @JsonProperty(value="param")
    @JacksonXmlProperty(localName="param")
    @XmlElement(name="param")
    private Parameter param = null;

    public ColumnParameterMapping columnName(String columnName) {
        this.columnName = columnName;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="The fully qualified target column name.")
    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public ColumnParameterMapping param(Parameter param) {
        this.param = param;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="The parameter specifying the unit.")
    public Parameter getParam() {
        return this.param;
    }

    public void setParam(Parameter param) {
        this.param = param;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnParameterMapping columnParameterMapping = (ColumnParameterMapping)o;
        return Objects.equals(this.columnName, columnParameterMapping.columnName) && Objects.equals(this.param, columnParameterMapping.param);
    }

    public int hashCode() {
        return Objects.hash(this.columnName, this.param);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ColumnParameterMapping {\n");
        sb.append("    columnName: ").append(this.toIndentedString(this.columnName)).append("\n");
        sb.append("    param: ").append(this.toIndentedString(this.param)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum Properties {
        columnName("column_name"),
        param("param");

        private final String propertyName;

        private Properties(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String toString() {
            return this.propertyName;
        }

        public String toUpper() {
            return this.propertyName.toUpperCase();
        }

        public static Properties of(String value) {
            if (value == null) {
                throw new NullPointerException("Argument value must not be null!");
            }
            return Arrays.asList(Properties.values()).stream().filter(m -> m.propertyName.equals(value.toLowerCase())).findAny().orElseThrow(IllegalArgumentException::new);
        }
    }
}

