/*
 * Decompiled with CFR 0.152.
 */
package de.isas.mztab2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import de.isas.mztab2.model.IndexedElement;
import de.isas.mztab2.model.PublicationItem;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@ApiModel(description="A publication associated with this file. Several publications can be given by indicating the number in the square brackets after \u201cpublication\u201d. PubMed ids must be prefixed by \u201cpubmed:\u201d, DOIs by \u201cdoi:\u201d. Multiple identifiers MUST be separated by \u201c|\u201d. ")
@XmlRootElement(name="Publication")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JacksonXmlRootElement(localName="Publication")
public class Publication
extends IndexedElement {
    @JsonProperty(value="publicationItems")
    @XmlElement(name="publicationItems")
    private List<PublicationItem> publicationItems = new ArrayList<PublicationItem>();

    @Override
    public Publication id(Integer id) {
        super.setId(id);
        return this;
    }

    @Override
    public Publication elementType(String elementType) {
        super.setElementType(elementType);
        return this;
    }

    public Publication publicationItems(List<PublicationItem> publicationItems) {
        this.publicationItems = publicationItems;
        return this;
    }

    public Publication addPublicationItemsItem(PublicationItem publicationItemsItem) {
        this.publicationItems.add(publicationItemsItem);
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="The publication item ids referenced by this publication.")
    public List<PublicationItem> getPublicationItems() {
        return this.publicationItems;
    }

    public void setPublicationItems(List<PublicationItem> publicationItems) {
        this.publicationItems = publicationItems;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Publication publication = (Publication)o;
        return Objects.equals(this.publicationItems, publication.publicationItems) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.publicationItems, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Publication {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    publicationItems: ").append(this.toIndentedString(this.publicationItems)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum Properties {
        publicationItems("publicationItems");

        private final String propertyName;

        private Properties(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String toString() {
            return this.propertyName;
        }

        public String toUpper() {
            return this.propertyName.toUpperCase();
        }

        public static Properties of(String value) {
            if (value == null) {
                throw new NullPointerException("Argument value must not be null!");
            }
            return Arrays.asList(Properties.values()).stream().filter(m -> m.propertyName.equals(value.toLowerCase())).findAny().orElseThrow(IllegalArgumentException::new);
        }
    }
}

