/*
 * Decompiled with CFR 0.152.
 */
package de.isas.mztab2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import de.isas.mztab2.model.Comment;
import de.isas.mztab2.model.OptColumnMapping;
import de.isas.mztab2.model.Parameter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@ApiModel(description="The small molecule summary section is table-based, represented summarized quantitative information across assays and study variables, grouped by identification in rows. The small molecule section MUST always come after the metadata section. All table columns MUST be Tab separated. There MUST NOT be any empty cells; missing values MUST be reported using \u201cnull\u201d for columns where Is Nullable = \u201cTrue\u201d.  Each row of the small molecule section is intended to report one final result to be communicated in terms of a molecule that has been quantified. In many cases, this may be the molecule of biological interest, although in some cases, the final result could be a derivatized form as appropriate \u2013 although it is desirable for the database identifier(s) to reference to the biological (non-derivatized) form. In general, different adduct forms would generally be reported in the Small Molecule Feature section.  The order of columns MUST follow the order specified below.  All columns are MANDATORY except for \u201copt_\u201d columns. ")
@XmlRootElement(name="SmallMoleculeSummary")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JacksonXmlRootElement(localName="SmallMoleculeSummary")
public class SmallMoleculeSummary {
    @JsonProperty(value="prefix")
    @JacksonXmlProperty(localName="prefix")
    @XmlElement(name="prefix")
    private PrefixEnum prefix = PrefixEnum.SML;
    @JsonProperty(value="header_prefix")
    @JacksonXmlProperty(localName="header_prefix")
    @XmlElement(name="header_prefix")
    private HeaderPrefixEnum headerPrefix = HeaderPrefixEnum.SMH;
    @JsonProperty(value="sml_id")
    @JacksonXmlProperty(localName="sml_id")
    @XmlElement(name="sml_id")
    private Integer smlId = null;
    @JsonProperty(value="smf_id_refs")
    @XmlElement(name="smfIdRefs")
    private List<Integer> smfIdRefs = null;
    @JsonProperty(value="database_identifier")
    @XmlElement(name="databaseIdentifier")
    private List<String> databaseIdentifier = null;
    @JsonProperty(value="chemical_formula")
    @XmlElement(name="chemicalFormula")
    private List<String> chemicalFormula = null;
    @JsonProperty(value="smiles")
    @XmlElement(name="smiles")
    private List<String> smiles = null;
    @JsonProperty(value="inchi")
    @XmlElement(name="inchi")
    private List<String> inchi = null;
    @JsonProperty(value="chemical_name")
    @XmlElement(name="chemicalName")
    private List<String> chemicalName = null;
    @JsonProperty(value="uri")
    @XmlElement(name="uri")
    private List<String> uri = null;
    @JsonProperty(value="theoretical_neutral_mass")
    @XmlElement(name="theoreticalNeutralMass")
    private List<Double> theoreticalNeutralMass = null;
    @JsonProperty(value="adduct_ions")
    @XmlElement(name="adductIons")
    private List<String> adductIons = null;
    @JsonProperty(value="reliability")
    @JacksonXmlProperty(localName="reliability")
    @XmlElement(name="reliability")
    private String reliability = null;
    @JsonProperty(value="best_id_confidence_measure")
    @JacksonXmlProperty(localName="best_id_confidence_measure")
    @XmlElement(name="best_id_confidence_measure")
    private Parameter bestIdConfidenceMeasure = null;
    @JsonProperty(value="best_id_confidence_value")
    @JacksonXmlProperty(localName="best_id_confidence_value")
    @XmlElement(name="best_id_confidence_value")
    private Double bestIdConfidenceValue = null;
    @JsonProperty(value="abundance_assay")
    @XmlElement(name="abundanceAssay")
    private List<Double> abundanceAssay = null;
    @JsonProperty(value="abundance_study_variable")
    @XmlElement(name="abundanceStudyVariable")
    private List<Double> abundanceStudyVariable = null;
    @JsonProperty(value="abundance_variation_study_variable")
    @XmlElement(name="abundanceVariationStudyVariable")
    private List<Double> abundanceVariationStudyVariable = null;
    @JsonProperty(value="opt")
    @XmlElement(name="opt")
    private List<OptColumnMapping> opt = null;
    @JsonProperty(value="comment")
    @XmlElement(name="comment")
    private List<Comment> comment = null;

    @ApiModelProperty(value="The small molecule table row prefix. SML MUST be used for rows of the small molecule table.")
    public PrefixEnum getPrefix() {
        return this.prefix;
    }

    @ApiModelProperty(value="The small molecule table header prefix. SMH MUST be used for the small molecule table header line (the column labels).")
    public HeaderPrefixEnum getHeaderPrefix() {
        return this.headerPrefix;
    }

    public SmallMoleculeSummary smlId(Integer smlId) {
        this.smlId = smlId;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="A within file unique identifier for the small molecule.")
    public Integer getSmlId() {
        return this.smlId;
    }

    public void setSmlId(Integer smlId) {
        this.smlId = smlId;
    }

    public SmallMoleculeSummary smfIdRefs(List<Integer> smfIdRefs) {
        this.smfIdRefs = smfIdRefs;
        return this;
    }

    public SmallMoleculeSummary addSmfIdRefsItem(Integer smfIdRefsItem) {
        if (this.smfIdRefs == null) {
            this.smfIdRefs = new ArrayList<Integer>();
        }
        this.smfIdRefs.add(smfIdRefsItem);
        return this;
    }

    @ApiModelProperty(value="References to all the features on which quantitation has been based (SMF elements) via referencing SMF_ID values. Multiple values SHOULD be provided as a \u201c|\u201d separated list. This MAY be null only if this is a Summary file.")
    public List<Integer> getSmfIdRefs() {
        return this.smfIdRefs;
    }

    public void setSmfIdRefs(List<Integer> smfIdRefs) {
        this.smfIdRefs = smfIdRefs;
    }

    public SmallMoleculeSummary databaseIdentifier(List<String> databaseIdentifier) {
        this.databaseIdentifier = databaseIdentifier;
        return this;
    }

    public SmallMoleculeSummary addDatabaseIdentifierItem(String databaseIdentifierItem) {
        if (this.databaseIdentifier == null) {
            this.databaseIdentifier = new ArrayList<String>();
        }
        this.databaseIdentifier.add(databaseIdentifierItem);
        return this;
    }

    @ApiModelProperty(value="A list of \u201c|\u201d separated possible identifiers for the small molecule; multiple values MUST only be provided to indicate ambiguity in the identification of the molecule and not to demonstrate different identifier types for the same molecule. Alternative identifiers for the same molecule MAY be provided as optional columns.  The database identifier must be preceded by the resource description (prefix) followed by a colon, as specified in the metadata section.      A null value MAY be provided if the identification is sufficiently ambiguous as to be meaningless for reporting or the small molecule has not been identified. ")
    public List<String> getDatabaseIdentifier() {
        return this.databaseIdentifier;
    }

    public void setDatabaseIdentifier(List<String> databaseIdentifier) {
        this.databaseIdentifier = databaseIdentifier;
    }

    public SmallMoleculeSummary chemicalFormula(List<String> chemicalFormula) {
        this.chemicalFormula = chemicalFormula;
        return this;
    }

    public SmallMoleculeSummary addChemicalFormulaItem(String chemicalFormulaItem) {
        if (this.chemicalFormula == null) {
            this.chemicalFormula = new ArrayList<String>();
        }
        this.chemicalFormula.add(chemicalFormulaItem);
        return this;
    }

    @ApiModelProperty(value="A list of \u201c|\u201d separated potential chemical formulae of the reported compound. The number of values provided MUST match the number of entities reported under \u201cdatabase_identifier\u201d, even if this leads to redundant reporting of information (i.e. if ambiguity can be resolved in the chemical formula), and the validation software will throw an error if the number of \u201c|\u201d symbols does not match. \u201cnull\u201d values between bars are allowed.  This should be specified in Hill notation (EA Hill 1900), i.e. elements in the order C, H and then alphabetically all other elements. Counts of one may be omitted. Elements should be capitalized properly to avoid confusion (e.g., \u201cCO\u201d vs. \u201cCo\u201d). The chemical formula reported should refer to the neutral form.  Example: N-acetylglucosamine would be encoded by the string \u201cC8H15NO6\u201d. ")
    public List<String> getChemicalFormula() {
        return this.chemicalFormula;
    }

    public void setChemicalFormula(List<String> chemicalFormula) {
        this.chemicalFormula = chemicalFormula;
    }

    public SmallMoleculeSummary smiles(List<String> smiles) {
        this.smiles = smiles;
        return this;
    }

    public SmallMoleculeSummary addSmilesItem(String smilesItem) {
        if (this.smiles == null) {
            this.smiles = new ArrayList<String>();
        }
        this.smiles.add(smilesItem);
        return this;
    }

    @ApiModelProperty(value="A list of \u201c|\u201d separated potential molecule structures in the simplified molecular-input line-entry system (SMILES) for the small molecule. The number of values provided MUST match the number of entities reported under \u201cdatabase_identifier\u201d, and the validation software will throw an error if the number of \u201c|\u201d symbols does not match. \u201cnull\u201d values between bars are allowed.")
    public List<String> getSmiles() {
        return this.smiles;
    }

    public void setSmiles(List<String> smiles) {
        this.smiles = smiles;
    }

    public SmallMoleculeSummary inchi(List<String> inchi) {
        this.inchi = inchi;
        return this;
    }

    public SmallMoleculeSummary addInchiItem(String inchiItem) {
        if (this.inchi == null) {
            this.inchi = new ArrayList<String>();
        }
        this.inchi.add(inchiItem);
        return this;
    }

    @ApiModelProperty(value="A list of \u201c|\u201d separated potential standard IUPAC International Chemical Identifier (InChI) of the given substance.  The number of values provided MUST match the number of entities reported under \u201cdatabase_identifier\u201d, even if this leads to redundant information being reported (i.e. if ambiguity can be resolved in the InChi), and the validation software will throw an error if the number of \u201c|\u201d symbols does not match. \u201cnull\u201d values between bars are allowed. ")
    public List<String> getInchi() {
        return this.inchi;
    }

    public void setInchi(List<String> inchi) {
        this.inchi = inchi;
    }

    public SmallMoleculeSummary chemicalName(List<String> chemicalName) {
        this.chemicalName = chemicalName;
        return this;
    }

    public SmallMoleculeSummary addChemicalNameItem(String chemicalNameItem) {
        if (this.chemicalName == null) {
            this.chemicalName = new ArrayList<String>();
        }
        this.chemicalName.add(chemicalNameItem);
        return this;
    }

    @ApiModelProperty(value="A list of \u201c|\u201d separated possible chemical/common names for the small molecule, or general description if a chemical name is unavailable. Multiple names are only to demonstrate ambiguity in the identification. The number of values provided MUST match the number of entities reported under \u201cdatabase_identifier\u201d, and the validation software will throw an error if the number of \u201c|\u201d symbols does not match. \u201cnull\u201d values between bars are allowed. ")
    public List<String> getChemicalName() {
        return this.chemicalName;
    }

    public void setChemicalName(List<String> chemicalName) {
        this.chemicalName = chemicalName;
    }

    public SmallMoleculeSummary uri(List<String> uri) {
        this.uri = uri;
        return this;
    }

    public SmallMoleculeSummary addUriItem(String uriItem) {
        if (this.uri == null) {
            this.uri = new ArrayList<String>();
        }
        this.uri.add(uriItem);
        return this;
    }

    @ApiModelProperty(value="A URI pointing to the small molecule\u2019s entry in a reference database (e.g., the small molecule\u2019s HMDB or KEGG entry). The number of values provided MUST match the number of entities reported under \u201cdatabase_identifier\u201d, and the validation software will throw an error if the number of \u201c|\u201d symbols does not match. \u201cnull\u201d values between bars are allowed.")
    public List<String> getUri() {
        return this.uri;
    }

    public void setUri(List<String> uri) {
        this.uri = uri;
    }

    public SmallMoleculeSummary theoreticalNeutralMass(List<Double> theoreticalNeutralMass) {
        this.theoreticalNeutralMass = theoreticalNeutralMass;
        return this;
    }

    public SmallMoleculeSummary addTheoreticalNeutralMassItem(Double theoreticalNeutralMassItem) {
        if (this.theoreticalNeutralMass == null) {
            this.theoreticalNeutralMass = new ArrayList<Double>();
        }
        this.theoreticalNeutralMass.add(theoreticalNeutralMassItem);
        return this;
    }

    @ApiModelProperty(value="The small molecule\u2019s precursor\u2019s theoretical neutral mass.  The number of values provided MUST match the number of entities reported under \u201cdatabase_identifier\u201d, and the validation software will throw an error if the number of \u201c|\u201d symbols does not match. \u201cnull\u201d values (in general and between bars) are allowed for molecules that have not been identified only, or for molecules where the neutral mass cannot be calculated. In these cases, the SML entry SHOULD reference features in which exp_mass_to_charge values are captured. ")
    public List<Double> getTheoreticalNeutralMass() {
        return this.theoreticalNeutralMass;
    }

    public void setTheoreticalNeutralMass(List<Double> theoreticalNeutralMass) {
        this.theoreticalNeutralMass = theoreticalNeutralMass;
    }

    public SmallMoleculeSummary adductIons(List<String> adductIons) {
        this.adductIons = adductIons;
        return this;
    }

    public SmallMoleculeSummary addAdductIonsItem(String adductIonsItem) {
        if (this.adductIons == null) {
            this.adductIons = new ArrayList<String>();
        }
        this.adductIons.add(adductIonsItem);
        return this;
    }

    @ApiModelProperty(value="A \u201c|\u201d separated list of detected adducts for this this molecule, following the general style in the 2013 IUPAC recommendations on terms relating to MS e.g. [M+H]1+, [M+Na]1+, [M+NH4]1+, [M-H]1-, [M+Cl]1-, [M+H]1+. If the adduct classification is ambiguous with regards to identification evidence it MAY be null. ")
    public List<String> getAdductIons() {
        return this.adductIons;
    }

    public void setAdductIons(List<String> adductIons) {
        this.adductIons = adductIons;
    }

    public SmallMoleculeSummary reliability(String reliability) {
        this.reliability = reliability;
        return this;
    }

    @ApiModelProperty(value="The reliability of the given small molecule identification. This must be supplied by the resource and MUST be reported as an integer between 1-4:      identified metabolite (1)      putatively annotated compound (2)      putatively characterized compound class (3)      unknown compound (4)  These MAY be replaced using a suitable CV term in the metadata section e.g. to use MSI recommendation levels (see Section 6.2.57 for details).  The following CV terms are already available within the PSI MS CV. Future schemes may be implemented by extending the PSI MS CV with new terms and associated levels.  The MSI has recently discussed an extension of the original four level scheme into a five level scheme MS:1002896 (compound identification confidence level) with levels      isolated, pure compound, full stereochemistry (0)      reference standard match or full 2D structure (1)      unambiguous diagnostic evidence (literature, database) (2)      most likely structure, including isomers, substance class or substructure match (3)      unknown compound (4)  For high-resolution MS, the following term and its levels may be used: MS:1002955 (hr-ms compound identification confidence level) with levels      confirmed structure (1)      probable structure (2)          unambiguous ms library match (2a)          diagnostic evidence (2b)      tentative candidates (3)      unequivocal molecular formula (4)      exact mass (5)  A String data type is set to allow for different systems to be specified in the metadata section. ")
    public String getReliability() {
        return this.reliability;
    }

    public void setReliability(String reliability) {
        this.reliability = reliability;
    }

    public SmallMoleculeSummary bestIdConfidenceMeasure(Parameter bestIdConfidenceMeasure) {
        this.bestIdConfidenceMeasure = bestIdConfidenceMeasure;
        return this;
    }

    @Valid
    @ApiModelProperty(value="The approach or database search that identified this small molecule with highest confidence.")
    public Parameter getBestIdConfidenceMeasure() {
        return this.bestIdConfidenceMeasure;
    }

    public void setBestIdConfidenceMeasure(Parameter bestIdConfidenceMeasure) {
        this.bestIdConfidenceMeasure = bestIdConfidenceMeasure;
    }

    public SmallMoleculeSummary bestIdConfidenceValue(Double bestIdConfidenceValue) {
        this.bestIdConfidenceValue = bestIdConfidenceValue;
        return this;
    }

    @ApiModelProperty(value="The best confidence measure in identification (for this type of score) for the given small molecule across all assays. The type of score MUST be defined in the metadata section. If the small molecule was not identified by the specified search engine, \u201cnull\u201d MUST be reported. If the confidence measure does not report a numerical confidence value, \u201cnull\u201d SHOULD be reported.")
    public Double getBestIdConfidenceValue() {
        return this.bestIdConfidenceValue;
    }

    public void setBestIdConfidenceValue(Double bestIdConfidenceValue) {
        this.bestIdConfidenceValue = bestIdConfidenceValue;
    }

    public SmallMoleculeSummary abundanceAssay(List<Double> abundanceAssay) {
        this.abundanceAssay = abundanceAssay;
        return this;
    }

    public SmallMoleculeSummary addAbundanceAssayItem(Double abundanceAssayItem) {
        if (this.abundanceAssay == null) {
            this.abundanceAssay = new ArrayList<Double>();
        }
        this.abundanceAssay.add(abundanceAssayItem);
        return this;
    }

    @ApiModelProperty(value="The small molecule\u2019s abundance in every assay described in the metadata section MUST be reported. Null or zero values may be reported as appropriate. \"null\" SHOULD be used to report missing quantities, while zero SHOULD be used to indicate a present but not reliably quantifiable value (e.g. below a minimum noise threshold).")
    public List<Double> getAbundanceAssay() {
        return this.abundanceAssay;
    }

    public void setAbundanceAssay(List<Double> abundanceAssay) {
        this.abundanceAssay = abundanceAssay;
    }

    public SmallMoleculeSummary abundanceStudyVariable(List<Double> abundanceStudyVariable) {
        this.abundanceStudyVariable = abundanceStudyVariable;
        return this;
    }

    public SmallMoleculeSummary addAbundanceStudyVariableItem(Double abundanceStudyVariableItem) {
        if (this.abundanceStudyVariable == null) {
            this.abundanceStudyVariable = new ArrayList<Double>();
        }
        this.abundanceStudyVariable.add(abundanceStudyVariableItem);
        return this;
    }

    @ApiModelProperty(value="The small molecule\u2019s abundance in all the study variables described in the metadata section (study_variable[1-n]_average_function), calculated using the method as described in the Metadata section (default = arithmetic mean across assays). Null or zero values may be reported as appropriate. \"null\" SHOULD be used to report missing quantities, while zero SHOULD be used to indicate a present but not reliably quantifiable value (e.g. below a minimum noise threshold).")
    public List<Double> getAbundanceStudyVariable() {
        return this.abundanceStudyVariable;
    }

    public void setAbundanceStudyVariable(List<Double> abundanceStudyVariable) {
        this.abundanceStudyVariable = abundanceStudyVariable;
    }

    public SmallMoleculeSummary abundanceVariationStudyVariable(List<Double> abundanceVariationStudyVariable) {
        this.abundanceVariationStudyVariable = abundanceVariationStudyVariable;
        return this;
    }

    public SmallMoleculeSummary addAbundanceVariationStudyVariableItem(Double abundanceVariationStudyVariableItem) {
        if (this.abundanceVariationStudyVariable == null) {
            this.abundanceVariationStudyVariable = new ArrayList<Double>();
        }
        this.abundanceVariationStudyVariable.add(abundanceVariationStudyVariableItem);
        return this;
    }

    @ApiModelProperty(value="A measure of the variability of the study variable abundance measurement, calculated using the method as described in the metadata section (study_variable[1-n]_average_function), with a default = arithmethic co-efficient of variation of the small molecule\u2019s abundance in the given study variable.")
    public List<Double> getAbundanceVariationStudyVariable() {
        return this.abundanceVariationStudyVariable;
    }

    public void setAbundanceVariationStudyVariable(List<Double> abundanceVariationStudyVariable) {
        this.abundanceVariationStudyVariable = abundanceVariationStudyVariable;
    }

    public SmallMoleculeSummary opt(List<OptColumnMapping> opt) {
        this.opt = opt;
        return this;
    }

    public SmallMoleculeSummary addOptItem(OptColumnMapping optItem) {
        if (this.opt == null) {
            this.opt = new ArrayList<OptColumnMapping>();
        }
        this.opt.add(optItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="Additional columns can be added to the end of the small molecule table. These column headers MUST start with the prefix \u201copt_\u201d followed by the {identifier} of the object they reference: assay, study variable, MS run or \u201cglobal\u201d (if the value relates to all replicates). Column names MUST only contain the following characters: \u2018A\u2019-\u2018Z\u2019, \u2018a\u2019-\u2018z\u2019, \u20180\u2019-\u20189\u2019, \u2018\u2019, \u2018-\u2019, \u2018[\u2019, \u2018]\u2019, and \u2018:\u2019. CV parameter accessions MAY be used for optional columns following the format: opt{identifier}_cv_{accession}_\\{parameter name}. Spaces within the parameter\u2019s name MUST be replaced by \u2018_\u2019. ")
    public List<OptColumnMapping> getOpt() {
        return this.opt;
    }

    public void setOpt(List<OptColumnMapping> opt) {
        this.opt = opt;
    }

    public SmallMoleculeSummary comment(List<Comment> comment) {
        this.comment = comment;
        return this;
    }

    public SmallMoleculeSummary addCommentItem(Comment commentItem) {
        if (this.comment == null) {
            this.comment = new ArrayList<Comment>();
        }
        this.comment.add(commentItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public List<Comment> getComment() {
        return this.comment;
    }

    public void setComment(List<Comment> comment) {
        this.comment = comment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SmallMoleculeSummary smallMoleculeSummary = (SmallMoleculeSummary)o;
        return Objects.equals((Object)this.prefix, (Object)smallMoleculeSummary.prefix) && Objects.equals((Object)this.headerPrefix, (Object)smallMoleculeSummary.headerPrefix) && Objects.equals(this.smlId, smallMoleculeSummary.smlId) && Objects.equals(this.smfIdRefs, smallMoleculeSummary.smfIdRefs) && Objects.equals(this.databaseIdentifier, smallMoleculeSummary.databaseIdentifier) && Objects.equals(this.chemicalFormula, smallMoleculeSummary.chemicalFormula) && Objects.equals(this.smiles, smallMoleculeSummary.smiles) && Objects.equals(this.inchi, smallMoleculeSummary.inchi) && Objects.equals(this.chemicalName, smallMoleculeSummary.chemicalName) && Objects.equals(this.uri, smallMoleculeSummary.uri) && Objects.equals(this.theoreticalNeutralMass, smallMoleculeSummary.theoreticalNeutralMass) && Objects.equals(this.adductIons, smallMoleculeSummary.adductIons) && Objects.equals(this.reliability, smallMoleculeSummary.reliability) && Objects.equals(this.bestIdConfidenceMeasure, smallMoleculeSummary.bestIdConfidenceMeasure) && Objects.equals(this.bestIdConfidenceValue, smallMoleculeSummary.bestIdConfidenceValue) && Objects.equals(this.abundanceAssay, smallMoleculeSummary.abundanceAssay) && Objects.equals(this.abundanceStudyVariable, smallMoleculeSummary.abundanceStudyVariable) && Objects.equals(this.abundanceVariationStudyVariable, smallMoleculeSummary.abundanceVariationStudyVariable) && Objects.equals(this.opt, smallMoleculeSummary.opt) && Objects.equals(this.comment, smallMoleculeSummary.comment);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.prefix, this.headerPrefix, this.smlId, this.smfIdRefs, this.databaseIdentifier, this.chemicalFormula, this.smiles, this.inchi, this.chemicalName, this.uri, this.theoreticalNeutralMass, this.adductIons, this.reliability, this.bestIdConfidenceMeasure, this.bestIdConfidenceValue, this.abundanceAssay, this.abundanceStudyVariable, this.abundanceVariationStudyVariable, this.opt, this.comment});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SmallMoleculeSummary {\n");
        sb.append("    prefix: ").append(this.toIndentedString((Object)this.prefix)).append("\n");
        sb.append("    headerPrefix: ").append(this.toIndentedString((Object)this.headerPrefix)).append("\n");
        sb.append("    smlId: ").append(this.toIndentedString(this.smlId)).append("\n");
        sb.append("    smfIdRefs: ").append(this.toIndentedString(this.smfIdRefs)).append("\n");
        sb.append("    databaseIdentifier: ").append(this.toIndentedString(this.databaseIdentifier)).append("\n");
        sb.append("    chemicalFormula: ").append(this.toIndentedString(this.chemicalFormula)).append("\n");
        sb.append("    smiles: ").append(this.toIndentedString(this.smiles)).append("\n");
        sb.append("    inchi: ").append(this.toIndentedString(this.inchi)).append("\n");
        sb.append("    chemicalName: ").append(this.toIndentedString(this.chemicalName)).append("\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("    theoreticalNeutralMass: ").append(this.toIndentedString(this.theoreticalNeutralMass)).append("\n");
        sb.append("    adductIons: ").append(this.toIndentedString(this.adductIons)).append("\n");
        sb.append("    reliability: ").append(this.toIndentedString(this.reliability)).append("\n");
        sb.append("    bestIdConfidenceMeasure: ").append(this.toIndentedString(this.bestIdConfidenceMeasure)).append("\n");
        sb.append("    bestIdConfidenceValue: ").append(this.toIndentedString(this.bestIdConfidenceValue)).append("\n");
        sb.append("    abundanceAssay: ").append(this.toIndentedString(this.abundanceAssay)).append("\n");
        sb.append("    abundanceStudyVariable: ").append(this.toIndentedString(this.abundanceStudyVariable)).append("\n");
        sb.append("    abundanceVariationStudyVariable: ").append(this.toIndentedString(this.abundanceVariationStudyVariable)).append("\n");
        sb.append("    opt: ").append(this.toIndentedString(this.opt)).append("\n");
        sb.append("    comment: ").append(this.toIndentedString(this.comment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum HeaderPrefixEnum {
        SMH("SMH");

        private String value;

        private HeaderPrefixEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static HeaderPrefixEnum fromValue(String text) {
            for (HeaderPrefixEnum b : HeaderPrefixEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum PrefixEnum {
        SML("SML");

        private String value;

        private PrefixEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PrefixEnum fromValue(String text) {
            for (PrefixEnum b : PrefixEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum Properties {
        prefix("prefix"),
        headerPrefix("header_prefix"),
        smlId("sml_id"),
        smfIdRefs("smf_id_refs"),
        databaseIdentifier("database_identifier"),
        chemicalFormula("chemical_formula"),
        smiles("smiles"),
        inchi("inchi"),
        chemicalName("chemical_name"),
        uri("uri"),
        theoreticalNeutralMass("theoretical_neutral_mass"),
        adductIons("adduct_ions"),
        reliability("reliability"),
        bestIdConfidenceMeasure("best_id_confidence_measure"),
        bestIdConfidenceValue("best_id_confidence_value"),
        abundanceAssay("abundance_assay"),
        abundanceStudyVariable("abundance_study_variable"),
        abundanceVariationStudyVariable("abundance_variation_study_variable"),
        opt("opt"),
        comment("comment");

        private final String propertyName;

        private Properties(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String toString() {
            return this.propertyName;
        }

        public String toUpper() {
            return this.propertyName.toUpperCase();
        }

        public static Properties of(String value) {
            if (value == null) {
                throw new NullPointerException("Argument value must not be null!");
            }
            return Arrays.asList(Properties.values()).stream().filter(m -> m.propertyName.equals(value.toLowerCase())).findAny().orElseThrow(IllegalArgumentException::new);
        }
    }
}

