/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.loaders.objectfile;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.jogamp.java3d.Appearance;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.Geometry;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.Shape3D;
import org.jogamp.java3d.loaders.IncorrectFormatException;
import org.jogamp.java3d.loaders.Loader;
import org.jogamp.java3d.loaders.ParsingErrorException;
import org.jogamp.java3d.loaders.Scene;
import org.jogamp.java3d.loaders.SceneBase;
import org.jogamp.java3d.loaders.objectfile.ObjectFileMaterials;
import org.jogamp.java3d.loaders.objectfile.ObjectFileParser;
import org.jogamp.java3d.utils.geometry.GeometryInfo;
import org.jogamp.java3d.utils.geometry.NormalGenerator;
import org.jogamp.java3d.utils.geometry.Stripifier;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.TexCoord2f;
import org.jogamp.vecmath.Tuple3f;
import org.jogamp.vecmath.Vector3f;

public class ObjectFile
implements Loader {
    private static final int DEBUG = 0;
    public static final int RESIZE = 64;
    public static final int TRIANGULATE = 128;
    public static final int REVERSE = 256;
    public static final int STRIPIFY = 512;
    private static final char BACKSLASH = '\\';
    private int flags;
    private String basePath = null;
    private URL baseUrl = null;
    private boolean fromUrl = false;
    private float radians;
    private ArrayList<Point3f> coordList;
    private ArrayList<TexCoord2f> texList;
    private ArrayList<Vector3f> normList;
    private ArrayList coordIdxList;
    private ArrayList texIdxList;
    private ArrayList normIdxList;
    private ArrayList stripCounts;
    private HashMap groups;
    private String curGroup;
    private HashMap sGroups;
    private String curSgroup;
    private HashMap groupMaterials;
    private HashMap triGroups;
    private ArrayList curTriGroup;
    private HashMap triSgroups;
    private ArrayList curTriSgroup;
    private Point3f[] coordArray = null;
    private Vector3f[] normArray = null;
    private TexCoord2f[] texArray = null;
    private long time;
    private ObjectFileMaterials materials = null;

    void readVertex(ObjectFileParser st) throws ParsingErrorException {
        Point3f p = new Point3f();
        st.getNumber();
        p.x = (float)st.nval;
        st.getNumber();
        p.y = (float)st.nval;
        st.getNumber();
        p.z = (float)st.nval;
        st.skipToNextLine();
        this.coordList.add(p);
    }

    void readNormal(ObjectFileParser st) throws ParsingErrorException {
        Vector3f p = new Vector3f();
        st.getNumber();
        p.x = (float)st.nval;
        st.getNumber();
        p.y = (float)st.nval;
        st.getNumber();
        p.z = (float)st.nval;
        st.skipToNextLine();
        this.normList.add(p);
    }

    void readTexture(ObjectFileParser st) throws ParsingErrorException {
        TexCoord2f p = new TexCoord2f();
        st.getNumber();
        p.x = (float)st.nval;
        st.getNumber();
        p.y = (float)st.nval;
        st.skipToNextLine();
        this.texList.add(p);
    }

    void readFace(ObjectFileParser st) throws ParsingErrorException {
        int texIndex = 0;
        int normIndex = 0;
        int count = 0;
        st.getToken();
        while (st.ttype != 10) {
            st.pushBack();
            st.getNumber();
            int vertIndex = (int)st.nval - 1;
            if (vertIndex < 0) {
                vertIndex += this.coordList.size() + 1;
            }
            this.coordIdxList.add(new Integer(vertIndex));
            st.getToken();
            if (st.ttype == 47) {
                st.getToken();
                if (st.ttype == -3) {
                    st.pushBack();
                    st.getNumber();
                    texIndex = (int)st.nval - 1;
                    if (texIndex < 0) {
                        texIndex += this.texList.size() + 1;
                    }
                    this.texIdxList.add(new Integer(texIndex));
                    st.getToken();
                }
                if (st.ttype == 47) {
                    st.getNumber();
                    normIndex = (int)st.nval - 1;
                    if (normIndex < 0) {
                        normIndex += this.normList.size() + 1;
                    }
                    this.normIdxList.add(new Integer(normIndex));
                    st.getToken();
                }
            }
            ++count;
        }
        Integer faceNum = new Integer(this.stripCounts.size());
        this.stripCounts.add(new Integer(count));
        this.groups.put(faceNum, this.curGroup);
        if (this.curSgroup != null) {
            this.sGroups.put(faceNum, this.curSgroup);
        }
        st.skipToNextLine();
    }

    void readPartName(ObjectFileParser st) {
        st.getToken();
        String curMat = (String)this.groupMaterials.get(this.curGroup);
        this.curGroup = st.ttype != -3 ? "default" : st.sval;
        if (this.groupMaterials.get(this.curGroup) == null) {
            this.groupMaterials.put(this.curGroup, curMat);
        }
        st.skipToNextLine();
    }

    void readMaterialName(ObjectFileParser st) throws ParsingErrorException {
        st.getToken();
        if (st.ttype == -3) {
            this.groupMaterials.put(this.curGroup, new String(st.sval));
        }
        st.skipToNextLine();
    }

    void loadMaterialFile(ObjectFileParser st) throws ParsingErrorException {
        String s = null;
        st.lowerCaseMode(false);
        do {
            st.getToken();
            if (st.ttype != -3) continue;
            s = st.sval;
        } while (st.ttype != 10);
        this.materials.readMaterialFile(this.fromUrl, this.fromUrl ? this.baseUrl.toString() : this.basePath, s);
        st.lowerCaseMode(true);
        st.skipToNextLine();
    }

    void readSmoothingGroup(ObjectFileParser st) throws ParsingErrorException {
        st.getToken();
        if (st.ttype != -3) {
            st.skipToNextLine();
            return;
        }
        this.curSgroup = st.sval.equals("off") ? "0" : st.sval;
        st.skipToNextLine();
    }

    void readFile(ObjectFileParser st) throws ParsingErrorException {
        st.getToken();
        while (st.ttype != -1) {
            if (st.ttype == -3) {
                if (st.sval.equals("v")) {
                    this.readVertex(st);
                } else if (st.sval.equals("vn")) {
                    this.readNormal(st);
                } else if (st.sval.equals("vt")) {
                    this.readTexture(st);
                } else if (st.sval.equals("f")) {
                    this.readFace(st);
                } else if (st.sval.equals("fo")) {
                    this.readFace(st);
                } else if (st.sval.equals("g")) {
                    this.readPartName(st);
                } else if (st.sval.equals("s")) {
                    this.readSmoothingGroup(st);
                } else if (st.sval.equals("p")) {
                    st.skipToNextLine();
                } else if (st.sval.equals("l")) {
                    st.skipToNextLine();
                } else if (st.sval.equals("mtllib")) {
                    this.loadMaterialFile(st);
                } else if (st.sval.equals("usemtl")) {
                    this.readMaterialName(st);
                } else if (st.sval.equals("maplib")) {
                    st.skipToNextLine();
                } else if (st.sval.equals("usemap")) {
                    st.skipToNextLine();
                } else {
                    throw new ParsingErrorException("Unrecognized token, line " + st.lineno());
                }
            }
            st.skipToNextLine();
            st.getToken();
        }
    }

    public ObjectFile(int flags, float radians) {
        this.setFlags(flags);
        this.radians = radians;
    }

    public ObjectFile(int flags) {
        this(flags, -1.0f);
    }

    public ObjectFile() {
        this(0, -1.0f);
    }

    private void setBasePathFromFilename(String fileName) {
        if (fileName.lastIndexOf(File.separator) == -1) {
            this.setBasePath("." + File.separator);
        } else {
            this.setBasePath(fileName.substring(0, fileName.lastIndexOf(File.separator)));
        }
    }

    @Override
    public Scene load(String filename) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        this.setBasePathFromFilename(filename);
        BufferedReader reader = new BufferedReader(new FileReader(filename));
        return this.load(reader);
    }

    private void setBaseUrlFromUrl(URL url) throws FileNotFoundException {
        String u = url.toString();
        String s = u.lastIndexOf(47) == -1 ? String.valueOf(url.getProtocol()) + ":" : u.substring(0, u.lastIndexOf(47) + 1);
        try {
            this.baseUrl = new URL(s);
        }
        catch (MalformedURLException e) {
            throw new FileNotFoundException(e.getMessage());
        }
    }

    @Override
    public Scene load(URL url) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        BufferedReader reader;
        if (this.baseUrl == null) {
            this.setBaseUrlFromUrl(url);
        }
        try {
            reader = new BufferedReader(new InputStreamReader(url.openStream()));
        }
        catch (IOException e) {
            throw new FileNotFoundException(e.getMessage());
        }
        this.fromUrl = true;
        return this.load(reader);
    }

    private Point3f[] getLimits() {
        Point3f[] limit = new Point3f[]{new Point3f(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE), new Point3f(Float.MIN_VALUE, Float.MIN_VALUE, Float.MIN_VALUE)};
        int i = 0;
        while (i < this.coordList.size()) {
            Point3f cur_vtx = this.coordList.get(i);
            if (cur_vtx.x < limit[0].x) {
                limit[0].x = cur_vtx.x;
            }
            if (cur_vtx.x > limit[1].x) {
                limit[1].x = cur_vtx.x;
            }
            if (cur_vtx.y < limit[0].y) {
                limit[0].y = cur_vtx.y;
            }
            if (cur_vtx.y > limit[1].y) {
                limit[1].y = cur_vtx.y;
            }
            if (cur_vtx.z < limit[0].z) {
                limit[0].z = cur_vtx.z;
            }
            if (cur_vtx.z > limit[1].z) {
                limit[1].z = cur_vtx.z;
            }
            ++i;
        }
        return limit;
    }

    private void resize() {
        Point3f[] limit = this.getLimits();
        Vector3f offset = new Vector3f(-0.5f * (limit[0].x + limit[1].x), -0.5f * (limit[0].y + limit[1].y), -0.5f * (limit[0].z + limit[1].z));
        float biggest_dif = limit[1].x - limit[0].x;
        if (biggest_dif < limit[1].y - limit[0].y) {
            biggest_dif = limit[1].y - limit[0].y;
        }
        if (biggest_dif < limit[1].z - limit[0].z) {
            biggest_dif = limit[1].z - limit[0].z;
        }
        biggest_dif /= 2.0f;
        int i = 0;
        while (i < this.coordList.size()) {
            Point3f cur_vtx = this.coordList.get(i);
            cur_vtx.add((Tuple3f)cur_vtx, (Tuple3f)offset);
            cur_vtx.x /= biggest_dif;
            cur_vtx.y /= biggest_dif;
            cur_vtx.z /= biggest_dif;
            ++i;
        }
    }

    private int[] objectToIntArray(ArrayList inList) {
        int[] outList = new int[inList.size()];
        int i = 0;
        while (i < inList.size()) {
            outList[i] = (Integer)inList.get(i);
            ++i;
        }
        return outList;
    }

    private Point3f[] objectToPoint3Array(ArrayList<Point3f> inList) {
        Point3f[] outList = new Point3f[inList.size()];
        int i = 0;
        while (i < inList.size()) {
            outList[i] = inList.get(i);
            ++i;
        }
        return outList;
    }

    private TexCoord2f[] objectToTexCoord2Array(ArrayList<TexCoord2f> inList) {
        TexCoord2f[] outList = new TexCoord2f[inList.size()];
        int i = 0;
        while (i < inList.size()) {
            outList[i] = inList.get(i);
            ++i;
        }
        return outList;
    }

    private Vector3f[] objectToVectorArray(ArrayList<Vector3f> inList) {
        Vector3f[] outList = new Vector3f[inList.size()];
        int i = 0;
        while (i < inList.size()) {
            outList[i] = inList.get(i);
            ++i;
        }
        return outList;
    }

    private int[] groupIndices(ArrayList sourceList, ArrayList group) {
        int[] indices = new int[group.size() * 3];
        int i = 0;
        while (i < group.size()) {
            int j = (Integer)group.get(i);
            indices[i * 3 + 0] = (Integer)sourceList.get(j + 0);
            indices[i * 3 + 1] = (Integer)sourceList.get(j + 1);
            indices[i * 3 + 2] = (Integer)sourceList.get(j + 2);
            ++i;
        }
        return indices;
    }

    private void smoothingGroupNormals() {
        NormalGenerator ng = new NormalGenerator(this.radians == -1.0f ? Math.PI : (double)this.radians);
        NormalGenerator ng0 = new NormalGenerator(0.0);
        this.normList.clear();
        this.normIdxList = null;
        int[] newNormIdxArray = new int[this.coordIdxList.size()];
        for (String curname : this.triSgroups.keySet()) {
            ArrayList triList = (ArrayList)this.triSgroups.get(curname);
            if (triList.size() <= 0) continue;
            GeometryInfo gi = new GeometryInfo(1);
            gi.setCoordinateIndices(this.groupIndices(this.coordIdxList, triList));
            gi.setCoordinates(this.coordArray);
            if (curname.equals("0")) {
                ng0.generateNormals(gi);
            } else {
                ng.generateNormals(gi);
            }
            Vector3f[] genNorms = gi.getNormals();
            int[] genNormIndices = gi.getNormalIndices();
            int normIdx = 0;
            int i = 0;
            while (i < triList.size()) {
                int idx = (Integer)triList.get(i);
                int j = 0;
                while (j < 3) {
                    newNormIdxArray[idx + j] = this.normList.size();
                    this.normList.add(genNorms[genNormIndices[normIdx++]]);
                    ++j;
                }
                ++i;
            }
        }
        this.normIdxList = new ArrayList(this.coordIdxList.size());
        int i = 0;
        while (i < this.coordIdxList.size()) {
            this.normIdxList.add(new Integer(newNormIdxArray[i]));
            ++i;
        }
        this.normArray = this.objectToVectorArray(this.normList);
    }

    private void convertToTriangles() {
        boolean triangulate = (this.flags & 0x80) != 0;
        boolean textures = !this.texList.isEmpty() && !this.texIdxList.isEmpty() && this.texIdxList.size() == this.coordIdxList.size();
        boolean normals = !this.normList.isEmpty() && !this.normIdxList.isEmpty() && this.normIdxList.size() == this.coordIdxList.size();
        int numFaces = this.stripCounts.size();
        boolean haveSgroups = this.curSgroup != null;
        this.triGroups = new HashMap(50);
        if (haveSgroups) {
            this.triSgroups = new HashMap(50);
        }
        ArrayList newCoordIdxList = null;
        ArrayList newTexIdxList = null;
        ArrayList newNormIdxList = null;
        if (triangulate) {
            GeometryInfo gi = new GeometryInfo(5);
            gi.setStripCounts(this.objectToIntArray(this.stripCounts));
            gi.setCoordinates(this.coordArray);
            gi.setCoordinateIndices(this.objectToIntArray(this.coordIdxList));
            if (textures) {
                gi.setTextureCoordinateParams(1, 2);
                gi.setTextureCoordinates(0, this.texArray);
                gi.setTextureCoordinateIndices(0, this.objectToIntArray(this.texIdxList));
            }
            if (normals) {
                gi.setNormals(this.normArray);
                gi.setNormalIndices(this.objectToIntArray(this.normIdxList));
            }
            gi.convertToIndexedTriangles();
            int[] coordIndicesArray = gi.getCoordinateIndices();
            int tris = 0;
            int i = 0;
            while (i < numFaces) {
                tris += (Integer)this.stripCounts.get(i) - 2;
                ++i;
            }
            if (coordIndicesArray.length != tris * 3) {
                triangulate = false;
            } else {
                int[] texIndicesArray = gi.getTextureCoordinateIndices();
                int[] normIndicesArray = gi.getNormalIndices();
                this.coordIdxList.clear();
                this.texIdxList.clear();
                this.normIdxList.clear();
                int i2 = 0;
                while (i2 < coordIndicesArray.length) {
                    this.coordIdxList.add(new Integer(coordIndicesArray[i2]));
                    if (textures) {
                        this.texIdxList.add(new Integer(texIndicesArray[i2]));
                    }
                    if (normals) {
                        this.normIdxList.add(new Integer(normIndicesArray[i2]));
                    }
                    ++i2;
                }
            }
        }
        if (!triangulate) {
            newCoordIdxList = new ArrayList();
            if (textures) {
                newTexIdxList = new ArrayList();
            }
            if (normals) {
                newNormIdxList = new ArrayList();
            }
        }
        int baseVertex = 0;
        int f = 0;
        while (f < numFaces) {
            int faceSize = (Integer)this.stripCounts.get(f);
            Integer curFace = new Integer(f);
            this.curGroup = (String)this.groups.get(curFace);
            this.curTriGroup = (ArrayList)this.triGroups.get(this.curGroup);
            if (this.curTriGroup == null) {
                this.curTriGroup = new ArrayList();
                this.triGroups.put(this.curGroup, this.curTriGroup);
            }
            if (haveSgroups) {
                this.curSgroup = (String)this.sGroups.get(curFace);
                if (this.curSgroup == null) {
                    this.curSgroup = "0";
                }
                this.curTriSgroup = (ArrayList)this.triSgroups.get(this.curSgroup);
                if (this.curTriSgroup == null) {
                    this.curTriSgroup = new ArrayList();
                    this.triSgroups.put(this.curSgroup, this.curTriSgroup);
                }
            }
            if (triangulate) {
                int t = 0;
                while (t < faceSize - 2) {
                    Integer triBaseVertex = new Integer(baseVertex);
                    this.curTriGroup.add(triBaseVertex);
                    if (haveSgroups) {
                        this.curTriSgroup.add(triBaseVertex);
                    }
                    baseVertex += 3;
                    ++t;
                }
            } else {
                int v = 0;
                while (v < faceSize - 2) {
                    Integer triBaseVertex = new Integer(newCoordIdxList.size());
                    this.curTriGroup.add(triBaseVertex);
                    if (haveSgroups) {
                        this.curTriSgroup.add(triBaseVertex);
                    }
                    newCoordIdxList.add(this.coordIdxList.get(baseVertex));
                    newCoordIdxList.add(this.coordIdxList.get(baseVertex + v + 1));
                    newCoordIdxList.add(this.coordIdxList.get(baseVertex + v + 2));
                    if (textures) {
                        newTexIdxList.add(this.texIdxList.get(baseVertex));
                        newTexIdxList.add(this.texIdxList.get(baseVertex + v + 1));
                        newTexIdxList.add(this.texIdxList.get(baseVertex + v + 2));
                    }
                    if (normals) {
                        newNormIdxList.add(this.normIdxList.get(baseVertex));
                        newNormIdxList.add(this.normIdxList.get(baseVertex + v + 1));
                        newNormIdxList.add(this.normIdxList.get(baseVertex + v + 2));
                    }
                    ++v;
                }
                baseVertex += faceSize;
            }
            ++f;
        }
        this.stripCounts = null;
        this.groups = null;
        this.sGroups = null;
        if (!triangulate) {
            this.coordIdxList = newCoordIdxList;
            this.texIdxList = newTexIdxList;
            this.normIdxList = newNormIdxList;
        }
    }

    private SceneBase makeScene() {
        SceneBase scene = new SceneBase();
        BranchGroup group = new BranchGroup();
        scene.setSceneGroup(group);
        boolean gen_norms = this.normList.isEmpty() || this.normIdxList.isEmpty() || this.normIdxList.size() != this.coordIdxList.size();
        boolean do_tex = !this.texList.isEmpty() && !this.texIdxList.isEmpty() && this.texIdxList.size() == this.coordIdxList.size();
        this.coordArray = this.objectToPoint3Array(this.coordList);
        if (!gen_norms) {
            this.normArray = this.objectToVectorArray(this.normList);
        }
        if (do_tex) {
            this.texArray = this.objectToTexCoord2Array(this.texList);
        }
        this.convertToTriangles();
        if (gen_norms && this.curSgroup != null) {
            this.smoothingGroupNormals();
            gen_norms = false;
        }
        NormalGenerator ng = null;
        if (gen_norms) {
            ng = new NormalGenerator(this.radians);
        }
        Stripifier strippy = null;
        if ((this.flags & 0x200) != 0) {
            strippy = new Stripifier();
        }
        long t1 = 0L;
        long t2 = 0L;
        long t3 = 0L;
        long t4 = 0L;
        for (String curname : this.triGroups.keySet()) {
            ArrayList triList = (ArrayList)this.triGroups.get(curname);
            if (triList.size() <= 0) continue;
            GeometryInfo gi = new GeometryInfo(1);
            gi.setCoordinateIndices(this.groupIndices(this.coordIdxList, triList));
            gi.setCoordinates(this.coordArray);
            if (do_tex) {
                gi.setTextureCoordinateParams(1, 2);
                gi.setTextureCoordinates(0, this.texArray);
                gi.setTextureCoordinateIndices(0, this.groupIndices(this.texIdxList, triList));
            }
            if (gen_norms) {
                if ((this.flags & 0x100) != 0) {
                    gi.reverse();
                }
                ng.generateNormals(gi);
            } else {
                gi.setNormalIndices(this.groupIndices(this.normIdxList, triList));
                gi.setNormals(this.normArray);
                if ((this.flags & 0x100) != 0) {
                    gi.reverse();
                }
            }
            if ((this.flags & 0x200) != 0) {
                strippy.stripify(gi);
            }
            Shape3D shape = new Shape3D();
            shape.setGeometry((Geometry)gi.getGeometryArray(true, false, true));
            String matName = (String)this.groupMaterials.get(curname);
            this.materials.assignMaterial(matName, shape, this.createAppearance());
            group.addChild((Node)shape);
            scene.addNamedObject(curname, shape);
        }
        return scene;
    }

    public Appearance createAppearance() {
        return new Appearance();
    }

    @Override
    public Scene load(Reader reader) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        ObjectFileParser st = new ObjectFileParser(reader);
        this.coordList = new ArrayList();
        this.texList = new ArrayList();
        this.normList = new ArrayList();
        this.coordIdxList = new ArrayList();
        this.texIdxList = new ArrayList();
        this.normIdxList = new ArrayList();
        this.groups = new HashMap(50);
        this.curGroup = "default";
        this.sGroups = new HashMap(50);
        this.curSgroup = null;
        this.stripCounts = new ArrayList();
        this.groupMaterials = new HashMap(50);
        this.groupMaterials.put(this.curGroup, "default");
        this.materials = new ObjectFileMaterials();
        this.time = 0L;
        this.readFile(st);
        if ((this.flags & 0x40) != 0) {
            this.resize();
        }
        return this.makeScene();
    }

    @Override
    public void setBaseUrl(URL url) {
        this.baseUrl = url;
    }

    @Override
    public URL getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    public void setBasePath(String pathName) {
        this.basePath = pathName;
        if (this.basePath == null || this.basePath == "") {
            this.basePath = "." + File.separator;
        }
        this.basePath = this.basePath.replace('/', File.separatorChar);
        this.basePath = this.basePath.replace('\\', File.separatorChar);
        if (!this.basePath.endsWith(File.separator)) {
            this.basePath = String.valueOf(this.basePath) + File.separator;
        }
    }

    @Override
    public String getBasePath() {
        return this.basePath;
    }

    @Override
    public void setFlags(int flags) {
        this.flags = flags;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }
}

