/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jogamp.java3d.Appearance;
import org.jogamp.java3d.Geometry;
import org.jogamp.java3d.SceneGraphObject;
import org.jogamp.java3d.Shape3D;
import org.jogamp.java3d.utils.scenegraph.io.retained.Controller;
import org.jogamp.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d.LeafState;

public class Shape3DState
extends LeafState {
    private int[] geometry;
    private int appearance;

    public Shape3DState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
        if (this.node != null) {
            this.appearance = control.getSymbolTable().addReference((SceneGraphObject)((Shape3D)this.node).getAppearance());
            int length = ((Shape3D)this.node).numGeometries();
            this.geometry = new int[length];
            int i = 0;
            while (i < length) {
                this.geometry[i] = control.getSymbolTable().addReference((SceneGraphObject)((Shape3D)this.node).getGeometry(i));
                ++i;
            }
        }
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        this.control.writeBounds(out, ((Shape3D)this.node).getCollisionBounds());
        out.writeInt(this.appearance);
        out.writeInt(this.geometry.length);
        int i = 0;
        while (i < this.geometry.length) {
            out.writeInt(this.geometry[i]);
            ++i;
        }
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        ((Shape3D)this.node).setCollisionBounds(this.control.readBounds(in));
        this.appearance = in.readInt();
        this.geometry = new int[in.readInt()];
        int i = 0;
        while (i < this.geometry.length) {
            this.geometry[i] = in.readInt();
            ++i;
        }
    }

    public void addSubReference() {
        this.control.getSymbolTable().incNodeComponentRefCount(this.appearance);
    }

    @Override
    public void buildGraph() {
        ((Shape3D)this.node).setAppearance((Appearance)this.control.getSymbolTable().getJ3dNode(this.appearance));
        ((Shape3D)this.node).setGeometry((Geometry)this.control.getSymbolTable().getJ3dNode(this.geometry[0]));
        int i = 1;
        while (i < this.geometry.length) {
            ((Shape3D)this.node).addGeometry((Geometry)this.control.getSymbolTable().getJ3dNode(this.geometry[i]));
            ++i;
        }
        super.buildGraph();
    }

    @Override
    protected SceneGraphObject createNode() {
        return new Shape3D();
    }
}

