/*
 * Decompiled with CFR 0.152.
 */
package com.exe4j.runtime.util;

import com.exe4j.runtime.util.NullOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LazyFileOutputStream
extends OutputStream {
    private String fileName;
    private boolean append;
    private OutputStream fos;

    public LazyFileOutputStream(String fileName) {
        this.append = fileName.endsWith("+");
        if (this.append) {
            fileName = fileName.substring(0, fileName.length() - 1);
        }
        this.fileName = fileName;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.init();
        this.fos.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.init();
        this.fos.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        this.init();
        this.fos.write(b);
    }

    private void init() {
        if (this.fos == null) {
            try {
                this.fos = new FileOutputStream(this.fileName, this.append);
            }
            catch (FileNotFoundException e) {
                this.fos = new NullOutputStream();
            }
        }
    }
}

