/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.MsiHelper;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchObjectAction;
import com.install4j.runtime.installer.helper.content.ChecksumChecker;
import com.install4j.runtime.installer.helper.content.ContentStats;
import com.install4j.runtime.installer.helper.content.CountingInputStream;
import com.install4j.runtime.installer.helper.content.Downloader;
import com.install4j.runtime.installer.helper.content.PartialFileInputStream;
import com.install4j.runtime.installer.helper.content.SplittedFileInputStream;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

class ContentCollector {
    private static final String DATA_DIR_NAME = "data";
    private InstallerContext context;
    private boolean saveDownloadedFiles;
    private boolean acceptAllCertificates;

    public ContentCollector(InstallerContext context, boolean saveDownloadedFiles, boolean acceptAllCertificates) {
        this.context = context;
        this.saveDownloadedFiles = saveDownloadedFiles;
        this.acceptAllCertificates = acceptAllCertificates;
    }

    public Map<Comparable<String>, InputStream> collectContentStreams(String componentId) throws UserCanceledException, IOException {
        HashMap<Comparable<String>, InputStream> contentStreams = new HashMap<Comparable<String>, InputStream>();
        ArrayList<String> downloadNumbers = new ArrayList<String>();
        ContentStats contentStats = ContentStats.getInstance();
        String propertyModuleName = System.getProperty("exe4j.moduleName");
        Map<String, UnextractedInfo> nameToUnextractedInfo = this.initUnextractedFiles();
        Set<String> contentNumbers = contentStats.getSelectedContentNumbers(componentId);
        for (String number : contentNumbers) {
            String mediaDir;
            String fileName = contentStats.getFileName(number);
            UnextractedInfo unextractedInfo = nameToUnextractedInfo.get(fileName);
            if (unextractedInfo != null) {
                assert (propertyModuleName != null);
                PartialFileInputStream in = new PartialFileInputStream(new File(propertyModuleName), unextractedInfo.position, unextractedInfo.length);
                contentStreams.put((Comparable<String>)((Object)number), in);
                continue;
            }
            File installerDir = propertyModuleName == null ? new File(".") : InstallerUtil.getAbsoluteFile(new File(propertyModuleName)).getParentFile();
            File contentFile = this.getContentFile(contentStats, number, fileName, installerDir);
            if (!contentFile.exists() && (Util.isMacosInstaller() || MsiHelper.isStartedFromMsi()) && (mediaDir = (String)this.context.getVariable("sys.mediaDir")) != null) {
                contentFile = this.getContentFile(contentStats, number, fileName, new File(mediaDir));
            }
            if (!contentFile.exists()) {
                String downloadUrl = InstallerConfig.getCurrentInstance().getDownloadURL();
                if (downloadUrl.trim().length() == 0) {
                    String message = Messages.getString(".ErrorReadingSource") + "\n" + fileName;
                    Util.showMessage(message, 0);
                    throw new UserCanceledException();
                }
                downloadNumbers.add(number);
                continue;
            }
            SplittedFileInputStream in = new SplittedFileInputStream(contentFile);
            contentStreams.put((Comparable<String>)((Object)number), in);
        }
        Map<Comparable<String>, File> numberToDownloadedFiles = ContentCollector.downloadContentFiles(downloadNumbers, this.saveDownloadedFiles, this.acceptAllCertificates, this.context);
        for (Map.Entry<Comparable<String>, File> entry : numberToDownloadedFiles.entrySet()) {
            contentStreams.put(entry.getKey(), new FileInputStream(entry.getValue()));
        }
        return contentStreams;
    }

    private File getContentFile(ContentStats contentStats, String number, String fileName, File installerDir) {
        File contentFile = this.getAbsoluteFile(new File(fileName));
        if (!contentFile.exists()) {
            contentFile = this.getAbsoluteFile(new File(new File(installerDir, contentStats.getDirName()), fileName));
        }
        if (!contentFile.exists()) {
            contentFile = this.getAbsoluteFile(new File(installerDir, fileName));
        }
        if (!contentFile.exists()) {
            contentFile = this.getAbsoluteFile(new File(new File(installerDir, DATA_DIR_NAME), fileName));
        }
        if (!contentFile.exists()) {
            contentFile = this.getAbsoluteFile(new File(new File(installerDir, "common_files.dat"), "common_files." + contentStats.getComponentListString(number) + ".dat"));
        }
        if (!contentFile.exists()) {
            contentFile = this.getAbsoluteFile(new File(new File(installerDir, DATA_DIR_NAME), "common_files." + contentStats.getComponentListString(number) + ".dat"));
        }
        if (!contentFile.exists()) {
            contentFile = this.getAbsoluteFile(new File(installerDir, "common_files." + contentStats.getComponentListString(number) + ".dat"));
        }
        return contentFile;
    }

    private File getAbsoluteFile(File file) {
        return InstallerUtil.getAbsoluteFile(file);
    }

    private Map<String, UnextractedInfo> initUnextractedFiles() throws IOException {
        HashMap<String, UnextractedInfo> nameToUnextractedInfo = new HashMap<String, UnextractedInfo>();
        String propertyModuleName = System.getProperty("exe4j.moduleName");
        if (!Util.isMacosInstaller() && propertyModuleName != null) {
            int startPos = Integer.getInteger("exe4j.unextractedPositionRestart", 0);
            if (startPos == 0) {
                startPos = Integer.getInteger("exe4j.unextractedPosition", 0);
            }
            if (startPos == 0) {
                long totalDataLength = Long.getLong("exe4j.totalDataLength", 0L);
                File moduleFile = new File(propertyModuleName);
                if (totalDataLength > 0L && moduleFile.exists()) {
                    startPos = (int)(moduleFile.length() - totalDataLength);
                }
            }
            if (startPos > 0) {
                long currentPosition = 0L;
                CountingInputStream cin = new CountingInputStream(new BufferedInputStream(new FileInputStream(propertyModuleName)));
                DataInputStream din = new DataInputStream(cin);
                din.skipBytes(startPos);
                if (din.readInt() == -387705899) {
                    int count = din.readInt();
                    for (int i = 0; i < count; ++i) {
                        UnextractedInfo unextractedInfo = new UnextractedInfo();
                        String name = din.readUTF();
                        unextractedInfo.length = din.readLong();
                        unextractedInfo.position = currentPosition;
                        currentPosition += unextractedInfo.length;
                        nameToUnextractedInfo.put(name, unextractedInfo);
                    }
                    for (UnextractedInfo unextractedInfo : nameToUnextractedInfo.values()) {
                        unextractedInfo.position += cin.getCount();
                    }
                } else {
                    throw new IOException("wrong magic number");
                }
                din.close();
            }
        }
        return nameToUnextractedInfo;
    }

    private static Map<Comparable<String>, File> downloadContentFiles(final List<String> downloadNumbers, final boolean saveDownloadedFiles, final boolean acceptAllCertificates, Context context) throws IOException, UserCanceledException {
        if (downloadNumbers.size() > 0) {
            context.getProgressInterface().setStatusMessage(Messages.getString(".Downloading"));
        }
        return HelperCommunication.getInstance().fetchObjectChecked(ExecutionContext.UNELEVATED, new FetchObjectAction<Map<Comparable<String>, File>>(){

            @Override
            protected Map<Comparable<String>, File> fetchValue(Context context) throws Exception {
                try (Downloader downloader = new Downloader(context, context.getProgressInterface());){
                    downloader.setAcceptAllCertificates(acceptAllCertificates);
                    if (downloadNumbers.size() > 0) {
                        context.getProgressInterface().setStatusMessage(Messages.getString(".Downloading"));
                    }
                    ContentStats contentStats = ContentStats.getInstance();
                    long totalSize = 0L;
                    for (String number : downloadNumbers) {
                        totalSize += contentStats.getFileSize(number);
                    }
                    downloader.setTotalSize(totalSize);
                    HashMap<String, File> downloadedFiles = new HashMap<String, File>();
                    for (String number : downloadNumbers) {
                        boolean retry = true;
                        while (retry) {
                            try {
                                File file = ContentCollector.downloadSingleFile(number, downloader, context, saveDownloadedFiles);
                                downloadedFiles.put(number, file);
                                retry = false;
                            }
                            catch (IOException e) {
                                downloader.resetLastTransfer();
                                Logger.getInstance().info(this, e.toString());
                                ContentCollector.askRetry(".DownloadContentError");
                            }
                        }
                    }
                    HashMap<String, File> hashMap = downloadedFiles;
                    return hashMap;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static File downloadSingleFile(String number, Downloader downloader, Context context, boolean saveDownloadedFiles) throws IOException, UserCanceledException {
        ContentStats contentStats = ContentStats.getInstance();
        File outputFile = null;
        try {
            boolean retry;
            String baseUrlString = InstallerConfig.getCurrentInstance().getDownloadURL().trim();
            if (!baseUrlString.endsWith("/")) {
                baseUrlString = baseUrlString + "/";
            }
            String expectedChecksum = null;
            do {
                String fileName;
                String actualChecksum = null;
                do {
                    retry = false;
                    fileName = ContentCollector.connect(number, baseUrlString, downloader);
                    String mediaDir = (String)context.getVariable("sys.mediaDir");
                    if (saveDownloadedFiles && mediaDir != null) {
                        try {
                            File testFile = File.createTempFile("i4jc", ".tst", new File(mediaDir));
                            if (!testFile.delete()) {
                                InstallerUtil.deleteOnExit(testFile);
                            }
                            outputFile = new File(mediaDir, fileName);
                        }
                        catch (IOException testFile) {
                            // empty catch block
                        }
                    }
                    if (outputFile == null) {
                        outputFile = File.createTempFile("i4jc", ".dat");
                    }
                    try {
                        downloader.download(outputFile, contentStats.getFileSize(number), !saveDownloadedFiles);
                        actualChecksum = ChecksumChecker.getHexStringFromBytes(downloader.digest());
                    }
                    catch (IOException e) {
                        Logger.getInstance().error(ContentCollector.class, "could not download file");
                        Logger.getInstance().log(e);
                        ContentCollector.askRetry(".DownloadInterrupted");
                        retry = true;
                    }
                } while (retry);
                retry = false;
                if (expectedChecksum == null) {
                    expectedChecksum = ChecksumChecker.getExpectedDigest(context, baseUrlString + "sha256sums", fileName);
                }
                if (Objects.equals("", expectedChecksum)) continue;
                Logger.getInstance().info(ContentCollector.class, "expected checksum " + expectedChecksum + ", actual checksum " + actualChecksum);
                if (Objects.equals(expectedChecksum, actualChecksum)) continue;
                downloader.resetLastTransfer();
                ContentCollector.askRetry(".DownloadFileCorrupt");
                retry = true;
            } while (retry);
            if (saveDownloadedFiles || outputFile == null) return outputFile;
        }
        catch (Throwable throwable) {
            if (saveDownloadedFiles || outputFile == null) throw throwable;
            InstallerUtil.deleteOnExit(outputFile);
            throw throwable;
        }
        InstallerUtil.deleteOnExit(outputFile);
        return outputFile;
    }

    private static String connect(String number, String baseUrlString, Downloader downloader) throws UserCanceledException, IOException {
        ContentStats contentStats = ContentStats.getInstance();
        String fileName = contentStats.getFileName(number);
        String downloadUrlString = baseUrlString + fileName;
        try {
            Logger.getInstance().info(ContentCollector.class, "Trying to load " + downloadUrlString);
            downloader.connect(downloadUrlString);
            int responseCode = downloader.getConnection().getResponseCode();
            if (responseCode / 100 != 2) {
                throw new IOException("Response code " + responseCode);
            }
        }
        catch (IOException e) {
            Logger.getInstance().info(ContentCollector.class, e.toString());
            fileName = "common_files." + contentStats.getComponentListString(number) + ".dat";
            downloadUrlString = baseUrlString + fileName;
            Logger.getInstance().info(ContentCollector.class, "Trying to load " + downloadUrlString);
            downloader.connect(downloadUrlString);
        }
        Logger.getInstance().info(ContentCollector.class, "connected");
        return fileName;
    }

    private static void askRetry(String messageKey) throws UserCanceledException {
        switch (Util.showOptionDialog(Messages.getString(messageKey), new String[]{Messages.getString(".ButtonOK"), Messages.getString(".ButtonCancel")}, 2)) {
            case -1: 
            case 1: {
                throw new UserCanceledException();
            }
        }
    }

    private static class UnextractedInfo {
        private long position;
        private long length;

        private UnextractedInfo() {
        }
    }
}

