/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.fastexcel;

import java.math.BigDecimal;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.dhatim.fastexcel.Alignment;
import org.dhatim.fastexcel.Border;
import org.dhatim.fastexcel.BorderElement;
import org.dhatim.fastexcel.BorderSide;
import org.dhatim.fastexcel.BorderStyle;
import org.dhatim.fastexcel.Fill;
import org.dhatim.fastexcel.Font;
import org.dhatim.fastexcel.Protection;
import org.dhatim.fastexcel.ProtectionOption;
import org.dhatim.fastexcel.Range;

public class StyleSetter {
    private final Range range;
    private String valueFormatting;
    private String fillColor;
    private String alternateShadingFillColor;
    private String shadingFillColor;
    private int eachNRows;
    private boolean bold;
    private boolean italic;
    private boolean underlined;
    private String fontName;
    private BigDecimal fontSize;
    private String fontColor;
    private String horizontalAlignment;
    private String verticalAlignment;
    private boolean wrapText;
    private Border border;
    private Map<ProtectionOption, Boolean> protectionOptions;

    StyleSetter(Range range) {
        this.range = range;
    }

    public StyleSetter format(String numberingFormat) {
        this.valueFormatting = numberingFormat;
        return this;
    }

    public StyleSetter fillColor(String rgb) {
        this.fillColor = rgb;
        return this;
    }

    public StyleSetter shadeAlternateRows(String rgb) {
        this.alternateShadingFillColor = rgb;
        return this;
    }

    public StyleSetter shadeRows(String rgb, int eachNRows) {
        this.shadingFillColor = rgb;
        this.eachNRows = eachNRows;
        return this;
    }

    public StyleSetter fontColor(String rgb) {
        this.fontColor = rgb;
        return this;
    }

    public StyleSetter fontName(String name) {
        this.fontName = name;
        return this;
    }

    public StyleSetter fontSize(BigDecimal size) {
        this.fontSize = size;
        return this;
    }

    public StyleSetter fontSize(int size) {
        this.fontSize = BigDecimal.valueOf(size);
        return this;
    }

    public StyleSetter bold() {
        this.bold = true;
        return this;
    }

    public StyleSetter italic() {
        this.italic = true;
        return this;
    }

    public StyleSetter underlined() {
        this.underlined = true;
        return this;
    }

    public StyleSetter horizontalAlignment(String alignment) {
        this.horizontalAlignment = alignment;
        return this;
    }

    public StyleSetter verticalAlignment(String alignment) {
        this.verticalAlignment = alignment;
        return this;
    }

    public StyleSetter wrapText(boolean wrapText) {
        this.wrapText = wrapText;
        return this;
    }

    private StyleSetter borderElement(BorderSide side, BorderElement element) {
        if (this.border == null) {
            this.border = new Border();
        }
        this.border.setElement(side, element);
        return this;
    }

    public StyleSetter borderStyle(BorderStyle borderStyle) {
        return this.borderStyle(borderStyle.xmlValue);
    }

    public StyleSetter borderStyle(String borderStyle) {
        if (this.border == null) {
            this.border = new Border();
        }
        EnumSet.of(BorderSide.TOP, BorderSide.LEFT, BorderSide.BOTTOM, BorderSide.RIGHT).forEach(side -> this.borderElement((BorderSide)((Object)side), this.border.elements.get(side).updateStyle(borderStyle)));
        return this;
    }

    public StyleSetter borderStyle(BorderSide side, BorderStyle borderStyle) {
        return this.borderStyle(side, borderStyle.xmlValue);
    }

    public StyleSetter borderStyle(BorderSide side, String borderStyle) {
        if (this.border == null) {
            this.border = new Border();
        }
        return this.borderElement(side, this.border.elements.get((Object)side).updateStyle(borderStyle));
    }

    public StyleSetter borderColor(String borderColor) {
        if (this.border == null) {
            this.border = new Border();
        }
        EnumSet.of(BorderSide.TOP, BorderSide.LEFT, BorderSide.BOTTOM, BorderSide.RIGHT).forEach(side -> this.borderElement((BorderSide)((Object)side), this.border.elements.get(side).updateColor(borderColor)));
        return this;
    }

    public StyleSetter borderColor(BorderSide side, String borderColor) {
        if (this.border == null) {
            this.border = new Border();
        }
        return this.borderElement(side, this.border.elements.get((Object)side).updateColor(borderColor));
    }

    public StyleSetter protectionOption(ProtectionOption option, Boolean value) {
        if (this.protectionOptions == null) {
            this.protectionOptions = new EnumMap<ProtectionOption, Boolean>(ProtectionOption.class);
        }
        this.protectionOptions.put(option, value);
        return this;
    }

    public StyleSetter merge() {
        this.range.merge();
        return this;
    }

    public void set() {
        Alignment alignment = this.horizontalAlignment != null || this.verticalAlignment != null || this.wrapText ? new Alignment(this.horizontalAlignment, this.verticalAlignment, this.wrapText) : null;
        Font font = this.bold || this.italic || this.underlined || this.fontColor != null || this.fontName != null || this.fontSize != null ? Font.build(this.bold, this.italic, this.underlined, this.fontName, this.fontSize, this.fontColor) : Font.DEFAULT;
        Fill fill = this.fillColor == null ? Fill.NONE : Fill.fromColor(this.fillColor);
        if (this.border == null) {
            this.border = Border.NONE;
        }
        Protection protection = this.protectionOptions != null ? new Protection(this.protectionOptions) : null;
        Set<Integer> currentStyles = this.range.getStyles();
        Map<Integer, Integer> newStyles = currentStyles.stream().collect(Collectors.toMap(Function.identity(), s -> this.range.getWorksheet().getWorkbook().mergeAndCacheStyle((int)s, this.valueFormatting, font, fill, this.border, alignment, protection)));
        this.range.applyStyle(newStyles);
        if (this.alternateShadingFillColor != null) {
            this.range.shadeAlternateRows(Fill.fromColor(this.alternateShadingFillColor, false));
        }
        if (this.shadingFillColor != null) {
            this.range.shadeRows(Fill.fromColor(this.shadingFillColor, false), this.eachNRows);
        }
    }
}

