/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing;

import chrriis.common.SystemProperty;
import chrriis.common.Utils;
import chrriis.dj.nativeswing.NativeComponentProxy;
import chrriis.dj.nativeswing.NativeComponentWrapper;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.AWTEventListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.SwingUtilities;

public class NativeSwing {
    private static volatile List<NativeComponentWrapper> nativeComponentWrapperList;
    private static List<Window> windowList;
    private static volatile boolean isInitialized;
    private static volatile boolean isHeavyWeightForcerEnabled;

    static NativeComponentWrapper[] getNativeComponentWrappers() {
        if (nativeComponentWrapperList == null) {
            return new NativeComponentWrapper[0];
        }
        return nativeComponentWrapperList.toArray(new NativeComponentWrapper[0]);
    }

    static void addNativeComponentWrapper(NativeComponentWrapper nativeComponentWrapper) {
        NativeSwing.checkInitialized();
        if (nativeComponentWrapperList == null) {
            nativeComponentWrapperList = new ArrayList<NativeComponentWrapper>();
        }
        nativeComponentWrapperList.add(nativeComponentWrapper);
        if (!isHeavyWeightForcerEnabled) {
            HeavyweightForcer.activate(nativeComponentWrapper.getNativeComponent());
        }
    }

    static boolean removeNativeComponentWrapper(NativeComponentWrapper nativeComponentWrapper) {
        if (nativeComponentWrapperList == null) {
            return false;
        }
        return nativeComponentWrapperList.remove(nativeComponentWrapper);
    }

    static Window[] getWindows() {
        if (Utils.IS_JAVA_6_OR_GREATER) {
            ArrayList<Window> windowList = new ArrayList<Window>();
            Window[] windowArray = Window.getWindows();
            int n = windowArray.length;
            int n2 = 0;
            while (n2 < n) {
                Window window = windowArray[n2];
                if (!(window instanceof HeavyweightForcerWindow)) {
                    windowList.add(window);
                }
                ++n2;
            }
            return windowList.toArray(new Window[0]);
        }
        return windowList == null ? new Window[]{} : windowList.toArray(new Window[0]);
    }

    private static boolean isInitialized() {
        return isInitialized;
    }

    private static void checkInitialized() {
        if (!NativeSwing.isInitialized()) {
            throw new IllegalStateException("The Native Swing framework is not initialized! Please refer to the instructions to set it up properly.");
        }
    }

    private static void loadClipboardDebuggingProperties() {
        try {
            Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            if (!systemClipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
                return;
            }
            BufferedReader reader = new BufferedReader(new StringReader((String)systemClipboard.getData(DataFlavor.stringFlavor)));
            if ("[nativeswing debug]".equals(reader.readLine().trim().toLowerCase(Locale.ENGLISH))) {
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.length() == 0) continue;
                    int index = line.indexOf(61);
                    if (index <= 0) break;
                    String propertyName = line.substring(0, index).trim();
                    String propertyValue = line.substring(index + 1).trim();
                    if (!propertyName.startsWith("nativeswing.")) continue;
                    System.setProperty(propertyName, propertyValue);
                }
            }
            reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void initialize() {
        boolean isSunMixingEnabled;
        if (NativeSwing.isInitialized()) {
            return;
        }
        NativeSwing.loadClipboardDebuggingProperties();
        SystemProperty.SUN_AWT_NOERASEBACKGROUND.set("true");
        SystemProperty.SUN_AWT_XEMBEDSERVER.set("true");
        System.setProperty("jna.force_hw_popups", "false");
        if (SystemProperty.SUN_AWT_DISABLEMIXING.get() == null) {
            SystemProperty.SUN_AWT_DISABLEMIXING.set("true");
        }
        isHeavyWeightForcerEnabled = isSunMixingEnabled = !"true".equals(SystemProperty.SUN_AWT_DISABLEMIXING.get()) && SystemProperty.JAVA_VERSION.get().compareTo("1.6.0_12") >= 0;
        System.setProperty("nativeswing.integration.useDefaultClipping", String.valueOf(isSunMixingEnabled));
        Toolkit.getDefaultToolkit().addAWTEventListener(new NIAWTEventListener(), 65L);
        isInitialized = true;
    }

    private NativeSwing() {
    }

    private static class HeavyweightForcer
    implements HierarchyListener {
        private Component component;
        private HeavyweightForcerWindow forcer;

        private HeavyweightForcer(Component component) {
            this.component = component;
            if (component.isShowing()) {
                this.createForcer();
            }
        }

        public static void activate(Component component) {
            component.addHierarchyListener(new HeavyweightForcer(component));
        }

        private void destroyForcer() {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        HeavyweightForcer.this.destroyForcer();
                    }
                });
                return;
            }
            if (this.forcer == null) {
                return;
            }
            int count = this.forcer.getCount() - 1;
            this.forcer.setCount(count);
            if (count == 0) {
                this.forcer.dispose();
            }
            this.forcer = null;
        }

        private void createForcer() {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        HeavyweightForcer.this.createForcer();
                    }
                });
                return;
            }
            Window windowAncestor = SwingUtilities.getWindowAncestor(this.component);
            Window[] windowArray = windowAncestor.getOwnedWindows();
            int n = windowArray.length;
            int n2 = 0;
            while (n2 < n) {
                Window window = windowArray[n2];
                if (window instanceof HeavyweightForcerWindow) {
                    this.forcer = (HeavyweightForcerWindow)window;
                    break;
                }
                ++n2;
            }
            if (this.forcer == null) {
                this.forcer = new HeavyweightForcerWindow(windowAncestor);
            }
            this.forcer.setCount(this.forcer.getCount() + 1);
        }

        public void hierarchyChanged(HierarchyEvent e) {
            long changeFlags = e.getChangeFlags();
            if ((changeFlags & 2L) != 0L) {
                if (!this.component.isDisplayable()) {
                    this.component.removeHierarchyListener(this);
                    this.destroyForcer();
                }
            } else if ((changeFlags & 4L) != 0L) {
                if (this.component.isShowing()) {
                    this.createForcer();
                } else {
                    this.destroyForcer();
                }
            }
        }
    }

    private static class HeavyweightForcerWindow
    extends Window {
        private boolean isPacked;
        private int count;

        public HeavyweightForcerWindow(Window parent) {
            super(parent);
            this.pack();
            this.isPacked = true;
        }

        public boolean isVisible() {
            return this.isPacked;
        }

        public Rectangle getBounds() {
            Window owner = this.getOwner();
            return owner == null ? super.getBounds() : owner.getBounds();
        }

        public void setCount(int count) {
            this.count = count;
        }

        public int getCount() {
            return this.count;
        }
    }

    private static class NIAWTEventListener
    implements AWTEventListener {
        private List<Dialog> dialogList = new ArrayList<Dialog>();
        private volatile Set<Window> blockedWindowSet = new HashSet<Window>();

        private NIAWTEventListener() {
        }

        private static boolean isDescendant(Window window, Window ancestorWindow) {
            while (window != null) {
                if (window == ancestorWindow) {
                    return true;
                }
                window = window.getOwner();
            }
            return false;
        }

        private void computeBlockedDialogs() {
            int isApplicationModal;
            this.blockedWindowSet.clear();
            Window[] windows = NativeSwing.getWindows();
            Dialog applicationModalDialog = null;
            for (Dialog dialog : this.dialogList) {
                if (!dialog.isVisible()) continue;
                isApplicationModal = 0;
                if (Utils.IS_JAVA_6_OR_GREATER) {
                    switch (dialog.getModalityType()) {
                        case APPLICATION_MODAL: 
                        case TOOLKIT_MODAL: {
                            isApplicationModal = 1;
                        }
                    }
                } else if (dialog.isModal()) {
                    isApplicationModal = 1;
                }
                if (isApplicationModal == 0) continue;
                if (applicationModalDialog != null) {
                    if (!NIAWTEventListener.isDescendant(dialog, applicationModalDialog)) continue;
                    applicationModalDialog = dialog;
                    continue;
                }
                applicationModalDialog = dialog;
            }
            if (applicationModalDialog != null) {
                Window[] windowArray = windows;
                isApplicationModal = windows.length;
                int n = 0;
                while (n < isApplicationModal) {
                    Window window = windowArray[n];
                    if (window != applicationModalDialog && !NIAWTEventListener.isDescendant(window, applicationModalDialog)) {
                        boolean isIncluded = true;
                        if (Utils.IS_JAVA_6_OR_GREATER) {
                            switch (window.getModalExclusionType()) {
                                case APPLICATION_EXCLUDE: 
                                case TOOLKIT_EXCLUDE: {
                                    isIncluded = false;
                                }
                            }
                        }
                        if (isIncluded) {
                            this.blockedWindowSet.add(window);
                        }
                    }
                    ++n;
                }
            }
            if (Utils.IS_JAVA_6_OR_GREATER) {
                int i = this.dialogList.size() - 1;
                while (i >= 0) {
                    Dialog dialog = this.dialogList.get(i);
                    if (dialog.isVisible() && !this.blockedWindowSet.contains(dialog)) {
                        switch (dialog.getModalityType()) {
                            case DOCUMENT_MODAL: {
                                Window hierarchyOwnerWindow;
                                Window owner = hierarchyOwnerWindow = dialog.getOwner();
                                while (owner != null) {
                                    hierarchyOwnerWindow = owner;
                                    owner = owner.getOwner();
                                }
                                if (hierarchyOwnerWindow == null) break;
                                Window[] windowArray = windows;
                                int n = windows.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Window window = windowArray[n2];
                                    if (window != dialog && !NIAWTEventListener.isDescendant(window, dialog) && (window == hierarchyOwnerWindow || NIAWTEventListener.isDescendant(window, hierarchyOwnerWindow))) {
                                        this.blockedWindowSet.add(window);
                                    }
                                    ++n2;
                                }
                                break;
                            }
                        }
                    }
                    --i;
                }
            }
        }

        private void adjustNativeComponents() {
            if (nativeComponentWrapperList == null) {
                return;
            }
            int i = nativeComponentWrapperList.size() - 1;
            while (i >= 0) {
                Component component;
                NativeComponentWrapper nativeComponentWrapper = (NativeComponentWrapper)nativeComponentWrapperList.get(i);
                Component c = component = nativeComponentWrapper.getNativeComponent();
                NativeComponentProxy componentProxy = nativeComponentWrapper.getNativeComponentProxy();
                if (componentProxy != null) {
                    c = componentProxy;
                }
                Window embedderWindowAncestor = SwingUtilities.getWindowAncestor(c);
                boolean isBlocked = this.blockedWindowSet.contains(embedderWindowAncestor);
                boolean isShowing = c.isShowing();
                nativeComponentWrapper.setNativeComponentEnabled(!isBlocked && isShowing);
                if (!Utils.IS_MAC && !isShowing && component.hasFocus()) {
                    component.transferFocus();
                }
                --i;
            }
        }

        public void eventDispatched(AWTEvent e) {
            boolean isAdjusting = false;
            switch (e.getID()) {
                case 102: 
                case 103: {
                    isAdjusting = true;
                }
            }
            if (!Utils.IS_JAVA_6_OR_GREATER && e.getSource() instanceof Window) {
                if (windowList == null) {
                    windowList = new ArrayList();
                }
                switch (e.getID()) {
                    case 102: 
                    case 200: {
                        Window w = (Window)e.getSource();
                        windowList.remove(w);
                        windowList.add(w);
                        break;
                    }
                    case 103: 
                    case 202: {
                        windowList.remove(e.getSource());
                    }
                }
            }
            if (e.getSource() instanceof Dialog) {
                switch (e.getID()) {
                    case 102: 
                    case 200: {
                        Dialog d = (Dialog)e.getSource();
                        this.dialogList.remove(d);
                        this.dialogList.add(d);
                        break;
                    }
                    case 103: 
                    case 202: {
                        this.dialogList.remove(e.getSource());
                    }
                }
                switch (e.getID()) {
                    case 102: 
                    case 103: 
                    case 200: 
                    case 202: {
                        this.computeBlockedDialogs();
                        isAdjusting = true;
                    }
                }
            }
            if (isAdjusting) {
                this.adjustNativeComponents();
            }
        }
    }
}

