/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl.components;

import chrriis.dj.nativeswing.NSOption;
import chrriis.dj.nativeswing.swtimpl.components.JWebBrowser;
import chrriis.dj.nativeswing.swtimpl.components.JWebBrowserWindow;
import chrriis.dj.nativeswing.swtimpl.components.NativeWebBrowser;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserAdapter;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserDecorator;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserEvent;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserNavigationEvent;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserWindowFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class DefaultWebBrowserDecorator
extends WebBrowserDecorator {
    private final ResourceBundle RESOURCES;
    private boolean isViewMenuVisible;
    private static final Border STATUS_BAR_BORDER = new AbstractBorder(){

        public Insets getBorderInsets(Component c) {
            return new Insets(1, 1, 1, 1);
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Color background = c.getBackground();
            g.setColor(background == null ? Color.LIGHT_GRAY : background.darker());
            g.drawLine(0, 0, width - 1, 0);
            g.drawLine(width - 1, 0, width - 1, height - 1);
            g.drawLine(0, height - 1, width - 1, height - 1);
            g.drawLine(0, 0, 0, height - 1);
        }
    };
    private WebBrowserMenuBar menuBar;
    private WebBrowserButtonBar buttonBar;
    private WebBrowserLocationBar locationBar;
    private WebBrowserStatusBar statusBar;
    private JWebBrowser webBrowser;
    private NativeWebBrowser nativeWebBrowser;
    private JPanel menuToolAndLocationBarPanel;
    private JPanel nativeWebBrowserBorderContainerPane;

    private void updateNavigationButtons() {
        if (this.isViewMenuVisible || this.isButtonBarVisible()) {
            boolean isForwardEnabled;
            boolean isBackEnabled;
            boolean bl = isBackEnabled = this.nativeWebBrowser.isNativePeerInitialized() ? this.nativeWebBrowser.isBackNavigationEnabled() : false;
            if (this.buttonBar != null) {
                this.buttonBar.getBackButton().setEnabled(isBackEnabled);
            }
            this.menuBar.backMenuItem.setEnabled(isBackEnabled);
            boolean bl2 = isForwardEnabled = this.nativeWebBrowser.isNativePeerInitialized() ? this.nativeWebBrowser.isForwardNavigationEnabled() : false;
            if (this.buttonBar != null) {
                this.buttonBar.getForwardButton().setEnabled(isForwardEnabled);
            }
            this.menuBar.forwardMenuItem.setEnabled(isForwardEnabled);
        }
    }

    protected void addButtonBarComponents(WebBrowserButtonBar buttonBar) {
        buttonBar.add(buttonBar.getBackButton());
        buttonBar.add(buttonBar.getForwardButton());
        buttonBar.add(buttonBar.getReloadButton());
        buttonBar.add(buttonBar.getStopButton());
    }

    protected void addLocationBarComponents(WebBrowserLocationBar locationBar) {
        JPanel locationToolBarInnerPanel = new JPanel(new GridBagLayout());
        locationToolBarInnerPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
        locationToolBarInnerPanel.setOpaque(false);
        locationToolBarInnerPanel.add((Component)locationBar.getLocationField(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        locationBar.add(locationToolBarInnerPanel);
        locationBar.add(locationBar.getGoButton());
    }

    protected void addMenuBarComponents(WebBrowserMenuBar menuBar) {
        menuBar.add(menuBar.getFileMenu());
        menuBar.add(menuBar.getViewMenu());
    }

    public DefaultWebBrowserDecorator(JWebBrowser webBrowser, Component renderingComponent) {
        String className = JWebBrowser.class.getName();
        this.RESOURCES = ResourceBundle.getBundle(String.valueOf(className.substring(0, className.lastIndexOf(46)).replace('.', '/')) + "/resource/WebBrowser");
        this.webBrowser = webBrowser;
        this.nativeWebBrowser = (NativeWebBrowser)webBrowser.getNativeComponent();
        this.menuToolAndLocationBarPanel = new JPanel(new BorderLayout());
        this.menuBar = new WebBrowserMenuBar();
        this.menuToolAndLocationBarPanel.add((Component)this.menuBar, "North");
        this.add((Component)this.menuToolAndLocationBarPanel, "North");
        this.nativeWebBrowserBorderContainerPane = new JPanel(new BorderLayout());
        this.nativeWebBrowserBorderContainerPane.add(renderingComponent, "Center");
        this.add((Component)this.nativeWebBrowserBorderContainerPane, "Center");
        this.nativeWebBrowser.addWebBrowserListener(new NWebBrowserListener());
        this.adjustBorder();
    }

    protected JWebBrowser getWebBrowser() {
        return this.webBrowser;
    }

    private Icon createIcon(String resourceKey) {
        String value = this.RESOURCES.getString(resourceKey);
        return value.length() == 0 ? null : new ImageIcon(JWebBrowser.class.getResource(value));
    }

    private void adjustBorder() {
        this.nativeWebBrowserBorderContainerPane.setBorder(this.getInnerAreaBorder());
    }

    protected Border getInnerAreaBorder() {
        Border border = this.isMenuBarVisible() || this.isButtonBarVisible() || this.isLocationBarVisible() || this.isStatusBarVisible() ? BorderFactory.createBevelBorder(1) : null;
        return border;
    }

    public void setStatusBarVisible(boolean isStatusBarVisible) {
        if (isStatusBarVisible == this.isStatusBarVisible()) {
            return;
        }
        if (isStatusBarVisible) {
            this.statusBar = new WebBrowserStatusBar();
            this.webBrowser.add((Component)this.statusBar, "South");
        } else {
            this.webBrowser.remove(this.statusBar);
            this.statusBar = null;
        }
        this.webBrowser.revalidate();
        this.webBrowser.repaint();
        this.menuBar.statusBarCheckBoxMenuItem.setSelected(isStatusBarVisible);
        this.adjustBorder();
    }

    public boolean isStatusBarVisible() {
        return this.statusBar != null;
    }

    public void setMenuBarVisible(boolean isMenuBarVisible) {
        if (isMenuBarVisible == this.isMenuBarVisible()) {
            return;
        }
        this.menuBar.setVisible(isMenuBarVisible);
        this.adjustBorder();
    }

    public boolean isMenuBarVisible() {
        return this.menuBar.isVisible();
    }

    public void setButtonBarVisible(boolean isButtonBarVisible) {
        if (isButtonBarVisible == this.isButtonBarVisible()) {
            return;
        }
        if (isButtonBarVisible) {
            this.buttonBar = new WebBrowserButtonBar();
            this.menuToolAndLocationBarPanel.add((Component)this.buttonBar, "West");
        } else {
            this.menuToolAndLocationBarPanel.remove(this.buttonBar);
            this.buttonBar = null;
        }
        this.menuToolAndLocationBarPanel.revalidate();
        this.menuToolAndLocationBarPanel.repaint();
        this.menuBar.buttonBarCheckBoxMenuItem.setSelected(isButtonBarVisible);
        this.adjustBorder();
        if (isButtonBarVisible && !this.isViewMenuVisible) {
            this.updateNavigationButtons();
        }
    }

    public boolean isButtonBarVisible() {
        return this.buttonBar != null;
    }

    public void setLocationBarVisible(boolean isLocationBarVisible) {
        if (isLocationBarVisible == this.isLocationBarVisible()) {
            return;
        }
        if (isLocationBarVisible) {
            this.locationBar = new WebBrowserLocationBar();
            this.menuToolAndLocationBarPanel.add((Component)this.locationBar, "Center");
        } else {
            this.menuToolAndLocationBarPanel.remove(this.locationBar);
            this.locationBar = null;
        }
        this.menuToolAndLocationBarPanel.revalidate();
        this.menuToolAndLocationBarPanel.repaint();
        this.menuBar.locationBarCheckBoxMenuItem.setSelected(isLocationBarVisible);
        this.adjustBorder();
    }

    public boolean isLocationBarVisible() {
        return this.locationBar != null;
    }

    public void configureForWebBrowserWindow(final JWebBrowserWindow webBrowserWindow) {
        JMenu fileMenu = this.menuBar.fileMenu;
        fileMenu.addSeparator();
        JMenuItem fileCloseMenuItem = new JMenuItem(this.RESOURCES.getString("FileCloseMenu"));
        fileCloseMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                webBrowserWindow.dispose();
            }
        });
        fileMenu.add(fileCloseMenuItem);
        this.webBrowser.addWebBrowserListener(new WebBrowserAdapter(){

            public void titleChanged(WebBrowserEvent e) {
                DefaultWebBrowserDecorator.this.setWebBrowserWindowTitle(webBrowserWindow, e.getWebBrowser().getPageTitle());
            }
        });
        this.setWebBrowserWindowIcon(webBrowserWindow);
    }

    protected void setWebBrowserWindowTitle(JWebBrowserWindow webBrowserWindow, String pageTitle) {
        webBrowserWindow.setTitle(new MessageFormat(this.RESOURCES.getString("BrowserTitle")).format(new Object[]{pageTitle}));
    }

    protected void setWebBrowserWindowIcon(JWebBrowserWindow webBrowserWindow) {
        String value = this.RESOURCES.getString("BrowserIcon");
        if (value.length() > 0) {
            webBrowserWindow.setIconImage(new ImageIcon(JWebBrowserWindow.class.getResource(value)).getImage());
        }
    }

    private static class NWebBrowserListener
    extends WebBrowserAdapter {
        private NWebBrowserListener() {
        }

        public void locationChanged(WebBrowserNavigationEvent e) {
            JWebBrowser webBrowser = e.getWebBrowser();
            this.updateStopButton(webBrowser, false);
            DefaultWebBrowserDecorator decorator = (DefaultWebBrowserDecorator)webBrowser.getWebBrowserDecorator();
            if (e.isTopFrame() && decorator.locationBar != null) {
                decorator.locationBar.updateLocation();
            }
            decorator.updateNavigationButtons();
        }

        public void locationChanging(WebBrowserNavigationEvent e) {
            JWebBrowser webBrowser = e.getWebBrowser();
            DefaultWebBrowserDecorator decorator = (DefaultWebBrowserDecorator)webBrowser.getWebBrowserDecorator();
            if (e.isTopFrame() && decorator.locationBar != null) {
                decorator.locationBar.updateLocation(e.getNewResourceLocation());
            }
            this.updateStopButton(webBrowser, true);
        }

        public void locationChangeCanceled(WebBrowserNavigationEvent e) {
            JWebBrowser webBrowser = e.getWebBrowser();
            this.updateStopButton(webBrowser, false);
            DefaultWebBrowserDecorator decorator = (DefaultWebBrowserDecorator)webBrowser.getWebBrowserDecorator();
            if (e.isTopFrame() && decorator.locationBar != null) {
                decorator.locationBar.updateLocation();
            }
            decorator.updateNavigationButtons();
        }

        public void statusChanged(WebBrowserEvent e) {
            JWebBrowser webBrowser = e.getWebBrowser();
            DefaultWebBrowserDecorator decorator = (DefaultWebBrowserDecorator)webBrowser.getWebBrowserDecorator();
            if (decorator.statusBar != null) {
                decorator.statusBar.updateStatus();
            }
        }

        public void loadingProgressChanged(WebBrowserEvent e) {
            JWebBrowser webBrowser = e.getWebBrowser();
            DefaultWebBrowserDecorator decorator = (DefaultWebBrowserDecorator)webBrowser.getWebBrowserDecorator();
            if (decorator.statusBar != null) {
                decorator.statusBar.updateProgressValue();
            }
            this.updateStopButton(webBrowser, false);
        }

        private void updateStopButton(JWebBrowser webBrowser, boolean isForcedOn) {
            boolean isStopEnabled = isForcedOn || webBrowser.getLoadingProgress() != 100;
            DefaultWebBrowserDecorator decorator = (DefaultWebBrowserDecorator)webBrowser.getWebBrowserDecorator();
            if (decorator.buttonBar != null) {
                decorator.buttonBar.getStopButton().setEnabled(isStopEnabled);
            }
            decorator.menuBar.stopMenuItem.setEnabled(isStopEnabled);
        }
    }

    public class WebBrowserButtonBar
    extends JToolBar {
        private JButton backButton;
        private JButton forwardButton;
        private JButton reloadButton;
        private JButton stopButton;

        WebBrowserButtonBar() {
            this.setFloatable(false);
            this.backButton = new JButton(DefaultWebBrowserDecorator.this.createIcon("BackIcon"));
            this.backButton.setEnabled(DefaultWebBrowserDecorator.this.menuBar.backMenuItem.isEnabled());
            this.backButton.setToolTipText(DefaultWebBrowserDecorator.this.RESOURCES.getString("BackText"));
            this.backButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DefaultWebBrowserDecorator.this.webBrowser.navigateBack();
                    DefaultWebBrowserDecorator.this.nativeWebBrowser.requestFocus();
                }
            });
            this.forwardButton = new JButton(DefaultWebBrowserDecorator.this.createIcon("ForwardIcon"));
            this.forwardButton.setToolTipText(DefaultWebBrowserDecorator.this.RESOURCES.getString("ForwardText"));
            this.forwardButton.setEnabled(DefaultWebBrowserDecorator.this.menuBar.forwardMenuItem.isEnabled());
            this.forwardButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DefaultWebBrowserDecorator.this.webBrowser.navigateForward();
                    DefaultWebBrowserDecorator.this.nativeWebBrowser.requestFocus();
                }
            });
            this.reloadButton = new JButton(DefaultWebBrowserDecorator.this.createIcon("ReloadIcon"));
            this.reloadButton.setToolTipText(DefaultWebBrowserDecorator.this.RESOURCES.getString("ReloadText"));
            this.reloadButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DefaultWebBrowserDecorator.this.webBrowser.reloadPage();
                    DefaultWebBrowserDecorator.this.nativeWebBrowser.requestFocus();
                }
            });
            this.stopButton = new JButton(DefaultWebBrowserDecorator.this.createIcon("StopIcon"));
            this.stopButton.setToolTipText(DefaultWebBrowserDecorator.this.RESOURCES.getString("StopText"));
            this.stopButton.setEnabled(DefaultWebBrowserDecorator.this.menuBar.stopMenuItem.isEnabled());
            this.stopButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DefaultWebBrowserDecorator.this.webBrowser.stopLoading();
                }
            });
            DefaultWebBrowserDecorator.this.addButtonBarComponents(this);
            this.add(Box.createHorizontalStrut(2));
        }

        public JButton getBackButton() {
            return this.backButton;
        }

        public JButton getForwardButton() {
            return this.forwardButton;
        }

        public JButton getReloadButton() {
            return this.reloadButton;
        }

        public JButton getStopButton() {
            return this.stopButton;
        }
    }

    public class WebBrowserLocationBar
    extends JToolBar {
        private JTextField locationField;
        private JButton goButton;

        WebBrowserLocationBar() {
            this.setLayout(new BoxLayout(this, 2));
            this.setFloatable(false);
            this.locationField = new JTextField();
            this.locationField.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 27) {
                        WebBrowserLocationBar.this.updateLocation();
                        WebBrowserLocationBar.this.locationField.selectAll();
                    }
                }
            });
            ActionListener goActionListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DefaultWebBrowserDecorator.this.webBrowser.navigate(WebBrowserLocationBar.this.locationField.getText());
                    DefaultWebBrowserDecorator.this.nativeWebBrowser.requestFocus();
                }
            };
            this.locationField.addActionListener(goActionListener);
            this.updateLocation();
            this.goButton = new JButton(DefaultWebBrowserDecorator.this.createIcon("GoIcon"));
            this.goButton.setToolTipText(DefaultWebBrowserDecorator.this.RESOURCES.getString("GoText"));
            this.goButton.addActionListener(goActionListener);
            DefaultWebBrowserDecorator.this.addLocationBarComponents(this);
        }

        public JTextField getLocationField() {
            return this.locationField;
        }

        public JButton getGoButton() {
            return this.goButton;
        }

        void updateLocation(String location) {
            this.locationField.setText(location);
        }

        void updateLocation() {
            this.locationField.setText(DefaultWebBrowserDecorator.this.nativeWebBrowser.isNativePeerInitialized() ? DefaultWebBrowserDecorator.this.nativeWebBrowser.getResourceLocation() : "");
        }
    }

    public class WebBrowserMenuBar
    extends JMenuBar {
        private JMenu fileMenu;
        private JMenu viewMenu;
        private JCheckBoxMenuItem buttonBarCheckBoxMenuItem;
        private JCheckBoxMenuItem locationBarCheckBoxMenuItem;
        private JCheckBoxMenuItem statusBarCheckBoxMenuItem;
        private JMenuItem backMenuItem;
        private JMenuItem forwardMenuItem;
        private JMenuItem reloadMenuItem;
        private JMenuItem stopMenuItem;

        WebBrowserMenuBar() {
            this.fileMenu = new JMenu(DefaultWebBrowserDecorator.this.RESOURCES.getString("FileMenu"));
            JMenuItem fileNewWindowMenuItem = new JMenuItem(DefaultWebBrowserDecorator.this.RESOURCES.getString("FileNewWindowMenu"));
            fileNewWindowMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JWebBrowser newWebBrowser = ((NativeWebBrowser)DefaultWebBrowserDecorator.this.webBrowser.getNativeComponent()).isXULRunnerRuntime() ? new JWebBrowser(JWebBrowser.useXULRunnerRuntime()) : new JWebBrowser(new NSOption[0]);
                    JWebBrowser.copyAppearance(DefaultWebBrowserDecorator.this.webBrowser, newWebBrowser);
                    JWebBrowser.copyContent(DefaultWebBrowserDecorator.this.webBrowser, newWebBrowser);
                    JWebBrowserWindow webBrowserWindow = WebBrowserWindowFactory.create(newWebBrowser);
                    webBrowserWindow.setVisible(true);
                }
            });
            this.fileMenu.add(fileNewWindowMenuItem);
            JMenuItem fileOpenLocationMenuItem = new JMenuItem(DefaultWebBrowserDecorator.this.RESOURCES.getString("FileOpenLocationMenu"));
            fileOpenLocationMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String path = JOptionPane.showInputDialog(DefaultWebBrowserDecorator.this.webBrowser, DefaultWebBrowserDecorator.this.RESOURCES.getString("FileOpenLocationDialogMessage"), DefaultWebBrowserDecorator.this.RESOURCES.getString("FileOpenLocationDialogTitle"), 3);
                    if (path != null) {
                        DefaultWebBrowserDecorator.this.webBrowser.navigate(path);
                    }
                }
            });
            this.fileMenu.add(fileOpenLocationMenuItem);
            JMenuItem fileOpenFileMenuItem = new JMenuItem(DefaultWebBrowserDecorator.this.RESOURCES.getString("FileOpenFileMenu"));
            fileOpenFileMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFileChooser fileChooser = new JFileChooser();
                    if (fileChooser.showOpenDialog(DefaultWebBrowserDecorator.this.webBrowser) == 0) {
                        try {
                            DefaultWebBrowserDecorator.this.webBrowser.navigate(fileChooser.getSelectedFile().getAbsolutePath());
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            });
            this.fileMenu.add(fileOpenFileMenuItem);
            this.viewMenu = new JMenu(DefaultWebBrowserDecorator.this.RESOURCES.getString("ViewMenu"));
            JMenu viewToolbarsMenu = new JMenu(DefaultWebBrowserDecorator.this.RESOURCES.getString("ViewToolbarsMenu"));
            this.buttonBarCheckBoxMenuItem = new JCheckBoxMenuItem(DefaultWebBrowserDecorator.this.RESOURCES.getString("ViewToolbarsButtonBarMenu"));
            this.buttonBarCheckBoxMenuItem.setSelected(DefaultWebBrowserDecorator.this.isButtonBarVisible());
            this.buttonBarCheckBoxMenuItem.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    DefaultWebBrowserDecorator.this.setButtonBarVisible(e.getStateChange() == 1);
                }
            });
            viewToolbarsMenu.add(this.buttonBarCheckBoxMenuItem);
            this.locationBarCheckBoxMenuItem = new JCheckBoxMenuItem(DefaultWebBrowserDecorator.this.RESOURCES.getString("ViewToolbarsLocationBarMenu"));
            this.locationBarCheckBoxMenuItem.setSelected(DefaultWebBrowserDecorator.this.isLocationBarVisible());
            this.locationBarCheckBoxMenuItem.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    DefaultWebBrowserDecorator.this.setLocationBarVisible(e.getStateChange() == 1);
                }
            });
            viewToolbarsMenu.add(this.locationBarCheckBoxMenuItem);
            this.viewMenu.add(viewToolbarsMenu);
            this.statusBarCheckBoxMenuItem = new JCheckBoxMenuItem(DefaultWebBrowserDecorator.this.RESOURCES.getString("ViewStatusBarMenu"));
            this.statusBarCheckBoxMenuItem.setSelected(DefaultWebBrowserDecorator.this.isStatusBarVisible());
            this.statusBarCheckBoxMenuItem.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    DefaultWebBrowserDecorator.this.setStatusBarVisible(e.getStateChange() == 1);
                }
            });
            this.viewMenu.add(this.statusBarCheckBoxMenuItem);
            this.viewMenu.addSeparator();
            this.backMenuItem = new JMenuItem(DefaultWebBrowserDecorator.this.RESOURCES.getString("ViewMenuBack"), DefaultWebBrowserDecorator.this.createIcon("ViewMenuBackIcon"));
            this.backMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DefaultWebBrowserDecorator.this.webBrowser.navigateBack();
                    DefaultWebBrowserDecorator.this.nativeWebBrowser.requestFocus();
                }
            });
            this.backMenuItem.setEnabled(false);
            this.viewMenu.add(this.backMenuItem);
            this.forwardMenuItem = new JMenuItem(DefaultWebBrowserDecorator.this.RESOURCES.getString("ViewMenuForward"), DefaultWebBrowserDecorator.this.createIcon("ViewMenuForwardIcon"));
            this.forwardMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DefaultWebBrowserDecorator.this.webBrowser.navigateForward();
                    DefaultWebBrowserDecorator.this.nativeWebBrowser.requestFocus();
                }
            });
            this.forwardMenuItem.setEnabled(false);
            this.viewMenu.add(this.forwardMenuItem);
            this.reloadMenuItem = new JMenuItem(DefaultWebBrowserDecorator.this.RESOURCES.getString("ViewMenuReload"), DefaultWebBrowserDecorator.this.createIcon("ViewMenuReloadIcon"));
            this.reloadMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DefaultWebBrowserDecorator.this.webBrowser.reloadPage();
                    DefaultWebBrowserDecorator.this.nativeWebBrowser.requestFocus();
                }
            });
            this.viewMenu.add(this.reloadMenuItem);
            this.stopMenuItem = new JMenuItem(DefaultWebBrowserDecorator.this.RESOURCES.getString("ViewMenuStop"), DefaultWebBrowserDecorator.this.createIcon("ViewMenuStopIcon"));
            this.stopMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DefaultWebBrowserDecorator.this.webBrowser.stopLoading();
                }
            });
            this.stopMenuItem.setEnabled(false);
            this.viewMenu.add(this.stopMenuItem);
            this.viewMenu.getPopupMenu().addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuCanceled(PopupMenuEvent e) {
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    DefaultWebBrowserDecorator.this.isViewMenuVisible = false;
                }

                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    DefaultWebBrowserDecorator.this.isViewMenuVisible = true;
                    if (!DefaultWebBrowserDecorator.this.isButtonBarVisible()) {
                        DefaultWebBrowserDecorator.this.updateNavigationButtons();
                    }
                }
            });
            DefaultWebBrowserDecorator.this.addMenuBarComponents(this);
        }

        public JMenu getFileMenu() {
            return this.fileMenu;
        }

        public JMenu getViewMenu() {
            return this.viewMenu;
        }
    }

    private class WebBrowserStatusBar
    extends JPanel {
        private JLabel statusLabel;
        private JProgressBar progressBar;

        public WebBrowserStatusBar() {
            super(new BorderLayout());
            this.setBorder(BorderFactory.createCompoundBorder(STATUS_BAR_BORDER, BorderFactory.createEmptyBorder(2, 2, 2, 2)));
            this.statusLabel = new JLabel();
            this.updateStatus();
            this.add((Component)this.statusLabel, "Center");
            this.progressBar = new JProgressBar(){

                public Dimension getPreferredSize() {
                    return new Dimension(this.getParent().getWidth() / 10, 0);
                }
            };
            this.updateProgressValue();
            this.add((Component)this.progressBar, "East");
        }

        public void updateProgressValue() {
            int loadingProgress = DefaultWebBrowserDecorator.this.nativeWebBrowser.isNativePeerInitialized() ? DefaultWebBrowserDecorator.this.nativeWebBrowser.getLoadingProgress() : 100;
            this.progressBar.setValue(loadingProgress);
            this.progressBar.setVisible(loadingProgress < 100);
        }

        public void updateStatus() {
            String status = DefaultWebBrowserDecorator.this.nativeWebBrowser.isNativePeerInitialized() ? DefaultWebBrowserDecorator.this.nativeWebBrowser.getStatusText() : "";
            this.statusLabel.setText(status.length() == 0 ? " " : status);
        }
    }
}

