/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl.components;

import chrriis.dj.nativeswing.swtimpl.ControlCommandMessage;
import chrriis.dj.nativeswing.swtimpl.components.ModalDialogUtils;
import java.awt.Component;
import java.io.Serializable;
import java.util.HashMap;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class JFileDialog {
    private Data data = new Data();

    public void show(Component component) {
        final NativeFileDialogContainer nativeComponent = new NativeFileDialogContainer();
        ModalDialogUtils.showModalDialog(component, nativeComponent, new Runnable(){

            public void run() {
                JFileDialog.this.data = nativeComponent.open(JFileDialog.this.data);
            }
        });
    }

    public String getSelectedFileName() {
        String[] selectedFileNames = this.getSelectedFileNames();
        return selectedFileNames.length >= 1 ? selectedFileNames[0] : null;
    }

    public String[] getSelectedFileNames() {
        if (this.data.selectedFileNames == null) {
            return new String[0];
        }
        String[] selectedFileNames = new String[this.data.selectedFileNames.length];
        System.arraycopy(this.data.selectedFileNames, 0, selectedFileNames, 0, selectedFileNames.length);
        return selectedFileNames;
    }

    public void setSelectedFileName(String selectedFileName) {
        this.data.selectedFileNames = new String[]{selectedFileName};
    }

    public SelectionMode getSelectionMode() {
        return this.data.isMulti ? SelectionMode.MULTIPLE_SELECTION : SelectionMode.SINGLE_SELECTION;
    }

    public void setSelectionMode(SelectionMode selectionMode) {
        this.data.isMulti = selectionMode == SelectionMode.MULTIPLE_SELECTION;
    }

    public DialogType getDialogType() {
        return this.data.isSave ? DialogType.SAVE_DIALOG_TYPE : DialogType.OPEN_DIALOG_TYPE;
    }

    public void setDialogType(DialogType dialogType) {
        this.data.isSave = dialogType == DialogType.SAVE_DIALOG_TYPE;
    }

    public void setConfirmedOverwrite(boolean isConfirmedOverwrite) {
        this.data.isConfirmedOverwrite = isConfirmedOverwrite;
    }

    public boolean isConfirmedOverwrite() {
        return this.data.isConfirmedOverwrite;
    }

    public String getParentDirectory() {
        return this.data.parentDirectory;
    }

    public void setParentDirectory(String parentDirectory) {
        this.data.parentDirectory = parentDirectory;
    }

    public void setExtensionFilters(String[] extensionFilters, String[] extensionFiltersNames, int selectedExtensionFilterIndex) {
        if (extensionFiltersNames != null && (extensionFilters == null || extensionFilters.length != extensionFiltersNames.length)) {
            throw new IllegalArgumentException("Filter descriptions can only be defined when filter extensions are defined, and the two arrays must have the same size!");
        }
        this.data.extensionFilters = extensionFilters;
        this.data.extensionFiltersNames = extensionFiltersNames;
        this.data.selectedExtensionFilterIndex = selectedExtensionFilterIndex;
    }

    public String[] getExtensionFilters() {
        return this.data.extensionFilters;
    }

    public String[] getExtensionFiltersNames() {
        return this.data.extensionFiltersNames;
    }

    public int getSelectedExtensionFilterIndex() {
        return this.data.selectedExtensionFilterIndex;
    }

    public void setTitle(String title) {
        this.data.title = title;
    }

    public String getTitle() {
        return this.data.title;
    }

    private static class Data
    implements Serializable {
        public String title;
        public boolean isSave;
        public boolean isMulti;
        public boolean isConfirmedOverwrite;
        public String[] selectedFileNames;
        public String[] extensionFiltersNames;
        public String[] extensionFilters;
        public int selectedExtensionFilterIndex;
        public String parentDirectory;

        private Data() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DialogType {
        OPEN_DIALOG_TYPE,
        SAVE_DIALOG_TYPE;

    }

    private static class NativeFileDialogContainer
    extends ModalDialogUtils.NativeModalComponent {
        private NativeFileDialogContainer() {
        }

        protected static Control createControl(Shell shell, Object[] parameters) {
            return new Composite(shell, 0);
        }

        protected Component createEmbeddableComponent() {
            return super.createEmbeddableComponent(new HashMap<Object, Object>());
        }

        public Data open(Data data) {
            return (Data)new CMN_openFileDialog().syncExec(this, data);
        }

        private static class CMN_openFileDialog
        extends ControlCommandMessage {
            private CMN_openFileDialog() {
            }

            public Object run(Object[] args) {
                Data data = (Data)args[0];
                Control control = this.getControl();
                if (control.isDisposed()) {
                    return data;
                }
                int style = 0;
                if (data.isSave) {
                    style |= 0x2000;
                }
                if (data.isMulti) {
                    style |= 2;
                }
                FileDialog fileDialog = new FileDialog(control.getShell(), style);
                if (data.title != null) {
                    fileDialog.setText(data.title);
                }
                fileDialog.setOverwrite(data.isConfirmedOverwrite);
                if (data.parentDirectory != null) {
                    fileDialog.setFilterPath(data.parentDirectory);
                }
                if (data.selectedFileNames != null && data.selectedFileNames.length == 1) {
                    fileDialog.setFileName(data.selectedFileNames[0]);
                }
                if (data.extensionFilters != null) {
                    fileDialog.setFilterExtensions(data.extensionFilters);
                    fileDialog.setFilterNames(data.extensionFiltersNames);
                    fileDialog.setFilterIndex(data.selectedExtensionFilterIndex);
                }
                fileDialog.open();
                data.selectedFileNames = fileDialog.getFileNames();
                data.selectedExtensionFilterIndex = fileDialog.getFilterIndex();
                data.parentDirectory = fileDialog.getFilterPath();
                if (data.parentDirectory.length() == 0) {
                    data.parentDirectory = null;
                }
                return data;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SelectionMode {
        SINGLE_SELECTION,
        MULTIPLE_SELECTION;

    }
}

