/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl.components;

import chrriis.dj.nativeswing.swtimpl.WebBrowserObject;
import chrriis.dj.nativeswing.swtimpl.components.JVLCPlayer;

public class VLCAudio {
    private JVLCPlayer vlcPlayer;
    private WebBrowserObject webBrowserObject;

    VLCAudio(JVLCPlayer vlcPlayer) {
        this.vlcPlayer = vlcPlayer;
        this.webBrowserObject = vlcPlayer.getWebBrowserObject();
    }

    public void setMute(boolean isMute) {
        this.webBrowserObject.setObjectProperty("audio.mute", isMute);
        this.vlcPlayer.adjustVolumePanel();
    }

    public boolean isMute() {
        return Boolean.TRUE.equals(this.webBrowserObject.getObjectProperty("audio.mute"));
    }

    public void setVolume(int volume) {
        if (volume < 0 || volume > 100) {
            throw new IllegalArgumentException("The volume must be between 0 and 100");
        }
        this.webBrowserObject.setObjectProperty("audio.volume", Math.round((double)volume * 1.99 + 1.0));
        this.vlcPlayer.adjustVolumePanel();
    }

    public int getVolume() {
        Object value = this.webBrowserObject.getObjectProperty("audio.volume");
        return value == null ? -1 : Math.max(0, (int)Math.round((double)(((Number)value).intValue() - 1) / 1.99));
    }

    public void setTrack(int track) {
        this.webBrowserObject.setObjectProperty("audio.track", track);
    }

    public int getTrack() {
        Object value = this.webBrowserObject.getObjectProperty("audio.track");
        return value == null ? -1 : ((Number)value).intValue();
    }

    public void setChannel(VLCChannel channel) {
        int value;
        switch (channel) {
            case STEREO: {
                value = 1;
                break;
            }
            case REVERSE_STEREO: {
                value = 2;
                break;
            }
            case LEFT: {
                value = 3;
                break;
            }
            case RIGHT: {
                value = 4;
                break;
            }
            case DOLBY: {
                value = 5;
                break;
            }
            default: {
                throw new IllegalArgumentException("The channel value is invalid!");
            }
        }
        this.webBrowserObject.setObjectProperty("audio.channel", value);
    }

    public VLCChannel getChannel() {
        Object value = this.webBrowserObject.getObjectProperty("audio.channel");
        if (value == null) {
            return null;
        }
        switch (((Number)value).intValue()) {
            case 1: {
                return VLCChannel.STEREO;
            }
            case 2: {
                return VLCChannel.REVERSE_STEREO;
            }
            case 3: {
                return VLCChannel.LEFT;
            }
            case 4: {
                return VLCChannel.RIGHT;
            }
            case 5: {
                return VLCChannel.DOLBY;
            }
        }
        return null;
    }

    public void toggleMute() {
        this.webBrowserObject.invokeObjectFunction("audio.toggleMute", new Object[0]);
        this.vlcPlayer.adjustVolumePanel();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VLCChannel {
        STEREO,
        REVERSE_STEREO,
        LEFT,
        RIGHT,
        DOLBY;

    }
}

