/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fo.flow.AbstractRetrieveMarker;
import org.apache.fop.fo.flow.Marker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Markers {
    private Map<String, Marker> firstQualifyingIsFirst;
    private Map<String, Marker> firstQualifyingIsAny;
    private Map<String, Marker> lastQualifyingIsFirst;
    private Map<String, Marker> lastQualifyingIsLast;
    private Map<String, Marker> lastQualifyingIsAny;
    private static Log log = LogFactory.getLog(Markers.class);

    public void register(Map<String, Marker> marks, boolean starting, boolean isfirst, boolean islast) {
        if (marks == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("--" + marks.keySet() + ": " + (starting ? "starting" : "ending") + (isfirst ? ", first" : "") + (islast ? ", last" : ""));
        }
        if (starting) {
            if (this.firstQualifyingIsAny == null) {
                this.firstQualifyingIsAny = new HashMap<String, Marker>();
            }
            if (isfirst) {
                if (this.firstQualifyingIsFirst == null) {
                    this.firstQualifyingIsFirst = new HashMap<String, Marker>();
                }
                Set<Map.Entry<String, Marker>> entries = marks.entrySet();
                for (Map.Entry<String, Marker> entry : entries) {
                    String key = entry.getKey();
                    Marker marker = entry.getValue();
                    if (!this.firstQualifyingIsFirst.containsKey(key)) {
                        this.firstQualifyingIsFirst.put(key, marker);
                        if (log.isTraceEnabled()) {
                            log.trace("Adding marker " + key + " to firstQualifyingIsFirst");
                        }
                    }
                    if (this.firstQualifyingIsAny.containsKey(key)) continue;
                    this.firstQualifyingIsAny.put(key, marker);
                    if (!log.isTraceEnabled()) continue;
                    log.trace("Adding marker " + key + " to firstQualifyingIsAny");
                }
                if (this.lastQualifyingIsFirst == null) {
                    this.lastQualifyingIsFirst = new HashMap<String, Marker>();
                }
                this.lastQualifyingIsFirst.putAll(marks);
                if (log.isTraceEnabled()) {
                    log.trace("Adding all markers to LastStart");
                }
            } else {
                Set<Map.Entry<String, Marker>> entries = marks.entrySet();
                for (Map.Entry<String, Marker> entry : entries) {
                    String key = entry.getKey();
                    Marker marker = entry.getValue();
                    if (this.firstQualifyingIsAny.containsKey(key)) continue;
                    this.firstQualifyingIsAny.put(key, marker);
                    if (!log.isTraceEnabled()) continue;
                    log.trace("Adding marker " + key + " to firstQualifyingIsAny");
                }
            }
        } else {
            if (islast) {
                if (this.lastQualifyingIsLast == null) {
                    this.lastQualifyingIsLast = new HashMap<String, Marker>();
                }
                this.lastQualifyingIsLast.putAll(marks);
                if (log.isTraceEnabled()) {
                    log.trace("Adding all markers to lastQualifyingIsLast");
                }
            }
            if (this.lastQualifyingIsAny == null) {
                this.lastQualifyingIsAny = new HashMap<String, Marker>();
            }
            this.lastQualifyingIsAny.putAll(marks);
            if (log.isTraceEnabled()) {
                log.trace("Adding all markers to lastQualifyingIsAny");
            }
        }
    }

    public Marker resolve(AbstractRetrieveMarker arm) {
        Marker mark = null;
        int pos = arm.getPosition();
        String name = arm.getRetrieveClassName();
        String posName = arm.getPositionLabel();
        String localName = arm.getLocalName();
        switch (pos) {
            case 54: 
            case 189: {
                if (this.firstQualifyingIsFirst != null) {
                    mark = this.firstQualifyingIsFirst.get(name);
                }
                if (mark != null || this.firstQualifyingIsAny == null) break;
                mark = this.firstQualifyingIsAny.get(name);
                posName = "FirstAny after " + posName;
                break;
            }
            case 49: 
            case 204: {
                if (this.firstQualifyingIsAny == null) break;
                mark = this.firstQualifyingIsAny.get(name);
                break;
            }
            case 81: 
            case 190: {
                if (this.lastQualifyingIsFirst != null) {
                    mark = this.lastQualifyingIsFirst.get(name);
                }
                if (mark != null || this.lastQualifyingIsAny == null) break;
                mark = this.lastQualifyingIsAny.get(name);
                posName = "LastAny after " + posName;
                break;
            }
            case 74: 
            case 191: {
                if (this.lastQualifyingIsLast != null) {
                    mark = this.lastQualifyingIsLast.get(name);
                }
                if (mark != null || this.lastQualifyingIsAny == null) break;
                mark = this.lastQualifyingIsAny.get(name);
                posName = "LastAny after " + posName;
                break;
            }
            default: {
                throw new RuntimeException("Invalid position attribute in " + localName + ".");
            }
        }
        if (log.isTraceEnabled()) {
            log.trace(localName + ": name[" + name + "]; position [" + posName + "]");
        }
        return mark;
    }

    public void dump() {
        if (log.isTraceEnabled()) {
            log.trace("FirstAny: " + this.firstQualifyingIsAny);
            log.trace("FirstStart: " + this.firstQualifyingIsFirst);
            log.trace("LastAny: " + this.lastQualifyingIsAny);
            log.trace("LastEnd: " + this.lastQualifyingIsLast);
            log.trace("LastStart: " + this.lastQualifyingIsFirst);
        }
    }
}

