/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFArray
extends PDFObject {
    protected List<Object> values = new ArrayList<Object>();

    public PDFArray(PDFObject parent) {
        super(parent);
    }

    public PDFArray() {
        this((PDFObject)null);
    }

    public PDFArray(PDFObject parent, int[] values) {
        super(parent);
        int c = values.length;
        for (int i = 0; i < c; ++i) {
            this.values.add(values[i]);
        }
    }

    public PDFArray(PDFObject parent, double[] values) {
        super(parent);
        int c = values.length;
        for (int i = 0; i < c; ++i) {
            this.values.add(new Double(values[i]));
        }
    }

    public PDFArray(PDFObject parent, List<?> values) {
        super(parent);
        this.values.addAll(values);
    }

    public PDFArray(Object ... elements) {
        this(null, elements);
    }

    public PDFArray(List<?> elements) {
        this(null, elements);
    }

    public PDFArray(PDFObject parent, Object[] values) {
        super(parent);
        int c = values.length;
        for (int i = 0; i < c; ++i) {
            this.values.add(values[i]);
        }
    }

    public boolean contains(Object obj) {
        return this.values.contains(obj);
    }

    public int length() {
        return this.values.size();
    }

    public void set(int index, Object obj) {
        this.values.set(index, obj);
    }

    public void set(int index, double value) {
        this.values.set(index, new Double(value));
    }

    public Object get(int index) {
        return this.values.get(index);
    }

    public void add(Object obj) {
        PDFObject pdfObj;
        if (obj instanceof PDFObject && !(pdfObj = (PDFObject)obj).hasObjectNumber()) {
            pdfObj.setParent(this);
        }
        this.values.add(obj);
    }

    public void add(double value) {
        this.values.add(new Double(value));
    }

    public void clear() {
        this.values.clear();
    }

    @Override
    public int output(OutputStream stream) throws IOException {
        CountingOutputStream cout = new CountingOutputStream(stream);
        StringBuilder textBuffer = new StringBuilder(64);
        textBuffer.append('[');
        for (int i = 0; i < this.values.size(); ++i) {
            if (i > 0) {
                textBuffer.append(' ');
            }
            Object obj = this.values.get(i);
            this.formatObject(obj, cout, textBuffer);
        }
        textBuffer.append(']');
        PDFDocument.flushTextBuffer(textBuffer, cout);
        return cout.getCount();
    }

    @Override
    public void getChildren(Set<PDFObject> children) {
        ArrayList<Object> contents = new ArrayList<Object>();
        for (Object c : this.values) {
            if (c instanceof PDFReference) continue;
            contents.add(c);
        }
        PDFDictionary.getChildren(contents, children);
    }
}

