/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.fop.pdf.PDFColorSpace;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFICCStream;
import org.apache.fop.pdf.PDFObject;
import org.apache.xmlgraphics.java2d.color.profile.ColorProfileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFICCBasedColorSpace
extends PDFObject
implements PDFColorSpace {
    private PDFICCStream iccStream;
    private String explicitName;
    private int numComponents;

    public PDFICCBasedColorSpace(String explicitName, PDFICCStream iccStream) {
        this.explicitName = explicitName;
        this.iccStream = iccStream;
        this.numComponents = iccStream.getICCProfile().getNumComponents();
    }

    public PDFICCBasedColorSpace(PDFICCStream iccStream) {
        this(null, iccStream);
    }

    public PDFICCStream getICCStream() {
        return this.iccStream;
    }

    @Override
    public int getNumComponents() {
        return this.numComponents;
    }

    @Override
    public String getName() {
        if (this.explicitName != null) {
            return this.explicitName;
        }
        return "ICC" + this.iccStream.getObjectNumber();
    }

    @Override
    public boolean isDeviceColorSpace() {
        return false;
    }

    @Override
    public boolean isRGBColorSpace() {
        return this.getNumComponents() == 3;
    }

    @Override
    public boolean isCMYKColorSpace() {
        return this.getNumComponents() == 4;
    }

    @Override
    public boolean isGrayColorSpace() {
        return this.getNumComponents() == 1;
    }

    @Override
    protected String toPDFString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append("[/ICCBased ").append(this.getICCStream().referencePDF()).append("]");
        return sb.toString();
    }

    public static PDFICCBasedColorSpace setupsRGBAsDefaultRGBColorSpace(PDFDocument pdfDoc) {
        PDFICCStream sRGBProfile = PDFICCBasedColorSpace.setupsRGBColorProfile(pdfDoc);
        return pdfDoc.getFactory().makeICCBasedColorSpace(null, "DefaultRGB", sRGBProfile);
    }

    public static PDFICCBasedColorSpace setupsRGBColorSpace(PDFDocument pdfDoc) {
        PDFICCStream sRGBProfile = PDFICCBasedColorSpace.setupsRGBColorProfile(pdfDoc);
        return pdfDoc.getFactory().makeICCBasedColorSpace(null, null, sRGBProfile);
    }

    public static PDFICCStream setupsRGBColorProfile(PDFDocument pdfDoc) {
        ICC_Profile profile;
        PDFICCStream sRGBProfile = pdfDoc.getFactory().makePDFICCStream();
        InputStream in = PDFDocument.class.getResourceAsStream("sRGB Color Space Profile.icm");
        if (in != null) {
            try {
                profile = ColorProfileUtil.getICC_Profile(in);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Unexpected IOException loading the sRGB profile: " + ioe.getMessage());
            }
            finally {
                IOUtils.closeQuietly(in);
            }
        } else {
            profile = ColorProfileUtil.getICC_Profile(1000);
        }
        sRGBProfile.setColorSpace(profile, null);
        return sRGBProfile;
    }

    @Override
    public void getChildren(Set<PDFObject> children) {
        super.getChildren(children);
        children.add(this.iccStream);
        this.iccStream.getChildren(children);
    }
}

