/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pcl;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.HashMap;
import java.util.Stack;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.render.ImageHandlerUtil;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.intermediate.AbstractIFPainter;
import org.apache.fop.render.intermediate.IFException;
import org.apache.fop.render.intermediate.IFState;
import org.apache.fop.render.intermediate.IFUtil;
import org.apache.fop.render.java2d.FontMetricsMapper;
import org.apache.fop.render.java2d.Java2DPainter;
import org.apache.fop.render.pcl.HardcodedFonts;
import org.apache.fop.render.pcl.PCLConstants;
import org.apache.fop.render.pcl.PCLDocumentHandler;
import org.apache.fop.render.pcl.PCLGenerator;
import org.apache.fop.render.pcl.PCLPageDefinition;
import org.apache.fop.render.pcl.PCLRenderingContext;
import org.apache.fop.render.pcl.PCLRenderingMode;
import org.apache.fop.render.pcl.PCLRenderingUtil;
import org.apache.fop.traits.BorderProps;
import org.apache.fop.traits.RuleStyle;
import org.apache.fop.util.CharUtilities;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageProcessingHints;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.apache.xmlgraphics.image.loader.impl.ImageGraphics2D;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.apache.xmlgraphics.java2d.Graphics2DImagePainter;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PCLPainter
extends AbstractIFPainter<PCLDocumentHandler>
implements PCLConstants {
    private static final boolean DEBUG = false;
    private PCLGenerator gen;
    private PCLPageDefinition currentPageDefinition;
    private int currentPrintDirection;
    private Stack<GraphicContext> graphicContextStack = new Stack();
    private GraphicContext graphicContext = new GraphicContext();
    private static final double SAFETY_MARGIN_FACTOR = 0.05;

    public PCLPainter(PCLDocumentHandler parent, PCLPageDefinition pageDefinition) {
        super(parent);
        this.gen = parent.getPCLGenerator();
        this.state = IFState.create();
        this.currentPageDefinition = pageDefinition;
    }

    PCLRenderingUtil getPCLUtil() {
        return ((PCLDocumentHandler)this.getDocumentHandler()).getPCLUtil();
    }

    protected int getResolution() {
        int resolution = Math.round(this.getUserAgent().getTargetResolution());
        if (resolution <= 300) {
            return 300;
        }
        return 600;
    }

    private boolean isSpeedOptimized() {
        return this.getPCLUtil().getRenderingMode() == PCLRenderingMode.SPEED;
    }

    @Override
    public void startViewport(AffineTransform transform, Dimension size, Rectangle clipRect) throws IFException {
        this.saveGraphicsState();
        try {
            this.concatenateTransformationMatrix(transform);
        }
        catch (IOException ioe) {
            throw new IFException("I/O error in startViewport()", ioe);
        }
    }

    @Override
    public void endViewport() throws IFException {
        this.restoreGraphicsState();
    }

    @Override
    public void startGroup(AffineTransform transform, String layer) throws IFException {
        this.saveGraphicsState();
        try {
            this.concatenateTransformationMatrix(transform);
        }
        catch (IOException ioe) {
            throw new IFException("I/O error in startGroup()", ioe);
        }
    }

    @Override
    public void endGroup() throws IFException {
        this.restoreGraphicsState();
    }

    @Override
    public void drawImage(String uri, Rectangle rect) throws IFException {
        this.drawImageUsingURI(uri, rect);
    }

    @Override
    protected RenderingContext createRenderingContext() {
        PCLRenderingContext pdfContext = new PCLRenderingContext(this.getUserAgent(), this.gen, this.getPCLUtil()){

            public Point2D transformedPoint(int x, int y) {
                return PCLPainter.this.transformedPoint(x, y);
            }

            public GraphicContext getGraphicContext() {
                return PCLPainter.this.graphicContext;
            }
        };
        return pdfContext;
    }

    @Override
    public void drawImage(Document doc, Rectangle rect) throws IFException {
        this.drawImageUsingDocument(doc, rect);
    }

    @Override
    public void clipRect(Rectangle rect) throws IFException {
    }

    @Override
    public void clipBackground(Rectangle rect, BorderProps bpsBefore, BorderProps bpsAfter, BorderProps bpsStart, BorderProps bpsEnd) throws IFException {
    }

    @Override
    public void fillRect(Rectangle rect, Paint fill) throws IFException {
        if (fill == null) {
            return;
        }
        if (rect.width != 0 && rect.height != 0) {
            Color fillColor = null;
            if (fill != null) {
                if (!(fill instanceof Color)) {
                    throw new UnsupportedOperationException("Non-Color paints NYI");
                }
                fillColor = (Color)fill;
                try {
                    this.setCursorPos(rect.x, rect.y);
                    this.gen.fillRect(rect.width, rect.height, fillColor);
                }
                catch (IOException ioe) {
                    throw new IFException("I/O error in fillRect()", ioe);
                }
            }
        }
    }

    public void drawBorderRect(final Rectangle rect, final BorderProps top, final BorderProps bottom, final BorderProps left, final BorderProps right) throws IFException {
        if (this.isSpeedOptimized()) {
            super.drawBorderRect(rect, top, bottom, left, right, null);
            return;
        }
        if (top != null || bottom != null || left != null || right != null) {
            Rectangle boundingBox = rect;
            final Dimension dim = boundingBox.getSize();
            Graphics2DImagePainter painter = new Graphics2DImagePainter(){

                public void paint(Graphics2D g2d, Rectangle2D area) {
                    g2d.translate(-rect.x, -rect.y);
                    Java2DPainter painter = new Java2DPainter(g2d, PCLPainter.this.getContext(), PCLPainter.this.getFontInfo(), PCLPainter.this.state);
                    try {
                        painter.drawBorderRect(rect, top, bottom, left, right);
                    }
                    catch (IFException e) {
                        throw new RuntimeException("Unexpected error while painting borders", e);
                    }
                }

                public Dimension getImageSize() {
                    return dim.getSize();
                }
            };
            this.paintMarksAsBitmap(painter, boundingBox);
        }
    }

    @Override
    public void drawLine(final Point start, final Point end, final int width, final Color color, final RuleStyle style) throws IFException {
        if (this.isSpeedOptimized()) {
            super.drawLine(start, end, width, color, style);
            return;
        }
        final Rectangle boundingBox = this.getLineBoundingBox(start, end, width);
        final Dimension dim = boundingBox.getSize();
        Graphics2DImagePainter painter = new Graphics2DImagePainter(){

            public void paint(Graphics2D g2d, Rectangle2D area) {
                g2d.translate(-boundingBox.x, -boundingBox.y);
                Java2DPainter painter = new Java2DPainter(g2d, PCLPainter.this.getContext(), PCLPainter.this.getFontInfo(), PCLPainter.this.state);
                try {
                    painter.drawLine(start, end, width, color, style);
                }
                catch (IFException e) {
                    throw new RuntimeException("Unexpected error while painting a line", e);
                }
            }

            public Dimension getImageSize() {
                return dim.getSize();
            }
        };
        this.paintMarksAsBitmap(painter, boundingBox);
    }

    private void paintMarksAsBitmap(Graphics2DImagePainter painter, Rectangle boundingBox) throws IFException {
        ImageInfo info = new ImageInfo(null, null);
        ImageSize size = new ImageSize();
        size.setSizeInMillipoints(boundingBox.width, boundingBox.height);
        info.setSize(size);
        ImageGraphics2D img = new ImageGraphics2D(info, painter);
        HashMap<Object, String> hints = new HashMap<Object, String>();
        if (this.isSpeedOptimized()) {
            hints.put(ImageProcessingHints.BITMAP_TYPE_INTENT, "mono");
        } else {
            hints.put(ImageProcessingHints.BITMAP_TYPE_INTENT, "gray");
        }
        hints.put(ImageHandlerUtil.CONVERSION_MODE, "bitmap");
        PCLRenderingContext context = (PCLRenderingContext)this.createRenderingContext();
        context.setSourceTransparencyEnabled(true);
        try {
            this.drawImage(img, boundingBox, context, true, hints);
        }
        catch (IOException ioe) {
            throw new IFException("I/O error while painting marks using a bitmap", ioe);
        }
        catch (ImageException ie) {
            throw new IFException("Error while painting marks using a bitmap", ie);
        }
    }

    @Override
    public void drawText(int x, int y, int letterSpacing, int wordSpacing, int[][] dp, String text) throws IFException {
        try {
            boolean pclFont;
            FontTriplet triplet = new FontTriplet(this.state.getFontFamily(), this.state.getFontStyle(), this.state.getFontWeight());
            String fontKey = this.getFontKey(triplet);
            boolean bl = pclFont = this.getPCLUtil().isAllTextAsBitmaps() ? false : HardcodedFonts.setFont(this.gen, fontKey, this.state.getFontSize(), text);
            if (pclFont) {
                this.drawTextNative(x, y, letterSpacing, wordSpacing, dp, text, triplet);
            } else {
                this.drawTextAsBitmap(x, y, letterSpacing, wordSpacing, dp, text, triplet);
            }
        }
        catch (IOException ioe) {
            throw new IFException("I/O error in drawText()", ioe);
        }
    }

    private void drawTextNative(int x, int y, int letterSpacing, int wordSpacing, int[][] dp, String text, FontTriplet triplet) throws IOException {
        Color textColor = this.state.getTextColor();
        if (textColor != null) {
            this.gen.setTransparencyMode(true, false);
            this.gen.selectGrayscale(textColor);
        }
        this.gen.setTransparencyMode(true, true);
        this.setCursorPos(x, y);
        float fontSize = (float)this.state.getFontSize() / 1000.0f;
        Font font = this.getFontInfo().getFontInstance(triplet, this.state.getFontSize());
        int l = text.length();
        StringBuffer sb = new StringBuffer(Math.max(16, l));
        if (dp != null && dp[0] != null && dp[0][0] != 0) {
            if (dp[0][0] > 0) {
                sb.append("\u001b&a+").append(this.gen.formatDouble2((double)dp[0][0] / 100.0)).append('H');
            } else {
                sb.append("\u001b&a-").append(this.gen.formatDouble2((double)(-dp[0][0]) / 100.0)).append('H');
            }
        }
        if (dp != null && dp[0] != null && dp[0][1] != 0) {
            if (dp[0][1] > 0) {
                sb.append("\u001b&a-").append(this.gen.formatDouble2((double)dp[0][1] / 100.0)).append('V');
            } else {
                sb.append("\u001b&a+").append(this.gen.formatDouble2((double)(-dp[0][1]) / 100.0)).append('V');
            }
        }
        for (int i = 0; i < l; ++i) {
            char ch;
            char orgChar = text.charAt(i);
            float xGlyphAdjust = 0.0f;
            float yGlyphAdjust = 0.0f;
            if (font.hasChar(orgChar)) {
                ch = font.mapChar(orgChar);
            } else if (CharUtilities.isFixedWidthSpace(orgChar)) {
                ch = font.mapChar(' ');
                int spaceDiff = font.getCharWidth(ch) - font.getCharWidth(orgChar);
                xGlyphAdjust = -((float)(10 * spaceDiff) / fontSize);
            } else {
                ch = font.mapChar(orgChar);
            }
            sb.append(ch);
            if (wordSpacing != 0 && CharUtilities.isAdjustableSpace(orgChar)) {
                xGlyphAdjust += (float)wordSpacing;
            }
            xGlyphAdjust += (float)letterSpacing;
            if (dp != null && i < dp.length && dp[i] != null) {
                xGlyphAdjust += (float)(dp[i][2] - dp[i][0]);
                yGlyphAdjust += (float)(dp[i][3] - dp[i][1]);
            }
            if (dp != null && i < dp.length - 1 && dp[i + 1] != null) {
                xGlyphAdjust += (float)dp[i + 1][0];
                yGlyphAdjust += (float)dp[i + 1][1];
            }
            if (xGlyphAdjust != 0.0f) {
                if (xGlyphAdjust > 0.0f) {
                    sb.append("\u001b&a+").append(this.gen.formatDouble2((double)xGlyphAdjust / 100.0)).append('H');
                } else {
                    sb.append("\u001b&a-").append(this.gen.formatDouble2((double)(-xGlyphAdjust) / 100.0)).append('H');
                }
            }
            if (yGlyphAdjust == 0.0f) continue;
            if (yGlyphAdjust > 0.0f) {
                sb.append("\u001b&a-").append(this.gen.formatDouble2((double)yGlyphAdjust / 100.0)).append('V');
                continue;
            }
            sb.append("\u001b&a+").append(this.gen.formatDouble2((double)(-yGlyphAdjust) / 100.0)).append('V');
        }
        this.gen.getOutputStream().write(sb.toString().getBytes(this.gen.getTextEncoding()));
    }

    private Rectangle getTextBoundingBox(int x, int y, int letterSpacing, int wordSpacing, int[][] dp, String text, Font font, FontMetricsMapper metrics) {
        int dxl;
        int maxAscent = metrics.getMaxAscent(font.getFontSize()) / 1000;
        int descent = metrics.getDescender(font.getFontSize()) / 1000;
        int safetyMargin = (int)(0.05 * (double)font.getFontSize());
        Rectangle boundingRect = new Rectangle(x, y - maxAscent - safetyMargin, 0, maxAscent - descent + 2 * safetyMargin);
        int l = text.length();
        int[] dx = IFUtil.convertDPToDX(dp);
        int n = dxl = dx != null ? dx.length : 0;
        if (dx != null && dxl > 0 && dx[0] != 0) {
            boundingRect.setLocation(boundingRect.x - (int)Math.ceil((float)dx[0] / 10.0f), boundingRect.y);
        }
        float width = 0.0f;
        for (int i = 0; i < l; ++i) {
            char orgChar = text.charAt(i);
            float glyphAdjust = 0.0f;
            int cw = font.getCharWidth(orgChar);
            if (wordSpacing != 0 && CharUtilities.isAdjustableSpace(orgChar)) {
                glyphAdjust += (float)wordSpacing;
            }
            glyphAdjust += (float)letterSpacing;
            if (dx != null && i < dxl - 1) {
                glyphAdjust += (float)dx[i + 1];
            }
            width += (float)cw + glyphAdjust;
        }
        int extraWidth = font.getFontSize() / 3;
        boundingRect.setSize((int)Math.ceil(width) + extraWidth, boundingRect.height);
        return boundingRect;
    }

    private void drawTextAsBitmap(final int x, final int y, final int letterSpacing, final int wordSpacing, final int[][] dp, final String text, FontTriplet triplet) throws IFException {
        FontMetricsMapper mapper;
        Font font = this.getFontInfo().getFontInstance(triplet, this.state.getFontSize());
        try {
            mapper = (FontMetricsMapper)this.getFontInfo().getMetricsFor(font.getFontName());
        }
        catch (Exception t) {
            throw new RuntimeException(t);
        }
        final int maxAscent = mapper.getMaxAscent(font.getFontSize()) / 1000;
        final int ascent = mapper.getAscender(font.getFontSize()) / 1000;
        final int descent = mapper.getDescender(font.getFontSize()) / 1000;
        int safetyMargin = (int)(0.05 * (double)font.getFontSize());
        final int baselineOffset = maxAscent + safetyMargin;
        Rectangle boundingBox = this.getTextBoundingBox(x, y, letterSpacing, wordSpacing, dp, text, font, mapper);
        final Dimension dim = boundingBox.getSize();
        Graphics2DImagePainter painter = new Graphics2DImagePainter(){

            public void paint(Graphics2D g2d, Rectangle2D area) {
                g2d.translate(-x, -y + baselineOffset);
                Java2DPainter painter = new Java2DPainter(g2d, PCLPainter.this.getContext(), PCLPainter.this.getFontInfo(), PCLPainter.this.state);
                try {
                    painter.drawText(x, y, letterSpacing, wordSpacing, dp, text);
                }
                catch (IFException e) {
                    throw new RuntimeException("Unexpected error while painting text", e);
                }
            }

            public Dimension getImageSize() {
                return dim.getSize();
            }
        };
        this.paintMarksAsBitmap(painter, boundingBox);
    }

    private void saveGraphicsState() {
        this.graphicContextStack.push(this.graphicContext);
        this.graphicContext = (GraphicContext)this.graphicContext.clone();
    }

    private void restoreGraphicsState() {
        this.graphicContext = this.graphicContextStack.pop();
    }

    private void concatenateTransformationMatrix(AffineTransform transform) throws IOException {
        if (!transform.isIdentity()) {
            this.graphicContext.transform(transform);
            this.changePrintDirection();
        }
    }

    private Point2D transformedPoint(int x, int y) {
        return PCLRenderingUtil.transformedPoint(x, y, this.graphicContext.getTransform(), this.currentPageDefinition, this.currentPrintDirection);
    }

    private void changePrintDirection() throws IOException {
        AffineTransform at = this.graphicContext.getTransform();
        int newDir = PCLRenderingUtil.determinePrintDirection(at);
        if (newDir != this.currentPrintDirection) {
            this.currentPrintDirection = newDir;
            this.gen.changePrintDirection(this.currentPrintDirection);
        }
    }

    void setCursorPos(int x, int y) throws IOException {
        Point2D transPoint = this.transformedPoint(x, y);
        this.gen.setCursorPos(transPoint.getX(), transPoint.getY());
    }
}

