/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.traits;

import java.awt.Color;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.traits.BorderStyle;
import org.apache.xmlgraphics.java2d.color.ColorUtil;

public class BorderProps
implements Serializable {
    private static final long serialVersionUID = 8022237892391068187L;
    public final int style;
    public final Color color;
    public final int width;
    private final int radiusStart;
    private final int radiusEnd;
    private final Mode mode;

    public BorderProps(int style, int width, int radiusStart, int radiusEnd, Color color, Mode mode) {
        this.style = style;
        this.width = width;
        this.radiusStart = radiusStart;
        this.radiusEnd = radiusEnd;
        this.color = color;
        this.mode = mode;
    }

    public static BorderProps makeRectangular(int style, int width, Color color, Mode mode) {
        return new BorderProps(style, width, 0, 0, color, mode);
    }

    private BorderProps(String style, int width, int radiusStart, int radiusEnd, Color color, Mode mode) {
        this(BorderProps.getConstantForStyle(style), width, radiusStart, radiusEnd, color, mode);
    }

    public int getRadiusStart() {
        return this.radiusStart;
    }

    public int getRadiusEnd() {
        return this.radiusEnd;
    }

    public static int getClippedWidth(BorderProps bp) {
        return bp == null ? 0 : bp.mode.getClippedWidth(bp);
    }

    private String getStyleString() {
        return BorderStyle.valueOf(this.style).getName();
    }

    private static int getConstantForStyle(String style) {
        return BorderStyle.valueOf(style).getEnumValue();
    }

    public boolean isCollapseOuter() {
        return this.mode == Mode.COLLAPSE_OUTER;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof BorderProps) {
            BorderProps other = (BorderProps)obj;
            return this.style == other.style && ColorUtil.isSameColor(this.color, other.color) && this.width == other.width && this.mode == other.mode && this.radiusStart == other.radiusStart && this.radiusEnd == other.radiusEnd;
        }
        return false;
    }

    public static BorderProps valueOf(FOUserAgent foUserAgent, String s) {
        return BorderPropsDeserializer.INSTANCE.valueOf(foUserAgent, s);
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append('(').append(this.getStyleString()).append(',').append(org.apache.fop.util.ColorUtil.colorToString(this.color)).append(',').append(this.width);
        if (!this.mode.equals((Object)Mode.SEPARATE)) {
            sbuf.append(",").append(this.mode.value);
        }
        if (this.radiusStart != 0 || this.radiusEnd != 0) {
            if (this.mode.equals((Object)Mode.SEPARATE)) {
                sbuf.append(",").append(Mode.SEPARATE.value);
            }
            sbuf.append(',').append(this.radiusStart).append(',').append(this.radiusEnd);
        }
        sbuf.append(')');
        return sbuf.toString();
    }

    private static final class BorderPropsDeserializer {
        private static final BorderPropsDeserializer INSTANCE = new BorderPropsDeserializer();
        private static final Pattern PATTERN = Pattern.compile("([^,\\(]+(?:\\(.*\\))?)");

        private BorderPropsDeserializer() {
        }

        public BorderProps valueOf(FOUserAgent foUserAgent, String s) {
            if (s.startsWith("(") && s.endsWith(")")) {
                Color c;
                s = s.substring(1, s.length() - 1);
                Matcher m = PATTERN.matcher(s);
                m.find();
                String style = m.group();
                m.find();
                String color = m.group();
                m.find();
                int width = Integer.parseInt(m.group());
                Mode mode = Mode.SEPARATE;
                if (m.find()) {
                    String ms = m.group();
                    if (Mode.COLLAPSE_INNER.value.equalsIgnoreCase(ms)) {
                        mode = Mode.COLLAPSE_INNER;
                    } else if (Mode.COLLAPSE_OUTER.value.equalsIgnoreCase(ms)) {
                        mode = Mode.COLLAPSE_OUTER;
                    }
                }
                try {
                    c = org.apache.fop.util.ColorUtil.parseColorString(foUserAgent, color);
                }
                catch (PropertyException e) {
                    throw new IllegalArgumentException(e.getMessage());
                }
                int startRadius = 0;
                int endRadius = 0;
                if (m.find()) {
                    startRadius = Integer.parseInt(m.group());
                    m.find();
                    endRadius = Integer.parseInt(m.group());
                }
                return new BorderProps(style, width, startRadius, endRadius, c, mode);
            }
            throw new IllegalArgumentException("BorderProps must be surrounded by parentheses");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        SEPARATE("separate"){

            int getClippedWidth(BorderProps bp) {
                return 0;
            }
        }
        ,
        COLLAPSE_INNER("collapse-inner"),
        COLLAPSE_OUTER("collapse-outer");

        private final String value;

        private Mode(String value) {
            this.value = value;
        }

        int getClippedWidth(BorderProps bp) {
            return bp.width / 2;
        }
    }
}

