/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.io.GlycoCT;

import java.util.ArrayList;
import org.eurocarbdb.MolecularFramework.io.SugarImporterException;
import org.eurocarbdb.MolecularFramework.sugar.Anomer;
import org.eurocarbdb.MolecularFramework.sugar.BaseType;
import org.eurocarbdb.MolecularFramework.sugar.Modification;
import org.eurocarbdb.MolecularFramework.sugar.ModificationType;
import org.eurocarbdb.MolecularFramework.sugar.Monosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.Superclass;

public class BasetypeFactory {
    private char m_cToken = (char)32;
    private String m_strMS = "";
    private int m_iPosition = -1;

    private void nextToken() throws Exception {
        ++this.m_iPosition;
        try {
            this.m_cToken = this.m_strMS.charAt(this.m_iPosition);
        }
        catch (IndexOutOfBoundsException e) {
            throw new Exception("COMMON000");
        }
    }

    private int number() throws Exception {
        int t_iResult = 0;
        char t_iDigit = '\u0000';
        if (this.m_cToken == '0') {
            this.nextToken();
            return t_iResult;
        }
        t_iDigit = this.m_cToken;
        if (t_iDigit < '1' || t_iDigit > '9') {
            throw new SugarImporterException("COMMON004", this.m_iPosition);
        }
        t_iResult = t_iDigit - 48;
        this.nextToken();
        t_iDigit = this.m_cToken;
        while (t_iDigit > '/' && t_iDigit < ':') {
            t_iResult = t_iResult * 10 + (t_iDigit - 48);
            this.nextToken();
            t_iDigit = this.m_cToken;
        }
        return t_iResult;
    }

    public Monosaccharide createResidue(String a_strMS) throws Exception {
        int t_iRingStart;
        Superclass t_objSuper;
        int t_iCounter;
        this.m_iPosition = -1;
        this.m_strMS = a_strMS;
        this.nextToken();
        Anomer t_objAnomer = Anomer.forSymbol(this.m_cToken);
        this.nextToken();
        if (this.m_cToken != '-') {
            throw new SugarImporterException("GLYCOCTC007", this.m_iPosition);
        }
        this.nextToken();
        int t_iMaxPos = this.m_strMS.indexOf(":", this.m_iPosition) - 7;
        ArrayList<BaseType> t_aConfiguration = new ArrayList<BaseType>();
        String t_strInformation = "";
        while (this.m_iPosition < t_iMaxPos) {
            t_strInformation = "";
            for (t_iCounter = 0; t_iCounter < 4; ++t_iCounter) {
                t_strInformation = t_strInformation + this.m_cToken;
                this.nextToken();
            }
            try {
                t_aConfiguration.add(BaseType.forName(t_strInformation));
            }
            catch (Exception e) {
                throw new SugarImporterException("GLYCOCTC008", this.m_iPosition);
            }
            if (this.m_cToken != '-') {
                throw new SugarImporterException("GLYCOCTC007", this.m_iPosition);
            }
            this.nextToken();
        }
        t_strInformation = "";
        for (t_iCounter = 0; t_iCounter < 3; ++t_iCounter) {
            t_strInformation = t_strInformation + this.m_cToken;
            this.nextToken();
        }
        try {
            t_objSuper = Superclass.forName(t_strInformation.toLowerCase());
        }
        catch (Exception e) {
            throw new SugarImporterException("GLYCOCTC009", this.m_iPosition);
        }
        Monosaccharide t_objMS = new Monosaccharide(t_objAnomer, t_objSuper);
        t_objMS.setBaseType(t_aConfiguration);
        if (this.m_cToken != '-') {
            throw new SugarImporterException("GLYCOCTC007", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken == 'x') {
            t_iRingStart = -1;
            this.nextToken();
        } else {
            t_iRingStart = this.number();
        }
        if (this.m_cToken != ':') {
            throw new SugarImporterException("GLYCOCTC005", this.m_iPosition);
        }
        this.nextToken();
        if (this.m_cToken == 'x') {
            t_objMS.setRing(t_iRingStart, -1);
            this.nextToken();
        } else {
            t_objMS.setRing(t_iRingStart, this.number());
        }
        while (this.m_cToken == '|') {
            ModificationType t_enumMod;
            int t_iPosOne;
            Integer t_iPosTwo = null;
            this.nextToken();
            if (this.m_cToken == 'x') {
                t_iPosOne = 0;
                this.nextToken();
            } else {
                t_iPosOne = this.number();
            }
            if (this.m_cToken == ',') {
                this.nextToken();
                t_iPosTwo = this.number();
            }
            if (this.m_cToken != ':') {
                throw new SugarImporterException("GLYCOCTC005", this.m_iPosition);
            }
            this.nextToken();
            int t_iStart = this.m_iPosition;
            this.modification_name();
            try {
                t_enumMod = ModificationType.forName(this.m_strMS.substring(t_iStart, this.m_iPosition));
            }
            catch (Exception e) {
                throw new SugarImporterException("GLYCOCTC010", this.m_iPosition);
            }
            Modification t_objModi = new Modification(t_enumMod, t_iPosOne, t_iPosTwo);
            t_objMS.addModification(t_objModi);
        }
        return t_objMS;
    }

    private void modification_name() throws Exception {
        boolean t_bNext = true;
        while (t_bNext) {
            t_bNext = false;
            if (this.m_cToken >= 'A' && this.m_cToken <= 'Z') {
                this.nextToken();
                t_bNext = true;
                continue;
            }
            if (this.m_cToken < 'a' || this.m_cToken > 'z') continue;
            this.nextToken();
            t_bNext = true;
        }
    }
}

