/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.sugar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eurocarbdb.MolecularFramework.sugar.GlycoEdge;
import org.eurocarbdb.MolecularFramework.sugar.GlycoGraphAlternative;
import org.eurocarbdb.MolecularFramework.sugar.GlycoNode;
import org.eurocarbdb.MolecularFramework.sugar.GlycoconjugateException;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitor;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;

public class SugarUnitAlternative
extends GlycoNode {
    private ArrayList<GlycoGraphAlternative> m_aAlternatives = new ArrayList();

    @Override
    public void accept(GlycoVisitor a_objVisitor) throws GlycoVisitorException {
        a_objVisitor.visit(this);
    }

    public void setAlternatives(ArrayList<GlycoGraphAlternative> a_aList) throws GlycoconjugateException {
        if (a_aList == null) {
            throw new GlycoconjugateException("null is not a valid set of alternatives");
        }
        this.m_aAlternatives.clear();
        Iterator<GlycoGraphAlternative> t_iterAlter = a_aList.iterator();
        while (t_iterAlter.hasNext()) {
            this.addAlternative(t_iterAlter.next());
        }
    }

    public ArrayList<GlycoGraphAlternative> getAlternatives() {
        return this.m_aAlternatives;
    }

    public void addAlternative(GlycoGraphAlternative a_objAlternative) throws GlycoconjugateException {
        if (a_objAlternative == null) {
            throw new GlycoconjugateException("null is not a valid residue.");
        }
        if (!this.m_aAlternatives.contains(a_objAlternative)) {
            this.m_aAlternatives.add(a_objAlternative);
        }
    }

    public void removeAlternative(GlycoGraphAlternative a_objAlternative) throws GlycoconjugateException {
        if (!this.m_aAlternatives.contains(a_objAlternative)) {
            throw new GlycoconjugateException("Can't remove invalid alternative residue.");
        }
        this.m_aAlternatives.remove(a_objAlternative);
    }

    @Override
    public SugarUnitAlternative copy() throws GlycoconjugateException {
        SugarUnitAlternative t_objCopy = new SugarUnitAlternative();
        Iterator<GlycoGraphAlternative> t_iterNodes = this.m_aAlternatives.iterator();
        while (t_iterNodes.hasNext()) {
            t_objCopy.addAlternative(t_iterNodes.next().copy());
        }
        return t_objCopy;
    }

    public void setLeadInNode(GlycoNode a_objParent, GlycoGraphAlternative a_objAlternative) throws GlycoconjugateException {
        if (!this.m_aAlternatives.contains(a_objAlternative)) {
            throw new GlycoconjugateException("GlycoGraphAlternative is not part of this sugar unit alternative.");
        }
        if (this.m_objParentLinkage == null) {
            throw new GlycoconjugateException("This sugar unit alternative does not have a parent linkage.");
        }
        a_objAlternative.setLeadInNode(a_objParent);
    }

    public void addLeadOutNodeToNode(GlycoNode a_objParent, GlycoGraphAlternative a_objAlternative, GlycoNode a_objChild) throws GlycoconjugateException {
        if (!this.m_aAlternatives.contains(a_objAlternative)) {
            throw new GlycoconjugateException("GlycoGraphAlternative is not part of this sugar unit alternative.");
        }
        boolean t_bFound = false;
        Iterator t_iterLinkages = this.m_aChildLinkages.iterator();
        while (t_iterLinkages.hasNext()) {
            if (a_objChild != ((GlycoEdge)t_iterLinkages.next()).getChild()) continue;
            t_bFound = true;
        }
        if (!t_bFound) {
            throw new GlycoconjugateException("This sugar unit alternative does not have this child linkage.");
        }
        a_objAlternative.addLeadOutNodeToNode(a_objChild, a_objParent);
    }

    public void setLeadOutNodeToNode(HashMap<GlycoNode, GlycoNode> a_hNodeToNode, GlycoGraphAlternative a_objAltGraph) throws GlycoconjugateException {
        a_objAltGraph.removeAllLeadOutNodes();
        for (GlycoNode t_objKEy : a_hNodeToNode.keySet()) {
            this.addLeadOutNodeToNode(a_hNodeToNode.get(t_objKEy), a_objAltGraph, t_objKEy);
        }
    }
}

