/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.util.analytical.disaccharide;

import java.util.ArrayList;
import java.util.Iterator;
import org.eurocarbdb.MolecularFramework.sugar.GlycoEdge;
import org.eurocarbdb.MolecularFramework.sugar.GlycoNode;
import org.eurocarbdb.MolecularFramework.sugar.Monosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.NonMonosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.Substituent;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitAlternative;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitCyclic;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitRepeat;
import org.eurocarbdb.MolecularFramework.sugar.UnderdeterminedSubTree;
import org.eurocarbdb.MolecularFramework.sugar.UnvalidatedGlycoNode;
import org.eurocarbdb.MolecularFramework.util.analytical.disaccharide.Disaccharide;
import org.eurocarbdb.MolecularFramework.util.traverser.GlycoTraverser;
import org.eurocarbdb.MolecularFramework.util.traverser.GlycoTraverserSimple;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitor;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorNodeType;

public class GlycoVisitorDisaccharide
implements GlycoVisitor {
    private ArrayList<Disaccharide> m_aDisaccharide = new ArrayList();
    private GlycoVisitorNodeType m_visNodeType = new GlycoVisitorNodeType();
    private boolean m_bCalculateStatistic = false;

    public void setCalculateStatistic(boolean a_bValue) {
        this.m_bCalculateStatistic = a_bValue;
    }

    public ArrayList<Disaccharide> getDisaccharide() {
        return this.m_aDisaccharide;
    }

    @Override
    public void clear() {
        this.m_aDisaccharide.clear();
    }

    @Override
    public GlycoTraverser getTraverser(GlycoVisitor a_objVisitor) throws GlycoVisitorException {
        return new GlycoTraverserSimple(a_objVisitor);
    }

    @Override
    public void visit(NonMonosaccharide residue) throws GlycoVisitorException {
    }

    @Override
    public void visit(Substituent substituent) throws GlycoVisitorException {
    }

    @Override
    public void visit(UnvalidatedGlycoNode unvalidated) throws GlycoVisitorException {
    }

    @Override
    public void visit(GlycoEdge linkage) throws GlycoVisitorException {
    }

    @Override
    public void visit(SugarUnitCyclic a_objCyclic) throws GlycoVisitorException {
        Monosaccharide t_objChild;
        Monosaccharide t_objParent = this.getMonosaccharide(a_objCyclic.getParentNode(), false);
        if (t_objParent != null && (t_objChild = this.getMonosaccharide(a_objCyclic.getCyclicStart(), true)) != null) {
            Disaccharide t_objDisaccaride = new Disaccharide();
            t_objDisaccaride.setParent(t_objParent);
            t_objDisaccaride.setChild(t_objChild);
            t_objDisaccaride.setLinkage(a_objCyclic.getParentEdge());
            this.m_aDisaccharide.add(t_objDisaccaride);
        }
    }

    @Override
    public void visit(SugarUnitAlternative alternative) throws GlycoVisitorException {
        throw new GlycoVisitorException("SugarUnitAlternative are not supported.");
    }

    @Override
    public void start(Sugar a_objSugar) throws GlycoVisitorException {
        this.clear();
        GlycoTraverser t_objTraverser = this.getTraverser(this);
        t_objTraverser.traverseGraph(a_objSugar);
        Iterator<UnderdeterminedSubTree> t_iterUnder = a_objSugar.getUndeterminedSubTrees().iterator();
        while (t_iterUnder.hasNext()) {
            UnderdeterminedSubTree t_objTree = t_iterUnder.next();
            if (t_objTree.getProbabilityLower() < 100.0 && this.m_bCalculateStatistic) {
                t_objTree = t_iterUnder.next();
                t_objTraverser = this.getTraverser(this);
                t_objTraverser.traverseGraph(t_objTree);
                continue;
            }
            if (t_objTree.getProbabilityLower() != 100.0) continue;
            t_objTraverser = this.getTraverser(this);
            t_objTraverser.traverseGraph(t_objTree);
        }
    }

    @Override
    public void visit(Monosaccharide a_objMonosaccharid) throws GlycoVisitorException {
        Monosaccharide t_objParent;
        GlycoNode t_objNode = a_objMonosaccharid.getParentNode();
        if (t_objNode != null && (t_objParent = this.getMonosaccharide(t_objNode, false)) != null) {
            Disaccharide t_objDisaccaride = new Disaccharide();
            t_objDisaccaride.setParent(t_objParent);
            t_objDisaccaride.setChild(a_objMonosaccharid);
            t_objDisaccaride.setLinkage(a_objMonosaccharid.getParentEdge());
            this.m_aDisaccharide.add(t_objDisaccaride);
        }
    }

    @Override
    public void visit(SugarUnitRepeat a_objRepeat) throws GlycoVisitorException {
        Monosaccharide t_objChild;
        Monosaccharide t_objParent;
        GlycoTraverser t_objTraverser = this.getTraverser(this);
        t_objTraverser.traverseGraph(a_objRepeat);
        GlycoNode t_objNode = a_objRepeat.getParentNode();
        if (t_objNode != null && (t_objParent = this.getMonosaccharide(t_objNode, false)) != null && (t_objChild = this.getMonosaccharide(a_objRepeat.getRepeatLinkage().getChild(), true)) != null) {
            Disaccharide t_objDisaccaride = new Disaccharide();
            t_objDisaccaride.setParent(t_objParent);
            t_objDisaccaride.setChild(t_objChild);
            t_objDisaccaride.setLinkage(a_objRepeat.getParentEdge());
            this.m_aDisaccharide.add(t_objDisaccaride);
        }
        for (UnderdeterminedSubTree t_objTree : a_objRepeat.getUndeterminedSubTrees()) {
            if (t_objTree.getProbabilityLower() < 100.0 && this.m_bCalculateStatistic) {
                t_objTraverser = this.getTraverser(this);
                t_objTraverser.traverseGraph(t_objTree);
                continue;
            }
            if (t_objTree.getProbabilityLower() != 100.0) continue;
            t_objTraverser = this.getTraverser(this);
            t_objTraverser.traverseGraph(t_objTree);
        }
    }

    private Monosaccharide getMonosaccharide(GlycoNode a_objResidue, boolean a_bRepeatIn) throws GlycoVisitorException {
        int t_iNodeType = this.m_visNodeType.getNodeType(a_objResidue);
        if (t_iNodeType == 0) {
            return this.m_visNodeType.getMonosaccharide(a_objResidue);
        }
        if (t_iNodeType == 2) {
            if (a_bRepeatIn) {
                return this.getMonosaccharide(this.m_visNodeType.getSugarUnitRepeat(a_objResidue).getRepeatLinkage().getChild(), a_bRepeatIn);
            }
            return this.getMonosaccharide(this.m_visNodeType.getSugarUnitRepeat(a_objResidue).getRepeatLinkage().getParent(), a_bRepeatIn);
        }
        return null;
    }
}

