/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.util.similiarity.SearchEngine;

import java.util.ArrayList;
import org.eurocarbdb.MolecularFramework.sugar.Anomer;
import org.eurocarbdb.MolecularFramework.sugar.BaseType;
import org.eurocarbdb.MolecularFramework.sugar.GlycoEdge;
import org.eurocarbdb.MolecularFramework.sugar.GlycoNode;
import org.eurocarbdb.MolecularFramework.sugar.GlycoconjugateException;
import org.eurocarbdb.MolecularFramework.sugar.Monosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.Superclass;
import org.eurocarbdb.MolecularFramework.util.similiarity.SearchEngine.NodeComparator;
import org.eurocarbdb.MolecularFramework.util.similiarity.SearchEngine.SimpleGetNameVisitor;
import org.eurocarbdb.MolecularFramework.util.similiarity.SearchEngine.StandardEdgeComparator;
import org.eurocarbdb.MolecularFramework.util.similiarity.SearchEngine.StandardNodeComparator;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorNodeType;

public class NodeComparatorWithSubstituents
implements NodeComparator {
    private GlycoVisitorNodeType m_visNodeType = new GlycoVisitorNodeType();

    @Override
    public int compare(GlycoNode o1, GlycoNode o2) {
        SimpleGetNameVisitor v = new SimpleGetNameVisitor();
        try {
            o1.accept(v);
            String r1Name = v.getName();
            v.clear();
            o2.accept(v);
            String r2Name = v.getName();
            v.clear();
            if (this.m_visNodeType.isMonosaccharide(o1) && this.m_visNodeType.isMonosaccharide(o2)) {
                Monosaccharide m1 = (Monosaccharide)o1.copy();
                Monosaccharide m2 = (Monosaccharide)o2.copy();
                this.harmonizeMS(m1, m2);
                m1.accept(v);
                String m1name = v.getName();
                v.clear();
                m2.accept(v);
                String m2name = v.getName();
                v.clear();
                if (!this.checkSubstituentsIdentity(o1, o2)) {
                    return 1;
                }
                if (m2name.equals(m1name)) {
                    return 0;
                }
            } else if (r2Name.equals(r1Name)) {
                return 0;
            }
        }
        catch (GlycoVisitorException e) {
            e.printStackTrace();
        }
        catch (GlycoconjugateException e) {
            e.printStackTrace();
        }
        return 1;
    }

    private boolean checkSubstituentsIdentity(GlycoNode m1, GlycoNode m2) throws GlycoVisitorException {
        for (GlycoEdge g : m1.getChildEdges()) {
            if (!this.m_visNodeType.isSubstituent(g.getChild()) || this.hasSubstituent(m2, g)) continue;
            return false;
        }
        for (GlycoEdge g : m2.getChildEdges()) {
            if (!this.m_visNodeType.isSubstituent(g.getChild()) || this.hasSubstituent(m1, g)) continue;
            return false;
        }
        return true;
    }

    private boolean hasSubstituent(GlycoNode m2, GlycoEdge g) throws GlycoVisitorException {
        Boolean flag = false;
        for (GlycoEdge t_g : m2.getChildEdges()) {
            if (!this.m_visNodeType.isSubstituent(t_g.getChild())) continue;
            StandardEdgeComparator t_edgeComp = new StandardEdgeComparator();
            StandardNodeComparator t_nodeComp = new StandardNodeComparator();
            if (t_edgeComp.compare(t_g, g) != 0 || t_nodeComp.compare(g.getChild(), t_g.getChild()) != 0) continue;
            flag = true;
        }
        return flag;
    }

    private void harmonizeMS(Monosaccharide m1, Monosaccharide m2) {
        ArrayList<BaseType> a_basetypes;
        String s2;
        String s1;
        BaseType b2;
        BaseType b1;
        int i;
        if (m1.getAnomer() == Anomer.Unknown || m2.getAnomer() == Anomer.Unknown) {
            try {
                m1.setAnomer(Anomer.Unknown);
                m2.setAnomer(Anomer.Unknown);
            }
            catch (GlycoconjugateException e) {
                e.printStackTrace();
            }
        }
        for (i = 0; i < m1.getBaseType().size(); ++i) {
            b1 = m1.getBaseType().get(i);
            if (!b1.absoluteConfigurationUnknown() || m2.getBaseType().size() <= i) continue;
            b2 = m2.getBaseType().get(i);
            s1 = b1.getName().subSequence(1, 3).toString();
            if (!s1.equalsIgnoreCase(s2 = b2.getName().subSequence(1, 3).toString())) continue;
            a_basetypes = m2.getBaseType();
            a_basetypes.set(i, b1);
            try {
                m2.setBaseType(a_basetypes);
                continue;
            }
            catch (GlycoconjugateException e) {
                e.printStackTrace();
            }
        }
        for (i = 0; i < m2.getBaseType().size(); ++i) {
            b1 = m2.getBaseType().get(i);
            if (!b1.absoluteConfigurationUnknown() || m1.getBaseType().size() <= i) continue;
            b2 = m1.getBaseType().get(i);
            s1 = b1.getName().subSequence(1, 3).toString();
            if (!s1.equalsIgnoreCase(s2 = b2.getName().subSequence(1, 3).toString())) continue;
            a_basetypes = m1.getBaseType();
            a_basetypes.set(i, b1);
            try {
                m1.setBaseType(a_basetypes);
                continue;
            }
            catch (GlycoconjugateException e) {
                e.printStackTrace();
            }
        }
        if (m1.getBaseType().size() == 0 || m2.getBaseType().size() == 0) {
            try {
                ArrayList<BaseType> BaseTypeTemp = new ArrayList<BaseType>();
                m1.setBaseType(BaseTypeTemp);
                m2.setBaseType(BaseTypeTemp);
            }
            catch (GlycoconjugateException e) {
                e.printStackTrace();
            }
        }
        if (m1.getSuperclass() == Superclass.SUG || m1.getSuperclass() == Superclass.SUG) {
            try {
                ArrayList<BaseType> BaseTypeTemp = new ArrayList<BaseType>();
                m1.setBaseType(BaseTypeTemp);
                m2.setBaseType(BaseTypeTemp);
                m1.setSuperclass(Superclass.SUG);
                m2.setSuperclass(Superclass.SUG);
            }
            catch (GlycoconjugateException e) {
                e.printStackTrace();
            }
        }
        if (m1.getRingStart() == -1 || m2.getRingStart() == -1) {
            try {
                m1.setRingStart(-1);
                m2.setRingStart(-1);
            }
            catch (GlycoconjugateException e) {
                e.printStackTrace();
            }
        }
        if (m1.getRingEnd() == -1 || m2.getRingEnd() == -1) {
            try {
                m1.setRingEnd(-1);
                m2.setRingEnd(-1);
            }
            catch (GlycoconjugateException e) {
                e.printStackTrace();
            }
        }
    }
}

