/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.transform.sax.TransformerHandler;
import org.eurocarbdb.application.glycanbuilder.FragmentEntry;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.util.SAXUtils;
import org.eurocarbdb.application.glycanbuilder.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class FragmentCollection
implements SAXUtils.SAXWriter {
    private LinkedList<FragmentEntry> fragments = new LinkedList();

    public FragmentCollection clone() {
        FragmentCollection ret = new FragmentCollection();
        Iterator i = this.fragments.iterator();
        while (i.hasNext()) {
            ret.fragments.add(((FragmentEntry)i.next()).clone());
        }
        return ret;
    }

    public Collection<FragmentEntry> getFragments() {
        return this.fragments;
    }

    public Iterator<FragmentEntry> iterator() {
        return this.fragments.iterator();
    }

    public FragmentEntry get(int ind) {
        return this.fragments.get(ind);
    }

    public int size() {
        return this.fragments.size();
    }

    public boolean addFragment(Glycan _fragment, String _name) {
        if (_fragment == null) {
            return false;
        }
        if (_fragment.getRoot() == null) {
            return false;
        }
        Double _mass = _fragment.computeMass();
        Double _mz = _fragment.computeMZ();
        String _structure = _fragment.toString();
        return this.addFragment(new FragmentEntry(_fragment, _name, _mass, _mz, _structure));
    }

    public boolean addFragment(FragmentEntry toadd) {
        for (int i = 0; i < this.fragments.size(); ++i) {
            FragmentEntry fe = this.fragments.get(i);
            int comp = toadd.compareTo(fe);
            if (comp == 0) {
                return false;
            }
            if (comp >= 0) continue;
            this.fragments.add(i, toadd);
            return true;
        }
        this.fragments.add(toadd);
        return true;
    }

    public boolean removeFragments(Collection<FragmentEntry> fec) {
        if (fec == null) {
            return false;
        }
        return this.fragments.removeAll(fec);
    }

    public boolean removeFragment(FragmentEntry _fe) {
        if (_fe == null) {
            return false;
        }
        for (int i = 0; i < this.fragments.size(); ++i) {
            if (!this.fragments.get(i).equals(_fe)) continue;
            this.fragments.remove(i);
            return true;
        }
        return false;
    }

    public boolean addFragments(FragmentCollection _fc) {
        if (_fc == null) {
            return false;
        }
        return this.addFragments(_fc.getFragments());
    }

    public boolean addFragments(Collection<FragmentEntry> _fragments) {
        if (this.fragments == null) {
            return false;
        }
        boolean added = false;
        for (FragmentEntry fe : _fragments) {
            added |= this.addFragment(fe.clone());
        }
        return added;
    }

    public static FragmentCollection fromXML(Node root_node) throws Exception {
        FragmentCollection ret = new FragmentCollection();
        LinkedList<Node> fe_nodes = XMLUtils.findAllChildren(root_node, "FragmentEntry");
        for (Node fe_node : fe_nodes) {
            ret.addFragment(FragmentEntry.fromXML(fe_node));
        }
        return ret;
    }

    public Element toXML(Document document) {
        if (document == null) {
            return null;
        }
        Element root_node = document.createElement("FragmentCollection");
        if (root_node == null) {
            return null;
        }
        for (FragmentEntry fe : this.fragments) {
            root_node.appendChild(fe.toXML(document));
        }
        return root_node;
    }

    @Override
    public void write(TransformerHandler th) throws SAXException {
        th.startElement("", "", "FragmentCollection", new AttributesImpl());
        for (FragmentEntry fe : this.fragments) {
            fe.write(th);
        }
        th.endElement("", "", "FragmentCollection");
    }

    public static class SAXHandler
    extends SAXUtils.ObjectTreeHandler {
        @Override
        public boolean isElement(String namespaceURI, String localName, String qName) {
            return qName.equals(SAXHandler.getNodeElementName());
        }

        public static String getNodeElementName() {
            return "FragmentCollection";
        }

        @Override
        protected SAXUtils.ObjectTreeHandler getHandler(String namespaceURI, String localName, String qName) throws SAXException {
            if (qName.equals(FragmentEntry.SAXHandler.getNodeElementName())) {
                return new FragmentEntry.SAXHandler();
            }
            return null;
        }

        @Override
        protected Object finalizeContent(String namespaceURI, String localName, String qName) throws SAXException {
            FragmentCollection ret = new FragmentCollection();
            for (Object e : this.getSubObjects(FragmentEntry.SAXHandler.getNodeElementName())) {
                ret.addFragment((FragmentEntry)e);
            }
            this.object = ret;
            return this.object;
        }
    }
}

