/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eurocarbdb.application.glycanbuilder.CrossRingFragmentType;
import org.eurocarbdb.application.glycanbuilder.FragmentCollection;
import org.eurocarbdb.application.glycanbuilder.FragmentDocument;
import org.eurocarbdb.application.glycanbuilder.FragmentOptions;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.TypePattern;
import org.eurocarbdb.application.glycanbuilder.dataset.CrossRingFragmentDictionary;
import org.eurocarbdb.application.glycanbuilder.dataset.ResidueDictionary;
import org.eurocarbdb.application.glycanbuilder.linkage.Linkage;
import org.eurocarbdb.application.glycanbuilder.massutil.IonCloud;
import org.eurocarbdb.application.glycanbuilder.massutil.MassOptions;

public class Fragmenter {
    protected boolean afragments = true;
    protected boolean bfragments = true;
    protected boolean cfragments = true;
    protected boolean xfragments = true;
    protected boolean yfragments = true;
    protected boolean zfragments = true;
    protected boolean internal_fragments = true;
    protected int max_no_cleavages = 2;
    protected int max_no_crossrings = 1;
    protected boolean small_ring_fragments = true;
    protected boolean iterate_ion_combinations = false;

    public Fragmenter() {
    }

    public Fragmenter(FragmentOptions opt) {
        if (opt != null) {
            this.afragments = opt.ADD_AFRAGMENTS;
            this.bfragments = opt.ADD_BFRAGMENTS;
            this.cfragments = opt.ADD_CFRAGMENTS;
            this.xfragments = opt.ADD_XFRAGMENTS;
            this.yfragments = opt.ADD_YFRAGMENTS;
            this.zfragments = opt.ADD_ZFRAGMENTS;
            this.internal_fragments = opt.INTERNAL_FRAGMENTS;
            this.max_no_cleavages = opt.MAX_NO_CLEAVAGES;
            this.max_no_crossrings = opt.MAX_NO_CROSSRINGS;
            this.iterate_ion_combinations = opt.ITERATE_ION_COMBINATIONS;
        }
    }

    public boolean getComputeAFragments() {
        return this.afragments;
    }

    public void setComputeAFragments(boolean f) {
        this.afragments = f;
    }

    public boolean getComputeBFragments() {
        return this.afragments;
    }

    public void setComputeBFragments(boolean f) {
        this.bfragments = f;
    }

    public boolean getComputeCFragments() {
        return this.afragments;
    }

    public void setComputeCFragments(boolean f) {
        this.cfragments = f;
    }

    public boolean getComputeXFragments() {
        return this.afragments;
    }

    public void setComputeXFragments(boolean f) {
        this.xfragments = f;
    }

    public boolean getComputeYFragments() {
        return this.yfragments;
    }

    public void setComputeYFragments(boolean f) {
        this.yfragments = f;
    }

    public boolean getComputeZFragments() {
        return this.zfragments;
    }

    public void setComputeZFragments(boolean f) {
        this.zfragments = f;
    }

    public boolean getComputeInternalFragments() {
        return this.internal_fragments;
    }

    public void setComputeInternalFragments(boolean f) {
        this.internal_fragments = f;
    }

    public int getMaxNoCleavages() {
        return this.max_no_cleavages;
    }

    public void setMaxNoCleavages(int i) {
        this.max_no_cleavages = i;
    }

    public int getMaxNoCrossRings() {
        return this.max_no_crossrings;
    }

    public void setMaxNoCrossRings(int i) {
        this.max_no_crossrings = i;
    }

    public boolean isIterate_ion_combinations() {
        return this.iterate_ion_combinations;
    }

    public void setIterate_ion_combinations(boolean iterate_ion_combinations) {
        this.iterate_ion_combinations = iterate_ion_combinations;
    }

    public boolean getComputeSmallRingFragments() {
        return this.small_ring_fragments;
    }

    public void setComputeSmallRingFragments(boolean f) {
        this.small_ring_fragments = f;
    }

    public static FragmentDocument generateLabilesConfigurations(Collection<Glycan> structures) {
        FragmentDocument ret = new FragmentDocument();
        for (Glycan s : structures) {
            FragmentCollection fc = new FragmentCollection();
            Glycan parent = s.detachLabileResidues().removeDetachedLabiles();
            TypePattern labiles = parent.getLabilePositionsPattern();
            MassOptions mass_opt = s.getMassOptions().removeExchanges();
            parent.setMassOptions(mass_opt);
            for (Glycan conf : parent.getAllLabilesConfigurations(labiles)) {
                fc.addFragment(conf, Fragmenter.getFragmentType(conf));
            }
            ret.addFragments(parent, fc);
        }
        return ret;
    }

    public FragmentCollection computeFragments(Glycan structure, Residue current) {
        FragmentCollection fragments = new FragmentCollection();
        this.computeFragments(fragments, structure, current);
        return fragments;
    }

    public void computeFragments(FragmentCollection fragments, Glycan structure, Residue current) {
        if (structure != null && structure.contains(current) && !structure.isFuzzy(true) && !structure.hasRepetition()) {
            MassOptions mass_opt = structure.getMassOptions().removeExchanges();
            if (Fragmenter.canDoCleavage(current)) {
                if (this.bfragments) {
                    Glycan b_frag = this.getBFragment(current, mass_opt);
                    fragments.addFragment(b_frag, Fragmenter.getFragmentType(b_frag));
                }
                if (this.cfragments) {
                    Glycan c_frag = this.getCFragment(current, mass_opt);
                    fragments.addFragment(c_frag, Fragmenter.getFragmentType(c_frag));
                }
                if (this.yfragments) {
                    Glycan y_frag = this.getYFragment(current, mass_opt);
                    fragments.addFragment(y_frag, Fragmenter.getFragmentType(y_frag));
                }
                if (this.zfragments) {
                    Glycan z_frag = this.getZFragment(current, mass_opt);
                    fragments.addFragment(z_frag, Fragmenter.getFragmentType(z_frag));
                }
            }
            if (Fragmenter.canDoRingFragment(current)) {
                if (this.afragments) {
                    for (CrossRingFragmentType crt : CrossRingFragmentDictionary.getCrossRingFragmentTypesA(current)) {
                        Glycan a_frag = this.getAFragment(current, crt, false, mass_opt);
                        fragments.addFragment(a_frag, Fragmenter.getFragmentType(a_frag));
                    }
                }
                if (this.xfragments) {
                    for (CrossRingFragmentType crt : CrossRingFragmentDictionary.getCrossRingFragmentTypesX(current)) {
                        Glycan x_frag = this.getXFragment(current, crt, false, mass_opt);
                        fragments.addFragment(x_frag, Fragmenter.getFragmentType(x_frag));
                    }
                }
            }
        }
    }

    public FragmentCollection computeAllFragments(Glycan structure) {
        FragmentCollection fragments = new FragmentCollection();
        this.computeAllFragments(fragments, structure);
        return fragments;
    }

    public void computeAllFragments(FragmentCollection fragments, Glycan structure) {
        if (structure != null && !structure.isFuzzy(true) && !structure.hasRepetition()) {
            List<IonCloud> ionClouds;
            MassOptions mass_opt = structure.getMassOptions().removeExchanges();
            if (this.iterate_ion_combinations) {
                ionClouds = mass_opt.ION_CLOUD.generateCombinations();
            } else {
                ionClouds = new ArrayList<IonCloud>();
                ionClouds.add(mass_opt.ION_CLOUD);
            }
            for (IonCloud ionCloud : ionClouds) {
                MassOptions options = mass_opt.clone();
                options.ION_CLOUD = ionCloud.clone();
                Glycan parent = structure.clone();
                parent.setMassOptions(options);
                if (parent.hasLabileResidues()) {
                    this.computeAllFragmentsWithLabiles(fragments, parent, this.max_no_cleavages, Math.min(this.max_no_cleavages, this.max_no_crossrings), options);
                    for (Glycan conf : parent.getAllLabilesConfigurations()) {
                        fragments.addFragment(conf, Fragmenter.getFragmentType(conf));
                    }
                    continue;
                }
                this.computeAllFragments(fragments, parent.getRoot(), this.max_no_cleavages, Math.min(this.max_no_cleavages, this.max_no_crossrings), options);
                fragments.addFragment(parent, Fragmenter.getFragmentType(parent));
            }
        }
    }

    protected void computeAllFragments(FragmentCollection fragments, Residue current, int cur_max_no_cleavages, int cur_max_no_crossrings, MassOptions mass_opt) {
        if (cur_max_no_cleavages == 0) {
            return;
        }
        if (Fragmenter.canDoCleavage(current)) {
            Glycan z_frag;
            Glycan y_frag;
            Glycan c_frag;
            Glycan b_frag;
            if (this.bfragments && fragments.addFragment(b_frag = this.getBFragment(current, mass_opt), Fragmenter.getFragmentType(b_frag))) {
                this.computeAllFragments(fragments, b_frag.getRoot(), cur_max_no_cleavages - 1, cur_max_no_crossrings, mass_opt);
            }
            if (this.cfragments && fragments.addFragment(c_frag = this.getCFragment(current, mass_opt), Fragmenter.getFragmentType(c_frag))) {
                this.computeAllFragments(fragments, c_frag.getRoot(), cur_max_no_cleavages - 1, cur_max_no_crossrings, mass_opt);
            }
            if (this.yfragments && fragments.addFragment(y_frag = this.getYFragment(current, mass_opt), Fragmenter.getFragmentType(y_frag))) {
                this.computeAllFragments(fragments, y_frag.getRoot(), cur_max_no_cleavages - 1, cur_max_no_crossrings, mass_opt);
            }
            if (this.zfragments && fragments.addFragment(z_frag = this.getZFragment(current, mass_opt), Fragmenter.getFragmentType(z_frag))) {
                this.computeAllFragments(fragments, z_frag.getRoot(), cur_max_no_cleavages - 1, cur_max_no_crossrings, mass_opt);
            }
        }
        if (cur_max_no_crossrings > 0 && Fragmenter.canDoRingFragment(current)) {
            if (this.afragments) {
                for (CrossRingFragmentType crt : CrossRingFragmentDictionary.getCrossRingFragmentTypesA(current)) {
                    Glycan a_frag = this.getAFragment(current, crt, false, mass_opt);
                    if (!fragments.addFragment(a_frag, Fragmenter.getFragmentType(a_frag))) continue;
                    this.computeAllFragments(fragments, a_frag.getRoot(), cur_max_no_cleavages - 1, cur_max_no_crossrings - 1, mass_opt);
                }
            }
            if (this.xfragments) {
                for (CrossRingFragmentType crt : CrossRingFragmentDictionary.getCrossRingFragmentTypesX(current)) {
                    Glycan x_frag = this.getXFragment(current, crt, false, mass_opt);
                    if (!fragments.addFragment(x_frag, Fragmenter.getFragmentType(x_frag))) continue;
                    this.computeAllFragments(fragments, x_frag.getRoot(), cur_max_no_cleavages - 1, cur_max_no_crossrings - 1, mass_opt);
                }
            }
        }
        for (Linkage l : current.getChildrenLinkages()) {
            this.computeAllFragments(fragments, l.getChildResidue(), cur_max_no_cleavages, cur_max_no_crossrings, mass_opt);
        }
    }

    protected void computeAllFragmentsWithLabiles(FragmentCollection fragments, Glycan structure, int cur_max_no_cleavages, int cur_max_no_crossrings, MassOptions mass_opt) {
        if (cur_max_no_cleavages == 0) {
            return;
        }
        structure = structure.detachLabileResidues();
        TypePattern avail_labiles = structure.getDetachedLabilesPattern();
        this.computeAllFragmentsWithLabiles(fragments, structure.getRoot(), avail_labiles, cur_max_no_cleavages, cur_max_no_crossrings, mass_opt);
    }

    protected void computeAllFragmentsWithLabiles(FragmentCollection fragments, Residue current, TypePattern avail_labiles, int cur_max_no_cleavages, int cur_max_no_crossrings, MassOptions mass_opt) {
        if (cur_max_no_cleavages == 0) {
            return;
        }
        if (Fragmenter.canDoCleavage(current)) {
            if (this.bfragments) {
                for (Glycan b_frag : Glycan.getAllLabilesConfigurations(this.getBFragment(current, mass_opt), avail_labiles)) {
                    if (!fragments.addFragment(b_frag, Fragmenter.getFragmentType(b_frag))) continue;
                    this.computeAllFragmentsWithLabiles(fragments, b_frag, cur_max_no_cleavages - 1, cur_max_no_crossrings, mass_opt);
                }
            }
            if (this.cfragments) {
                for (Glycan c_frag : Glycan.getAllLabilesConfigurations(this.getCFragment(current, mass_opt), avail_labiles)) {
                    if (!fragments.addFragment(c_frag, Fragmenter.getFragmentType(c_frag))) continue;
                    this.computeAllFragmentsWithLabiles(fragments, c_frag, cur_max_no_cleavages - 1, cur_max_no_crossrings, mass_opt);
                }
            }
            if (this.yfragments) {
                for (Glycan y_frag : Glycan.getAllLabilesConfigurations(this.getYFragment(current, mass_opt), avail_labiles)) {
                    if (!fragments.addFragment(y_frag, Fragmenter.getFragmentType(y_frag))) continue;
                    this.computeAllFragmentsWithLabiles(fragments, y_frag, cur_max_no_cleavages - 1, cur_max_no_crossrings, mass_opt);
                }
            }
            if (this.zfragments) {
                for (Glycan z_frag : Glycan.getAllLabilesConfigurations(this.getZFragment(current, mass_opt), avail_labiles)) {
                    if (!fragments.addFragment(z_frag, Fragmenter.getFragmentType(z_frag))) continue;
                    this.computeAllFragmentsWithLabiles(fragments, z_frag, cur_max_no_cleavages - 1, cur_max_no_crossrings, mass_opt);
                }
            }
        }
        if (cur_max_no_crossrings > 0 && Fragmenter.canDoRingFragment(current)) {
            if (this.afragments) {
                for (CrossRingFragmentType crt : CrossRingFragmentDictionary.getCrossRingFragmentTypesA(current)) {
                    for (Glycan a_frag : Glycan.getAllLabilesConfigurations(this.getAFragment(current, crt, true, mass_opt), avail_labiles)) {
                        if (a_frag.isSmallRingFragment() && a_frag.countCharges() <= 0 || !fragments.addFragment(a_frag, Fragmenter.getFragmentType(a_frag))) continue;
                        this.computeAllFragmentsWithLabiles(fragments, a_frag, cur_max_no_cleavages - 1, cur_max_no_crossrings - 1, mass_opt);
                    }
                }
            }
            if (this.xfragments) {
                for (CrossRingFragmentType crt : CrossRingFragmentDictionary.getCrossRingFragmentTypesX(current)) {
                    for (Glycan x_frag : Glycan.getAllLabilesConfigurations(this.getXFragment(current, crt, true, mass_opt), avail_labiles)) {
                        if (x_frag.isSmallRingFragment() && x_frag.countCharges() <= 0 || !fragments.addFragment(x_frag, Fragmenter.getFragmentType(x_frag))) continue;
                        this.computeAllFragmentsWithLabiles(fragments, x_frag, cur_max_no_cleavages - 1, cur_max_no_crossrings - 1, mass_opt);
                    }
                }
            }
        }
        for (Linkage l : current.getChildrenLinkages()) {
            this.computeAllFragmentsWithLabiles(fragments, l.getChildResidue(), avail_labiles, cur_max_no_cleavages, cur_max_no_crossrings, mass_opt);
        }
    }

    public static boolean canDoCleavage(Glycan structure, Residue current, boolean tolerate_labiles) {
        return structure != null && !structure.isFuzzy(tolerate_labiles) && !structure.hasRepetition() && Fragmenter.canDoCleavage(current);
    }

    public static boolean canDoCleavage(Glycan structure, Residue current) {
        return structure != null && !structure.isFuzzy() && !structure.hasRepetition() && Fragmenter.canDoCleavage(current);
    }

    public static boolean canDoCleavage(Residue current) {
        return current != null && current.isCleavable() && current.getParent() != null && (current.getParent().isCleavable() || current.getParent().getType().getName().equals("Cer"));
    }

    public static boolean canDoRingFragment(Glycan structure, Residue current, boolean tolerate_labiles) {
        return structure != null && !structure.isFuzzy(tolerate_labiles) && !structure.hasRepetition() && Fragmenter.canDoRingFragment(current);
    }

    public static boolean canDoRingFragment(Glycan structure, Residue current) {
        return structure != null && !structure.isFuzzy() && !structure.hasRepetition() && Fragmenter.canDoRingFragment(current);
    }

    public static boolean canDoRingFragment(Residue current) {
        return current != null && current.isSaccharide() && current.checkLinkages();
    }

    public Collection<Glycan> getAllAFragmentsWithLabiles(Glycan structure, Residue current, CrossRingFragmentType type) {
        if (!Fragmenter.canDoRingFragment(structure, current, true)) {
            return new LinkedList<Glycan>();
        }
        structure = structure.detachLabileResidues();
        TypePattern avail_labiles = structure.getDetachedLabilesPattern();
        Glycan fragment = this.getAFragment(current, type, false, structure.getMassOptions().removeExchanges());
        if (fragment == null) {
            return new LinkedList<Glycan>();
        }
        return Glycan.getAllLabilesConfigurations(fragment.detachLabileResidues(), avail_labiles);
    }

    public Collection<Glycan> getAllBFragmentsWithLabiles(Glycan structure, Residue current) {
        if (!Fragmenter.canDoCleavage(structure, current, true)) {
            return new LinkedList<Glycan>();
        }
        structure = structure.detachLabileResidues();
        TypePattern avail_labiles = structure.getDetachedLabilesPattern();
        Glycan fragment = this.getBFragment(current, structure.getMassOptions().removeExchanges());
        if (fragment == null) {
            return new LinkedList<Glycan>();
        }
        return Glycan.getAllLabilesConfigurations(fragment.detachLabileResidues(), avail_labiles);
    }

    public Collection<Glycan> getAllCFragmentsWithLabiles(Glycan structure, Residue current) {
        if (!Fragmenter.canDoCleavage(structure, current, true)) {
            return new LinkedList<Glycan>();
        }
        structure = structure.detachLabileResidues();
        TypePattern avail_labiles = structure.getDetachedLabilesPattern();
        Glycan fragment = this.getCFragment(current, structure.getMassOptions().removeExchanges());
        if (fragment == null) {
            return new LinkedList<Glycan>();
        }
        return Glycan.getAllLabilesConfigurations(fragment.detachLabileResidues(), avail_labiles);
    }

    public Collection<Glycan> getAllXFragmentsWithLabiles(Glycan structure, Residue current, CrossRingFragmentType type) {
        if (!Fragmenter.canDoRingFragment(structure, current, true)) {
            return new LinkedList<Glycan>();
        }
        structure = structure.detachLabileResidues();
        TypePattern avail_labiles = structure.getDetachedLabilesPattern();
        Glycan fragment = this.getXFragment(current, type, false, structure.getMassOptions().removeExchanges());
        if (fragment == null) {
            return new LinkedList<Glycan>();
        }
        return Glycan.getAllLabilesConfigurations(fragment.detachLabileResidues(), avail_labiles);
    }

    public Collection<Glycan> getAllYFragmentsWithLabiles(Glycan structure, Residue current) {
        if (!Fragmenter.canDoCleavage(structure, current, true)) {
            return new LinkedList<Glycan>();
        }
        structure = structure.detachLabileResidues();
        TypePattern avail_labiles = structure.getDetachedLabilesPattern();
        Glycan fragment = this.getYFragment(current, structure.getMassOptions().removeExchanges());
        if (fragment == null) {
            return new LinkedList<Glycan>();
        }
        return Glycan.getAllLabilesConfigurations(fragment.detachLabileResidues(), avail_labiles);
    }

    public Collection<Glycan> getAllZFragmentsWithLabiles(Glycan structure, Residue current) {
        if (!Fragmenter.canDoCleavage(structure, current, true)) {
            return new LinkedList<Glycan>();
        }
        structure = structure.detachLabileResidues();
        TypePattern avail_labiles = structure.getDetachedLabilesPattern();
        Glycan fragment = this.getZFragment(current, structure.getMassOptions().removeExchanges());
        if (fragment == null) {
            return new LinkedList<Glycan>();
        }
        return Glycan.getAllLabilesConfigurations(fragment.detachLabileResidues(), avail_labiles);
    }

    public Glycan getAFragment(Glycan structure, Residue current, CrossRingFragmentType type) {
        if (!Fragmenter.canDoRingFragment(structure, current)) {
            return null;
        }
        return this.getAFragment(current, type, false, structure.getMassOptions().removeExchanges());
    }

    protected Glycan getAFragment(Residue current, CrossRingFragmentType type, boolean allow_virtual_charges, MassOptions mass_opt) {
        Residue a_root = new Residue(type);
        a_root.setCleavedResidue(current.cloneResidue());
        if (!this.internal_fragments && type.anyValidPosition(current.getParentLinkage().getChildPositions())) {
            return null;
        }
        for (Linkage l : current.getChildrenLinkages()) {
            if (!type.areValidPositions(l.getParentPositions())) continue;
            a_root.addChild(l.getChildResidue().cloneSubtree(), l.getBonds());
        }
        if (!this.internal_fragments && a_root.hasGlycosidicCleavages()) {
            return null;
        }
        Glycan a_frag = new Glycan(a_root, false, mass_opt);
        if (!a_frag.isSmallRingFragment() && !a_root.hasRingFragments() || this.small_ring_fragments && a_frag.countCharges(allow_virtual_charges) > 0) {
            return a_frag;
        }
        return null;
    }

    public Glycan getBFragment(Glycan structure, Residue current) {
        if (!Fragmenter.canDoCleavage(structure, current)) {
            return null;
        }
        return this.getBFragment(current, structure.getMassOptions().removeExchanges());
    }

    protected Glycan getBFragment(Residue current, MassOptions mass_opt) {
        Residue b_frag = current.cloneSubtree();
        Residue b_root = ResidueDictionary.createBCleavage();
        b_root.setCleavedResidue(current.getParent().cloneResidue());
        b_root.addChild(b_frag, current.getParentLinkage().getBonds());
        if (!b_root.hasSaccharideChildren()) {
            return null;
        }
        return new Glycan(b_root, false, mass_opt);
    }

    public Glycan getCFragment(Glycan structure, Residue current) {
        if (!Fragmenter.canDoCleavage(structure, current)) {
            return null;
        }
        return this.getCFragment(current, structure.getMassOptions().removeExchanges());
    }

    protected Glycan getCFragment(Residue current, MassOptions mass_opt) {
        Residue c_frag = current.cloneSubtree();
        Residue c_root = ResidueDictionary.createCCleavage();
        c_root.setCleavedResidue(current.getParent().cloneResidue());
        c_root.addChild(c_frag, current.getParentLinkage().getBonds());
        if (!c_root.hasSaccharideChildren()) {
            return null;
        }
        return new Glycan(c_root, false, mass_opt);
    }

    public Glycan getXFragment(Glycan structure, Residue current, CrossRingFragmentType type) {
        if (!Fragmenter.canDoRingFragment(structure, current)) {
            return null;
        }
        return this.getXFragment(current, type, false, structure.getMassOptions().removeExchanges());
    }

    public Glycan getXFragment(Residue current, CrossRingFragmentType type, boolean allow_virtual_charges, MassOptions mass_opt) {
        Residue x_leaf = new Residue(type);
        x_leaf.setCleavedResidue(current.cloneResidue());
        if (!type.areValidPositions(current.getParentLinkage().getChildPositions())) {
            return null;
        }
        for (Linkage l : current.getChildrenLinkages()) {
            if (!type.areValidPositions(l.getParentPositions())) continue;
            x_leaf.addChild(l.getChildResidue().cloneSubtree(), l.getBonds());
        }
        if (!this.internal_fragments && x_leaf.hasSaccharideChildren()) {
            return null;
        }
        Glycan x_frag = new Glycan(current.getTreeRoot().cloneSubtree(current, x_leaf), false, mass_opt);
        if (!this.internal_fragments && x_leaf.hasGlycosidicCleavages()) {
            return null;
        }
        if (!x_frag.isSmallRingFragment() && !x_leaf.hasRingFragments() || this.small_ring_fragments && x_frag.countCharges(allow_virtual_charges) > 0) {
            return x_frag;
        }
        return null;
    }

    public Glycan getYFragment(Glycan structure, Residue current) {
        if (!Fragmenter.canDoCleavage(structure, current)) {
            return null;
        }
        return this.getYFragment(current, structure.getMassOptions().removeExchanges());
    }

    protected Glycan getYFragment(Residue current, MassOptions mass_opt) {
        Residue y_leaf = ResidueDictionary.createYCleavage();
        y_leaf.setCleavedResidue(current.cloneResidue());
        Glycan ret = new Glycan(current.getTreeRoot().cloneSubtree(current, y_leaf), false, mass_opt);
        if (!y_leaf.getParent().isSaccharide()) {
            return null;
        }
        return ret;
    }

    public Glycan getZFragment(Glycan structure, Residue current) {
        if (!Fragmenter.canDoCleavage(structure, current)) {
            return null;
        }
        return this.getZFragment(current, structure.getMassOptions().removeExchanges());
    }

    protected Glycan getZFragment(Residue current, MassOptions mass_opt) {
        Residue z_leaf = ResidueDictionary.createZCleavage();
        z_leaf.setCleavedResidue(current.cloneResidue());
        Glycan ret = new Glycan(current.getTreeRoot().cloneSubtree(current, z_leaf), false, mass_opt);
        if (!z_leaf.getParent().isSaccharide()) {
            return null;
        }
        return ret;
    }

    public Glycan getLFragment(Glycan structure, Residue current) {
        if (!Fragmenter.canDoCleavage(structure, current)) {
            return null;
        }
        return this.getLFragment(current, structure.getMassOptions().removeExchanges());
    }

    protected Glycan getLFragment(Residue current, MassOptions mass_opt) {
        Residue l_leaf = ResidueDictionary.createLCleavage();
        l_leaf.setCleavedResidue(current.cloneResidue());
        Glycan ret = new Glycan(current.getTreeRoot().cloneSubtree(current, l_leaf), false, mass_opt);
        if (!l_leaf.getParent().isSaccharide()) {
            return null;
        }
        return ret;
    }

    public static String getFragmentType(Glycan structure) {
        if (structure == null) {
            return "";
        }
        return Fragmenter.getFragmentType(structure.getRoot());
    }

    protected static String getFragmentType(Residue node) {
        if (node == null) {
            return "";
        }
        String type = "";
        if (node.isCleavage() && !node.isLCleavage()) {
            type = type + node.getCleavageType();
            if (node.isRingFragment()) {
                type = type + "_{" + node.getCleavedResidue().getTypeName() + "}";
            }
        }
        for (Linkage l : node.getChildrenLinkages()) {
            type = type + Fragmenter.getFragmentType(l.getChildResidue());
        }
        return type;
    }
}

