/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;
import java.util.TreeMap;
import java.util.Vector;
import javax.xml.transform.sax.TransformerHandler;
import org.eurocarbdb.MolecularFramework.sugar.LinkageType;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.application.glycanbuilder.PermutationGenerator;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.ResidueHolder;
import org.eurocarbdb.application.glycanbuilder.ResidueType;
import org.eurocarbdb.application.glycanbuilder.TypePattern;
import org.eurocarbdb.application.glycanbuilder.converterGWS.GWSParser;
import org.eurocarbdb.application.glycanbuilder.converterGlycoCT.GlycoCTCondensedParser;
import org.eurocarbdb.application.glycanbuilder.converterGlycoCT.GlycoCTParser;
import org.eurocarbdb.application.glycanbuilder.dataset.ResidueDictionary;
import org.eurocarbdb.application.glycanbuilder.linkage.Bond;
import org.eurocarbdb.application.glycanbuilder.linkage.Linkage;
import org.eurocarbdb.application.glycanbuilder.logutility.LogUtils;
import org.eurocarbdb.application.glycanbuilder.massutil.IonCloud;
import org.eurocarbdb.application.glycanbuilder.massutil.MassAware;
import org.eurocarbdb.application.glycanbuilder.massutil.MassOptions;
import org.eurocarbdb.application.glycanbuilder.massutil.MassUtils;
import org.eurocarbdb.application.glycanbuilder.massutil.Molecule;
import org.eurocarbdb.application.glycanbuilder.util.SAXUtils;
import org.eurocarbdb.application.glycanbuilder.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Glycan
implements Comparable,
SAXUtils.SAXWriter,
MassAware {
    private Residue root = null;
    private Residue bracket = null;
    private MassOptions mass_options = new MassOptions();
    private String name;

    public Glycan() {
    }

    public Glycan(Residue _root, boolean add_redend, MassOptions mass_opt) {
        if (_root == null) {
            this.root = null;
        } else if (_root.isReducingEnd()) {
            this.root = _root.hasChildren() || _root.isRingFragment() ? _root : null;
        } else if (!add_redend) {
            this.root = _root;
        } else {
            this.root = ResidueDictionary.createReducingEnd(null);
            this.root.addChild(_root);
        }
        this.bracket = null;
        if (mass_opt != null) {
            this.mass_options.setValues(mass_opt);
        }
        if (!this.mass_options.getReducingEndType().isFreeReducingEnd()) {
            this.setReducingEndType(this.mass_options.getReducingEndType());
        } else {
            this.mass_options.synchronize(this);
        }
    }

    public Glycan(Residue _root, Residue _bracket, boolean add_redend, MassOptions mass_opt) {
        if (_root.isStartCyclic()) {
            add_redend = false;
        }
        if (_root == null) {
            this.root = null;
        } else if (_root.isReducingEnd()) {
            this.root = _bracket != null || _root.hasChildren() || _root.isRingFragment() ? _root : null;
        } else if (!add_redend) {
            this.root = _root;
        } else {
            this.root = ResidueDictionary.createReducingEnd(null);
            this.root.addChild(_root);
        }
        this.bracket = this.root != null ? _bracket : null;
        if (mass_opt != null) {
            this.mass_options.setValues(mass_opt);
        }
        if (!this.mass_options.getReducingEndType().isFreeReducingEnd()) {
            this.setReducingEndType(this.mass_options.getReducingEndType());
        } else {
            this.mass_options.synchronize(this);
        }
    }

    public static Glycan createComposition(MassOptions mass_opt) {
        Residue bracket = ResidueDictionary.createBracket();
        Residue root = ResidueDictionary.createReducingEnd(null);
        bracket.isComposition(true);
        root.isComposition(true);
        return new Glycan(root, bracket, true, mass_opt);
    }

    public Glycan getComposition() {
        return this.getComposition(true);
    }

    public Glycan getComposition(boolean show_superclasses) {
        try {
            Glycan ret = Glycan.createComposition(this.mass_options);
            for (Residue r : this.getAllResidues()) {
                if (r.getType().isAttachPoint() || r.getType().isBracket()) continue;
                if (r.getType().isCleavage()) {
                    if (r.getType().canBeReducingEnd()) {
                        ret.setRoot(r.cloneResidue());
                        continue;
                    }
                    ret.addAntenna(r.cloneResidue());
                    continue;
                }
                if (r.isReducingEnd()) {
                    ret.setRoot(r.cloneResidue());
                    continue;
                }
                if (show_superclasses) {
                    ret.addAntenna(ResidueDictionary.newResidue(r.getType().getCompositionClass()));
                    continue;
                }
                ret.addAntenna(ResidueDictionary.newResidue(r.getType().getName()));
            }
            return ret;
        }
        catch (Exception e) {
            return Glycan.createComposition(this.mass_options);
        }
    }

    public Collection<Residue> getAllResidues() {
        LinkedList<Residue> ret = new LinkedList<Residue>();
        this.getAllResidues(ret, this.root);
        this.getAllResidues(ret, this.bracket);
        return ret;
    }

    private void getAllResidues(LinkedList<Residue> dest, Residue node) {
        if (node != null) {
            dest.addLast(node);
            for (Linkage l : node.getChildrenLinkages()) {
                this.getAllResidues(dest, l.getChildResidue());
            }
        }
    }

    public LinkedList<Residue> getAllSaccharide() {
        TreeMap<Integer, Residue> map = new TreeMap<Integer, Residue>();
        this.getAllSaccharide(map, this.root.getChildAt(0));
        return this.sortResidue(map);
    }

    private void getAllSaccharide(TreeMap<Integer, Residue> lst_red, Residue node) {
        if (node == null || node.isBracket() || node.equals(this.root)) {
            return;
        }
        if (node.isSaccharide() && !lst_red.containsValue(node)) {
            lst_red.put(node.id, node);
        }
        for (Linkage l : node.getChildrenLinkages()) {
            this.getAllSaccharide(lst_red, l.getChildResidue());
        }
    }

    private LinkedList<Residue> sortResidue(TreeMap<Integer, Residue> map_red) {
        LinkedList<Residue> ret = new LinkedList<Residue>();
        for (Residue r : map_red.values()) {
            ret.addLast(r);
        }
        return ret;
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof Glycan)) {
            return 1;
        }
        String s1 = this.toStringOrdered();
        String s2 = ((Glycan)o).toStringOrdered();
        return s1.compareTo(s2);
    }

    public int compareToIgnoreCharges(Object o) {
        if (o == null || !(o instanceof Glycan)) {
            return 1;
        }
        String s1 = this.toStringOrdered(false);
        String s2 = ((Glycan)o).toStringOrdered(false);
        return s1.compareTo(s2);
    }

    public Glycan clone() {
        return this.clone(false);
    }

    public Glycan clone(boolean add_redend) {
        Glycan ret = null;
        ret = this.root == null ? new Glycan(null, add_redend, this.mass_options) : new Glycan(this.root.cloneSubtree(), this.bracket != null ? this.bracket.cloneSubtree() : null, add_redend, this.mass_options);
        return ret;
    }

    public boolean equalsStructure(Glycan og) {
        if (og == null) {
            return false;
        }
        if (this.root == null) {
            return og.root == null;
        }
        if (!this.root.subtreeEquals(og.root)) {
            return false;
        }
        if (this.bracket == null) {
            return og.bracket == null;
        }
        return this.bracket.subtreeEquals(og.bracket);
    }

    public MassOptions getMassOptions() {
        return this.mass_options;
    }

    public boolean setMassOptions(MassOptions mass_opt) {
        boolean changed = this.mass_options.setValues(mass_opt);
        return changed |= this.setReducingEndType(this.mass_options.getReducingEndType());
    }

    public boolean setReducingEndType(ResidueType new_type) {
        Residue redend = this.getRoot();
        if (redend == null) {
            return false;
        }
        if (!redend.isReducingEnd()) {
            return false;
        }
        if (redend.isCleavage()) {
            return false;
        }
        if (redend.getTypeName().equals(new_type.getName())) {
            return false;
        }
        redend.setType(new_type);
        if (redend.getTypeName().equals("redEnd")) {
            redend.getChildAt(0).setAlditol(true);
            redend.getChildAt(0).setAnomericState('?');
            redend.getChildAt(0).setRingSize('o');
        }
        if (redend.getTypeName().equals("d")) {
            redend.getChildAt(0).setAnomericState('?');
        }
        if (!redend.getTypeName().equals("redEnd")) {
            redend.getChildAt(0).setAlditol(false);
            if (redend.getChildAt(0).getRingSize() == 'o') {
                redend.getChildAt(0).setRingSize(redend.getChildAt(0).getType().getRingSize());
            }
        }
        return true;
    }

    public void removeReducingEndModification() {
        this.setReducingEndType(ResidueType.createCerReducingEnd());
    }

    public Glycan withNoReducingEndModification() {
        Glycan ret = this.clone();
        ret.removeReducingEndModification();
        return ret;
    }

    public Residue getRoot() {
        return this.root;
    }

    public Residue getRoot(boolean ret_redend) {
        if (this.root == null) {
            return null;
        }
        if (ret_redend) {
            return this.root;
        }
        return this.root.firstChild();
    }

    public void setRoot(Residue new_root) {
        this.root = new_root;
    }

    public Residue getBracket() {
        return this.bracket;
    }

    public boolean isEmpty() {
        if (this.root == null) {
            return true;
        }
        if (this.root.hasChildren()) {
            return false;
        }
        if (this.bracket == null) {
            return true;
        }
        return !this.bracket.hasChildren();
    }

    public boolean isComposition() {
        return this.bracket != null && this.root != null && !this.root.hasChildren();
    }

    public boolean isFuzzy() {
        return this.isFuzzy(false);
    }

    public boolean isFuzzy(boolean tolerate_labiles) {
        if (this.bracket == null) {
            return false;
        }
        if (!tolerate_labiles) {
            return true;
        }
        for (Linkage l : this.bracket.getChildrenLinkages()) {
            if (l.getChildResidue().isLabile()) continue;
            return true;
        }
        TypePattern lp = this.getDetachedLabilesPattern();
        TypePattern lpp = this.getLabilePositionsPattern();
        return !lpp.contains(lp);
    }

    public boolean isFragment() {
        return this.isFragmentSubtree(this.root);
    }

    private boolean isFragmentSubtree(Residue node) {
        if (node.isCleavage()) {
            return true;
        }
        for (Linkage link : node.getChildrenLinkages()) {
            if (!this.isFragmentSubtree(link.getChildResidue())) continue;
            return true;
        }
        return false;
    }

    public boolean hasRepetition() {
        return this.hasRepetition(this.root) || this.hasRepetition(this.bracket);
    }

    private boolean hasRepetition(Residue node) {
        if (node == null) {
            return false;
        }
        if (node.isRepetition()) {
            return true;
        }
        for (Linkage link : node.getChildrenLinkages()) {
            if (!this.hasRepetition(link.getChildResidue())) continue;
            return true;
        }
        return false;
    }

    public int getNoAntennae() {
        if (this.bracket == null) {
            return 0;
        }
        return this.bracket.getChildrenLinkages().size();
    }

    public LinkedList<Linkage> getAntennaeLinkages() {
        if (this.bracket != null) {
            return this.bracket.getChildrenLinkages();
        }
        return new LinkedList<Linkage>();
    }

    public boolean contains(Residue node) {
        return this.root != null && this.root.subtreeContains(node) || this.bracket != null && this.bracket.subtreeContains(node);
    }

    public boolean checkLinkages() {
        if (this.root != null && !this.root.checkLinkagesSubtree()) {
            return false;
        }
        return this.bracket == null || this.bracket.checkLinkagesSubtree();
    }

    public boolean isFullySpecified() {
        if (this.isFuzzy()) {
            return false;
        }
        return this.root.isFullySpecifiedSubtree();
    }

    protected static Collection<Residue> getPath(Residue a, Residue b) {
        Residue nav;
        Stack<Residue> pra = new Stack<Residue>();
        for (nav = a; nav != null; nav = nav.getParent()) {
            pra.push(nav);
        }
        Stack<Residue> prb = new Stack<Residue>();
        for (nav = b; nav != null; nav = nav.getParent()) {
            prb.push(nav);
        }
        if (pra.peek() != prb.peek()) {
            return new Vector<Residue>();
        }
        Residue common = null;
        while (!pra.empty() && !prb.empty() && pra.peek() == prb.peek()) {
            common = (Residue)pra.pop();
            prb.pop();
        }
        pra.push(common);
        Vector<Residue> path = new Vector<Residue>();
        Iterator i = pra.iterator();
        while (i.hasNext()) {
            path.add((Residue)i.next());
        }
        while (!prb.empty()) {
            path.add((Residue)prb.pop());
        }
        return path;
    }

    public int getDepth() {
        return this.getDepth(this.root) + (this.getDepth(this.bracket) - 1);
    }

    private int getDepth(Residue current) {
        if (current == null) {
            return 0;
        }
        int depth = 0;
        for (Linkage l : current.getChildrenLinkages()) {
            depth = Math.max(depth, this.getDepth(l.getChildResidue()));
        }
        return depth + 1;
    }

    public int getCount() {
        return this.getCount(this.root) + (this.getCount(this.bracket) - 1);
    }

    private int getCount(Residue current) {
        if (current == null) {
            return 0;
        }
        int tot_count = 1;
        for (Linkage l : current.getChildrenLinkages()) {
            tot_count += this.getCount(l.getChildResidue());
        }
        return tot_count;
    }

    public void removePlacements() {
        this.removePlacements(this.root);
        this.removePlacements(this.bracket);
    }

    private void removePlacements(Residue current) {
        if (current == null) {
            return;
        }
        current.resetPreferredPlacement();
        for (Linkage l : current.getChildrenLinkages()) {
            this.removePlacements(l.getChildResidue());
        }
    }

    public int countResidues(String typename) {
        return this.countResidues(this.root, typename) + this.countResidues(this.bracket, typename);
    }

    private int countResidues(Residue current, String typename) {
        int count = 0;
        if (current == null) {
            return count;
        }
        if (current.getTypeName().equals(typename)) {
            ++count;
        }
        for (Linkage l : current.getChildrenLinkages()) {
            count += this.countResidues(l.getChildResidue(), typename);
        }
        return count;
    }

    public boolean contains(Glycan other, boolean include_redend, boolean include_all_leafs) {
        return this.contains(other, include_redend, include_all_leafs, true);
    }

    public boolean contains(Glycan other, boolean include_redend, boolean include_all_leafs, boolean fuzzy) {
        return other == null || this.countSubtree(this.getRoot(false), other.getRoot(false), include_redend, include_all_leafs, true, fuzzy) != 0 && this.contains(this.getBracket(), other.getBracket(), include_all_leafs, fuzzy) || other.getBracket() == null && (!include_redend || this.getRoot(false) == null) && this.countSubtree(this.getBracket(), other.getRoot(false), include_redend, include_all_leafs, true, fuzzy) != 0;
    }

    public int count(Glycan other, boolean include_redend, boolean include_all_leafs) {
        return this.count(other, include_redend, include_all_leafs, true);
    }

    public int count(Glycan other, boolean include_redend, boolean include_all_leafs, boolean fuzzy) {
        if (other == null) {
            return 1;
        }
        int count = this.countSubtree(this.getRoot(false), other.getRoot(false), include_redend, include_all_leafs, false, fuzzy);
        if (count != 0 && this.contains(this.getBracket(), other.getBracket(), include_all_leafs, fuzzy)) {
            return count;
        }
        if (!(other.getBracket() != null || include_redend && this.getRoot(false) != null)) {
            return this.countSubtree(this.getBracket(), other.getRoot(false), include_redend, include_all_leafs, true, fuzzy);
        }
        return 0;
    }

    private int countSubtree(Residue container, Residue terminal, boolean include_redend, boolean include_all_leafs, boolean stop_at_first) {
        return this.countSubtree(container, terminal, include_redend, include_all_leafs, stop_at_first, true);
    }

    private int countSubtree(Residue container, Residue terminal, boolean include_redend, boolean include_all_leafs, boolean stop_at_first, boolean fuzzy) {
        int count = 0;
        if (this.contains(container, terminal, include_all_leafs, fuzzy)) {
            if (stop_at_first) {
                return 1;
            }
            count = 1;
        }
        if (container == null) {
            return count;
        }
        if (!include_redend) {
            for (Linkage l : container.getChildrenLinkages()) {
                if ((count += this.countSubtree(l.getChildResidue(), terminal, false, include_all_leafs, stop_at_first, fuzzy)) == 0 || !stop_at_first) continue;
                return 1;
            }
        }
        return count;
    }

    private boolean contains(Linkage container, Linkage other, boolean include_all_leafs) {
        return this.contains(container, other, include_all_leafs, true);
    }

    private boolean contains(Linkage container, Linkage other, boolean include_all_leafs, boolean fuzzy) {
        if (!container.match(other, fuzzy)) {
            return false;
        }
        return this.contains(container.getChildResidue(), other.getChildResidue(), include_all_leafs, fuzzy);
    }

    private boolean contains(Residue container, Residue other, boolean include_all_leafs) {
        return this.contains(container, other, include_all_leafs, true);
    }

    private boolean contains(Residue container, Residue other, boolean include_all_leafs, boolean fuzzy) {
        if (other == null) {
            return container == null || !include_all_leafs;
        }
        if (container == null) {
            return false;
        }
        if (!container.match(other, fuzzy)) {
            return false;
        }
        if (include_all_leafs && container.getNoChildren() != other.getNoChildren() || container.getNoChildren() < other.getNoChildren()) {
            return false;
        }
        if (other.getNoChildren() == 0) {
            return true;
        }
        PermutationGenerator cg = new PermutationGenerator(other.getNoChildren());
        while (cg.hasMore()) {
            int[] indices = cg.getNext();
            int matched = 0;
            int i = 0;
            block1: for (int l = 0; l < other.getNoChildren(); ++l) {
                boolean contains = false;
                while (i < container.getNoChildren()) {
                    if (this.contains(container.getLinkageAt(i), other.getLinkageAt(indices[l]), include_all_leafs, fuzzy)) {
                        ++matched;
                        ++i;
                        continue block1;
                    }
                    ++i;
                }
            }
            if (matched != other.getNoChildren()) continue;
            return true;
        }
        return false;
    }

    public Residue addBracket() {
        if (this.bracket == null) {
            this.bracket = ResidueDictionary.createBracket();
            return this.bracket;
        }
        return null;
    }

    public boolean removeBracket() {
        if (this.bracket == null) {
            return false;
        }
        this.bracket = null;
        return true;
    }

    public boolean addAntenna(Residue antenna) {
        return this.addAntenna(antenna, Bond.single());
    }

    public boolean addAntenna(Residue antenna, char parent_link_pos) {
        return this.addAntenna(antenna, Bond.single(parent_link_pos));
    }

    public boolean addAntenna(Residue antenna, Collection<Bond> bonds) {
        if (this.bracket == null) {
            this.addBracket();
        }
        return this.bracket.addChild(antenna, bonds);
    }

    public boolean removeResidue(Residue toremove) {
        if (this.root == null) {
            return false;
        }
        if (toremove == null || this.root == toremove) {
            return false;
        }
        if (toremove == this.bracket) {
            if (this.bracket.hasChildren()) {
                return false;
            }
            return this.removeBracket();
        }
        if (this.root.removeChild(toremove)) {
            if (!this.root.hasChildren()) {
                this.root = null;
            }
            return true;
        }
        return this.bracket != null && this.bracket.removeChild(toremove);
    }

    public boolean removeResidues(Collection<Residue> toremove) {
        boolean removed = false;
        boolean had_antennae = this.bracket != null && this.bracket.hasChildren();
        Iterator<Residue> i = toremove.iterator();
        while (i.hasNext()) {
            if (!this.removeResidue(i.next())) continue;
            removed = true;
        }
        if (!removed) {
            return false;
        }
        if (had_antennae && this.bracket != null && !this.bracket.hasChildren()) {
            this.removeResidue(this.bracket);
        }
        return true;
    }

    public void removeUnpairedRepetitions() {
        this.removeUnpairedRepetitions(this.root);
        this.removeUnpairedRepetitions(this.bracket);
    }

    private void removeUnpairedRepetitions(Residue cur) {
        if (cur == null) {
            return;
        }
        if (cur.isStartRepetition() && cur.findEndRepetition() == null || cur.isEndRepetition() && cur.findStartRepetition() == null) {
            this.removeResidue(cur);
        }
        for (int i = 0; i < cur.getNoChildren(); ++i) {
            this.removeUnpairedRepetitions(cur.getChildAt(i));
        }
    }

    public LinkedList<Glycan> splitMultipleRoots() {
        LinkedList<Glycan> new_structures = new LinkedList<Glycan>();
        while (this.root.getNoChildren() > 1) {
            Residue child = this.root.getChildAt(1);
            this.root.getChildrenLinkages().remove(1);
            child.setParentLinkage(null);
            new_structures.addLast(new Glycan(child, true, this.mass_options));
        }
        return new_structures;
    }

    public Collection<Glycan> placeAntennae() {
        LinkedList<Glycan> ret = new LinkedList<Glycan>();
        this.placeAntennae(ret);
        return ret;
    }

    public void placeAntennae(LinkedList<Glycan> structures) {
        structures.clear();
        if (this.bracket == null) {
            structures.add(this.clone());
        } else if (this.root != null) {
            this.placeAntennae(this.root, this.root, new LinkedList<Linkage>(this.bracket.getChildrenLinkages()), structures);
        }
    }

    private void placeAntennae(Residue root, Residue current, LinkedList<Linkage> antennae, LinkedList<Glycan> structures) {
        if (current == null) {
            return;
        }
        if (antennae.size() == 0) {
            structures.add(new Glycan(root, false, this.mass_options));
            return;
        }
        Linkage link = antennae.getFirst();
        Residue antenna = link.getChildResidue();
        ArrayList<Bond> ant_pos = link.getBonds();
        if (current.isSaccharide() && current.canAddChild(antenna, ant_pos)) {
            antennae.removeFirst();
            Residue new_root = root.cloneSubtreeAdd(current, antenna.cloneSubtree(), ant_pos, new ResidueHolder());
            this.placeAntennae(new_root, new_root, antennae, structures);
            antennae.addFirst(link);
        }
        for (Linkage l : current.getChildrenLinkages()) {
            this.placeAntennae(root, l.getChildResidue(), antennae, structures);
        }
    }

    public boolean isSmallRingFragment() {
        if (this.bracket != null || this.root == null) {
            return false;
        }
        if (this.root.isRingFragment()) {
            return !this.root.hasSaccharideChildren();
        }
        if (this.root.getNoChildren() == 1 && this.root.firstChild().isRingFragment()) {
            return !this.root.firstChild().hasSaccharideChildren();
        }
        return false;
    }

    public Vector<Residue> getCleavages() {
        Vector<Residue> ret = new Vector<Residue>();
        Glycan.getCleavages(ret, this.root);
        return ret;
    }

    private static void getCleavages(Vector<Residue> buffer, Residue node) {
        if (node == null || buffer == null) {
            return;
        }
        if (node.isCleavage()) {
            buffer.add(node);
        }
        for (Linkage l : node.getChildrenLinkages()) {
            Glycan.getCleavages(buffer, l.getChildResidue());
        }
    }

    public String getDerivatization() {
        return this.mass_options.DERIVATIZATION;
    }

    public IonCloud getCharges() {
        return this.mass_options.ION_CLOUD;
    }

    public void setCharges(IonCloud ic) {
        this.mass_options.ION_CLOUD = ic != null ? ic : new IonCloud();
    }

    public IonCloud getNeutralExchanges() {
        return this.mass_options.NEUTRAL_EXCHANGES;
    }

    public void setNeutralExchanges(IonCloud ne) {
        this.mass_options.NEUTRAL_EXCHANGES = ne != null ? ne : new IonCloud();
    }

    public int countCharges() {
        return Glycan.countChargesSubtree(this.root, false) + Glycan.countChargesSubtree(this.bracket, false);
    }

    public int countCharges(boolean allow_virtual_charges) {
        return Glycan.countChargesSubtree(this.root, allow_virtual_charges) + Glycan.countChargesSubtree(this.bracket, allow_virtual_charges);
    }

    private static int countChargesSubtree(Residue node, boolean allow_virtual_charges) {
        if (node == null) {
            return 0;
        }
        int no_charges = node.getType().getNoCharges();
        if (no_charges == 0 && allow_virtual_charges && node.isLCleavage()) {
            no_charges = node.getCleavedResidue().getType().getNoCharges();
        }
        for (Linkage l : node.getChildrenLinkages()) {
            no_charges += Glycan.countChargesSubtree(l.getChildResidue(), allow_virtual_charges);
        }
        return no_charges;
    }

    @Override
    public double computeMass(String type) {
        Glycan cloneOf = this.clone();
        cloneOf.setMassOptions(this.mass_options.clone());
        cloneOf.getMassOptions().setIsotope(type);
        return cloneOf.computeMass();
    }

    @Override
    public double computeMass() {
        if (!(!this.hasRepetition() || this.areAllRepetitionsConstant(this.root) && this.areAllRepetitionsConstant(this.bracket))) {
            return -1.0;
        }
        return this.computeMass(this.root, 1.0) + this.computeMass(this.bracket, 1.0);
    }

    public int computeNoMethylPositions() {
        return this.computeNoMethylPositions(this.root) + this.computeNoMethylPositions(this.bracket);
    }

    public int computeNoAcetylPositions() {
        return this.computeNoAcetylPositions(this.root) + this.computeNoAcetylPositions(this.bracket);
    }

    public double computeMZ() {
        double mass = this.computeMass();
        return this.mass_options.ION_CLOUD.and(this.mass_options.NEUTRAL_EXCHANGES).computeMZ(mass);
    }

    public Molecule computeMolecule() throws Exception {
        Molecule ret = new Molecule();
        Molecule subst_mol = this.substitutionMolecule();
        this.computeMolecule(ret, this.root, subst_mol);
        this.computeMolecule(ret, this.bracket, subst_mol);
        return ret;
    }

    public Molecule computeIon() throws Exception {
        Molecule ret = this.computeMolecule();
        ret.add(this.mass_options.ION_CLOUD.getMolecule());
        ret.add(this.mass_options.NEUTRAL_EXCHANGES.getMolecule());
        return ret;
    }

    public IonCloud getChargesAndExchanges() {
        return this.mass_options.ION_CLOUD.and(this.mass_options.NEUTRAL_EXCHANGES);
    }

    private boolean isDropped(ResidueType type) {
        if (type.isDroppedWithMethylation() && (this.mass_options.DERIVATIZATION.equals("perMe") || this.mass_options.DERIVATIZATION.equals("perDMe") || this.mass_options.DERIVATIZATION.equals("perMe(C^13)"))) {
            return true;
        }
        return type.isDroppedWithAcetylation() && (this.mass_options.DERIVATIZATION.equals("perAc") || this.mass_options.DERIVATIZATION.equals("perAc"));
    }

    private int noSubstitutions(ResidueType type) {
        if (this.mass_options.DERIVATIZATION.equals("perMe") || this.mass_options.DERIVATIZATION.equals("perDMe") || this.mass_options.DERIVATIZATION.equals("perMe(C^13)")) {
            return type.getNoMethyls();
        }
        if (this.mass_options.DERIVATIZATION.equals("perAc") || this.mass_options.DERIVATIZATION.equals("perDAc")) {
            return type.getNoAcetyls();
        }
        return 0;
    }

    private double substitutionMass() {
        if (this.mass_options.DERIVATIZATION.equals("perMe")) {
            return MassUtils.methyl.getMass() - MassUtils.hydrogen.getMass();
        }
        if (this.mass_options.DERIVATIZATION.equals("perDMe")) {
            return MassUtils.dmethyl.getMass() - MassUtils.hydrogen.getMass();
        }
        if (this.mass_options.DERIVATIZATION.equals("perAc")) {
            return MassUtils.acetyl.getMass() - MassUtils.hydrogen.getMass();
        }
        if (this.mass_options.DERIVATIZATION.equals("perDAc")) {
            return MassUtils.dacetyl.getMass() - MassUtils.hydrogen.getMass();
        }
        if (this.mass_options.DERIVATIZATION.equals("perMe(C^13)")) {
            return MassUtils.heavyMethyl.getMass() - MassUtils.hydrogen.getMass();
        }
        return 0.0;
    }

    private Molecule substitutionMolecule() throws Exception {
        if (this.mass_options.DERIVATIZATION.equals("perMe")) {
            return MassUtils.methyl.and(MassUtils.hydrogen, -1);
        }
        if (this.mass_options.DERIVATIZATION.equals("perDMe")) {
            return MassUtils.dmethyl.and(MassUtils.hydrogen, -1);
        }
        if (this.mass_options.DERIVATIZATION.equals("perAc")) {
            return MassUtils.acetyl.and(MassUtils.hydrogen, -1);
        }
        if (this.mass_options.DERIVATIZATION.equals("perDAc")) {
            return MassUtils.dacetyl.and(MassUtils.hydrogen, -1);
        }
        if (this.mass_options.DERIVATIZATION.equals("perMe(C^13)")) {
            return MassUtils.heavyMethyl.and(MassUtils.hydrogen, -1);
        }
        return new Molecule();
    }

    private double computeMass(Residue node) {
        if (node == null) {
            return 0.0;
        }
        ResidueType type = node.getType();
        int no_bonds = node.getNoBonds();
        double mass = type.getMass();
        if (node.isReducingEnd() && node.getType().makesAlditol()) {
            mass += 2.0 * MassUtils.hydrogen.getMass();
        }
        if (node.isBracket()) {
            int no_linked_labiles = Math.min(this.countLabilePositions(), this.countDetachedLabiles());
            mass -= (double)(no_bonds - no_linked_labiles) * this.substitutionMass();
        } else if (node.isCleavage() && !node.isRingFragment()) {
            if (node.isReducingEnd() && !node.hasChildren()) {
                mass += this.substitutionMass();
            }
        } else {
            mass = this.isDropped(type) ? (mass -= type.getMass() - MassUtils.water.getMass() - this.substitutionMass()) : (mass += (double)(this.noSubstitutions(type) - no_bonds) * this.substitutionMass());
        }
        for (Linkage l : node.getChildrenLinkages()) {
            mass -= MassUtils.water.getMass() * (double)l.getNoBonds();
            mass += this.computeMass(l.getChildResidue());
        }
        return mass;
    }

    public boolean areAllRepetitionsConstant(Residue node) {
        if (node == null) {
            return true;
        }
        if (node.isEndRepetition() && (node.getMinRepetitions() == -1 || node.getMaxRepetitions() == -1 || node.getMinRepetitions() != node.getMaxRepetitions())) {
            return false;
        }
        for (Linkage l : node.getChildrenLinkages()) {
            if (this.areAllRepetitionsConstant(l.getChildResidue())) continue;
            return false;
        }
        return true;
    }

    private double computeMass(Residue node, double multipler) {
        if (node == null || node.getTypeName().equals("Sugar")) {
            return 0.0;
        }
        if (node.isStartRepetition()) {
            Residue end = node.getEndRepitionResidue();
            if (end.getMaxRepetitions() == end.getMinRepetitions()) {
                multipler = end.getMaxRepetitions();
            }
        } else if (node.isEndRepetition()) {
            multipler = 1.0;
        }
        ResidueType type = node.getType();
        int no_bonds = node.getNoBonds();
        double mass = 0.0;
        if (!node.isRepetition() || this.checkCompositionResidue(node)) {
            mass = type.getMass();
        }
        if (node.isReducingEnd() && node.getType().makesAlditol()) {
            mass += 2.0 * MassUtils.hydrogen.getMass();
        }
        if (node.isBracket() && !node.isComposition()) {
            int no_linked_labiles = Math.min(this.countLabilePositions(), this.countDetachedLabiles());
            mass -= (double)(no_bonds - no_linked_labiles) * this.substitutionMass();
        } else if (node.isCleavage() && !node.isRingFragment()) {
            if (node.isReducingEnd() && !node.hasChildren()) {
                mass += this.substitutionMass();
            }
        } else if (!node.isRepetition()) {
            mass = this.isDropped(type) ? (mass -= type.getMass() - MassUtils.water.getMass() - this.substitutionMass()) : (mass += (double)(this.noSubstitutions(type) - no_bonds) * this.substitutionMass());
        }
        mass *= multipler;
        if (node.getParent() != null && node.getParent().isStartRepetition()) {
            Residue startRepResidue = node.getParent();
            int noBonds = startRepResidue.getLinkageAt(0).getNoBonds();
            int repetitions = startRepResidue.getEndRepitionResidue().getMaxRepetitions();
            mass += (double)((repetitions - 1) * (noBonds - 1)) * MassUtils.water.getMass();
            mass += (double)((repetitions - 2) * (noBonds - 1)) * this.substitutionMass();
        }
        for (Linkage l : node.getChildrenLinkages()) {
            if (l.getChildResidue().isEndCyclic()) continue;
            if (l.getChildResidue().isRepetition() && l.getChildResidue().isEndRepetition()) {
                mass += (double)(no_bonds - (l.getChildResidue().getNoBonds() + no_bonds - 2)) * this.substitutionMass();
            }
            if (this.isDehydrationBond(l)) {
                mass -= MassUtils.water.getMass() * (double)l.getNoBonds() * multipler;
            }
            if (!l.getChildResidue().getType().getComposition().contains("O") && (l.getParentLinkageType().equals((Object)LinkageType.H_AT_OH) || l.getParentLinkageType().equals((Object)LinkageType.H_LOSE))) {
                mass += MassUtils.water.getMass() * (double)l.getNoBonds() * multipler;
                mass -= MassUtils.hydrogen.getMass() * (double)l.getNoBonds() * multipler * 2.0;
            }
            mass += this.computeMass(l.getChildResidue(), multipler);
        }
        return mass;
    }

    private boolean checkCompositionResidue(Residue node) {
        if (node.isComposition()) {
            return !node.isBracket();
        }
        return false;
    }

    private boolean isDehydrationBond(Linkage childLinkage) {
        Residue child = childLinkage.getChildResidue();
        if (child.isRepetition()) {
            return false;
        }
        if (child.isComposition()) {
            if (child.getParentsOfFragment().isEmpty()) {
                return false;
            }
            if (child.getParentsOfFragment().contains(child) && child.getParentsOfFragment().size() == 1) {
                return false;
            }
        }
        return true;
    }

    private void computeMolecule(Molecule ret, Residue node, Molecule substitution_molecule) throws Exception {
        if (node == null) {
            return;
        }
        ResidueType type = node.getType();
        int no_bonds = node.getNoBonds();
        Molecule molecule = type.getMolecule();
        if (molecule == null) {
            molecule = new Molecule("");
        }
        ret.add(molecule);
        if (node.isReducingEnd() && node.getType().makesAlditol()) {
            ret.add(MassUtils.hydrogen, 2);
        }
        if (node.isBracket()) {
            int no_linked_labiles = Math.min(this.countLabilePositions(), this.countDetachedLabiles());
            ret.remove(substitution_molecule, no_bonds - no_linked_labiles);
        } else if (node.isCleavage() && !node.isRingFragment()) {
            if (node.isReducingEnd() && !node.hasChildren()) {
                ret.add(substitution_molecule);
            }
        } else if (this.isDropped(type)) {
            ret.remove(type.getMolecule());
            ret.add(MassUtils.water);
            ret.add(substitution_molecule);
        } else {
            ret.add(substitution_molecule, this.noSubstitutions(type) - no_bonds);
        }
        for (Linkage l : node.getChildrenLinkages()) {
            ret.remove(MassUtils.water, l.getNoBonds());
            this.computeMolecule(ret, l.getChildResidue(), substitution_molecule);
        }
    }

    private int computeNoMethylPositions(Residue node) {
        if (node == null) {
            return 0;
        }
        int ret = 0;
        int no_bonds = node.getNoBonds();
        if (node.isBracket()) {
            int no_linked_labiles = Math.min(this.countLabilePositions(), this.countDetachedLabiles());
            ret -= no_bonds - no_linked_labiles;
        } else {
            ret = node.getType().isDroppedWithMethylation() ? --ret : (ret += node.getType().getNoMethyls() - no_bonds);
        }
        for (Linkage l : node.getChildrenLinkages()) {
            ret += this.computeNoMethylPositions(l.getChildResidue());
        }
        return ret;
    }

    private int computeNoAcetylPositions(Residue node) {
        if (node == null) {
            return 0;
        }
        int ret = 0;
        int no_bonds = node.getNoBonds();
        if (node.isBracket()) {
            int no_linked_labiles = Math.min(this.countLabilePositions(), this.countDetachedLabiles());
            ret -= no_bonds - no_linked_labiles;
        } else {
            ret = node.getType().isDroppedWithAcetylation() ? --ret : (ret += node.getType().getNoAcetyls() - no_bonds);
        }
        for (Linkage l : node.getChildrenLinkages()) {
            ret += this.computeNoMethylPositions(l.getChildResidue());
        }
        return ret;
    }

    public boolean hasLabileResidues() {
        return this.hasLabileResidues(this.root) || this.hasLabileResidues(this.bracket);
    }

    private boolean hasLabileResidues(Residue current) {
        if (current == null) {
            return false;
        }
        if (current.isLabile()) {
            return true;
        }
        for (Linkage l : current.getChildrenLinkages()) {
            if (!this.hasLabileResidues(l.getChildResidue())) continue;
            return true;
        }
        return false;
    }

    public Glycan detachLabileResidues() {
        Glycan ret = this.clone();
        ret.detachLabileResidues(ret.getRoot());
        return ret;
    }

    private void detachLabileResidues(Residue current) {
        if (current == null) {
            return;
        }
        if (current.isLabile()) {
            Residue l_leaf = new Residue(ResidueType.createLCleavage());
            l_leaf.setCleavedResidue(current);
            current.getParentLinkage().setChildResidue(l_leaf);
            l_leaf.setParentLinkage(current.getParentLinkage());
            current.setParentLinkage(null);
            this.addAntenna(current.cloneResidue());
        } else {
            for (Linkage l : current.getChildrenLinkages()) {
                this.detachLabileResidues(l.getChildResidue());
            }
        }
    }

    public TypePattern getDetachedLabilesPattern() {
        TypePattern conf = new TypePattern();
        if (this.bracket == null) {
            return conf;
        }
        for (Linkage l : this.bracket.getChildrenLinkages()) {
            if (!l.getChildResidue().isLabile()) continue;
            conf.add(l.getChildResidue().getTypeName());
        }
        return conf;
    }

    public TypePattern getAllLabilesPattern() {
        TypePattern conf = new TypePattern();
        this.getAllLabilesPattern(this.root, conf);
        this.getAllLabilesPattern(this.bracket, conf);
        return conf;
    }

    private void getAllLabilesPattern(Residue current, TypePattern conf) {
        if (current == null) {
            return;
        }
        if (current.isLabile()) {
            conf.add(current.getTypeName());
        }
        for (Linkage l : current.getChildrenLinkages()) {
            this.getAllLabilesPattern(l.getChildResidue(), conf);
        }
    }

    public TypePattern getLabilePositionsPattern() {
        TypePattern conf = new TypePattern();
        this.getLabilePositionsPattern(this.root, conf);
        return conf;
    }

    private void getLabilePositionsPattern(Residue current, TypePattern conf) {
        if (current == null) {
            return;
        }
        if (current.isLCleavage()) {
            conf.add(current.getCleavedResidue().getTypeName());
        }
        for (Linkage l : current.getChildrenLinkages()) {
            this.getLabilePositionsPattern(l.getChildResidue(), conf);
        }
    }

    public int countDetachedLabiles() {
        int count = 0;
        if (this.bracket != null) {
            for (Linkage l : this.bracket.getChildrenLinkages()) {
                if (!l.getChildResidue().isLabile()) continue;
                ++count;
            }
        }
        return count;
    }

    public int countLabilePositions() {
        return this.countLabilePositions(this.root) + this.countLabilePositions(this.bracket);
    }

    private int countLabilePositions(Residue current) {
        if (current == null) {
            return 0;
        }
        if (current.isLCleavage()) {
            return 1;
        }
        int count = 0;
        for (Linkage l : current.getChildrenLinkages()) {
            count += this.countLabilePositions(l.getChildResidue());
        }
        return count;
    }

    public Glycan removeDetachedLabiles() {
        Glycan ret = this.clone();
        if (ret.bracket == null) {
            return ret;
        }
        Iterator link_enum = ret.bracket.getChildrenLinkages().iterator();
        while (link_enum.hasNext()) {
            Linkage l = (Linkage)link_enum.next();
            if (!l.getChildResidue().isLabile()) continue;
            l.setParentResidue(null);
            link_enum.remove();
        }
        if (ret.bracket.getChildrenLinkages().size() == 0) {
            ret.bracket = null;
        }
        return ret;
    }

    private void removeDetachedLabile(String typename) {
        if (this.bracket == null) {
            return;
        }
        for (Linkage l : this.bracket.getChildrenLinkages()) {
            if (!l.getChildResidue().getTypeName().equals(typename)) continue;
            this.bracket.removeChild(l.getChildResidue());
            break;
        }
        if (!this.bracket.hasChildren()) {
            this.bracket = null;
        }
    }

    public static Collection<Glycan> getAllLabilesConfigurations(Glycan structure, TypePattern avail_labiles) {
        if (structure == null) {
            return new Vector<Glycan>();
        }
        return structure.getAllLabilesConfigurations(avail_labiles);
    }

    public Collection<Glycan> getAllLabilesConfigurations() {
        Glycan dest = this.detachLabileResidues();
        return dest.getAllLabilesConfigurations(dest.getDetachedLabilesPattern());
    }

    protected Collection<Glycan> getAllLabilesConfigurations(TypePattern avail_labiles) {
        Vector<Glycan> ret = new Vector<Glycan>();
        Glycan dest = this.removeDetachedLabiles();
        int no_labiles = avail_labiles.size();
        ret.add(dest);
        if (no_labiles > 0) {
            TypePattern labile_pos = dest.getLabilePositionsPattern();
            for (int i = 1; i <= no_labiles && i <= labile_pos.size(); ++i) {
                if (i == labile_pos.size()) {
                    ret.add(dest.reattachAllLabileResidues());
                    continue;
                }
                for (TypePattern conf : labile_pos.subPatterns(i)) {
                    ret.add(dest.addLabileResidues(conf));
                }
            }
        }
        return ret;
    }

    private Glycan addLabileResidues(TypePattern conf) {
        Glycan ret = this.clone();
        try {
            if (conf != null) {
                for (String typename : conf.getTypes()) {
                    ret.addAntenna(ResidueDictionary.newResidue(typename));
                }
            }
        }
        catch (Exception e) {
            LogUtils.report(e);
        }
        return ret;
    }

    public Glycan reattachAllLabileResidues() {
        Glycan ret = this.clone();
        ret.reattachAllLabileResidues(ret.getRoot());
        return ret;
    }

    private void reattachAllLabileResidues(Residue current) {
        if (current == null) {
            return;
        }
        if (current.isLCleavage()) {
            current.getParentLinkage().setChildResidue(current.getCleavedResidue());
            current.getCleavedResidue().setParentLinkage(current.getParentLinkage());
            current.setParentLinkage(null);
            this.removeDetachedLabile(current.getCleavedResidue().getTypeName());
        } else {
            for (Linkage l : current.getChildrenLinkages()) {
                this.reattachAllLabileResidues(l.getChildResidue());
            }
        }
    }

    public static Glycan fromString(String str) {
        try {
            return GWSParser.fromString(str, new MassOptions());
        }
        catch (Exception e) {
            LogUtils.report(e);
            return null;
        }
    }

    public static Glycan fromString(String str, MassOptions default_mass_options) {
        try {
            return GWSParser.fromString(str, default_mass_options);
        }
        catch (Exception e) {
            LogUtils.report(e);
            return null;
        }
    }

    public String toString() {
        return GWSParser.toString(this, false);
    }

    public String toStringOrdered() {
        return GWSParser.toString(this, true);
    }

    public String toStringOrdered(boolean add_massopt) {
        return GWSParser.toString(this, true, add_massopt);
    }

    public String toGlycoCT() {
        return new GlycoCTParser(false).toGlycoCT(this);
    }

    public String toGlycoCTCondensed() {
        return new GlycoCTCondensedParser(false).toGlycoCTCondensed(this);
    }

    public Sugar toSugar() throws Exception {
        return new GlycoCTParser(false).toSugar(this);
    }

    public static Glycan fromGlycoCT(String str) {
        try {
            return new GlycoCTParser(false).fromGlycoCT(str, new MassOptions());
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtils.report(e);
            return null;
        }
    }

    public static Glycan fromGlycoCT(String str, MassOptions default_mass_options) {
        try {
            return new GlycoCTParser(false).fromGlycoCT(str, default_mass_options);
        }
        catch (Exception e) {
            LogUtils.report(e);
            return null;
        }
    }

    public static Glycan fromGlycoCTCondensed(String str) {
        try {
            return new GlycoCTCondensedParser(false).fromGlycoCTCondensed(str, new MassOptions());
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtils.report(e);
            return null;
        }
    }

    public static Glycan fromGlycoCTCondensed(String str, boolean tolerate_unknown) {
        try {
            return new GlycoCTCondensedParser(tolerate_unknown).fromGlycoCTCondensed(str, new MassOptions());
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtils.report(e);
            return null;
        }
    }

    public static Glycan fromGlycoCTCondensed(String str, MassOptions default_mass_options) {
        try {
            return new GlycoCTCondensedParser(false).fromGlycoCTCondensed(str, default_mass_options);
        }
        catch (Exception e) {
            LogUtils.report(e);
            return null;
        }
    }

    public static Glycan fromXML(Node s_node, MassOptions default_mass_options) throws Exception {
        Glycan ret = Glycan.fromString(XMLUtils.getAttribute(s_node, "structure"), default_mass_options);
        return ret;
    }

    public Element toXML(Document document) {
        if (document == null) {
            return null;
        }
        Element s_node = document.createElement("Glycan");
        if (s_node == null) {
            return null;
        }
        s_node.setAttribute("structure", this.toString());
        return s_node;
    }

    @Override
    public void write(TransformerHandler th) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", "structure", "CDATA", this.toString());
        th.startElement("", "", "Glycan", atts);
        th.endElement("", "", "Glycan");
    }

    @Override
    public boolean equals(MassAware aware) {
        if (!(aware instanceof Glycan)) {
            return false;
        }
        return this.toGlycoCTCondensed().equals(((Glycan)aware).toGlycoCT()) && this.computeMZ() == ((Glycan)aware).computeMZ();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static class SAXHandler
    extends SAXUtils.ObjectTreeHandler {
        private MassOptions default_mass_options;

        public SAXHandler(MassOptions _default_mass_options) {
            this.default_mass_options = _default_mass_options;
        }

        @Override
        protected boolean isElement(String namespaceURI, String localName, String qName) {
            return qName.equals(SAXHandler.getNodeElementName());
        }

        public static String getNodeElementName() {
            return "Glycan";
        }

        @Override
        protected void initContent(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            super.initContent(namespaceURI, localName, qName, atts);
            this.object = Glycan.fromString(atts.getValue("structure"), this.default_mass_options);
        }
    }
}

