/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.imageio.ImageIO;
import org.eurocarbdb.application.glycanbuilder.Data;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GlycanDocument;
import org.eurocarbdb.application.glycanbuilder.logutility.LogUtils;
import org.eurocarbdb.application.glycanbuilder.renderutil.GlycanRenderer;
import org.eurocarbdb.application.glycanbuilder.renderutil.GlycanRendererAWT;
import org.eurocarbdb.application.glycanbuilder.renderutil.SVGUtils;

public class GlycanSelection
implements Transferable {
    private static final DataFlavor[] dataFlavors;
    private static final DataFlavor[] imageFlavors;
    public static final DataFlavor stringFlavor;
    public static final DataFlavor glycoFlavor;
    public static final DataFlavor imageFlavor;
    public static final DataFlavor bmpFlavor;
    public static final DataFlavor pngFlavor;
    public static final DataFlavor jpegFlavor;
    public static final DataFlavor svgFlavor;
    private GlycanRenderer theGlycanRenderer = null;
    private Collection<Glycan> theStructures = null;
    private Data theData = null;

    public GlycanSelection(Data _data) {
        this.theData = _data;
    }

    public GlycanSelection(GlycanRenderer _glycanRenderer, Collection<Glycan> _structures) {
        this.theGlycanRenderer = _glycanRenderer;
        this.theStructures = _structures;
    }

    public GlycanSelection(Data _data, GlycanRendererAWT _glycanRenderer, Collection<Glycan> _structures) {
        this.theData = _data;
        this.theGlycanRenderer = _glycanRenderer;
        this.theStructures = _structures;
    }

    public ArrayList<DataFlavor> getTransferDataFlavorsVector() {
        int i;
        ArrayList<DataFlavor> supportedFlavors = new ArrayList<DataFlavor>();
        if (this.theData != null) {
            for (i = 0; i < dataFlavors.length; ++i) {
                supportedFlavors.add(dataFlavors[i]);
            }
        }
        if (this.theStructures != null && this.theGlycanRenderer != null) {
            for (i = 0; i < imageFlavors.length; ++i) {
                supportedFlavors.add(imageFlavors[i]);
            }
        }
        return supportedFlavors;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.getTransferDataFlavorsVector().toArray(new DataFlavor[0]);
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor parFlavor) {
        int i;
        if (parFlavor == null) {
            throw new NullPointerException();
        }
        if (this.theData != null) {
            for (i = 0; i < dataFlavors.length; ++i) {
                if (!parFlavor.equals(dataFlavors[i])) continue;
                return true;
            }
        }
        if (this.theStructures != null && this.theGlycanRenderer != null) {
            for (i = 0; i < imageFlavors.length; ++i) {
                if (!parFlavor.equals(imageFlavors[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized Object getTransferData(DataFlavor parFlavor) throws UnsupportedFlavorException, IOException {
        if (parFlavor == null) {
            throw new NullPointerException();
        }
        if (this.theData != null && parFlavor.equals(stringFlavor)) {
            return this.theData.toString();
        }
        if (this.theStructures != null && this.theGlycanRenderer != null) {
            if (parFlavor.equals(glycoFlavor)) {
                return this.getStream(this.getText().getBytes());
            }
            if (parFlavor.equals(imageFlavor)) {
                return this.getImage();
            }
            if (parFlavor.equals(bmpFlavor)) {
                return this.getImageStream("bmp");
            }
            if (parFlavor.equals(pngFlavor)) {
                return this.getImageStream("png");
            }
            if (parFlavor.equals(jpegFlavor)) {
                return this.getImageStream("jpeg");
            }
            if (parFlavor.equals(svgFlavor)) {
                return this.getStream(this.getSVG().getBytes());
            }
        }
        throw new UnsupportedFlavorException(parFlavor);
    }

    public Data getData() {
        return this.theData;
    }

    public Collection<Glycan> getStructures() {
        return this.theStructures;
    }

    public String getText() {
        return GlycanDocument.toString(this.theStructures);
    }

    public BufferedImage getImage() {
        return this.theGlycanRenderer.getImage(this.theStructures, true, this.theGlycanRenderer.getGraphicOptions().SHOW_MASSES, this.theGlycanRenderer.getGraphicOptions().SHOW_REDEND);
    }

    public InputStream getImageStream(String format) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)this.getImage(), format, bos);
            return new ByteArrayInputStream(bos.toByteArray());
        }
        catch (Exception e) {
            LogUtils.report(e);
            return null;
        }
    }

    public String getSVG() {
        return SVGUtils.getVectorGraphics((GlycanRendererAWT)this.theGlycanRenderer, this.theStructures, this.theGlycanRenderer.getGraphicOptions().SHOW_MASSES, this.theGlycanRenderer.getGraphicOptions().SHOW_MASSES);
    }

    protected InputStream getStream(byte[] buffer) {
        try {
            return new ByteArrayInputStream(buffer);
        }
        catch (Exception e) {
            LogUtils.report(e);
            return null;
        }
    }

    static {
        imageFlavors = new DataFlavor[6];
        GlycanSelection.imageFlavors[0] = glycoFlavor = new DataFlavor("application/x-glycoworkbench", "application/x-glycoworkbench");
        GlycanSelection.imageFlavors[1] = imageFlavor = DataFlavor.imageFlavor;
        GlycanSelection.imageFlavors[2] = bmpFlavor = new DataFlavor("image/bmp", "image/bmp");
        GlycanSelection.imageFlavors[3] = pngFlavor = new DataFlavor("image/png", "image/png");
        GlycanSelection.imageFlavors[4] = jpegFlavor = new DataFlavor("image/jpeg", "image/jpeg");
        GlycanSelection.imageFlavors[5] = svgFlavor = new DataFlavor("image/svg+xml", "image/svg+xml");
        dataFlavors = new DataFlavor[1];
        GlycanSelection.dataFlavors[0] = stringFlavor = DataFlavor.stringFlavor;
    }
}

