/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.opencsv.CSVReader;
import com.opencsv.CSVWriter;
import java.awt.Frame;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.eurocarbdb.application.glycanbuilder.GlycanDocument;
import org.eurocarbdb.application.glycanbuilder.util.SelectAPIDialog;
import org.eurocarbdb.application.glycanbuilder.util.UserLoginDialog;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class GlycanStructureAndChangeUser
extends JComponent {
    protected GlycanDocument theDoc;
    private JFrame theParent = null;
    private static String reg_url;
    private static String env;
    private boolean exists = false;
    private static final String accessionIdBetaApi = "https://sparqlist.glyconavi.org/api/Get_beta_accession_number_by_wurcs_text?wurcs=";
    private static final String accessionIdRealApi = "https://api.glycosmos.org/glycanformatconverter/2.7.0/wurcs2wurcs";
    private static final String registerBetaApi = "https://api.beta.glytoucan.org/glycan/register";
    private static final String registerRealApi = "https://api.glytoucan.org/glycan/register";

    public static File getConfigurationDirectory() throws IOException {
        File configurationFile;
        String userHomeDirectory = System.getProperty("user.home");
        String osName = System.getProperty("os.name");
        if (osName.equals("Linux")) {
            configurationFile = new File(userHomeDirectory + File.separator + ".GlycoWorkbench");
        } else if (osName.startsWith("Windows")) {
            String applicationDataDirectory = System.getenv("APPDATA");
            if (applicationDataDirectory == null) {
                applicationDataDirectory = userHomeDirectory + File.separator + "Application Data";
            }
            configurationFile = new File(applicationDataDirectory + File.separator + "GlycoWorkBench");
        } else {
            configurationFile = new File(userHomeDirectory + File.separator + ".GlycoWorkbench");
        }
        if (!configurationFile.exists() && !configurationFile.mkdir()) {
            throw new IOException("Could not create directory: " + configurationFile.toString());
        }
        return configurationFile;
    }

    public static File getJsonFile() throws IOException {
        File configDirectory = GlycanStructureAndChangeUser.getConfigurationDirectory();
        File creatingJsonFile = new File(configDirectory.getPath() + File.separator + "Apikey.json");
        if (!creatingJsonFile.exists()) {
            creatingJsonFile.createNewFile();
        }
        return creatingJsonFile;
    }

    public static CSVReader readCSVFile() throws IOException {
        File configDirectory = GlycanStructureAndChangeUser.getConfigurationDirectory();
        File glytoucanIDFilepath = new File(configDirectory.getPath() + File.separator + "GlytoucanIdList.csv");
        if (!glytoucanIDFilepath.exists()) {
            glytoucanIDFilepath.createNewFile();
        }
        CSVReader csvreader = new CSVReader(new FileReader(glytoucanIDFilepath));
        return csvreader;
    }

    public void onSelectAPIDialog(JFrame frame, GlycanDocument doc) {
        this.theParent = frame;
        this.theDoc = doc;
        try {
            SelectAPIDialog dig = new SelectAPIDialog(this.theParent);
            dig.setVisible(true);
            if (!dig.isCanceled()) {
                boolean isBeta = dig.getFormat().contains("beta");
                reg_url = dig.getFormat();
                String keyPath = GlycanStructureAndChangeUser.getJsonFile().toString();
                env = isBeta ? "beta" : "real";
                this.getAccessionIdorHashKey(env, keyPath, reg_url);
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
    }

    public void getAccessionIdorHashKey(String env, String keyPath, String reg_url) throws UnirestException {
        String strRegUrl;
        String strIdUrl;
        if (env == "beta") {
            strIdUrl = accessionIdBetaApi;
            strRegUrl = registerBetaApi;
        } else {
            strIdUrl = accessionIdRealApi;
            strRegUrl = registerRealApi;
        }
        try {
            ArrayList<String> sequences = this.getSequences();
            if (sequences.size() == 0) {
                JOptionPane.showMessageDialog(null, "You haven't draw the Glycan structure in the area", "GLYCAN STRUCTURE", 2);
                return;
            }
            String glycan_id = "";
            int index = 0;
            CSVReader csvreader = GlycanStructureAndChangeUser.readCSVFile();
            List<String[]> glycan_sequences = csvreader.readAll();
            csvreader.close();
            for (String sequence : sequences) {
                this.exists = false;
                String res = "";
                StringBuilder strAccId = new StringBuilder();
                if (!this.getAccessionId(strIdUrl, sequence, strAccId)) {
                    return;
                }
                String accession = strAccId.toString();
                if (accession.isEmpty() || accession == null) {
                    JSONParser jsonParser = new JSONParser();
                    StringBuilder strConId = new StringBuilder();
                    StringBuilder strApiKey = new StringBuilder();
                    boolean saveConIdandApiKey = false;
                    long fsize = new File(keyPath).length();
                    if (fsize < 1L) {
                        saveConIdandApiKey = true;
                        if (!this.inputConIdandApiKey(strConId, strApiKey)) {
                            return;
                        }
                    } else {
                        FileReader reader = new FileReader(keyPath);
                        Object obj = jsonParser.parse(reader);
                        JSONObject jsonObject = (JSONObject)obj;
                        if (!jsonObject.keySet().contains(env)) {
                            saveConIdandApiKey = true;
                            if (!this.inputConIdandApiKey(strConId, strApiKey)) {
                                return;
                            }
                        } else {
                            JSONObject obj1 = (JSONObject)jsonObject.get(env);
                            strConId.append((String)obj1.get("contributor_id"));
                            strApiKey.append((String)obj1.get("api_key"));
                        }
                    }
                    StringBuilder strHashKey = new StringBuilder();
                    int ret = this.getHashKey(strRegUrl, sequence, strConId.toString(), strApiKey.toString(), strHashKey);
                    if (ret == 2) {
                        return;
                    }
                    if (ret == 1) {
                        saveConIdandApiKey = true;
                        boolean nextAgain = true;
                        while (nextAgain) {
                            strConId = new StringBuilder();
                            strApiKey = new StringBuilder();
                            if (!this.inputConIdandApiKey(strConId, strApiKey)) {
                                return;
                            }
                            int ret1 = this.getHashKey(strRegUrl, sequence, strConId.toString(), strApiKey.toString(), strHashKey);
                            if (ret1 == 2) {
                                return;
                            }
                            if (ret1 != 0) continue;
                            nextAgain = false;
                        }
                    }
                    if (!(res = strHashKey.toString()).isEmpty()) {
                        glycan_id = glycan_id + " Hash Key of Glycan Structure" + ++index + " is \"" + res + "\"\n";
                    }
                    if (saveConIdandApiKey) {
                        this.writeConIDandApiKey(strRegUrl, strConId.toString(), strApiKey.toString());
                    }
                } else {
                    res = accession;
                    if (accession != null) {
                        glycan_id = glycan_id + " Accession ID of GlycanStructure" + ++index + " is \"" + accession + "\"\n";
                    }
                }
                glycan_sequences = this.getCSVData(res, sequence, env, glycan_sequences);
            }
            JOptionPane.showMessageDialog(null, glycan_id, "Accession ID", 1);
            this.writeCSVData(glycan_sequences);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "UnExecpted error occur.\nPlease Try again your process!", "UnExecpted Error", 0);
        }
    }

    private boolean getAccessionId(String apiUrl, String sequence, StringBuilder outputString) {
        try {
            HttpResponse<String> response = null;
            Unirest.setTimeouts(0L, 0L);
            if (env == "beta") {
                String encodedSeq = URLEncoder.encode(sequence, StandardCharsets.UTF_8.displayName());
                response = Unirest.post(apiUrl + encodedSeq).asString();
                String responseBody = response.getBody();
                if (responseBody.length() < 10) {
                    outputString.append(responseBody);
                }
            } else {
                response = Unirest.post(apiUrl).header("Content-Type", "application/x-www-form-urlencoded").field("str", sequence).asString();
                String responseBody = response.getBody();
                int responseStatus = response.getStatus();
                char status = Integer.toString(responseStatus).charAt(0);
                if ((responseStatus = Character.getNumericValue(status)) == 5) {
                    JOptionPane.showMessageDialog(null, "Server service is unavailable now", "Server Error!", 2);
                    return false;
                }
                JSONParser parser2 = new JSONParser();
                JSONObject json2 = (JSONObject)parser2.parse(responseBody);
                outputString.append((String)json2.get("id"));
            }
            return true;
        }
        catch (UnirestException e) {
            if (e.getMessage().contains("org.apache.http.conn.HttpHostConnectException")) {
                JOptionPane.showMessageDialog(null, "Server service is unavailable now", "Server Error!", 2);
            } else {
                JOptionPane.showMessageDialog(null, "Please, check your internet connection again!", "Connection Error", 0);
            }
            return false;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "UnExecpted error occur.\nPlease Try again your process!", "UnExecpted Error", 0);
            return false;
        }
    }

    private int getHashKey(String apiUrl, String sequence, String conId, String apiKey, StringBuilder outputString) {
        String ConvertString = conId + ":" + apiKey;
        byte[] encodedBytes = Base64.getEncoder().encode(ConvertString.getBytes());
        String authorization = new String(encodedBytes);
        HttpResponse<String> response = null;
        try {
            Unirest.setTimeouts(0L, 0L);
            response = Unirest.post(apiUrl).header("Content-Type", "application/json").header("Accept", "application/json").header("Authorization", "Basic " + authorization).body("{ \"sequence\": \"" + sequence + "\" }").asString();
            String responseBody = response.getBody();
            int responseStatus = response.getStatus();
            char s = Integer.toString(responseStatus).charAt(0);
            responseStatus = Character.getNumericValue(s);
            if (responseStatus == 4) {
                JOptionPane.showMessageDialog(null, "Your Contributor Id or API Key was wrong", "Key error!", 0);
                return 1;
            }
            if (responseStatus == 5) {
                JOptionPane.showMessageDialog(null, "Server service is unavailable now", "Service Unavailable Error!", 2);
                return 2;
            }
            JSONParser parser = new JSONParser();
            JSONObject json = (JSONObject)parser.parse(responseBody);
            outputString.append((String)json.get("message"));
            return 0;
        }
        catch (UnirestException e) {
            if (e.getMessage().contains("org.apache.http.conn.HttpHostConnectException")) {
                JOptionPane.showMessageDialog(null, "Server service is unavailable now", "Server Error!", 2);
            } else {
                JOptionPane.showMessageDialog(null, "Please, check your internet connection again!", "Connection Error", 0);
            }
            return 2;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "UnExecpted error occur.\nPlease Try again your process!", "UnExecpted Error", 0);
            return 2;
        }
    }

    private boolean inputConIdandApiKey(StringBuilder strConId, StringBuilder strApiKey) {
        UserLoginDialog dlg = new UserLoginDialog((Frame)this.theParent, null, null);
        boolean showAgain = true;
        while (showAgain) {
            dlg.setVisible(true);
            if (!dlg.isCanceled()) {
                if (dlg.getContributorId().isEmpty() && dlg.getApikey().isEmpty()) {
                    JOptionPane.showMessageDialog(null, "Need to insert both Contributor ID and API Key", "Mandatory Error!", 2);
                    continue;
                }
                if (dlg.getContributorId().isEmpty() && !dlg.getApikey().isEmpty()) {
                    JOptionPane.showMessageDialog(null, "Please enter Contributor ID", "Mandatory Error!", 2);
                    continue;
                }
                if (!dlg.getContributorId().isEmpty() && dlg.getApikey().isEmpty()) {
                    JOptionPane.showMessageDialog(null, "Please enter API Key", "Mandatory Error!", 2);
                    continue;
                }
                strConId.append(dlg.getContributorId());
                strApiKey.append(dlg.getApikey());
                showAgain = false;
                continue;
            }
            return false;
        }
        return true;
    }

    private boolean writeConIDandApiKey(String apiUrl, String conId, String apiKey) {
        try {
            String keyPath = GlycanStructureAndChangeUser.getJsonFile().toString();
            try {
                JSONParser jsonParser = new JSONParser();
                FileReader reader = new FileReader(GlycanStructureAndChangeUser.getJsonFile().toString());
                JSONObject jsonObject = (JSONObject)jsonParser.parse(reader);
                JSONObject envNewObj = new JSONObject();
                envNewObj.remove("contributor_id");
                envNewObj.put("contributor_id", conId);
                envNewObj.remove("api_key");
                envNewObj.put("api_key", apiKey);
                envNewObj.remove("reg_url");
                envNewObj.put("reg_url", apiUrl);
                jsonObject.put(env, envNewObj);
                FileWriter file = new FileWriter(keyPath);
                file.write(jsonObject.toJSONString());
                file.close();
                return true;
            }
            catch (ParseException e) {
                JSONObject envNewObj = new JSONObject();
                JSONObject envNewObj1 = new JSONObject();
                envNewObj.put("contributor_id", conId);
                envNewObj.put("api_key", apiKey);
                envNewObj.put("reg_url", apiUrl);
                envNewObj1.put(env, envNewObj);
                FileWriter file = new FileWriter(keyPath);
                file.write(envNewObj1.toJSONString());
                file.close();
                return true;
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "UnExecpted error occur.\nPlease Try again your process!", "UnExecpted Error", 0);
            return false;
        }
    }

    private List<String[]> getCSVData(String id, String seq, String env, List<String[]> g_seq) {
        String[] glycan_data = new String[3];
        List<String[]> glycan_sequences = g_seq;
        glycan_data[0] = id;
        glycan_data[1] = seq;
        glycan_data[2] = env;
        if (glycan_sequences != null) {
            for (int k = 0; k < glycan_sequences.size(); ++k) {
                String[] strArray = glycan_sequences.get(k);
                for (int j = 1; j < strArray.length - 1; ++j) {
                    if (!strArray[j].equalsIgnoreCase(glycan_data[1]) || !strArray[j + 1].equals(glycan_data[2])) continue;
                    glycan_sequences.set(k, glycan_data);
                    this.exists = true;
                }
            }
        }
        if (!this.exists) {
            glycan_sequences.add(glycan_data);
        }
        return glycan_sequences;
    }

    private ArrayList<String> getSequences() throws Exception {
        ArrayList<String> seq_strArr = new ArrayList<String>();
        if (this.theDoc.getStructures().size() > 0) {
            seq_strArr = this.theDoc.exportFromStructures(this.theDoc.getStructures(), "wurcs2");
        }
        return seq_strArr;
    }

    private void writeCSVData(List<String[]> glycan_sequences) {
        try {
            File configDirectory = GlycanStructureAndChangeUser.getConfigurationDirectory();
            File glytoucanIDFilepath = new File(configDirectory.getPath() + File.separator + "glytoucanIdList.csv");
            try (CSVWriter writer = new CSVWriter(new FileWriter(glytoucanIDFilepath));){
                writer.writeAll(glycan_sequences);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void changeUser() throws ParseException {
        try {
            SelectAPIDialog dig = new SelectAPIDialog(this.theParent);
            dig.setVisible(true);
            if (!dig.isCanceled()) {
                boolean isBeta = dig.getFormat().contains("beta");
                env = isBeta ? "beta" : "real";
                reg_url = dig.getFormat();
                this.showUserDialogBox();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "UnExecpted error occur.\nPlease Try again your process!", "UnExecpted Error", 0);
            return;
        }
    }

    private void showUserDialogBox() {
        String sequence = "";
        StringBuilder strConId = new StringBuilder();
        StringBuilder strApiKey = new StringBuilder();
        String strRegUrl = env == "beta" ? registerBetaApi : registerRealApi;
        if (!this.inputConIdandApiKey(strConId, strApiKey)) {
            return;
        }
        StringBuilder strHashKey = new StringBuilder();
        int ret = this.getHashKey(strRegUrl, sequence, strConId.toString(), strApiKey.toString(), strHashKey);
        if (ret == 2) {
            return;
        }
        if (ret == 1) {
            boolean nextAgain = true;
            while (nextAgain) {
                strConId = new StringBuilder();
                strApiKey = new StringBuilder();
                if (!this.inputConIdandApiKey(strConId, strApiKey)) {
                    return;
                }
                int ret1 = this.getHashKey(strRegUrl, sequence, strConId.toString(), strApiKey.toString(), strHashKey);
                if (ret1 == 2) {
                    return;
                }
                if (ret1 != 0) continue;
                nextAgain = false;
            }
        }
        if (this.writeConIDandApiKey(strRegUrl, strConId.toString(), strApiKey.toString())) {
            JOptionPane.showMessageDialog(null, "Change Successfully", "Success", 1);
        }
    }
}

