/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import org.eurocarbdb.application.glycanbuilder.DefaultPaintable;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.linkage.Linkage;
import org.eurocarbdb.application.glycanbuilder.linkage.Union;
import org.eurocarbdb.application.glycanbuilder.renderutil.BBoxManager;
import org.eurocarbdb.application.glycanbuilder.renderutil.Geometry;
import org.eurocarbdb.application.glycanbuilder.renderutil.GlycanRenderer;
import org.eurocarbdb.application.glycanbuilder.renderutil.GlycanRendererAWT;
import org.eurocarbdb.application.glycanbuilder.renderutil.PositionManager;
import org.eurocarbdb.application.glycanbuilder.util.MouseUtils;

class ResidueSelector
extends JComponent
implements MouseListener,
MouseMotionListener {
    protected static final long serialVersionUID = 0L;
    protected JScrollPane theScrollPane = null;
    protected Glycan theStructure = null;
    protected Collection<Residue> active_residues = null;
    protected boolean allow_multiple_selection;
    protected Residue current_residue;
    protected HashSet<Residue> selected_residues;
    protected GlycanRenderer theGlycanRenderer;
    protected Rectangle structure_bbox;
    protected BBoxManager theBBoxManager;
    protected PositionManager thePosManager;
    protected Point mouse_start_point = null;
    protected Point mouse_end_point = null;
    protected LinkedList<SelectionChangeListener> listeners;

    public ResidueSelector(Glycan structure, Collection<Residue> actives, boolean multiple_sel) {
        this.theStructure = structure;
        this.active_residues = actives;
        this.allow_multiple_selection = multiple_sel;
        this.current_residue = null;
        this.selected_residues = new HashSet();
        this.theGlycanRenderer = new GlycanRendererAWT();
        this.thePosManager = new PositionManager();
        this.theBBoxManager = new BBoxManager();
        this.structure_bbox = null;
        this.listeners = new LinkedList();
        this.setOpaque(true);
        this.setBackground(Color.white);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    public GlycanRenderer getGlycanRenderer() {
        return this.theGlycanRenderer;
    }

    public void setGlycanRenderer(GlycanRenderer r) {
        this.theGlycanRenderer = r;
    }

    public void setScrollPane(JScrollPane sp) {
        this.theScrollPane = sp;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.structure_bbox == null) {
            this.structure_bbox = this.theGlycanRenderer.computeBoundingBoxes(new Union<Glycan>(this.theStructure), false, true, this.thePosManager, this.theBBoxManager);
        }
        return this.theGlycanRenderer.computeSize(this.structure_bbox);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Rectangle clipRect = new Rectangle();
        g.getClipBounds(clipRect);
        if (this.mouse_start_point != null && this.mouse_end_point != null) {
            g2d.setColor(Color.black);
            g2d.draw(Geometry.makeRectangle(this.mouse_start_point, this.mouse_end_point));
        }
        this.structure_bbox = this.theGlycanRenderer.computeBoundingBoxes(new Union<Glycan>(this.theStructure), false, true, this.thePosManager, this.theBBoxManager);
        this.theGlycanRenderer.paint(new DefaultPaintable(g2d), this.theStructure, this.selected_residues, null, this.active_residues, false, true, this.thePosManager, this.theBBoxManager);
        this.revalidate();
        g2d.dispose();
    }

    public Residue getResidueAtPoint(Point p) {
        Residue ret = this.getResidueAtPoint(this.theStructure.getRoot(), p);
        if (ret != null) {
            return ret;
        }
        ret = this.getResidueAtPoint(this.theStructure.getBracket(), p);
        if (ret != null) {
            return ret;
        }
        return null;
    }

    public Residue getResidueAtPoint(Residue r, Point p) {
        if (r == null) {
            return null;
        }
        Rectangle cur_bbox = this.theBBoxManager.getCurrent(r);
        if (cur_bbox == null) {
            return null;
        }
        if (cur_bbox.contains(p)) {
            return r;
        }
        for (Linkage l : r.getChildrenLinkages()) {
            Residue ret = this.getResidueAtPoint(l.getChildResidue(), p);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public boolean hasSelection() {
        return this.selected_residues.size() > 0;
    }

    public void resetSelection() {
        this.selected_residues.clear();
        this.current_residue = null;
        this.fireUpdatedSelection();
    }

    public boolean hasCurrentSelection() {
        return this.current_residue != null;
    }

    public Residue getCurrentSelection() {
        return this.current_residue;
    }

    public boolean hasCurrentResidue() {
        return this.current_residue != null;
    }

    public Residue getCurrentResidue() {
        return this.current_residue;
    }

    private void setCurrentResidue(Residue node) {
        if (this.active_residues != null && !this.active_residues.contains(node)) {
            node = null;
        }
        if (node != null) {
            this.selected_residues.add(node);
        }
        this.current_residue = node;
        this.fireUpdatedSelection();
    }

    public boolean isSelected(Residue node) {
        if (node == null) {
            return false;
        }
        return this.selected_residues.contains(node);
    }

    public boolean hasSelectedResidues() {
        return !this.selected_residues.isEmpty();
    }

    public Collection<Residue> getSelectedResiduesList() {
        return this.selected_residues;
    }

    public Residue[] getSelectedResidues() {
        return this.selected_residues.toArray(new Residue[0]);
    }

    public void setSelection(Collection<Residue> nodes) {
        if (this.active_residues != null) {
            nodes = new Union<Residue>(this.active_residues).intersect(nodes);
        }
        if (nodes == null || nodes.isEmpty()) {
            this.resetSelection();
        } else if (nodes.size() == 1) {
            this.selected_residues.clear();
            this.current_residue = nodes.iterator().next();
            this.selected_residues.add(this.current_residue);
            this.fireUpdatedSelection();
        } else if (this.allow_multiple_selection) {
            this.selected_residues.clear();
            this.current_residue = null;
            Iterator<Residue> i = nodes.iterator();
            while (i.hasNext()) {
                this.selected_residues.add(i.next());
            }
            this.fireUpdatedSelection();
        }
    }

    public void setSelection(Residue node) {
        if (this.active_residues != null && !this.active_residues.contains(node)) {
            node = null;
        }
        if (node == null) {
            this.resetSelection();
        } else {
            this.selected_residues.clear();
            this.selected_residues.add(node);
            this.current_residue = node;
            this.fireUpdatedSelection();
        }
    }

    public void enforceSelection(Point p) {
        Residue r = this.getResidueAtPoint(p);
        if (r != null) {
            this.enforceSelection(r);
        }
    }

    public void enforceSelection(Residue node) {
        if (this.active_residues != null && !this.active_residues.contains(node)) {
            node = null;
        }
        if (this.isSelected(node)) {
            this.current_residue = node;
            this.fireUpdatedSelection();
        } else {
            this.setSelection(node);
        }
    }

    public boolean enforceSelection() {
        this.setSelection(this.theStructure.getRoot());
        return true;
    }

    public void addSelection(Collection<Residue> nodes) {
        if (this.active_residues != null) {
            nodes = new Union<Residue>(this.active_residues).intersect(nodes);
        }
        if (nodes != null && nodes.size() > 0) {
            if (this.allow_multiple_selection) {
                for (Residue node : nodes) {
                    this.selected_residues.add(node);
                }
                this.current_residue = null;
                this.fireUpdatedSelection();
            } else if (nodes.size() == 1) {
                this.setSelection(nodes.iterator().next());
            }
        }
    }

    public void addSelection(Residue node) {
        if (this.active_residues != null && !this.active_residues.contains(node)) {
            node = null;
        }
        if (node != null) {
            if (this.allow_multiple_selection) {
                this.selected_residues.add(node);
                this.current_residue = node;
                this.fireUpdatedSelection();
            } else {
                this.setSelection(node);
            }
        }
    }

    public void addSelectionPathTo(Residue node) {
        if (this.active_residues != null && !this.active_residues.contains(node)) {
            node = null;
        }
        if (node != null) {
            if (this.allow_multiple_selection) {
                if (this.current_residue == null) {
                    this.selected_residues.add(node);
                } else {
                    this.selected_residues.addAll(Glycan.getPath(this.current_residue, node));
                }
                this.current_residue = node;
                this.fireUpdatedSelection();
            } else {
                this.setSelection(node);
            }
        }
    }

    private Residue findNearest(Point p, Collection<Residue> nodes) {
        if (p == null) {
            return null;
        }
        Residue best_node = null;
        double best_dist = 0.0;
        for (Residue cur_node : nodes) {
            Rectangle cur_rect = this.theBBoxManager.getCurrent(cur_node);
            double cur_dist = Geometry.distance(p, cur_rect);
            if (best_node != null && !(best_dist > cur_dist)) continue;
            best_node = cur_node;
            best_dist = cur_dist;
        }
        return best_node;
    }

    public void goToStart() {
        if (this.theScrollPane != null) {
            JViewport vp = this.theScrollPane.getViewport();
            vp.setViewPosition(new Point(0, 0));
            vp.setViewPosition(new Point(0, 0));
        }
    }

    public void goToEnd() {
        if (this.theScrollPane != null) {
            JViewport vp = this.theScrollPane.getViewport();
            Dimension all = this.getPreferredSize();
            Dimension view = vp.getExtentSize();
            vp.setViewPosition(new Point(0, all.height - view.height));
            vp.setViewPosition(new Point(0, all.height - view.height));
        }
    }

    public void onNavigateUp() {
        Residue current = this.getCurrentSelection();
        if (current == null) {
            this.setSelection(this.theStructure.getRoot());
        } else {
            Residue best_node = this.theBBoxManager.getNearestUp(current);
            if (best_node != null) {
                this.setSelection(best_node);
            }
        }
    }

    public void onNavigateDown() {
        Residue current = this.getCurrentSelection();
        if (current == null) {
            this.setSelection(this.theStructure.getRoot());
        } else {
            Residue best_node = this.theBBoxManager.getNearestDown(current);
            if (best_node != null) {
                this.setSelection(best_node);
            }
        }
    }

    public void onNavigateLeft() {
        Residue current = this.getCurrentSelection();
        if (current == null) {
            this.setSelection(this.theStructure.getRoot());
        } else {
            Residue best_node = this.theBBoxManager.getNearestLeft(current);
            if (best_node != null) {
                this.setSelection(best_node);
            }
        }
    }

    public void onNavigateRight() {
        Residue current = this.getCurrentSelection();
        if (current == null) {
            this.setSelection(this.theStructure.getRoot());
        } else {
            Residue best_node = this.theBBoxManager.getNearestRight(current);
            if (best_node != null) {
                this.setSelection(best_node);
            }
        }
    }

    public void addSelectionChangeListener(SelectionChangeListener l) {
        if (l != null) {
            this.listeners.add(l);
        }
    }

    public void removeSelectionChangeListener(SelectionChangeListener l) {
        if (l != null) {
            this.listeners.remove(l);
        }
    }

    public void fireUpdatedSelection() {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((SelectionChangeListener)i.next()).selectionChanged(new SelectionChangeEvent(this));
        }
        this.repaint();
        this.showSelection();
    }

    public void showSelection() {
        if (this.theScrollPane == null) {
            return;
        }
        this.theGlycanRenderer.computeBoundingBoxes(new Union<Glycan>(this.theStructure), false, true, this.thePosManager, this.theBBoxManager);
        Rectangle bbox = null;
        for (Residue r : this.selected_residues) {
            bbox = Geometry.union(bbox, this.theBBoxManager.getCurrent(r));
        }
        if (bbox != null) {
            int max_move;
            int min_move;
            bbox = Geometry.expand(bbox, 5);
            Rectangle view = this.theScrollPane.getViewport().getViewRect();
            int new_x = Geometry.left(view);
            int new_y = Geometry.top(view);
            if (Geometry.left(view) > Geometry.left(bbox)) {
                new_x = Geometry.left(bbox);
            } else if (Geometry.right(view) < Geometry.right(bbox)) {
                min_move = Geometry.right(bbox) - Geometry.right(view);
                max_move = Geometry.left(bbox) - Geometry.left(view);
                new_x += Math.min(min_move, max_move);
            }
            if (Geometry.top(view) > Geometry.top(bbox)) {
                new_y = Geometry.top(bbox);
            } else if (Geometry.bottom(view) < Geometry.bottom(bbox)) {
                min_move = Geometry.bottom(bbox) - Geometry.bottom(view);
                max_move = Geometry.top(bbox) - Geometry.top(view);
                new_y += Math.min(min_move, max_move);
            }
            this.theScrollPane.getViewport().setViewPosition(new Point(new_x, new_y));
            this.theScrollPane.getViewport().setViewPosition(new Point(new_x, new_y));
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (MouseUtils.isPushTrigger(e) || MouseUtils.isCtrlPushTrigger(e)) {
            this.mouse_start_point = e.getPoint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.mouse_start_point != null) {
            this.mouse_end_point = e.getPoint();
            this.repaint();
            this.dragAndScroll(e);
        }
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.mouse_end_point != null) {
            Rectangle mouse_rect = Geometry.makeRectangle(this.mouse_start_point, this.mouse_end_point);
            if (MouseUtils.isNothingPressed(e)) {
                this.setSelection(this.theBBoxManager.getNodesInside(mouse_rect));
            } else if (MouseUtils.isCtrlPressed(e)) {
                this.addSelection(this.theBBoxManager.getNodesInside(mouse_rect));
            }
            this.setCurrentResidue(this.findNearest(e.getPoint(), this.selected_residues));
        }
        this.repaint();
        this.mouse_start_point = null;
        this.mouse_end_point = null;
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Residue r = this.getResidueAtPoint(e.getPoint());
        if (r != null) {
            if (MouseUtils.isSelectTrigger(e)) {
                this.setSelection(r);
            } else if (MouseUtils.isAddSelectTrigger(e)) {
                this.addSelection(r);
            } else if (MouseUtils.isSelectAllTrigger(e)) {
                this.addSelectionPathTo(r);
            }
        } else if (MouseUtils.isSelectTrigger(e) || MouseUtils.isAddSelectTrigger(e) || MouseUtils.isSelectAllTrigger(e)) {
            this.resetSelection();
        }
    }

    private void dragAndScroll(MouseEvent e) {
        if (this.theScrollPane == null) {
            return;
        }
        Point point = e.getPoint();
        JViewport view = this.theScrollPane.getViewport();
        Rectangle inner = view.getViewRect();
        inner.grow(-10, -10);
        if (!inner.contains(point)) {
            Point orig = view.getViewPosition();
            if (point.x < inner.x) {
                orig.x -= 10;
            } else if (point.x > inner.x + inner.width) {
                orig.x += 10;
            }
            if (point.y < inner.y) {
                orig.y -= 10;
            } else if (point.y > inner.y + inner.height) {
                orig.y += 10;
            }
            int maxx = this.getBounds().width - view.getViewRect().width;
            int maxy = this.getBounds().height - view.getViewRect().height;
            if (orig.x < 0) {
                orig.x = 0;
            }
            if (orig.x > maxx) {
                orig.x = maxx;
            }
            if (orig.y < 0) {
                orig.y = 0;
            }
            if (orig.y > maxy) {
                orig.y = maxy;
            }
            view.setViewPosition(orig);
        }
    }

    public static class SelectionChangeEvent {
        private ResidueSelector src;

        public SelectionChangeEvent(ResidueSelector _src) {
            this.src = _src;
        }

        public ResidueSelector getSource() {
            return this.src;
        }
    }

    public static interface SelectionChangeListener {
        public void selectionChanged(SelectionChangeEvent var1);
    }
}

