/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GlycanAction;
import org.eurocarbdb.application.glycanbuilder.ICON_SIZE;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.ResidueSelector;
import org.eurocarbdb.application.glycanbuilder.ThemeManager;
import org.eurocarbdb.application.glycanbuilder.renderutil.GlycanRenderer;
import org.eurocarbdb.application.glycanbuilder.util.EscapeDialog;

public class ResidueSelectorDialog
extends EscapeDialog
implements ResidueSelector.SelectionChangeListener,
ActionListener {
    private ResidueSelector theSelector;
    private JLabel theMessage;
    private JButton ok_button;
    private JButton cancel_button;

    public ResidueSelectorDialog(JFrame parent, String title, String message, Glycan structure, Collection<Residue> actives, boolean multiple_sel, GlycanRenderer gr) {
        super(parent, title, true);
        this.getContentPane().setLayout(new BorderLayout());
        this.theMessage = new JLabel(message);
        this.theMessage.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.getContentPane().add((Component)this.theMessage, "North");
        this.theSelector = new ResidueSelector(structure, actives, multiple_sel);
        this.theSelector.setGlycanRenderer(gr);
        this.theSelector.setBorder(new BevelBorder(1));
        this.getContentPane().add((Component)this.theSelector, "Center");
        JPanel buttons_panel = new JPanel(new FlowLayout());
        this.ok_button = new JButton(new GlycanAction("OK", ThemeManager.getResizableEmptyIcon(ICON_SIZE.L3), "OK", -1, "", this));
        this.cancel_button = new JButton(new GlycanAction("Cancel", ThemeManager.getResizableEmptyIcon(ICON_SIZE.L3), "Cancel", -1, "", this));
        buttons_panel.add(this.ok_button);
        buttons_panel.add(this.cancel_button);
        this.getContentPane().add((Component)buttons_panel, "South");
        this.getRootPane().setDefaultButton(this.ok_button);
        this.updateActions();
        this.theSelector.addSelectionChangeListener(this);
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(parent);
    }

    public boolean isCanceled() {
        return this.return_status.equals("Cancel");
    }

    public Collection<Residue> getSelectedResidues() {
        return this.theSelector.getSelectedResiduesList();
    }

    public Residue getCurrentResidue() {
        return this.theSelector.getCurrentResidue();
    }

    private void updateActions() {
        this.ok_button.getAction().setEnabled(this.theSelector.hasSelection());
    }

    @Override
    public void selectionChanged(ResidueSelector.SelectionChangeEvent e) {
        this.updateActions();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = GlycanAction.getAction(e);
        if (action.equals("OK")) {
            this.return_status = action;
            this.setVisible(false);
        } else if (action.equals("Cancel")) {
            this.return_status = action;
            this.setVisible(false);
        }
    }
}

