/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.text.DecimalFormat;
import java.util.Collection;
import java.util.LinkedList;
import org.eurocarbdb.application.glycanbuilder.massutil.MassUtils;
import org.eurocarbdb.application.glycanbuilder.massutil.Molecule;
import org.eurocarbdb.application.glycanbuilder.util.TextUtils;

public class ResidueType {
    protected String name;
    protected String superclass;
    protected String composition_class;
    protected String composition;
    protected String[] synonyms;
    protected String iupac_name;
    protected char anomeric_carbon;
    protected char chirality;
    protected char ring_size;
    protected boolean is_saccharide;
    protected boolean is_cleavable;
    protected boolean is_labile;
    protected int bar_order;
    protected double res_mass_main;
    protected double res_mass_avg;
    protected int nmethyls;
    protected boolean drop_methylated;
    protected int nacetyls;
    protected boolean drop_acetylated;
    protected int nlinkages;
    protected char[] linkage_pos;
    protected char[] charges_pos;
    protected boolean make_alditol;
    protected boolean can_redend;
    protected boolean can_parent;
    protected boolean isMSDefault;
    protected String msDefaultDesc;
    protected String description;
    protected Molecule molecule;

    public ResidueType() {
        this.name = "#empty";
        this.superclass = "special";
        this.composition_class = null;
        this.composition = "?";
        this.synonyms = new String[0];
        this.iupac_name = "-";
        this.anomeric_carbon = (char)63;
        this.chirality = (char)63;
        this.ring_size = (char)63;
        this.is_saccharide = false;
        this.is_cleavable = false;
        this.is_labile = false;
        this.bar_order = 0;
        this.res_mass_main = 0.0;
        this.res_mass_avg = 0.0;
        this.nmethyls = 0;
        this.drop_methylated = false;
        this.nacetyls = 0;
        this.drop_acetylated = false;
        this.nlinkages = 1;
        this.linkage_pos = new char[0];
        this.charges_pos = new char[0];
        this.make_alditol = false;
        this.can_redend = false;
        this.can_parent = false;
        this.isMSDefault = false;
        this.msDefaultDesc = "Empty";
        this.description = "Empty";
        this.molecule = null;
    }

    public ResidueType(String init) throws Exception {
        LinkedList<String> tokens = TextUtils.tokenize(init, "\t");
        if (tokens.size() != 26) {
            throw new Exception("Invalid string format: " + init);
        }
        this.name = tokens.get(0);
        this.superclass = tokens.get(1);
        this.composition_class = tokens.get(2);
        this.composition = tokens.get(3);
        this.synonyms = this.parseStringArray(tokens.get(4));
        this.iupac_name = tokens.get(5);
        this.anomeric_carbon = tokens.get(6).charAt(0);
        this.chirality = tokens.get(7).charAt(0);
        this.ring_size = tokens.get(8).charAt(0);
        this.is_saccharide = this.parseBoolean(tokens.get(9));
        this.is_cleavable = this.parseBoolean(tokens.get(10));
        this.is_labile = this.parseBoolean(tokens.get(11));
        this.bar_order = Integer.parseInt(tokens.get(12));
        this.nmethyls = Integer.parseInt(tokens.get(13));
        this.drop_methylated = this.parseBoolean(tokens.get(14));
        this.nacetyls = Integer.parseInt(tokens.get(15));
        this.drop_acetylated = this.parseBoolean(tokens.get(16));
        this.nlinkages = Integer.parseInt(tokens.get(17));
        this.linkage_pos = this.parseCharArray(tokens.get(18));
        this.charges_pos = this.parseCharArray(tokens.get(19));
        this.make_alditol = this.parseBoolean(tokens.get(20));
        this.can_redend = this.parseBoolean(tokens.get(21));
        this.can_parent = this.parseBoolean(tokens.get(22));
        this.isMSDefault = this.parseBoolean(tokens.get(23));
        this.msDefaultDesc = tokens.get(24);
        this.description = tokens.get(25);
        this.res_mass_main = 0.0;
        this.res_mass_avg = 0.0;
        this.updateMolecule();
        if (this.bar_order > 9 || this.bar_order < 0) {
            throw new Exception("Invalid toolbar order: " + this.bar_order);
        }
    }

    protected boolean parseBoolean(String str) {
        return str.equals("true") || str.equals("yes");
    }

    protected char[] parseCharArray(String str) throws Exception {
        if (str.equals("-") || str.equals("none") || str.equals("empty")) {
            return new char[0];
        }
        LinkedList<String> tokens = TextUtils.tokenize(str, ",");
        int ind = 0;
        char[] pos = new char[tokens.size()];
        for (String token : tokens) {
            if (token.length() != 1) {
                throw new Exception("Linkage position must be a single char");
            }
            pos[ind] = token.charAt(0);
            ++ind;
        }
        return pos;
    }

    protected String[] parseStringArray(String str) throws Exception {
        if (str.equals("-") || str.equals("none") || str.equals("empty")) {
            return new String[0];
        }
        return TextUtils.tokenize(str, ",").toArray(new String[0]);
    }

    public static ResidueType createUnknown(String _name) {
        ResidueType ret = new ResidueType();
        ret.name = _name;
        ret.superclass = "Unknown";
        ret.nlinkages = 10;
        ret.linkage_pos = new char[]{'1', '2', '3', '4', '6', '7', '8', '9', 'N'};
        ret.can_redend = true;
        ret.can_parent = true;
        ret.description = _name;
        return ret;
    }

    public static ResidueType createUnknown(String _name, String _composition) {
        ResidueType ret = new ResidueType();
        ret.name = _name;
        ret.superclass = "Unknown";
        ret.composition = _composition;
        ret.nlinkages = 10;
        ret.linkage_pos = new char[]{'1', '2', '3', '4', '6', '7', '8', '9', 'N'};
        ret.can_redend = true;
        ret.can_parent = true;
        ret.msDefaultDesc = _name;
        ret.description = _name;
        ret.updateMolecule();
        return ret;
    }

    public static ResidueType createCerReducingEnd() {
        ResidueType ret = new ResidueType();
        ret.name = "Cer";
        ret.superclass = "Reducing end";
        ret.composition_class = "Cer";
        ret.composition = "";
        ret.nmethyls = 1;
        ret.nacetyls = 1;
        ret.nlinkages = 1;
        ret.can_redend = true;
        ret.can_parent = true;
        ret.isMSDefault = true;
        ret.msDefaultDesc = "Cer";
        ret.description = "Cer reducing end";
        ret.updateMolecule();
        return ret;
    }

    public static ResidueType createOtherReducingEnd(String name, double mass) {
        if ((name = TextUtils.trim(name)) == null || name.length() == 0) {
            name = "XXX";
        }
        ResidueType ret = new ResidueType();
        ret.name = name + "=" + new DecimalFormat("0.0000").format(mass) + "u";
        ret.superclass = "Reducing end";
        ret.res_mass_main = mass + MassUtils.water.getMainMass();
        ret.res_mass_avg = mass + MassUtils.water.getAverageMass();
        ret.nmethyls = 1;
        ret.nacetyls = 1;
        ret.nlinkages = 1;
        ret.can_redend = true;
        ret.can_parent = true;
        ret.isMSDefault = true;
        ret.msDefaultDesc = "Other";
        ret.description = "Other reducing end";
        return ret;
    }

    public static ResidueType createOtherResidue(String name, double mass) {
        if ((name = TextUtils.trim(name)) == null || name.length() == 0) {
            name = "Or";
        }
        ResidueType ret = new ResidueType();
        ret.name = name + "=" + new DecimalFormat("0.0000").format(mass) + "u";
        ret.superclass = "Residue";
        ret.res_mass_main = mass + MassUtils.water.getMainMass();
        ret.res_mass_avg = mass + MassUtils.water.getAverageMass();
        ret.nmethyls = 1;
        ret.nacetyls = 1;
        ret.nlinkages = 1;
        ret.can_redend = false;
        ret.can_parent = true;
        ret.isMSDefault = true;
        ret.msDefaultDesc = "Other";
        ret.description = "Other residue";
        return ret;
    }

    public static ResidueType createAttachPoint() {
        ResidueType ret = new ResidueType();
        ret.name = "#attach";
        ret.description = "Attach Point";
        ret.composition = "0";
        ret.nlinkages = 2;
        ret.can_parent = true;
        ret.can_redend = false;
        ret.updateMolecule();
        return ret;
    }

    public static ResidueType createBracket() {
        ResidueType ret = new ResidueType();
        ret.name = "#bracket";
        ret.description = "Bracket";
        ret.composition = "0";
        ret.nlinkages = 99;
        ret.updateMolecule();
        return ret;
    }

    public static ResidueType createYCleavage() {
        ResidueType ret = new ResidueType();
        ret.name = "#ycleavage";
        ret.description = "Y Cleavage";
        ret.superclass = "cleavage";
        ret.composition = "H2O";
        ret.can_redend = false;
        ret.can_parent = true;
        ret.updateMolecule();
        return ret;
    }

    public static ResidueType createBCleavage() {
        ResidueType ret = new ResidueType();
        ret.name = "#bcleavage";
        ret.description = "B Cleavage";
        ret.superclass = "cleavage";
        ret.composition = "0";
        ret.can_redend = true;
        ret.can_parent = false;
        ret.updateMolecule();
        return ret;
    }

    public static ResidueType createZCleavage() {
        ResidueType ret = new ResidueType();
        ret.name = "#zcleavage";
        ret.description = "Z Cleavage";
        ret.superclass = "cleavage";
        ret.composition = "";
        ret.can_redend = false;
        ret.can_parent = true;
        ret.updateMolecule();
        return ret;
    }

    public static ResidueType createCCleavage() {
        ResidueType ret = new ResidueType();
        ret.name = "#ccleavage";
        ret.description = "C Cleavage";
        ret.superclass = "cleavage";
        ret.composition = "H2O";
        ret.can_redend = true;
        ret.can_parent = false;
        ret.updateMolecule();
        return ret;
    }

    public static ResidueType createLCleavage() {
        ResidueType ret = new ResidueType();
        ret.name = "#lcleavage";
        ret.description = "L Cleavage";
        ret.superclass = "cleavage";
        ret.composition = "H2O";
        ret.can_redend = false;
        ret.can_parent = true;
        ret.updateMolecule();
        return ret;
    }

    public static ResidueType createStartRepetition() {
        ResidueType ret = new ResidueType();
        ret.name = "#startrep";
        ret.description = "Start repetition";
        ret.nlinkages = 2;
        ret.can_parent = true;
        return ret;
    }

    public static ResidueType createEndRepetition() {
        return ResidueType.createEndRepetition(null, null);
    }

    public static ResidueType createEndRepetition(String min, String max) {
        ResidueType ret = new ResidueType();
        ret.name = "#endrep";
        ret.name = ret.name + "_" + (TextUtils.isPositiveInteger(min) ? min : "?");
        ret.name = ret.name + "_" + (TextUtils.isPositiveInteger(max) ? max : "?");
        ret.description = "End repetition";
        ret.nlinkages = 999;
        ret.can_parent = true;
        return ret;
    }

    public int getMinRepetitions() {
        if (!this.isEndRepetition()) {
            return -1;
        }
        String min_str = TextUtils.tokenize(this.name, "_").get(1);
        if (min_str.equals("?")) {
            return -1;
        }
        return Integer.parseInt(min_str);
    }

    public void setMinRepetitions(String min) {
        if (!this.isEndRepetition()) {
            return;
        }
        String new_name = "#endrep";
        new_name = new_name + "_" + (TextUtils.isPositiveInteger(min) ? min : "?");
        this.name = new_name = new_name + "_" + this.getMaxRepetitions();
    }

    public int getMaxRepetitions() {
        if (!this.isEndRepetition()) {
            return -1;
        }
        String max_str = TextUtils.tokenize(this.name, "_").get(2);
        if (max_str.equals("?")) {
            return -1;
        }
        return Integer.parseInt(max_str);
    }

    public void setMaxRepetitions(String max) {
        if (!this.isEndRepetition()) {
            return;
        }
        String new_name = "#endrep";
        new_name = new_name + "_" + this.getMinRepetitions();
        this.name = new_name = new_name + "_" + (TextUtils.isPositiveInteger(max) ? max : "?");
    }

    public static ResidueType createStartCyclic() {
        ResidueType ret = new ResidueType();
        ret.name = "#startcyclic";
        ret.superclass = "Cyclic";
        ret.description = "Start cyclic";
        ret.nlinkages = 2;
        ret.can_parent = true;
        ret.can_redend = false;
        return ret;
    }

    public static ResidueType createEndCyclic() {
        ResidueType ret = new ResidueType();
        ret.name = "#endcyclic";
        ret.superclass = "Cyclic";
        ret.description = "End cyclic";
        ret.nlinkages = 999;
        ret.can_parent = false;
        return ret;
    }

    public static ResidueType createAlternativeStart() {
        ResidueType a_oAltStart = new ResidueType();
        a_oAltStart.name = "#altstart";
        a_oAltStart.superclass = "Alternative";
        a_oAltStart.description = "Alternative Start";
        a_oAltStart.can_parent = true;
        a_oAltStart.can_redend = false;
        return a_oAltStart;
    }

    public static ResidueType createAlternativeEnd() {
        ResidueType a_oAltEnd = new ResidueType();
        a_oAltEnd.name = "#altend";
        a_oAltEnd.superclass = "Alternative";
        a_oAltEnd.description = "Alternative End";
        a_oAltEnd.nlinkages = 1;
        a_oAltEnd.can_parent = true;
        return a_oAltEnd;
    }

    public boolean isFreeReducingEnd() {
        return this.name.equals("freeEnd") || this.name.equals("Cer");
    }

    public boolean isReducingEndMarker() {
        return this.name.equals("#freeEnd") || this.name.equals("#redEnd") || this.name.equals("#Cer");
    }

    public boolean isAttachPoint() {
        return this.name.equals("#attach");
    }

    public boolean isSaccharide() {
        return this.is_saccharide;
    }

    public boolean isCleavable() {
        return this.is_cleavable;
    }

    public boolean isLabile() {
        return this.is_labile;
    }

    public boolean isSubstituent() {
        return this.superclass.equals("Substituent");
    }

    public boolean isModification() {
        return this.superclass.equals("Modification");
    }

    public boolean isSpecial() {
        return this.name.startsWith("#");
    }

    public boolean isRepetition() {
        return this.isStartRepetition() | this.isEndRepetition();
    }

    public boolean isStartRepetition() {
        return this.name.equals("#startrep");
    }

    public boolean isEndRepetition() {
        return this.name.startsWith("#endrep");
    }

    public boolean isStartCyclic() {
        return this.name.startsWith("#startcyclic");
    }

    public boolean isEndCyclic() {
        return this.name.startsWith("#endcyclic");
    }

    public boolean isBracket() {
        return this.name.equals("#bracket");
    }

    public boolean isBridge() {
        return this.superclass.equals("Bridge");
    }

    public boolean isCleavage() {
        return this.superclass.equals("cleavage");
    }

    public boolean isGlycosidicCleavage() {
        return this.isBCleavage() || this.isCCleavage() || this.isYCleavage() || this.isZCleavage();
    }

    public String getCleavageType() {
        String ret = "";
        if (this.isCleavage()) {
            ret = "" + Character.toUpperCase(this.name.charAt(1));
            if (this.isACleavage() || this.isXCleavage()) {
                ret = ret + this.name.substring(10);
            }
        }
        return ret;
    }

    public boolean isACleavage() {
        return this.name.startsWith("#acleavage");
    }

    public boolean isBCleavage() {
        return this.name.equals("#bcleavage");
    }

    public boolean isCCleavage() {
        return this.name.equals("#ccleavage");
    }

    public boolean isXCleavage() {
        return this.name.startsWith("#xcleavage");
    }

    public boolean isYCleavage() {
        return this.name.equals("#ycleavage");
    }

    public boolean isZCleavage() {
        return this.name.equals("#zcleavage");
    }

    public boolean isLCleavage() {
        return this.name.equals("#lcleavage");
    }

    public boolean isRingFragment() {
        return this.isACleavage() || this.isXCleavage();
    }

    public boolean isValidPosition(char pos) {
        if (this.linkage_pos.length > 0 && pos != '0') {
            for (int i = 0; i < this.linkage_pos.length; ++i) {
                if (this.linkage_pos[i] != pos) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean areValidPositions(Collection<Character> poss) {
        for (Character pos : poss) {
            boolean found = false;
            for (int i = 0; i < this.linkage_pos.length && !found; ++i) {
                if (this.linkage_pos[i] != pos.charValue()) continue;
                found = true;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public boolean anyValidPosition(Collection<Character> poss) {
        for (Character pos : poss) {
            for (int i = 0; i < this.linkage_pos.length; ++i) {
                if (this.linkage_pos[i] != pos.charValue()) continue;
                return true;
            }
        }
        return false;
    }

    protected void updateMolecule() {
        try {
            if (this.composition.equals("?")) {
                return;
            }
            this.molecule = new Molecule(this.composition);
            this.res_mass_main = this.molecule.getMainMass();
            this.res_mass_avg = this.molecule.getAverageMass();
        }
        catch (Exception e) {
            this.molecule = null;
        }
    }

    public boolean isCustomType() {
        return this.name.indexOf("=") != -1;
    }

    public String getName() {
        return this.name;
    }

    public String getResidueName() {
        if (this.isCustomType()) {
            return this.name.split("=")[0];
        }
        return this.name;
    }

    public String getCompositionClass() {
        if (this.composition_class != null && this.composition_class.length() > 0 && !this.composition_class.equals("-")) {
            return this.composition_class;
        }
        return this.name;
    }

    public String getMSDefaultDescriptor() {
        return this.msDefaultDesc;
    }

    public String getComposition() {
        return this.composition;
    }

    public String[] getSynonyms() {
        return this.synonyms;
    }

    public String getIupacName() {
        return this.iupac_name;
    }

    public boolean hasIupacName() {
        return !this.iupac_name.equals("-");
    }

    public boolean hasChirality() {
        return this.chirality != '?';
    }

    public String getSuperclass() {
        return this.superclass;
    }

    public char getAnomericCarbon() {
        return this.anomeric_carbon;
    }

    public char getChirality() {
        return this.chirality;
    }

    public char getRingSize() {
        return this.ring_size;
    }

    public int getToolbarOrder() {
        return this.bar_order;
    }

    public void setResidueMassMain(double mass) {
        this.res_mass_main = mass;
    }

    public double getResidueMassMain() {
        return this.res_mass_main;
    }

    public void setResidueMassAvg(double mass) {
        this.res_mass_avg = mass;
    }

    public double getResidueMassAvg() {
        return this.res_mass_avg;
    }

    public double getMass() {
        return this.res_mass_main;
    }

    public int getNoMethyls() {
        return this.nmethyls;
    }

    public boolean isDroppedWithMethylation() {
        return this.drop_methylated;
    }

    public int getNoAcetyls() {
        return this.nacetyls;
    }

    public boolean isDroppedWithAcetylation() {
        return this.drop_acetylated;
    }

    public int getMaxLinkages() {
        return this.nlinkages;
    }

    public char[] getLinkagePositions() {
        return this.linkage_pos;
    }

    public char[] getChargePositions() {
        return this.charges_pos;
    }

    public int getNoCharges() {
        return this.charges_pos.length;
    }

    public boolean makesAlditol() {
        return this.make_alditol;
    }

    public boolean canBeReducingEnd() {
        return this.can_redend;
    }

    public boolean canHaveChildren() {
        return this.nlinkages > 1;
    }

    public boolean canHaveParent() {
        return this.can_parent;
    }

    public boolean isMSDefault() {
        return this.isMSDefault;
    }

    public String getDescription() {
        return this.description;
    }

    public void changeDescription(String a_sNotation) {
        this.description = a_sNotation;
    }

    public Molecule getMolecule() {
        return this.molecule;
    }

    public String toString() {
        return this.description;
    }
}

