/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder.converterGlycoCT;

import java.util.Map;
import java.util.TreeMap;
import org.eurocarbdb.MolecularFramework.io.CarbohydrateSequenceEncoding;
import org.eurocarbdb.MolecularFramework.io.SugarExporterFactory;
import org.eurocarbdb.MolecularFramework.io.SugarImporterFactory;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.converterGlycoCT.GlycoCTParser;
import org.eurocarbdb.application.glycanbuilder.logutility.LogUtils;
import org.eurocarbdb.application.glycanbuilder.massutil.MassOptions;

public class MolecularFrameworkParser
extends GlycoCTParser {
    private CarbohydrateSequenceEncoding encoding = null;

    public static Map<String, String> getImportFormats() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (CarbohydrateSequenceEncoding cse : SugarImporterFactory.getSupportedEncodings()) {
            map.put(cse.getId(), cse.getName());
        }
        return map;
    }

    public static Map<String, String> getExportFormats() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (CarbohydrateSequenceEncoding cse : SugarExporterFactory.getSupportedEncodings()) {
            map.put(cse.getId(), cse.getName());
        }
        return map;
    }

    public static Map<String, String> getFormats() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (CarbohydrateSequenceEncoding cse : SugarImporterFactory.getSupportedEncodings()) {
            map.put(cse.getId(), cse.getName());
        }
        for (CarbohydrateSequenceEncoding cse : SugarExporterFactory.getSupportedEncodings()) {
            map.put(cse.getId(), cse.getName());
        }
        return map;
    }

    public static boolean isSequenceFormat(String format) {
        try {
            return CarbohydrateSequenceEncoding.forId(format) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public MolecularFrameworkParser(String format) {
        super(false);
        try {
            this.encoding = CarbohydrateSequenceEncoding.forId(format);
        }
        catch (Exception e) {
            LogUtils.report(e);
        }
    }

    @Override
    public String writeGlycan(Glycan structure) {
        try {
            Sugar s = this.toSugar(structure);
            return SugarExporterFactory.exportSugar(s, this.encoding);
        }
        catch (Exception e) {
            LogUtils.report(e);
            return "";
        }
    }

    @Override
    public Glycan readGlycan(String buffer, MassOptions default_mass_options) throws Exception {
        Sugar s = SugarImporterFactory.importSugar(buffer, this.encoding);
        return this.fromSugar(s, default_mass_options);
    }
}

