/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder.dataset;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eurocarbdb.application.glycanbuilder.Configuration;
import org.eurocarbdb.application.glycanbuilder.dataset.ResidueDictionary;

public class DictionaryConfiguration {
    public static String RESIDUE_TYPES_FILE = "residueTypesFile";
    public static String TERMINAL_TYPES_FILE = "terminalTypesFile";
    public static String CORE_TYPES_FILE = "coreTypesFile";
    public static String CROSS_RING_FRAGMENT_TYPES_FILE = "crossRingFragmentTypesFile";
    public static String CROSS_LINKED_SUBSTITUENT_TYPES_FILE = "crossLinkedSubstituentTypesFile";
    public static String NON_SYMBOLIC_RESIDUE_TYPES_FILE = "nonSymbolicResidueTypesFile";
    public static String UOXF_RESIDUE_PLACEMENTS_FILE = "uoxf_residuePlacementsFile";
    public static String UOXF_RESIDUE_STYLES_FILE = "uoxf_residueStylesFile";
    public static String UOXF_LINKAGE_STYLES_FILE = "uoxf_linkageStylesFile";
    public static String UOXFCOL_RESIDUE_PLACEMENTS_FILE = "uoxfcol_residuePlacementsFile";
    public static String UOXFCOL_RESIDUE_STYLES_FILE = "uoxfcol_residueStylesFile";
    public static String UOXFCOL_LINKAGE_STYLES_FILE = "uoxfcol_linkageStylesFile";
    public static String TEXT_RESIDUE_PLACEMENTS_FILE = "text_residuePlacementsFile";
    public static String TEXT_RESIDUE_STYLES_FILE = "text_residueStylesFile";
    public static String TEXT_LINKAGE_STYLES_FILE = "text_linkageStylesFile";
    public static String CFGLINK_RESIDUE_PLACEMENTS_FILE = "cfgLink_residuePlacementsFile";
    public static String CFGLINK_RESIDUE_STYLES_FILE = "cfgLink_residueStylesFile";
    public static String CFGLINK_LINKAGE_STYLES_FILE = "cfgLink_linkageStylesFile";
    public static String CFG_RESIDUE_PLACEMENTS_FILE = "cfg_residuePlacementsFile";
    public static String CFG_RESIDUE_STYLES_FILE = "cfg_residueStylesFile";
    public static String CFG_LINKAGE_STYLES_FILE = "cfg_linkageStylesFile";
    public static String CFGBW_RESIDUE_PLACEMENTS_FILE = "cfgBW_residuePlacementsFile";
    public static String CFGBW_RESIDUE_STYLES_FILE = "cfgBW_residueStylesFile";
    public static String CFGBW_LINKAGE_STYLES_FILE = "cfgBW_linkageStylesFile";
    public static String SNFG_RESIDUE_PLACEMENTS_FILE = "snfg_residuePlacementsFile";
    public static String SNFG_RESIDUE_STYLES_FILE = "snfg_residueStylesFile";
    public static String SNFG_LINKAGE_STYLES_FILE = "snfg_linkageStylesFile";
    private HashMap<String, String> keyToFile = new HashMap<String, String>(){

        @Override
        public String get(Object key) {
            if (this.containsKey(key)) {
                return (String)super.get(key);
            }
            return "";
        }
    };
    public static String DICT_SECT = "dictionaries";

    public DictionaryConfiguration() {
        for (String dictionaryName : DictionaryConfiguration.getDictionaryNameList()) {
            this.keyToFile.put(dictionaryName, DictionaryConfiguration.getDefaultDictionaryFile(dictionaryName));
        }
    }

    public static List<String> getDictionaryNameList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(RESIDUE_TYPES_FILE);
        list.add(TERMINAL_TYPES_FILE);
        list.add(CORE_TYPES_FILE);
        list.add(CROSS_RING_FRAGMENT_TYPES_FILE);
        list.add(CROSS_LINKED_SUBSTITUENT_TYPES_FILE);
        list.add(NON_SYMBOLIC_RESIDUE_TYPES_FILE);
        list.add(UOXF_RESIDUE_PLACEMENTS_FILE);
        list.add(UOXF_RESIDUE_STYLES_FILE);
        list.add(UOXF_LINKAGE_STYLES_FILE);
        list.add(UOXFCOL_RESIDUE_PLACEMENTS_FILE);
        list.add(UOXFCOL_RESIDUE_STYLES_FILE);
        list.add(UOXFCOL_LINKAGE_STYLES_FILE);
        list.add(TEXT_RESIDUE_PLACEMENTS_FILE);
        list.add(TEXT_RESIDUE_STYLES_FILE);
        list.add(TEXT_LINKAGE_STYLES_FILE);
        list.add(CFGLINK_RESIDUE_PLACEMENTS_FILE);
        list.add(CFGLINK_RESIDUE_STYLES_FILE);
        list.add(CFGLINK_LINKAGE_STYLES_FILE);
        list.add(CFG_RESIDUE_PLACEMENTS_FILE);
        list.add(CFG_RESIDUE_STYLES_FILE);
        list.add(CFG_LINKAGE_STYLES_FILE);
        list.add(CFGBW_RESIDUE_PLACEMENTS_FILE);
        list.add(CFGBW_RESIDUE_STYLES_FILE);
        list.add(CFGBW_LINKAGE_STYLES_FILE);
        list.add(SNFG_RESIDUE_PLACEMENTS_FILE);
        list.add(SNFG_RESIDUE_STYLES_FILE);
        list.add(SNFG_LINKAGE_STYLES_FILE);
        return list;
    }

    public void setDictionaryFile(String dictionaryName, String fileName) {
        this.keyToFile.put(dictionaryName, fileName);
    }

    public String getDictionaryFile(String dictionaryName) {
        return this.keyToFile.get(dictionaryName);
    }

    public void store(Configuration theConfiguration) {
        theConfiguration.put(DICT_SECT, RESIDUE_TYPES_FILE, this.keyToFile.get(RESIDUE_TYPES_FILE));
        theConfiguration.put(DICT_SECT, TERMINAL_TYPES_FILE, this.keyToFile.get(TERMINAL_TYPES_FILE));
        theConfiguration.put(DICT_SECT, CORE_TYPES_FILE, this.keyToFile.get(CORE_TYPES_FILE));
        theConfiguration.put(DICT_SECT, CROSS_RING_FRAGMENT_TYPES_FILE, this.keyToFile.get(CROSS_RING_FRAGMENT_TYPES_FILE));
        theConfiguration.put(DICT_SECT, CROSS_LINKED_SUBSTITUENT_TYPES_FILE, this.keyToFile.get(CROSS_LINKED_SUBSTITUENT_TYPES_FILE));
        theConfiguration.put(DICT_SECT, NON_SYMBOLIC_RESIDUE_TYPES_FILE, this.keyToFile.get(NON_SYMBOLIC_RESIDUE_TYPES_FILE));
        theConfiguration.put(DICT_SECT, UOXF_RESIDUE_PLACEMENTS_FILE, this.keyToFile.get(UOXF_RESIDUE_PLACEMENTS_FILE));
        theConfiguration.put(DICT_SECT, UOXF_RESIDUE_STYLES_FILE, this.keyToFile.get(UOXF_RESIDUE_STYLES_FILE));
        theConfiguration.put(DICT_SECT, UOXF_LINKAGE_STYLES_FILE, this.keyToFile.get(UOXF_LINKAGE_STYLES_FILE));
        theConfiguration.put(DICT_SECT, UOXFCOL_RESIDUE_PLACEMENTS_FILE, this.keyToFile.get(UOXFCOL_RESIDUE_PLACEMENTS_FILE));
        theConfiguration.put(DICT_SECT, UOXFCOL_RESIDUE_STYLES_FILE, this.keyToFile.get(UOXFCOL_RESIDUE_STYLES_FILE));
        theConfiguration.put(DICT_SECT, UOXFCOL_LINKAGE_STYLES_FILE, this.keyToFile.get(UOXFCOL_LINKAGE_STYLES_FILE));
        theConfiguration.put(DICT_SECT, TEXT_RESIDUE_PLACEMENTS_FILE, this.keyToFile.get(TEXT_RESIDUE_PLACEMENTS_FILE));
        theConfiguration.put(DICT_SECT, TEXT_RESIDUE_STYLES_FILE, this.keyToFile.get(TEXT_RESIDUE_STYLES_FILE));
        theConfiguration.put(DICT_SECT, TEXT_LINKAGE_STYLES_FILE, this.keyToFile.get(TEXT_LINKAGE_STYLES_FILE));
        theConfiguration.put(DICT_SECT, CFGLINK_RESIDUE_PLACEMENTS_FILE, this.keyToFile.get(CFGLINK_RESIDUE_PLACEMENTS_FILE));
        theConfiguration.put(DICT_SECT, CFGLINK_RESIDUE_STYLES_FILE, this.keyToFile.get(CFGLINK_RESIDUE_STYLES_FILE));
        theConfiguration.put(DICT_SECT, CFGLINK_LINKAGE_STYLES_FILE, this.keyToFile.get(CFGLINK_LINKAGE_STYLES_FILE));
        theConfiguration.put(DICT_SECT, CFG_RESIDUE_PLACEMENTS_FILE, this.keyToFile.get(CFG_RESIDUE_PLACEMENTS_FILE));
        theConfiguration.put(DICT_SECT, CFG_RESIDUE_STYLES_FILE, this.keyToFile.get(CFG_RESIDUE_STYLES_FILE));
        theConfiguration.put(DICT_SECT, CFG_LINKAGE_STYLES_FILE, this.keyToFile.get(CFG_LINKAGE_STYLES_FILE));
        theConfiguration.put(DICT_SECT, CFGBW_RESIDUE_PLACEMENTS_FILE, this.keyToFile.get(CFGBW_RESIDUE_PLACEMENTS_FILE));
        theConfiguration.put(DICT_SECT, CFGBW_RESIDUE_STYLES_FILE, this.keyToFile.get(CFGBW_RESIDUE_STYLES_FILE));
        theConfiguration.put(DICT_SECT, CFGBW_LINKAGE_STYLES_FILE, this.keyToFile.get(CFGBW_LINKAGE_STYLES_FILE));
        theConfiguration.put(DICT_SECT, SNFG_RESIDUE_PLACEMENTS_FILE, this.keyToFile.get(SNFG_RESIDUE_PLACEMENTS_FILE));
        theConfiguration.put(DICT_SECT, SNFG_RESIDUE_STYLES_FILE, this.keyToFile.get(SNFG_RESIDUE_STYLES_FILE));
        theConfiguration.put(DICT_SECT, SNFG_LINKAGE_STYLES_FILE, this.keyToFile.get(SNFG_LINKAGE_STYLES_FILE));
    }

    public void retrieve(Configuration theConfiguration) {
        this.keyToFile.put(RESIDUE_TYPES_FILE, theConfiguration.get(DICT_SECT, RESIDUE_TYPES_FILE, "/conf/residue_types"));
        this.keyToFile.put(TERMINAL_TYPES_FILE, theConfiguration.get(DICT_SECT, TERMINAL_TYPES_FILE, "/conf/terminal_types"));
        this.keyToFile.put(CORE_TYPES_FILE, theConfiguration.get(DICT_SECT, CORE_TYPES_FILE, "/conf/core_types"));
        this.keyToFile.put(CROSS_RING_FRAGMENT_TYPES_FILE, theConfiguration.get(DICT_SECT, CROSS_RING_FRAGMENT_TYPES_FILE, "/conf/cross_ring_fragment_types"));
        this.keyToFile.put(CROSS_LINKED_SUBSTITUENT_TYPES_FILE, theConfiguration.get(DICT_SECT, CROSS_LINKED_SUBSTITUENT_TYPES_FILE, "/conf/cross_linked_substituent_types"));
        this.keyToFile.put(NON_SYMBOLIC_RESIDUE_TYPES_FILE, theConfiguration.get(DICT_SECT, NON_SYMBOLIC_RESIDUE_TYPES_FILE, "/conf/non_symbolic_residue_types"));
        this.keyToFile.put(UOXF_RESIDUE_STYLES_FILE, theConfiguration.get(DICT_SECT, UOXF_RESIDUE_STYLES_FILE, "/conf/residue_styles_uoxf"));
        this.keyToFile.put(UOXF_RESIDUE_PLACEMENTS_FILE, theConfiguration.get(DICT_SECT, UOXF_RESIDUE_PLACEMENTS_FILE, "/conf/residue_placements_uoxf"));
        this.keyToFile.put(UOXF_LINKAGE_STYLES_FILE, theConfiguration.get(DICT_SECT, UOXF_LINKAGE_STYLES_FILE, "/conf/linkage_styles_uoxf"));
        this.keyToFile.put(UOXFCOL_RESIDUE_STYLES_FILE, theConfiguration.get(DICT_SECT, UOXFCOL_RESIDUE_STYLES_FILE, "/conf/residue_styles_uoxfcol"));
        this.keyToFile.put(UOXFCOL_RESIDUE_PLACEMENTS_FILE, theConfiguration.get(DICT_SECT, UOXFCOL_RESIDUE_PLACEMENTS_FILE, "/conf/residue_placements_uoxf"));
        this.keyToFile.put(UOXFCOL_LINKAGE_STYLES_FILE, theConfiguration.get(DICT_SECT, UOXFCOL_LINKAGE_STYLES_FILE, "/conf/linkage_styles_uoxf"));
        this.keyToFile.put(TEXT_RESIDUE_STYLES_FILE, theConfiguration.get(DICT_SECT, TEXT_RESIDUE_STYLES_FILE, "/conf/residue_styles_text"));
        this.keyToFile.put(TEXT_RESIDUE_PLACEMENTS_FILE, theConfiguration.get(DICT_SECT, TEXT_RESIDUE_PLACEMENTS_FILE, "/conf/residue_placements_cfg"));
        this.keyToFile.put(TEXT_LINKAGE_STYLES_FILE, theConfiguration.get(DICT_SECT, TEXT_LINKAGE_STYLES_FILE, "/conf/linkage_styles_cfg"));
        this.keyToFile.put(CFGLINK_RESIDUE_STYLES_FILE, theConfiguration.get(DICT_SECT, CFGLINK_RESIDUE_STYLES_FILE, "/conf/residue_styles_cfg"));
        this.keyToFile.put(CFGLINK_RESIDUE_PLACEMENTS_FILE, theConfiguration.get(DICT_SECT, CFGLINK_RESIDUE_PLACEMENTS_FILE, "/conf/residue_placements_uoxf"));
        this.keyToFile.put(CFGLINK_LINKAGE_STYLES_FILE, theConfiguration.get(DICT_SECT, CFGLINK_LINKAGE_STYLES_FILE, "/conf/linkage_styles_cfglink"));
        this.keyToFile.put(CFGBW_RESIDUE_STYLES_FILE, theConfiguration.get(DICT_SECT, CFGBW_RESIDUE_STYLES_FILE, "/conf/residue_styles_cfgbw"));
        this.keyToFile.put(CFGBW_RESIDUE_PLACEMENTS_FILE, theConfiguration.get(DICT_SECT, CFGBW_RESIDUE_PLACEMENTS_FILE, "/conf/residue_placements_cfg"));
        this.keyToFile.put(CFGBW_LINKAGE_STYLES_FILE, theConfiguration.get(DICT_SECT, CFGBW_LINKAGE_STYLES_FILE, "/conf/linkage_styles_cfg"));
        this.keyToFile.put(CFG_RESIDUE_STYLES_FILE, theConfiguration.get(DICT_SECT, CFG_RESIDUE_STYLES_FILE, "/conf/residue_styles_cfg"));
        this.keyToFile.put(CFG_RESIDUE_PLACEMENTS_FILE, theConfiguration.get(DICT_SECT, CFG_RESIDUE_PLACEMENTS_FILE, "/conf/residue_placements_cfg"));
        this.keyToFile.put(CFG_LINKAGE_STYLES_FILE, theConfiguration.get(DICT_SECT, CFG_LINKAGE_STYLES_FILE, "/conf/linkage_styles_cfg"));
        this.keyToFile.put(SNFG_RESIDUE_STYLES_FILE, theConfiguration.get(DICT_SECT, SNFG_RESIDUE_STYLES_FILE, "/conf/residue_styles_snfg"));
        this.keyToFile.put(SNFG_RESIDUE_PLACEMENTS_FILE, theConfiguration.get(DICT_SECT, SNFG_RESIDUE_PLACEMENTS_FILE, "/conf/residue_placements_snfg"));
        this.keyToFile.put(SNFG_LINKAGE_STYLES_FILE, theConfiguration.get(DICT_SECT, SNFG_LINKAGE_STYLES_FILE, "/conf/linkage_styles_snfg"));
    }

    public static String getDefaultDictionaryFile(String dictionaryName) {
        if (RESIDUE_TYPES_FILE.equals(dictionaryName)) {
            return "/conf/residue_types";
        }
        if (TERMINAL_TYPES_FILE.equals(dictionaryName)) {
            return "/conf/terminal_types";
        }
        if (CORE_TYPES_FILE.equals(dictionaryName)) {
            return "/conf/core_types";
        }
        if (CROSS_RING_FRAGMENT_TYPES_FILE.equals(dictionaryName)) {
            return "/conf/cross_ring_fragment_types";
        }
        if (CROSS_LINKED_SUBSTITUENT_TYPES_FILE.equals(dictionaryName)) {
            return "/conf/cross_linked_substituent_types";
        }
        if (NON_SYMBOLIC_RESIDUE_TYPES_FILE.equals(dictionaryName)) {
            return "/conf/non_symbolic_residue_types";
        }
        if (UOXF_RESIDUE_STYLES_FILE.equals(dictionaryName)) {
            return "/conf/residue_styles_uoxf";
        }
        if (UOXF_RESIDUE_PLACEMENTS_FILE.equals(dictionaryName)) {
            return "/conf/residue_placements_uoxf";
        }
        if (UOXF_LINKAGE_STYLES_FILE.equals(dictionaryName)) {
            return "/conf/linkage_styles_uoxf";
        }
        if (UOXFCOL_RESIDUE_STYLES_FILE.equals(dictionaryName)) {
            return "/conf/residue_styles_uoxfcol";
        }
        if (UOXFCOL_RESIDUE_PLACEMENTS_FILE.equals(dictionaryName)) {
            return "/conf/residue_placements_uoxf";
        }
        if (UOXFCOL_LINKAGE_STYLES_FILE.equals(dictionaryName)) {
            return "/conf/linkage_styles_uoxf";
        }
        if (TEXT_RESIDUE_STYLES_FILE.equals(dictionaryName)) {
            return "/conf/residue_styles_text";
        }
        if (TEXT_RESIDUE_PLACEMENTS_FILE.equals(dictionaryName)) {
            return "/conf/residue_placements_cfg";
        }
        if (TEXT_LINKAGE_STYLES_FILE.equals(dictionaryName)) {
            return "/conf/linkage_styles_cfg";
        }
        if (CFGLINK_RESIDUE_STYLES_FILE.equals(dictionaryName)) {
            return "/conf/residue_styles_cfg";
        }
        if (CFGLINK_RESIDUE_PLACEMENTS_FILE.equals(dictionaryName)) {
            return "/conf/residue_placements_uoxf";
        }
        if (CFGLINK_LINKAGE_STYLES_FILE.equals(dictionaryName)) {
            return "/conf/linkage_styles_cfglink";
        }
        if (CFGBW_RESIDUE_STYLES_FILE.equals(dictionaryName)) {
            return "/conf/residue_styles_cfgbw";
        }
        if (CFGBW_RESIDUE_PLACEMENTS_FILE.equals(dictionaryName)) {
            return "/conf/residue_placements_cfg";
        }
        if (CFGBW_LINKAGE_STYLES_FILE.equals(dictionaryName)) {
            return "/conf/linkage_styles_cfg";
        }
        if (CFG_RESIDUE_STYLES_FILE.equals(dictionaryName)) {
            return "/conf/residue_styles_cfg";
        }
        if (CFG_RESIDUE_PLACEMENTS_FILE.equals(dictionaryName)) {
            return "/conf/residue_placements_cfg";
        }
        if (CFG_LINKAGE_STYLES_FILE.equals(dictionaryName)) {
            return "/conf/linkage_styles_cfg";
        }
        if (SNFG_RESIDUE_STYLES_FILE.equals(dictionaryName)) {
            return "/conf/residue_styles_snfg";
        }
        if (SNFG_RESIDUE_PLACEMENTS_FILE.equals(dictionaryName)) {
            return "/conf/residue_placements_snfg";
        }
        if (SNFG_LINKAGE_STYLES_FILE.equals(dictionaryName)) {
            return "/conf/linkage_styles_snfg";
        }
        return null;
    }

    public boolean isDefault(String dictionaryName) {
        return this.keyToFile.get(dictionaryName).equals(DictionaryConfiguration.getDefaultDictionaryFile(dictionaryName));
    }

    public boolean isRemoteResource(String dictionaryName) {
        return this.keyToFile.get(dictionaryName).startsWith("http://");
    }

    public String getDictionaryResourceAsString(String dictionaryName) throws MalformedURLException, IOException {
        String filename = this.keyToFile.get(dictionaryName);
        return DictionaryConfiguration.getResourceAsString(filename);
    }

    public static String getResourceAsString(String filename) throws MalformedURLException, IOException {
        String line;
        BufferedReader is;
        if (filename.startsWith("http")) {
            URLConnection conn = new URL(filename).openConnection();
            is = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        } else {
            URL file_url = ResidueDictionary.class.getResource(filename);
            if (file_url == null) {
                File file = new File(filename);
                if (!file.exists()) {
                    throw new FileNotFoundException(filename);
                }
                is = new BufferedReader(new FileReader(file));
            } else {
                is = new BufferedReader(new InputStreamReader(file_url.openStream()));
            }
        }
        StringBuffer buf = new StringBuffer();
        while ((line = is.readLine()) != null) {
            buf.append(line + "\n");
        }
        return buf.toString();
    }
}

