/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder.linkage;

import java.util.LinkedList;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.linkage.Linkage;
import org.eurocarbdb.application.glycanbuilder.linkage.LinkageMatcher;
import org.eurocarbdb.application.glycanbuilder.util.TextUtils;

public class LinkageStyle {
    private String rule;
    private LinkageMatcher matcher;
    private boolean dashed;
    private String shape;
    private String show_info;

    public LinkageStyle() {
        this.rule = "";
        this.matcher = LinkageMatcher.parse(this.rule);
        this.dashed = false;
        this.shape = "line";
        this.show_info = "222";
    }

    public LinkageStyle(String init) throws Exception {
        LinkedList<String> tokens = TextUtils.tokenize(init, "\t");
        if (tokens.size() != 4) {
            throw new Exception("Invalid string format: " + init);
        }
        this.rule = tokens.get(0);
        this.matcher = LinkageMatcher.parse(this.rule);
        this.dashed = tokens.get(1).equals("yes") || tokens.get(1).equals("true");
        this.shape = tokens.get(2);
        this.show_info = tokens.get(3);
    }

    public LinkageStyle createPlain() {
        LinkageStyle ret = new LinkageStyle();
        this.show_info = "000";
        return ret;
    }

    public String getRule() {
        return this.rule;
    }

    public LinkageMatcher getMatcher() {
        return this.matcher;
    }

    public boolean matches(Residue parent, Linkage link, Residue child) {
        return this.matcher.matches(parent, link, child);
    }

    public boolean isDashed() {
        return this.dashed;
    }

    public String getShape() {
        return this.shape;
    }

    public boolean showParentLinkage(Linkage link) {
        if (this.show_info.charAt(0) == '0') {
            return false;
        }
        if (this.show_info.charAt(0) == '1') {
            return true;
        }
        if (this.show_info.charAt(0) == '2') {
            return link.hasMultipleBonds() || link.glycosidicBond().getParentPositions().length > 1 || link.glycosidicBond().getParentPositions()[0] != ' ';
        }
        if (this.show_info.charAt(0) == '3') {
            return link.hasMultipleBonds() || link.glycosidicBond().getParentPositions().length > 1 || link.glycosidicBond().getParentPositions()[0] == '?';
        }
        return true;
    }

    public boolean showAnomericState(Linkage link, char anomer) {
        if (link.getChildResidue().getType().getSuperclass().equals("Bridge")) {
            return false;
        }
        if (this.show_info.charAt(1) == '0') {
            return false;
        }
        if (this.show_info.charAt(1) == '1') {
            return link.hasSingleBond();
        }
        if (this.show_info.charAt(1) == '2') {
            return link.hasSingleBond();
        }
        if (this.show_info.charAt(1) == '3') {
            return link.hasSingleBond() && anomer == '?';
        }
        return true;
    }

    public boolean showAnomericCarbon(Linkage link) {
        if (this.show_info.charAt(2) == '0') {
            return false;
        }
        if (this.show_info.charAt(2) == '1') {
            return true;
        }
        if (this.show_info.charAt(2) == '2') {
            return link.hasMultipleBonds() || link.glycosidicBond().getChildPosition() != '?';
        }
        if (this.show_info.charAt(2) == '3') {
            return link.hasMultipleBonds() || link.glycosidicBond().getChildPosition() == '?';
        }
        return true;
    }

    public String toString() {
        return this.rule + " " + this.dashed + " " + this.shape + " " + this.show_info;
    }
}

