/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder.massutil;

import java.util.LinkedList;
import org.eurocarbdb.application.glycanbuilder.util.TextUtils;

public class Atom
implements Comparable<Atom> {
    private String symbol;
    private String name;
    private double main_mass;
    private double avg_mass;

    public Atom(String init) throws Exception {
        LinkedList<String> tokens = TextUtils.tokenize(init, "\t");
        if (tokens.size() != 4) {
            throw new Exception("Invalid line: " + init);
        }
        this.symbol = tokens.get(0);
        this.name = tokens.get(1);
        this.main_mass = Double.valueOf(tokens.get(2));
        this.avg_mass = Double.valueOf(tokens.get(3));
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Atom)) {
            return false;
        }
        return this.symbol.equals(((Atom)o).symbol);
    }

    @Override
    public int compareTo(Atom a) {
        if (a == null) {
            return 1;
        }
        return this.symbol.compareTo(a.symbol);
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getName() {
        return this.name;
    }

    public double getMass() {
        return this.main_mass;
    }

    public double getMainMass() {
        return this.main_mass;
    }

    public double getAverageMass() {
        return this.avg_mass;
    }

    public String toString() {
        return this.symbol;
    }
}

