/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder.massutil;

import java.util.LinkedList;
import org.eurocarbdb.application.glycanbuilder.util.TextUtils;

public class Isotope {
    private String symbol;
    private String atom_symbol;
    private boolean is_stable;
    private int atomic_number;
    private double mass;
    private double abundance;

    public Isotope(String init) throws Exception {
        LinkedList<String> tokens = TextUtils.tokenize(init, "\t");
        if (tokens.size() != 6) {
            throw new Exception("Invalid line: " + init);
        }
        this.symbol = tokens.get(0);
        this.atom_symbol = tokens.get(1);
        this.atomic_number = Integer.valueOf(tokens.get(2));
        this.is_stable = tokens.get(3).equals("1") || tokens.get(3).equals("true") || tokens.get(3).equals("yes");
        this.mass = Double.valueOf(tokens.get(4));
        this.abundance = Double.valueOf(tokens.get(5));
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Isotope)) {
            return false;
        }
        return this.symbol.equals(((Isotope)o).symbol);
    }

    public int compareTo(Isotope a) {
        if (a == null) {
            return 1;
        }
        return this.symbol.compareTo(a.symbol);
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getAtomSymbol() {
        return this.atom_symbol;
    }

    public int getAtomicNumber() {
        return this.atomic_number;
    }

    public boolean isStable() {
        return this.is_stable;
    }

    public double getMass() {
        return this.mass;
    }

    public double getAbundance() {
        return this.abundance;
    }
}

